PD HELP FILE FOR CBREEZE                         DLIBS FUNCTIONS
based on dlibs v1.2 manual

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNTRL & SHFT & CLK Go to previous

Suggest return to menu by macro     - (,),/ - of CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only


/*    HEADER FILES:

ar,       assert,  basepage,  ctype,   errno,   fcntl,
limits,   macros,  malloc,    osbind,  setjmp,  stat,
stdarg,   stddef,  stdio,     string,  time,    types,
minimum,  until,
 */


/*  MISCELLANEOUS FUNCTIONS: */

getopt,  rand,  srand,  swab,  abs,  max,
min,     swap,  assert,


/*  MEMORY MANAGEMENT: */

/*   variable  _BLKSIZ */
malloc,  calloc,  lalloc,  realloc,   free,   msize,   memavail,
alloca,  sbrk,    brk,


/*  DATE/TIME FUNCTIONS: */

time,   ctime,  localtime,  mtime,        asctime,      mktime,
stime,  utime,  clock,      start_timer,  time_since,   sleep,   usleep,


/*  SEARCHING AND SORTING: */

qsort,  hsort,  bsearch,    lsearch,      lfind,  


/*  ERROR HANDLING FUNCTIONS: */

/*   errno,  */
perror,  perrorf,  strerror,


/*  VARIABLE ARGUMENT LISTS: */

/*   typedef	... va_list; */
va_start,  va_arg,  va_end,



/*  STRING MANIPULATION: */

memmove,  lmemmove,  memcpy,   lmemcpy,   memset,   memcmp,
memicmp,  memccpy,   memchr,   bzero,     strlen,   strcpy,
strncpy,  strpcpy,   strdup,   strset,    strnset,  substr,
subnstr,  strcat,    strncat,  strupr,    strlwr,   strrev,
strcmp,   strncmp,   stricmp,  strnicmp,  strstr,   stristr,
strchr,   strrchr,   strpos,   strrpos,   strspn,   strcspn,
strpbrk,  strrpbrk,  strtok,   strtrim,   stradj,   strrpl,
strirpl,


/*  CHARACTER FUNCTIONS: */

toupper,  tolower,  _toupper,  _tolower,  toascii,   isalnum,
isalpha,  isascii,  iscntrl,   isdigit,   isgraph,   islower,
isprint,  ispunct,  isspace,   isupper,   isxdigit,


/*  FORMATTING/TYPE CONVERSION: */

_printf,  ltoa,     ultoa,   itoa,    atol,    atoi,
strtol,   strtoul,  _scanf,  ctlcnv,




/*  PROCESS CONTROL: */

/*   variables:  _STKSIZ  *etext  *edata  *end */
_initargs,  main,     _main,    exit,   _exit,   abort,   getpid,  getenv,
putenv,     shell,    system,   forkl,  forklp,  forkle,  forklpe, forkv,
forkvp,     forkve,   forkvpe,  wait,   gemdos,  bios,    xbios,   bdos,
setjmp,     longjmp,  catch,    throw,




/*  INPUT/OUTPUT FUNCTIONS: */

read,       lread,     write,       lwrite,   fread,     fwrite,
getc,       fgetc,     ungetc,      fungetc,  putc,      fputc,
fflush,     getw,      putw,        getl,     putl,      getch,
getchar,    ungetchar  putchar,     cfg_ch,   getche,    putch,
kbhit,      getln,     gets,        puts,     fgets,     fputs,
cputs,      printf,    fprintf,     sprintf,  cprintf,   vfprintf,
vprintf,    vsprintf,  scanf,       fscanf,   sscanf,    _tttty,


/*  FILE HANDLING: */

chdir,      mkdir,      rmdir,      fullpath,    getcwd,      access,
findfile,   pfindfile,  wildcard,   _splitpath,  _makepath,   tmpnam,
tempnam,    stat,       fsize,      isatty,      creat,       chmod,
open,       close,      dup,        dup2,        remove,      rename,
lseek,      tell,       fopen,      freopen,     fdopen,      fopenp,
fclose,     setbuf,     setvbuf,    fseek,       rewind,      ftell,
fgetpos,    fsetpos,    fileno,     feof,        ferror,      clearerr,
sync,




HEADER FILES:

ar.h
/*  This header defines the library archive header used by 'ar'. */

assert.h
/*  This header defines the assert() run-time condition checking macro. */

basepage.h
/*  The BASEPAGE struct and the _base variable, which is initialized */
/*  to point to the current process basepage, are defined in this file */

ctype.h
/*  The isxxxx() macros and toxxxx() macros are define in this file. */

errno.h
/*  This file defines the error code constants, the errno variable */
/*  and related error handling functions. */

fcntl.h
/*  This file defines the O_xxxx constants used by open(). */

limits.h
/*  Various maximum and minimum values are defined by this file. */
/*  Among these are PATHSIZE and MAXINT. */

macros.h
/*  This file contains a few useful macros including min(), max(), */
/*  abs() and swap(). */

malloc.h
/*  This file is defines the return values for the dynamic memory */
/*  managment functions, malloc(), et. al. */

osbind.h
/*  Mnemonics for bios(), xbios() and gemdos() calls are defined */
/*  in this file. */

setjmp.h
/*  This file defines the buffer needed to save your context when */
/*  using setjmp()/longjmp() or catch()/throw(). */

stat.h
/*  The struct stat and the file mode flag constants are defined */
/*  in this file. */

stdarg.h
/*  This header defines the type and macros needed for variable */
/*  argument list processing. */

stddef.h
/*  This is the root header file which should be included in all */
/*  programs.  It defines dLibs, NULL, size_t, ptrdiff_t and the */
/*  offsetof() macro. */

stdio.h
/*  This header file should be present in nearly all C programs. */
/*  It contains defines the FILE struct, EOF and contains extern */
/*  declarations for standard i/o and other commonly used functions. */
/*  For convenience, the constants TRUE, FALSE and ERROR are also */
/*  defined in this file, although this is somewhat non-standard. */

string.h
/*  This file defines aliases for string function names (since some */
/*  string functions have various names on different systems) and */
/*  extern declarations for all string functions. */

time.h
/*  This file defines time related constants and structures, and */
/*  extern declarations for the time functions. */

types.h
/*  This file contains typedefs for many special and/or non-standard */
/*  type names.  Many of the typedefs in this file define type names */
/*  which are ANSI and/or System V standard.  This file is included */
/*  by several other header files, and includes <stddef.h>. */

sys\minimum.h
/*  This file contains C code for new _main() and _initargs() functions. */
/*  It is used as a non-portable hack to make very small programs when */
/*  no standard i/o or argv/argc is needed. */

sys\until.h
/*  This file is provided just for fun.  It defines macros needed to */
/*  implement a "repeat { ... } until(HELL_FREEZES_OVER);" construct. */




MISCELLANEOUS FUNCTIONS:

int getopt(int argc, char **argv, char *optstring)
{
/*  This function eases the processing of the command line.  Each call
	returns a character from <optstring>, with optarg set to a parameter
	if one is required; or a '?' indicating that an invalid option was
	found; or EOF indicating that all options have been processed.  The
	<argc> and <argv> parameters are (of course) the argc and argv values
	passed to main().  The <opstring> is a string of option characters.
	If an option takes a parameter, it is followed by a ':' in <optstring>,
	and the char *optarg variable (global) will be set to point to the
	parameter string from the command line.  For example, "bno:v" defines
	the valid option characters as 'b', 'n', 'o' and 'v', and 'o' takes
	a parameter.  All options must be preceeded (in the command line) by
	a '-' character.  A single '-' character is taken to indicate stdin
	as a file, and terminates the argument processing.  A "--" string
	indicated the end of options, and is skipped over.  When option
	processing is successfully completed, the global variable optind will
	contain the index into argv[] of the next argument to be processed.
	Subsequent arguments should be processed with a loop like this:
		while(optind < argc)
			process(argv[optind++]);
	If an error occurs during argument process, an error message is
	written to stderr and '?' is returned by getopt().  Your program
	should then give a usage message and abort.  If the global variable
	opterr is set to zero, no error message will be given, but '?' will
	still be returned.  Note that command lines accepted by getopt() are
	quite flexible.  The command lines "-b -v -o filename -- - file",
	"-vbofilename - file",  and "-ofilename -bv - file" all will return
	the 'b', 'v', and 'o' options with the parameter to 'o' set to
	"filename" and leave the arguments "-" and "file2" for further
	processing.  Please examine the sample program "echo.c" for !n
	example of getopt() usage.
 */
}
int rand()
{
/*  Return a pseudorandom number in the range 0..32767.  This
	function uses the system random number generator, but grabs
	it's value out of the middle to avoid the exactly 50%
	behavior of the lowest order bit.  Source code is also provided,
	though commented out, showing how to generate your own
	random number sequence if the system random numbers aren't
	sufficient or for porting these routines to another machine.
 */
}
void srand(unsigned int seed)
{
/*  Seed the random number generator.  This function is #defined as
	a comment, since no seeding is possible for this implementation
	of rand().
 */
}
void swab(int *src, int *dst, int n)
{
/*  Swap adjacent bytes while copying <n> bytes from <src> to <dst>.
	This allows bulk translation to/from Intel byte ordering.  Please
	note the backward order of the <src> and <dst> parameters.  Don't
	blame me... this is how Microsoft specifies it.
 */
}
 MACRO abs(x)
{
/*  Return the absolute value of <x>.  This macro evalutes it's
	argument twice.	((x)<0?(-(x)):(x))
 */
}
MACRO max(x,y)
{
/*  Return the larger of <x> and <y>.  This macro evaluates the
	larger argument twice and the smaller argument once.
 */
}
MACRO min(x,y)
{
/*  Return the smaller of <x> and <y>.  This macro evaluates the
	smaller argument twice and the larger argument once.
 */
}
MACRO swap(a,b)
{
/*  Exchange <a> and <b> by chained XORs.  The macro evaluates
	each argument several times.
 */
}
MACRO assert(condition)
{
/*  If <condition> is not true at run-time, this macro causes an
	assert failure message to be written to stderr, displaying the
	line number and source file name, and aborts the program.  If
	the symbol NDEBUG is #defined (usually with a -D option to cc),
	all assert() calls are disabled.
 */
}


MEMORY MANAGEMENT:

/*  You should include <malloc.h> in your program if you use functions */
/*  in this section. */

long _BLKSIZ = 65536;
/*  This variable controls the granularity of system memory allocation */
/*  used by malloc(), et. al.  This is the amount of memory that is */
/*  requested from the system each time a new "heap" is needed to fill */
/*  dynamic memory requests.  To help avoid a GEMDOS bug, only 16 */
/*  heaps can be active at a time.  Therefore, (16 * _BLKSIZ) defines */
/*  the maximum amount of memory which can be managed by these routines */
/*  under normal circumstances.  The exception is if any single request */
/*  for memory exceeds _BLKSIZ.  In this case, a heap will be allocated */
/*  larger than _BLKSIZ. */

#include <malloc.h>
char *malloc(unsigned int size)
{
/*  Allocate at least <size> bytes of memory.  A pointer to the
	requested block is returned, or NULL if there is not enough
	free memory available.
 */
}
#include <malloc.h>
char *calloc(unsigned int n, size_t size)
{
/*  Allocate space for an array of <n> element of <size> bytes each.
	If the storage can be allocated, it is initialized to all zero.
	NULL is returned is there is not enough free memory.
 */
}
#include <malloc.h>
char *lalloc(long size)
{
/*  Allocate at least <size> bytes of memory.  A pointer to the
	requested block is returned, or NULL if there is not enough
	free memory available.
 */
}
#include <malloc.h>
char *realloc(char *addr, unsigned int size)
{
/*  Attempt to change the memory block at <addr> to the new <size>.
	Making a block smaller will always work, but making it larger
	may fail if there is not enough free memory.  If there is not
	enough memory, NULL is returned and the block will still reside
	at <addr>.  If realloc() succeeds, a pointer to the (possibly
	moved) new block will be returned.  If <addr> is NULL, realloc()
	will simply act like malloc().  If <size> is 0, and <addr> is
	not NULL, realloc() will work like free().
 */
}
#include <malloc.h>
void free(char *addr)
{
/*  Release the memory block at <addr> back into the free memory pool.
	WARNING: Unlike some implementations, you may not realloc() a block
	which has been free()ed.
 */
}
#include <malloc.h>
long msize(char *addr)
{
/*  Return the size, in bytes, of the memory block at <addr>.  Note
	that the size is a long value, since the block may have been
	allocated by lalloc().
 */
}
#include <malloc.h>
long memavail()
{
/*  Return the size, in bytes, of the largest block of free memory
	available for allocation.  Note that this value is a long.
 */
}
#include <malloc.h>
char *alloca(unsigned int size)
{
/*  Allocate at least <size> bytes of memory from the stack.  This
	is "automatic" variable space and will be freed when the function
	which called alloca() exits.  DO NOT use the other dynamic memory
	functions like free(), realloc() and msize() on the block returned
	by this function.  A pointer to the requested block is returned,
	or NULL if there is not enough stack space available.
 */
}
#include <malloc.h>
char *sbrk(int amount)
{
/*  Move the "break" by <amount>.  The break is the line between the
	top of the heap and the bottom of the stack.  The size of the
	stack/heap area is defined by _STKSIZ.  Initially, the heap uses
	zero bytes.  Since malloc() doesn't use the heap, often the heap
	will stay that way.  This function moves the location of the break
	by <amount> bytes, positive or negative, and returns the old value
	of the break.  If this causes a collision with the stack, or a
	negative value reduces the heap below zero bytes, NULL is returned
	and the break is not moved.  Note that the heap pointer is moved by
	EXACTLY the <amount> specified.  If you want to ensure that sbrk()
	will return word-aligned memory segments, you must make sure that
	<amount> is always even, since the heap is initially aligned properly.
 */
}
#include <malloc.h>
int brk(char *address)
{
/*  Set the "break" to <address>.  Return 0 for success.  If <address>
	is not a valid break value, return -1 and don't move the break.
 */
}


DATE/TIME FUNCTIONS:

	To use the functions in this section, you must include <time.h>
	in your source file.

#include <time.h>
time_t time(time_t *rawtime)
{
/*  Get the current system clock date/time value.  Altough the value
	of this function is compatible with the ANSI proposed standard,
	on some systems (notably System V), this function returns the
	number of seconds elapsed since 00:00:00 GMT on Jan 1, 1970.
	This implementation returns an encoded date/time value instead.
	Therefore any programs which depend on this value being a number
	of seconds will not work properly.  However, other functions in
	this section which make use of the raw time value returned by
	time() are implemented to be compatible with this encoding, and
	will work properly.  In addition to returning the raw time value,
	if the <rawtime> pointer is not NULL, the value is stored in
	the time_t variable <rawtime> points to.
 */
}
#include <time.h>
char *ctime(time_t *rawtime)
{
/*  Convert <rawtime> to a string.  A 26 character fixed field string
	is created from the raw time value.  The following is an example
	of what this string might look like:
		"Wed Jul 08 18:43:07 1987\n\0"
	A 24-hour clock is used, and due to a limitation in the ST system
	clock value, only a resolution of 2 seconds is possible.  A pointer
	to the formatted string, which is held in an internal buffer, is
	returned.
 */
}
#include <time.h>
struct tm *localtime(time_t *rawtime)
{
/*  Convert <rawtime> to fill time structure fields.  A pointer to an
	internal structure is returned.  Refer to <time.h> for the values
	of the various structure fields.
 */
}
#include <time.h>
struct tm *gmtime(time_t *rawtime)
{
/*  Since there is not concept of "time zone" on the ST, this function
	returns NULL, as specified by the proposed ANSI standard.
 */
}
#include <time.h>
char *asctime(struct tm *time)
{
/*  Convert <time> structure value to a string.  The same format, and
	the same internal buffer, as for ctime() is used for this function.
 */
}
#include <time.h>
time_t mktime(struct tm *time)
{
/*  Convert <time> structure value to raw time format.
 */
}
#include <time.h>
void stime(long *rawtime)
{
/*  Set the system clock to <rawtime>.
 */
}
#include <time.h>
int utime(char *pathname, long *rawtime)
{
/*  Set the modification date of <pathname> to <rawtime>.  Returns zero
	for success, or a negative error code.
 */
}
#include <time.h>
clock_t clock()
{
/*  Returns the current value of the system clock.  The difference
	of two clock() times, divded by CLK_TCK, will give you elapsed
	seconds.
 */
}
#include <time.h>
clock_t start_timer(clock_t *t)
{
/*  Start a 200Hz timer.  This timer value can later be checked with
	time_since() to determine elapsed time.  These functions provide
	a very low-overhead way of timing events.
 */
}
#include <time.h>
clock_t time_since(clock_t *t)
{
/*  Returns the number of 200Hz ticks since start_timer() was called
	for timer <t>.
 */
}
#include <time.h>
void sleep(int dt)
{
/*  Suspend operation for <dt> seconds.  This is implemented as a
	start_timer()/time_since() tight loop waiting for the specified
	amount of time to pass.  In a multi-tasking environment, this
	function should be replaced by a call which will de-activate
	this task for a period of time, allowing other tasks to run.
 */
}
#include <time.h>
void usleep(int dt)
{
/*  Suspend operation for <dt> microseconds.  Works like sleep().
 */
}


SEARCHING AND SORTING:

void qsort(char *base, int num, int size, int (*cmp)())
{
/*  Perform a recursive quick-sort on an array starting at <base>
	containing <num> elements of <size> bytes each.  The function
	pointed to by <cmp> is used to compare elements.  Pointers to
	two items in the array are passed to the function, which must
	return a number representing their relationship as follows:
		negative	item1 < item2
		0		item1 == item2
		positive	item1 > item2
	The qsort() function requires the use of a temporary data area
	that is large enough to hold <size> bytes.  The default space
	provided is 128 bytes large.  If your record size is larger than
	128 bytes, YOU MUST provide an alternative storage area.  The
	global variable "_qbuf" points to the storage qsort() will use.
	Setting "_qbuf" to NULL restores use of the internal buffer.
	This routine is optimized to avoid N*N sort times for ordered data.
	In fact, performance on sorted or reverse-sorted data is actually
	"best case" with this algorithm, rather than "worst case" as with
	most qsort() implementations.
 */
}
void hsort(ch!r *base, int num, int size, int (*cmp)())
{
/*  Perform an N*log(N) heap-sort on an array 3tarting at <base>
	containing <num> elements of <size> bytes each.  The function
	pointed to by <cmp> is used to compare elements.  Pointers to
	two items in the array are passed to the function, which must
	return a number representing their relationship as follows:
		negative	item1 < item2
		0		item1 == item2
		positive	item1 > item2
	The hsort() function requires no extra storage, is not recursive,
	and has an almost constant N*log(N) sort time.  In the average
	case, it is about half as fast as qsort() on random data.  If
	0ortability is a concern, it should be noted that qsort() is
	almost always available, but hsort() is not.
 */
}
char *bsearch(char *key, char *base, int num, int size, int (*cmp)())
{
/*  Perform a binary search for <key> on the sorted data at <base>.
	<num>, <size> and <cmp> are like the corresponding parameters
	to qsort().  A pointer to the matching element is returned for
	success, or NULL for failure.  The global variable "_bsearch"
	will contain the index of either the matching element, or the
	index of the element that the <key> value should be inserted
	after.  The use of "_bsearch" is not supported by most
	implementations of bsearch().
 */
}
char *lsearch(char *key, char *base, int *num, int size, int (*cmp)())
{
/*  Perform a linear search for <key> on the data at <base>. The
	<num>, <size> and <cmp> parameters are like the corresponding
	parameters to qsort().  A pointer to the first matching element
	is returned for success, or NULL for failure.  If <key> is not
	found, it will be added to the end of the array and <num> will
	be incremented.  Note that, unlike bsearch() and qsort(), the
	<num> parameter is a POINTER to a location which holds the
	number of elements to sort.
 */
}
char *lfind(char *key, char *base, int *num, int size, int (*cmp)())
{
/*  Like lsearch(), but do not add elements which are not found.
	Note that <num> is a POINTER, even though it is not modified.
 */
}



ERROR HANDLING FUNCTIONS:

int errno;

/*  This variable is set to zero when the program is loaded.  It is
	not zeroed by any library functions, but may be set to a non-zero
	error number by many of them (particularly the standard i/o and
	system service functions).  The meaning of this error number may
	be found in the symbolic #defines in <errno.h>, or by calling the
	seterror() functions as described below.  (cf: seterror)
 */

void perror(char *msg)
{
/*  Write, to stderr, <msg> (if non-null and non-empty), followed by
	": " and a system error messaged derived from the value of errno.
 */
}
void perrorf(char *fmt[, arg1, ..., argN])
{
/*  Write, to stderr, the name of the program, followed by ": ",
	followed by a message formatted as by printf() from <fmt> and
	the optional arguments, followed by ": " and a system error
	message derived from the value of errno.  This is a non-standard
	extended version of perror().  (cf: printf, perror)
 */
}
char *strerror(errnum)
{
/*  Return the system error message for error <errnum>.  If <errnum>
	is outside the range of valid error numbers, NULL is returned.
 */
}



VARIABLE ARGUMENT LISTS:

/*  The macros in this section are defined in the <stdarg.h> header file. */


typedef	... va_list;

/*  This is the type for a variable argument list traversal variable. */


#include <stdarg.h>
MACRO va_start(list, param)
{
/*  This macro initializes the va_list variable <list> to begin
	traversing variable argument lists.  <param> is the last parameter
	in the function call before the variable arguments begin.  This
	parameter MUST NOT be a register variable.
 */
}
#include <stdarg.h>
MACRO va_arg(list, type)
{
/*  This macro retrieves a variable argument of type <type>, updates
	the va_list variable <list>, and returns the value of the retrieved
	argument.  The <type> should not be parenthesised.
 */
}
#include <stdarg.h>
MACRO va_end(list)
{
/*  This macro must be called after all desired variable arguments have
	been retrieved, to reset the context of the va_list variable <list>.
 */
}


STRING MANIPULATION:

/*  You should include <string.h> in your program if you use functions */
/*  in this section. */

#include <string.h>
char *memmove(char *dest, char *source, int len)
{
/*  Copies the <source> block to the <dest>.  <len> bytes are
	always copied.  No terminator is added to <dest>.  A pointer
	to <dest> is returned.  Overlap checking IS done.
 */
}
#include <string.h>
char *lmemmove(char *dest, char *source, long len)
{
/*  Same as memmove() except a long value is used for <len>.
 */
}
#include <string.h>
char *memcpy(char *dest, char *source, int len)
{
/*  Copies the <source> block to the <dest>.  <len> bytes are
	always copied.  No terminator is added to <dest>.  A pointer
	to <dest> is returned.  Overlap checking IS NOT done.
 */
}
#include <string.h>
char *lmemcpy(char *dest, char *source, long len)
{
/*  Same as memcpy() except a long value is used for <len>.
 */
}
#include <string.h>
char *memset(char *dest, char data, int len)
{
/*  Set <len> bytes of <dest> to <data>.  A pointer to <dest>
	is returned.
 */
}
#include <string.h>
int memcmp(char *blk1, char *blk2, int len)
{
/*  Lexicographically compare the two blocks.  Return a value
	indicating the relationship between the blocks.  Possible
	return values are:
		negative	blk1 < blk2
		0		blk1 == blk2
		positive	blk1 > blk2
	<len> bytes are always compared.
 */
}
#include <string.h>
int memicmp(char *blk1, char *blk2, int len)
{
/*  Compare blocks as with memcmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
char *memccpy(char *dst, char *src, char c, int cnt)
{
/*  Copy bytes from <src> to <dst> until either <cnt> bytes have been
	copied, or the character <c> has been copied.  If <c> is found,
	a pointer to the character following <c> in <dst> is returned, or
	NULL is <cnt> reaches 0 before <c> is found.
 */
}
#include <string.h>
char *memchr(char *buf, char c, int cnt)
{
/*  Search the first <cnt> bytes of <buf> for <c>.  Returns a pointer to
	the matching character, or NULL if not found.
 */
}
#include <string.h>
char *bzero(char *buf, int cnt)
{
/*  Zero <cnt> characters in <buf>.  Returns <buf>.
 */
}
#include <string.h>
int strlen(char *string)
{
/*  Returns the number of characters in a string, not including the
	terminating '\0'.
 */
}
#include <string.h>
char *strcpy(char *dest, char *source)
{
/*  Copies the <source> string to the <dest> including the '\0'.  A
	pointer to the start of <dest> is returned.
 */
}
#include <string.h>
char *strncpy(char *dest, char *source, int limit)
{
/*  Copies the <source> string to the <dest>.  At most, <limit>
	characters are copied.  If <source> ends before <limit> characters
	have been copied, the '\0' is copied, otherwise <dest> is not
	terminated by the copy.
 */
}
#include <string.h>
char *strpcpy(char *dest, char *start, char *stop)
{
/*  Copies characters from <start> up to <stop> into <dest>.  The
	character pointed to by <stop> is not copied, and MUST be in the
	same string as <start>.  The <dest> pointer is returned.
 */
}
#include <string.h>
char *strdup(char *string)
{
/*  Create a copy of <string> and return a pointer to the copy.
	Storage for the copy is obtained from malloc().
 */
}
#include <string.h>
char *strset(char *string, char c)
{
/*  Fill <string> with <c> up the the terminating '\0' of <string>.
 */
}
#include <string.h>
char *strnset(char *string, char c, int n)
{
/*  Fill at most <n> characters of <string> with <c>, up the the
	terminating '\0' of <string>.
 */
}
#include <string.h>
char *substr(char *dest, char *source, int start, int end)
{
/*  Copy characters from <source> to <dest> starting with character
	<start> and ending with <end>.  A pointer to <dest>, which will
	be '\0' terminated, is returned.
 */
}
#include <string.h>
char *subnstr(char *dest, char *source, int start, int length)
{
/*  Copy <length> characters from <source> to <dest> starting with
	character <start>.  A pointer to <dest>, which will be '\0'
	terminated, is returned.
 */
}
#include <string.h>
char *strcat(char *dest, char *source)
{
/*  Concatenate <source> on the end of <dest>.  The terminator of
	<dest> will be overwritten by the first character of <source>.
	The termintor from <source> will be copied.  A pointer to
	the modified <dest> is returned.
 */
}
#include <string.h>
char *strncat(char *dest, char *source, int limit)
{
/*  Concatenate <limit> characters from <source> onto <dest>.  If
	<source> contains less than <limit> characters, the length of
	source is used for <limit>.  The terminating '\0' is always
	added.  A pointer to <dest> is returned.
 */
}
#include <string.h>
char *strupr(char *string)
{
/*  Convert all alphabetic characters in <string> to upper case.
 */
}
#include <string.h>
char *strlwr(char *string)
{
/*  Convert all alphabetic characters in <string> to lower case.
 */
}
#include <string.h>
char *strrev(char *string)
{
/*  Reverse the order of the characters in <string> in place.
 */
}
#include <string.h>
int strcmp(char *str1, char *str2)
{
/*  Lexicographically compare the two strings.  Return a value
	indicating the relationship between the strings.  Possible
	return values are:
		negative	str1 < str2
		0		str1 == str2
		positive	str1 > str2
 */
}
#include <string.h>
int strncmp(char *str1, char *str2, int limit)
{
/*  Compare strings as with strcmp(), but limit comparison to the
	<limit> characters.
 */
}
#include <string.h>
int stricmp(char *str1, char *str2)
{
/*  Compare strings as with strcmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
int strnicmp(char *str1, char *str2, int limit)
{
/*  Compare strings as with strncmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
char *strstr(char *string, char *pattern)  {  /*  Return a pointer to the first occurance of <pattern> in <string>.
	NULL is returned if <pattern> is not found.
 */
}
#include <string.h>
char *stristr(char *string, char *pattern)
{
/*  Same as strstr(), but ignore the case of any alphabetic characters.
 */
}
#include <string.h>
char *strchr(char *string, char symbol)
{
/*  Return a pointer to the first occurance of <symbol> in <string>.
	NULL is returned if <symbol> is not found.  '\0' is included in
	the search.
 */
}
#include <string.h>
char *strrchr(char *string, char symbol)
{
/*  Return a pointer to the last occurance of <symbol> in <string>.
	NULL is returned if <symbol> is not found.  '\0' is included in
	the search.
 */
}
#include <string.h>
int strpos(char *string, char symbol)
{
/*  Return the index of the first occurance of <symbol> in <string>.
	-1 is returned if <symbol> is not found.
 */
}
#include <string.h>
int strrpos(char *string, char symbol)
{
/*  Return the index of the last occurance of <symbol> in <string>.
	-1 is returned if <symbol> is not found.
 */
}
#include <string.h>
int strspn(char *string, char *set)
{
/*  Return the length of the sub-string of <string> that consists
	entirely of characters found in <set>.  The terminating '\0'
	in <set> is not considered part of the match set.  If the first
	character if <string> is not in <set>, 0 is returned.
 */
}
#include <string.h>
int strcspn(char *string, char *set)
{
/*  Return the length of the sub-string of <string> that consists
	entirel9 of characters not found in <set>.  The terminating '\0'
	in <set> is not considered part of the match set.  If the first
	character if <string> is in <set>, 0 is returned.
 */
}
#include <string.h>
char *strpbrk(char *string, char *set)
{
/*  Return a pointer to the first occurance in <string> of any
	character in <set>.
 */
}
#include <string.h>
char *strrpbrk(char *string, char *set)
{
/*  Return a pointer to the last occurance in <string> of any
	character in <set>.
 */
}
#include <string.h>
char *strtok(char *string, char *delim)
{
/*  Return a token from <string>.  If <string> is not NULL, it is
	the beginning of a string from which tokens are to be extracted.
	Characters found in <delim> are skipped over to find the start
	of a token, characters are then accumulated until a character in
	<delim> is found, or the terminator of <string> is reached.
	A pointer to the '\0' terminated token is then returned.  Note
	that this function modifies <string> (by inserting '\0's) in
	the process.  Subsequent calls to strtok() may specify NULL as
	the <string> argument, in which case subsequent tokens are
	returned, or NULL if there are no more tokens.
 */
}
#include <string.h>
char *strtrim(char *string, char *junk)
{
/*  Remove leading and trailing characters found in <junk>
	from <string>.  Return a pointer to the modified <string>.
 */
}
#include <string.h>
char *stradj(char *string, int dir)
{
/*  Adjust <string> by adding space if <dir> is positive, or removing
	space if <dir> is negative.  The magnitude of <dir> is the number
	of character positions to add or remove.  Characters are added or
	removed at the beginning of <string>.  A pointer to the modified
	<string> is returned.
 */
}
#include <string.h>
int strrpl(char *string, char *ptrn, char *rpl, int n)
{
/*  Replace at most <n> occurances of <ptrn> in <string> with <rpl>.
	If <n> is -1, replace all.  Return the number of replacments.
 */
}
#include <string.h>
int strirpl(char *string, char *ptrn, char *rpl, int n)
{
/*  Same as strrpl() except ignore the case of alphabetic characters.
 */
}


CHARACTER FUNCTIONS:

/*  To use the functions in this section, you must include <ctype.h> */
/*  in your source file.  Please note that the isxxxx() functions, */
/*  except isascii(), only have defined results if isascii() is true. */
/*  (ie. they only work properly on values 0x00 through 0x7F) */

#include <ctype.h>
int toupper(int c)
{
/*  Convert <c> to upper case, if alphabetic.  This is implemeted
	as a macro and also as a function.  You may force use of the
	function version rather than the macro (which evaluates its
	argument twice) by using the "#undef toupper" directive.
 */
}
#include <ctype.h>
int tolower(int c)
{
/*  Convert <c> to lower case, if alphabetic.  This is implemeted
	as a macro and also as a function.  You may force use of the
	function version rather than the macro (which evaluates its
	argument twice) by using the "#undef tolower" directive.
 */
}
#include <ctype.h>
MACRO _toupper(int c)
{
/*  This macro should be used only if <c> is known to be lower case.
	It converts <c> to upper case.  Results are undefined if converting
	a character which is not lower case.
 */
}
#include <ctype.h>
MACRO _tolower(int c)
{
/*  This macro should be used only if <c> is known to be upper case.
	It converts <c> to lower case.  Results are undefined if converting
	a character which is not upper case.
 */
}
#include <ctype.h>
MACRO toascii(int c)
{
/*  Convert <c> to 7-bit ascii, putting it into the range 0x00..0x7F.
 */
}
#include <ctype.h>
MACRO isalnum(int c)
{
/*  Return non-zero if <c> is '0'..'9','A'..'Z','a'..'z'.
 */
}
#include <ctype.h>
MACRO isalpha(int c)
{
/*  Return non-zero if <c> is 'A'..'Z','a'..'z'.
 */
}
#include <ctype.h>
MACRO isascii(int c)
{
/*  Return non-zero if <c> is 0x00..0x7F.
 */
}
#include <ctype.h>
MACRO iscntrl(int c)
{
/*  Return non-zero if <c> is 0x00..0x1F,0x7F.
 */
}
#include <ctype.h>
MACRO isdigit(int c)
{
/*  Return non-zero if <c> is '0'..'9'.
 */
}
#include <ctype.h>
MACRO isgraph(int c)
{
/*  Return non-zero if <c> is 0x21..0x7E.
 */
}
#include <ctype.h>
MACRO islower(int c)
{
/*  Return non-zero if <c> is 'a'..'z'.
 */
}
#include <ctype.h>
MACRO isprint(int c)
{
/*  Return non-zero if <c> is 0x20..0x7E.
 */
}
#include <ctype.h>
MACRO ispunct(int c)
{
/*  Return non-zero if <c> is not iscntrl(), isalnum() or isspace().
 */
}
#include <ctype.h>
MACRO isspace(int c)
{
/*  Return non-zero if <c> is 0x09..0x0D,0x20.
 */
}
#include <ctype.h>
MACRO isupper(int c)
{
/*  Return non-zero if <c> is 'A'..'Z'.
 */
}
#include <ctype.h>
MACRO isxdigit(int c)
{
/*  Return non-zero if <c> is '0'..'9','A'..'F','a'..'f'.
 */
}




FORMATTING/TYPE CONVERSION:

int _printf(char *op, int (*put)(), char *fmt, int *args)
{
/*  This function does all the work for printf(), et al.  Many systems
	don't provide direct access to this function (or it's equivalent),
	but it is useful for writing your own printf()-like functions.
	Since this is a non-standard interface, and v[sf]print() is now
	available, you should probably use the stdarg functions instead.
	<fmt> points to a format control string.  <args> pointers to a
	list of arguments.  The format string is used to create and output
	stream with the arguments.  The <put> function is used to output
	each character.  The <op> parameter is given to the <put> function
	to specify the output stream.  Calls to <put> are of the form:
	"(*put)(c, op);" where <c> is the character to output.  The format
	string is composed of characters and format specifications.  The
	'%' character introduces a format specifier.  The general form of
	a format specifier is:
	  %[-][ |+][0][<width>|*][.[<precision>|*]][l]{d|i|u|o|x|p|b|c|s
	The '-' specifies left justification.  The ' ' or '+' specifies
	the character which preceeds positive numeric values.  The '0'
	specifies that numeric fields will be padded with '0' rather than
	' '.  The <width> field is a numeric value specifying a minimum
	field width.  The <precision> field is a numeric value specifying
	the maximum number of data characters to display.  If '*' is
	specified for the width or the precision, an "int" value is taken
	from the argument list and used for that value.  If no width is
	specified, the field width varies according to the data width.  If
	no precision is specified, all data characters are included in the
	data width.  If the data width exceeds the field width, the field
	width will expand to allow all data characters to be printed.
	Including the 'l' or capitalizing the trailing character specifies
	that the associated value is a "long" type.  The trailing character
	specifies the format type, as follows:
		d	Signed decimal integer
		i	same as 'd'
		u	Unsigned decimal integer
		o	Unsigned octal integer
		x	Unsigned hexadecimal integer
		b	Unsigned binary integer
		p	Pointer (displayed in %06.8lX format)
		c	Character
		s	String
	If the character following the '%' is not recognized, it is
	simply passed along to the output stream, thus "%%" is used to
	print a single '%' character
 */
}

char *ltoa(long n, char *buffer, int radix)
{
/*  Convert the long value <n> to a string in <buf> using <radix>
	as the number base.  If <n> is negative, '-' will be the first
	character in <buf>.  A pointer to <buf> is returned.
 */
 */
}
char *ultoa(unsigned long n, char *buffer, int radix)
{
/*  Convert the unsigned long value <n> to a string in <buf> using
	<radix>	as the number base.  A pointer to <buf> is returned.
 */
}
char *itoa(int n, char *buffer, int radix)
{
/*  Convert the integer value <n> to a string in <buf> using <radix>
	as the number base.  If <n> is negative, '-' will be the first
	character in <buf>.  A pointer to <buf> is returned.
 */
}
long atol(char *number)
{
/*  Convert the string <number> to a long value.  Leading whitespace
	is ignored, a leading +/- is optional.  Characters are processed
	until a non-digit is reached.  Return value is undefined in an
	overflow situation.
 */
}
int atoi(char *number)
{
/*  Convert the string <number> to an int value.  Leading whitespace
	is ignored, a leading +/- is optional.  Characters are processed
	until a non-digit is reached.  Return value is undefined in an
	overflow situation.
 */
}
long strtol(char *number, char **nptr, int base) 
{
/*  Convert the string <number> to a long value of base <base>.  Bases
	from 0 to 36 are allowed.  Leading whitespace is ignored, and a
	leading +/- is optional.  If the <base> is 0, a leading '0'
	indicates base 8 and a leading "0x" or "0X" indicates base 16.
	Characters are processed until a character is found which is not in
	the specified base.  If <nptr> is non-NULL, it will be set to point
	to the character which terminated the translation in <number>.
	Return value is undefined in an overflow situation.
 */
}
unsigned long strtoul(char *number, char **nptr, int base)
{
/*  Convert the string <number> to an unsigned long value of base
	<base>.  Bases from 0 to 36 are allowed.  Leading whitespace is
	ignored.  If the <base> is 0, a leading '0' indicates base 8 and a
	leading "0x" or "0X" indicates base 16.  Characters are processed
	until a character is found which is not in the specified base.  If
	<nptr> is non-NULL, it will be set to point to the character which
	terminated the translation in <number>.  Return value is undefined
	in an overflow situation.
 */
}
int _scanf(char *ip, int (*get)(), int (*unget)(), char *fmt, char **args)
{
/*  This function does all the work for scanf(), et al.  Many systems
	don't provide direct access to this function (or it's equivalent),
	but it is useful for writing your own scanf()-like functions.
	<fmt> points to a format control string.  <args> pointers to a
	list of arguments, each of which is the address of a variable in
	which input data may be stored.  The format string is used to
	control reading of characters from the <get> function.  As each
	character is needed <get> is called in the form "c = (*get)(ip);"
	where <c> is the character read (negative for errors) and <ip> is
	the auxiliary pointer specified by the <ip> parameter.  If a
	character needs to be un-gotten, a call to <unget> of the form
	"(*unget)(c, ip);" is made.  The format string is composed of
	characters and format specifications.  Any characters in <fmt>,
	except whitespace characters, which are not part of a format
	specifier are expected to be matched one-to-one by characters in
	the input stream.  Scanning terminates if a mismatch occurs or if
	any call to <get> results in an error.  Whitespace characters
	match 0 or more whitespace characters in the input stream.  The
	'%' character introduces a format specifier.  The general form of
	a format specifier is:
		  
		  %[*][<width>][l|h]{d|u|o|x|b|i|c|s
	The '*' specifies that a field is to be scanned by not stored.
	No variable pointer should be provided for non-stored format
	specs.  The <width> field specifies that maximum number of
	characters to be process to fill the given format type.  Less
	than <width> characters will be processed if the field ends
	before <width> characters have been processed.  A field ends when
	either a whitespace character, or a character which does not fit
	the specified format, is read.  The preceding 'l' (or
	capitalizing the conversion character) specifies that the
	associated variable is a "long" type.  The trailing character
	specifies the format type, as follows:
		d Signed decimal integer
		u Unsigned decimal integer
		o Unsigned octal integer
		x Unsigned hexadecimal integer
		b Unsigned binary integer
		i Unsigned decimal/octal/hexadecimal/binary integer
		c Character
		s String
	If a <width> is specified with the 'c' format, exactly <width>
	characters (including whitespace) are read from the input stream,
	and written to a string.  No '\0' character is added If the
	character following the '%' is not recognized, it is expected to
	match the input stream as a non-format character, thus "%%" is
	used to match a single '%' character.
	One additional conversion is the brace-format.  Shown as "%[...]",
	the '...' represent a list of characters.  If the first character
	in the list is a '^', the field contains any characters -not- in
	the list (starting with the 1st character after the '^').  If the
	first character of the list is not a '^', then the field will
	only contain those characters found in the list.  A right brace 
	character (']') can be included as one of the list of characters
	by placing it as the first character in the list.  If the '^'
	negation character is the first character, the included brace
	should be the next character after the '^'.  For maximum
	portability, a range should be explicitly given (a good example
	would be "%[0123456789]"), but to allow for porting from
	systems with smarter scanf functions, this version of scanf
	also supports ranges represented using a <first>-<last>
	form (eg: "%[0-9]").  To use the first-last form, the
	character <first> must be lexically less than or equal to
	the character <last>.  If this rule is violated, or if the
	hyphen is the first or last character of the list, the
	hyphen will be assumed to be just another character in the
	list and no range expansion will be done.  The resulting
	string containing the characters in (or not in) the list
	will be null terminated.  It should be noted that, unlike
	most of the other formats, this conversion does allow the
	programmer to specify that whitespace characters will be
	included in the resulting string.
 */
}
char *ctlcnv(char *string)
{
/*  Convert \<char> notation in <string> to actual characters.  This
	is useful for reading strings from a stream when you want to allow
	insertion of control character or other characters that may have
	special meaning otherwise, or may not otherwise be allowed.  The
	following formats are supported:
		\n		newline or linefeed
		\r		carriage return
		\0		null character ( value 0 )
		\b		backspace
		\t		horizontal tab
		\v		vertical tab
		\f		form feed
		\a		alarm (bell)
		\\		backslash
		\'		single quote
		\"		double quote
		\NNN		octal constant
		\xNN		hexadecimal constant
		\<nl>		"folded" line ( both characters removed )
	A pointer to the modified <string> is returned.
 */
}



PROCESS CONTROL:

long _STKSIZ = 4096L;
/*  This variable defines the amount of run-time stack space to be */
/*  reserved.  The default value is 4K, which is more than enough */
/*  for most applications.  Since dynamic memory is NOT allocated */
/*  from the stack, this value need only be large enough to handle */
/*  local variables and deep recursion. */

char *etext;
char *edata;
char *end;
/*  These variables point to the first byte beyond the end of the */
/*  text, data and BSS segments respectively.  They are provided */
/*  for compatibility. */

void _initargs(char *cmdline, int cmdlen)
{
/*  Process the command arguments, either parsing the command line
	or copying XARG arguments, and retrieve the environment string.
	This function is called from the startup module very early on.
	Values to be passed to the user's main() function are stored in
	the global variables "_argc" and "_argv".  The startup module
	initiallizes these variables to indicate that no arguments are
	available, and sets "_envp" from the value in the basepage.  If
	a program doesn't use arguments, this function can be replaced
	by one like the one in <sys\minimum.h> to make the program smaller.
 */
}
int main(int argc, char *argv[], char *envp)
{
/*  This function is not actually in the standard libraries, but
	must be present somewhere in the user's code.  The parameters
	passed to it by _main() are the number of arguments in the
	command line, a pointer to a list of pointers to arguments, and
	a pointer to the initial environment string.  The return value
	from main() is passed, by _main(), to exit().  Therefore, you
	should always return() from main(), or call exit() directly.
 */
}
int _main()
{
/*  This function defines the standard streams, check to see which
	of them are devices, and calls the user's main() function.  The
	startup module calls this function to start the C program.  The
	following standard streams are initialized by _main():
		stdin		Standard input, may be redirected
		stdout		Standard output, may be redirected
		stderr		Usually the system console
		stdprn		The standard printer (output only)
		stdaux		The communication port (input/output)
	The global variables "_argc", "_argv" and "_envp" are used to
	store the values to be passed to the user's main().  If main()
	returns, exit() is called, with EXIT_SUCCESS status.  If a
	program doesn't use ANY standard i/o, this function can be
	replaced by one like the one in <sys\minimum.h> to make the
	program smaller.
 */
}
void exit(int status)
{
/*  Flushes and closes all open streams.  Returns <status> value to
	the operating system.
 */
}
void _exit(int status)
{
/*  Exits the program immediately, returning <status> to the OS.
 */
}
void abort()
{
/*  prints the message "Abnormal program termination" to stderr and
	calls _exit() with a status code of 3.
 */
}
int getpid()
{
/*  Return an integer value unique for this process.
 */
}
char *getenv(char *var)
{
/*  Search for <var> in the environment.  If <var> is found, a poin4er
	to it's value is returned.  NULL is returned if <var> is not found.
	WARNING:  The returned pointer points into the environment and
	must not be modified!
 */
}
int putenv(char *entry)
{
/*  Add <entry> to the environment.  <entry> can be any of the following
	forms:
		<VARIABLE>
		<VARIABLE>=
		<VARIABLE>=<value>
	The first form removes <VARIABLE> from the environment.  getenv()
	will return NULL if looking for this variable.  The second form adds
	<VARIABLE> to the environment, with a null value.  getenv() will
	return a pointer to a '\0' character if looking for this variable.
	Many environment handlers don't support such "tag variables", so
	their use is not recommended.  The final form is the most common,
	and safest to use.  <VARIABLE> is installed (or replaced) with the
	value <value>.  It should be noted that the putenv() function itself
	is not supported in many systems and therefore may not be portable.
	In addition, care should be taken to prevent overflowing the space
	allocated for the environment.  Returns TRUE for success or FALSE
	for failure.  NO OVERFLOW CHECKING IS DONE.
 */
}
void shell()
{
/*  Invoke a command line interface shell.  If the "SHELL" environment
	variable is not defined, a prompt showing the current working
	directory will be given.  Each line entered will then be passed
	to the system() function for execution until the command "exit"
	is entered to terminate the shell.  If "SHELL" is defined, and
	the "_shell_p" variable is valid, the value of "SHELL" will be
	passed to the program pointed to by "_shell_p" in order to allow
	the shell to invoke a command line interaction of its own.  If
	the "_shell_p" variable is not valid, the program defined by
	"SHELL" will be searched for along the "PATH", and executed with
	no arguments.  If the "SHELL" can't be found, the internal command
	line described above will be used.
 */
}
int system(char *command)
{
/*  Attempts to pass <command> to the shell program pointed to by
	the system variable "_shell_p".  If a valid shell can't be found
	there, the "SHELL" environment variable is searched for.  If it
	exists and is not empty, it will be the name of the shell program
	to execute the given command.  If "SHELL" is not valid, the
	"PATH" variable is used as a list of directories to search for
	the program name which is the first token of the command.  The
	extensions tried (if none is specified) are ".TTP", ".TOS",
	".PRG" and ".APP".
 */
}
int forkl(char *program[, *arg0, *arg1, ..., *argN], NULL)
{
/*  Create a child process.  Since it is not possible to do a true
	Unix-style fork(), the functionality of the fork()/exec() pair
	is provided by these fork*() functions.  A process is created,
	running concurrently if possible, which executes <program> with
	the arguments given.  A process id number is returned, which can
	be compared against the return value from wait().  Note that by
	convention <arg0> should be the name of the program that is
	being called, and is often ignored.  The fork*() functions all
	return ERROR if they for failure, or the child pid for success.
 */
}
int forklp(char *program[, *arg0, *arg1, ..., *argN], NULL)
{
/*  Use the environment variable "PATH" to find <program>. (cf: forkl)
 */
}
int forkle(char *program[, *arg0, *arg1, ..., *argN], NULL, *envp)
{
/*  Pass the environment <envp> to the child process. (cf: forkl)
 */
}
int forklpe(char *program[, *arg0, *arg1, ..., *argN], NULL, *envp)
{
/*  Use the environment variable "PATH" to find <program> and
	pass the environment <envp> to the child process. (cf: forkl)
 */
}
int forkv(char *program, **argv)
{
/*  Like forkl() except <argv> points to a NULL terminated list of
	pointers to arguments.  This is particularly useful if the number
	of arguments is not known at compile time.
 */
}
int forkvp(char *program, **argv)
{
/*  Use the environment variable "PATH" to find <program>. (cf: forkv)
 */
}
int forkve(char *program, **argv, *envp)
{
/*  Pass the environment <envp> to the child process. (cf: forkv)
 */
}
int forkvpe(char *program, **argv, *envp)
{
/*  Use the environment variable "PATH" to find <program> and
	pass the environment <envp> to the child process. (cf: forkv)
 */
}
int wait(int *rvp)
{
/*  Wait for a child process to terminate.  Return -1 if there are
	no children.  Normal return is the process id number of the
	terminated child.  <rvp> is an pointer to the place to store
	the return value and exit status.  The high byte of the word
	pointed to be <rvp> will contain the value returned from the
	child through exit().  The low byte will contain 0 if the process
	terminated normally, or an error code if abnormally.
 */
}
#include <osbind.h>
long gemdos(int func[, arg1, ..., argN])
{
/*  Call operating system trap #1 (GEMDOS) function number <func> with
	the arguments given.  Return value returned by the trap call.
 */
}
#include <osbind.h>
long bios(int func[, arg1, ..., argN])
{
/*  Call operating system trap #13 (BIOS) function number <func> with
	the arguments given.  Return value returned by the trap call.
 */
}
#include <osbind.h>
long xbios(int func[, arg1, ..., argN])
{
/*  Call operating system trap #14 (XBIOS) function number <func> with
	the arguments given.  Return value returned by the trap call.
 */
}
#include <osbind.h>
int bdos(int func, long parameter)
{
/*  Call operating system trap #2 (BDOS) function number <func> with
	passing the specified <parameter>.  Note that <parameter> must
	always be a long value, even if only a 16-bit value is required
	by the specified BDOS function.
 */
}
#include <setjmp.h>
int setjmp(jmp_buf context)
{
/*  Save <context> for longjmp(). You MUST include <setjmp.h> to use.
	Calling this function saves the current program context in the
	context buffer provided and returns zero.  A later call to the
	longjmp() function will cause the context to be restored and
	your program will continue as if it just returned from setjmp(),
	but this time with the (non-zero) return value specified in the
	longjmp() call.  THE SAVED CONTEXT WILL NOT BE VALID IF YOU
	EXIT THE FUNCTION THAT CALLED setjmp().
 */
}
#include <setjmp.h>
void longjmp(jmp_buf context, int rv)
{
/*  Return <rv> to the <context> saved by setjmp(). (cf: setjmp)
	You MUST include <setjmp.h> to use.
 */
}
#include <setjmp.h>
int catch(jmp_buf context, int (*func)())
{
/*  Execute <func> with <context> saved for throw().  You MUST include
	<setjmp.h> to use.  Return the value returned by <func>.  The main
	advantage of these functions over catch/throw is the ability to
	return zero from the function executed, and the logically "cleaner"
	encapsulation of the non-local jump operation.  These functions
	are patterned after similar functions in LISP.  (cf: setjmp/longjmp)
 */
}
#include <setjmp.h>
void throw(jump_buf context, int rv)
{
/*  Return <rv> to <context> saved by catch().  You MUST include
	<setjmp.h> to use.
 */
}




INPUT/OUTPUT FUNCTIONS:

int read(int h, char *data, int length)
{
/*  Read <length> bytes from the file reference by file handle <h>.
	Data is stored in the buffer pointed to by <data>.  The number
	of bytes actually read is returned, 0 for end of file, or a
	negative error code.  Note that the maximum number of bytes
	that can be read by this function is MAXINT.
 */
}
long lread(int h, char *data, long length)
{
/*  Same as read(), but uses a long value for number of bytes to read.
 */
}
int write(int h, char *data, int length)
{
/*  Write <length> bytes to the file reference by file handle <h>.
	Data is written from the buffer pointed to by <data>.  The number
	of bytes actually written is returned, or a negative error code.
	Note that the maximum number of bytes that can be written by
	this function is MAXINT.
 */
}
long lwrite(int h, char *data, long length)
{
/*  Same as write(), but uses a long value for number of bytes to write.
 */
}
int fread(char *data, int size, int count, FILE *fp)
{
/*  Read <count> items of <size> characters each from stream <fp>.
	Data is stored in the buffer pointed to by <data>.  The number of
	full items actually read is returned, or a negative error code.
	This call DOES NOT translate characters, even if the stream is
	opened in translate mode.
 */
}
int fwrite(char *data, int size, int count, FILE *fp)
{
/*  Write <count> items of <size> characters each to stream <fp>.
	Data is read from the buffer pointed to by <data>.  The number of
	full items actually written is returned, or a negative error code.
	This call DOES NOT translate characters, even if the stream is
	opened in translate mode.
 */
}
int getc(FILE *fp)
{
/*  Same as fgetc() but implemented as a macro.
 */
}
int fgetc(FILE *fp)
{
/*  Get a character from <fp>.  Returns the character or EOF.
 */
}
int ungetc(char c, FILE *fp)
{
/*  Same as fungetc() but implemented as a macro.
 */
}
int fungetc(char c, FILE *fp)
{
/*  Push the character <c> back to be gotten by the next fgetc()
	call on <fp>.  Only 1 character may be ungotten at a time on
	each stream.  Subsequent calls to fungetc() will write over
	the currently saved character.
 */
}
int putc(char c, FILE *fp)
{
/*  Same as fputc() but implemented as a macro.
 */
}
int fputc(char c, FILE *fp)
{
/*  Put the character <c> to the stream <fp>.
 */
}
int fflush(FILE *fp)
{
/*  Flush the file i/o buffer of the stream <fp>.  The buffer is
	automatically flushed when it is full, the stream is closed,
	or the program terminates through exit().  This function has
	no effect if the stream in unbuffered.  Call this function
	before switching between reading and writing on a stream which
	is opened for both.
 */
}
int getw(FILE *fp)
{
/*  Get a 2-byte value from the stream <fp>.  The high-order byte is
	read first.  Use feof() to test for end-of-file.
 */
}
int putw(int n, FILE *fp)
{
/*  Put the 2-byte value <n> to the stream <fp>.  The high-order byte
	is written first.
 */
}
int getl(FILE *fp)
{
/*  Get a 4-byte value from the stream <fp>.  The high-order byte is
	read first.  Use feof() to test for end-of-file.
 */
}
int putl(long n, FILE *fp)
{
/*  Put the 4-byte value <n> to the stream <fp>.  The high-order byte
	is written first.
 */
}
int getch()
{
/*  Machine dependent console input function.  This function normally
	gets a character from the keyboard by calling the GEMDOS "Cconin"
	function.  If cfg_ch() is given the _CIOB option, input is gotten
	from the BIOS "Bconin" function instead.  The BIOS level functions
	don't process ^C, ^S or ^Q, while the GEMDOS functions do.  The
	most common use for getch() is when keyboard scan codes are needed
	to process special function keys.  The return value from getch()
	consists of the scan code in the high-order byte, and the ascii
	character code in the low-order byte.  If cfg_ch() is given the
	_CIOCH option, the return value is always an 8-bit quantity,
	either the scan code with the 8th bit set, or the ascii code with
	the 8th bit clear.  This is somewhat less informative, since the
	scan code form is returned only if the ascii value is 0, but is the
	default configuration value for compatability with Microsoft C.
	In any case, the global unsigned long variable "_getch" will contain
	the full character code value returned by the OS.
 */
}
int getchar()
{
/*  Same as "fgetc(stdin)".
 */
}
int ungetchar(char c)
{
/*  Same as "fungetc(c, stdin)".  Note that this name will conflict
	with any function beginning "ungetch..." due to having only 7
	significant characters in external identifiers.
 */
}
int putchar(char c)
{
/*  Same as "fputc(c, stdin)".
 */
}
int cfg_ch(int cfg)
{
/*  Configure getch()/putch() operation.  The following are legal
	values for <cfg> and may be combined with the | operator:
		_CIOB		Use BIOS level i/o calls
		_CIOCH		8-bit character codes only (cf:getch)
		_CIOVT		Enable VT-52 escape sequence proc%ssing
	The initial configuration value at run time is _CIOCH.  This
	function returns the previous configuration value, and if <cfg>
	is -1 the value is not set.
 */
}
int getche()
{
/*  Same as getch() but calls putch() to echo the character.
 */
}
char putch(char c)
{
/*  Machine dependent (typically quite fast) console output function.
	This function normally puts a character to the console by calling
	the GEMDOS "Cconout" function.  If cfg_ch() is given the _CIOB
	option, output is sent to the BIOS "Bconout" function instead.
	The BIOS level functions don't process ^C, ^S or ^Q, while the
	GEMDOS functions do.  At the BIOS level, the _CIOVT option to
	cfg_ch() allows VT-52 escape code processing on output.  The
	GEMDOS function always does VT-52 emulation.  The BIOS function
	defaults to skipping this overhead, but if VT-52 emulation is
	desired, it can still be used through the faster BIOS level
	routine	by using the _CIOVT option.  Control codes, like '\b'
	and '\r', are supported even without VT-52 emulation.  The return
	value of this function is simply the character sent.
 */
}
int kbhit()
{
/*  Machine dependent function to detect if input is waiting for the
	getch() function.  Returns non-zero if the console has data ready.
 */
}
char *getln(char *ip, int (*get)(), int (*put)(), char *buffer, int limit)
{
/*  Get a line of input from the user.  Allow simple editing of the line
	with BS/DEL, ESC, and CR/LF to terminate input.  Characters are
	retreived by a (*get)(ip) and echoed with (*put)(c).  A pointer to
	<buffer> is returned in any case.  This function is no longer
	needed to handle editable i/o from stdin, since the pseduo-tty
	driver code built into fgetc() now handles line editing, but this
	function is still useful if you want to supply your own get/put
	functions (like curses?).
 */
}
char *gets(char *data)
{
/*  Get data from stdin and puts it in the <data> buffer.  Input is
	terminated when a newline is read.  The	newline will be replaced
	by a '\0' to terminate the string.  A backspace character will
	remove the preceeding character from the buffer, but will not
	backspace past the start of the buffer.  A pointer to the start
	of <data> is returned, or NULL for EOF.
 */
}
void puts(char *data)
{
/*  Write the characters in <data> to stdout.  A newline WILL be
	written after the data.
 */
}
char *fgets(char *data, int limit, FILE *fp)
{
/*  Get data from <fp> and puts it in the <data> buffer.  At most,
	<limit>-1 characters will be read.  Input will also be terminated
	when a newline is read.  <data> will be '\0' terminated and the
	newline, if read, will be included.  A pointer to the start of
	<data> is returned, or NULL for EOF.
 */
}
void fputs(char *data, FILE *fp)
{
/*  Write the characters in <data> to the stream <fp>.  A newline
	WILL NOT be added.
 */
}
void cputs(char *data)
{
/*  Write the characters in <data> directly to the console using the
	system dependent putch() function.  A newline WILL NOT be written
	after the data.
 */
}
int printf(char *fmt[, arg1, ..., argN])
{
/*  Formatted output to the stdout stream.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int fprintf(FILE *fp, char *fmt[, arg1, ..., argN])
{
/*  Formatted output to the stream <fp>.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int sprintf(char *buf, *fmt[, arg1, ..., argN])
{
/*  Formatted output to the string <buf>.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int cprintf(char *fmt[, arg1, ..., argN])
{
/*  Formatted output directly to the console.  This functions uses the
	system dependent putch() for output.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int vfprintf(FILE *fp, char *fmt, va_list ap)
{
/*  Formatted output to the stream <fp> with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int vprintf(FILE *fp, va_list ap)
{
/*  Formatted output to the stdout stream with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int vsprintf(char *buf, *fmt, va_list ap)
{
/*  Formatted outout to the string <buf> with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int scanf(char *fmt[, arg1, ..., argN])
{
/*  Formatted input from the stdin stream.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int fscanf(FILE *fp, char *fmt[, arg1, ..., argN])
{
/*  Formatted input from the stream <fp>.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int sscanf(char *buf, *fmt[, arg1, ..., argN])
{
/*  Formatted input from the string <s>.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int _tttty(FILE *fp)
{
/*  "Teeny Tiny TTY" driver function.  This function is internal to
	dLibs, but it's name is documented to allow you to replace it with
	a tty driver of your own.  It's operation can be best understood
	by reading and UNDERSTANDING the code in the routine provided.  In
	brief, this function is supposed to read from <fp>, up to a newline
	character, putting the character in the FILE buffer, and return the
	number of characters read (similar to _fillbuf() in some systems).
	If the stream is in binary mode, a full buffer is to be read, with
	no translation.  If the stream is unbuffered, characters are also
	untranslated, but ^C on input is checked for, however, the code
	which calls this function will translate carriage return characters
	into newlines and ^Z will cause EOF.  Effectively, this means that
	line editing is not allowed if the stream in unbuffered, but most
	translation is done.  Note that this mode of operation is the least
	likely to produce unix-like results, particularly in the way some
	control characters are echoed.  It is recommended that either binary
	mode, or buffered and translated mode be used.
 */
}



FILE HANDLING:

int chdir(char *pathname)
{
/*  Changes the current working directory to <pathname>.  If a
	drive letter is specified in <pathname>, the current working
	directory for that drive is set.  Returns 0 for success, or
	a negative error code.
 */
}
int mkdir(char *pathname)
{
/*  Creates a new directory called <pathname>.  A drive letter may
	be specified.  Returns 0 for success, or a negative error code.
 */
}
int rmdir(char *pathname)
{
/*  Removes an existing directory called <pathname>.  A drive letter may
	be specified.  Returns 0 for success, or a negative error code.
 */
}
char *fullpath(char *full, *part)
{
/*  <part> is a (possibly) ambiguous file/path specification.  A
	non-ambiguous file/path spec is created which includes a drive
	letter and all intermediate sub-directories.  If the partial
	specification is not valid, NULL is returned, otherwise a
	pointer to <full> is returned.  If NULL is specified for <full>,
	an internal buffer is used and a pointer to it is returned.
 */
}
char *getcwd(char *buffer, int size)
{
/*  Get the full pathname of the current working directory.  This
	value will ALWAYS end with a '\\' character.  <pathbuf> is a
	pointer to a buffer of <size> bytes that will be used to store
	the current working directory.  If <buffer> is NULL, a buffer
	of <size> bytes will be malloc()ed.  The function returns a
	pointer to the buffer for success, or NULL for failure, either
	because malloc() failed, or the value is larger than <size>.
	This function uses fullpath() to get the pathname, therefore
	the buffer internal to fullpath() is overwritten.
 */
}
int access(char *name, int amode)
{
/*  Return non-zero if a file with the given <name> can be accessed
	in the given <amode>.  Possible <amode> values are:
		0x00		file exists
		0x02		file can be written
		0x04		file can be read
		0x06		file can be read and written
 */
}
char *findfile(char *afn[, *ext])
{
/*  Return full file spec for <afn> if found. If <afn> has no extension,
	extensions from <ext> are tried until a match is found, or the list
	ends.  <ext> is a list of extensions separated by '\0' characters
	and ending with an additional '\0', ie. ".ttp\0.tos\0.prg\0" (note
	that the final null is added by the compiler to any string constant.
	If <afn> already has an extension, <ext> is not used.  If no matching
	files are found, NULL is returned.  The pointer returned when a match
	is found points to a buffer which is internal to fullpath().  If you
	want to save the value returned, you must make a copy before the
	buffer is overwritten by subsequent calls.  Note: several dLibs
	functions call filefind(), so don't make too many assumptions about
	how long the internal buffer is going to stay valid.
 */
}
char *pfindfile(char *path, *afn[, *ext])
{
/*  Like findfile() but search all directories (separated by ',' or ';')
	in <path>.  If <path> is NULL, the "PATH" environment variable is
	used instead.  If <afn> specifies a drive or directory, <path> is
	not used.  The internal buffer for findfile() is used by pfindfile().
 */
}
char *wildcard(char *pathname)
{
/*  Return matches for a wildcard filename.  If <pathname> is not
	NULL, the first file which matches <pathname> will be returned.
	The <pathname> may contain wildcards only in the filename portion,
	not in any sub-directories.  Subsequent calls to wildcard() with
	a NULL argument return the next matching filename.  NULL is
	returned when no more files match.  Note: the pointer returned
	points to an internal buffer which is overwritten with each
	call.  It should not be modified, and should be copied into a
	safe place if you want to save the value.
 */
}
char *_splitpath(char *src, *drive, *path, *file, *ext)
{
/*  Parse the <src> filename into component parts. Returns <src>.
	If any of the component pointers is NULL, that component will
	be parsed, but not saved.  If a given component does not exists
	int the <src> string, the component will be empty, (ie.: "").
	The <drive> component will be a drive letter followed by a colon,
	(ie.: "a:").  The <path> component will be the subdirectory names
	leading up to the filename, but will not include a trailing '\'
	unless the path the simply the root path "\", and there will only
	be a leading '\' if the path is fully qualified, or "rooted", ie.:
	"\this\is\a\path\name".  The <file> component is the base filename
	without any extension, ie.: "filename".  The <ext> component is
	the file extention with no leading '.', ie.: "txt".  Recommended
	sizes for the components is Drive[4], Path[128], File[10], Ext[4].
 */
}
char *_makepath(char *dst, *drive, *path, *file, *ext)
{
/*  Build the <dst> filename from component parts. Returns <dst>.
	This function is basically in inverse of _splitpath(), and will
	accept the components parsed by _splitpath() as input.  It will
	also allow a little more flexibility in that it will treat any
	component which is a NULL pointer as an empty field, and the
	<path> component may optionally have a trailing '\'.
 */
}
char *tmpnam(char *s)
{
/*  Generate a unique filename to be used for a temporary file.
	The filename will have the form "TEMP$nnn.TMP" where "nnn" is a
	sequence of numeric digits.  The name will unique in the current
	working directory.  If <s> is NULL, space will be obtained from
	malloc() to store the filename and thus must be free()'d by the
	caller.  If <s> is not NULL, the filename will be copied into the
	buffer provided.  This function returns NULL for failure, or a
	pointer to the filename for success.
 */
}
char *tempnam(char *dir, *pfx)
{
/*  This function is similar to tmpnam(), but is somewhat more flexible.
	<dir> specifies the directory part of the filename.  If <dir> is
	NULL, the TMPDIR environment variable will be used.  If TMPDIR is
	not found, the current directory is used.  <pfx> specifies the
	filename prefix (up to 5 characters).  The form of the filename
	will be "dir\pfxnnn.TMP", similar to tmpnam().  The storage for
	the filename is always obtained from malloc(), so the caller must
	free() it after use.  This function returns NULL for failure, or a
	pointer to the fully expanded filename for success.
 */
}
int stat(char *name, struct stat *statbuf)
{
/*  Search for file <name> and load <statbuf> with information
	about that file, if it is found.  Return 0 if found, or
	ERROR (-1) if no file/directory matched <name>.  Volume
	labels are not included in the search.  The file <stat.h>
	must be included if you 5se this functions, since it defines
	struct stat.
 */
}
long fsize(char *name)
{
/*  Return the size of the file <name> in bytes.  Note that this
	is a long value.  Return -1L if the file is not found.
 */
}
int isatty(int handle)
{
/*  Return non-zero if <handle> refers to a character device.
	Negative handles always refer to character devices.
 */
}
int creat(char *filename, int pmode)
{
/*  Create a new file with the given <filename>.  If a file with
	the name already exists, it will be truncated to zero bytes.
	Since the OS doesn't do this properly, the file is actually
	deleted and then re-created.  <pmode> specifies the attributes
	initially given to the file.  Valid <pmode> values are:
		0x00			normal, read/write
		S_ISRO			read only
		S_IFHID			hidden file
		S_IFSYS			system file
		S_ISVOL			volume label
	If S_ISVOL mode is specified, it must be the only mode given.
	Other modes may be combined with the | operator.  The <stat.h>
	file contains information useful with this function.
 */
}
int chmod(char *filename, int pmode)
{
/*  Change the mode attribute of <filename> to <pmode>.  Values for
	<pmode> are the same as for the creat() function.  Returns 0 for
	success, or a negative error code.
 */
}
int open(char *filename, int iomode[, pmode])
{
/*  Attempt to open <filename> with the given <iomode>.  A file handle
	is returned if the open succeeds.  A negative error code is returned
	for errors.  Valid <iomode> values are:
		O_RDONLY	read mode
		O_WRONLY	write mode
		O_RDWR		read/write mode
	In addition to the (mutually exclusive) modes above, one or more
	of the following options may be |-ed with <iomode>:
		O_APPEND	start file pointer at end of file
		O_TRUNC		if file exists, truncate to 0 length
		O_CREAT		creat() file if none exists (uses <pmode>)
		O_EXCL		return EEXIST if file exists and
				O_CREAT is specified (exclusive mode).
	Note: It is possible to open the character devices "con:", "aux:",
	and "prn:" with this call, and negative handles (-1..-3) will be
	returned.  Error returns are always < -3.  The <fcntl.h> file
	contains iomode constants.  The <stat.h> file contains pmode
	constants.
 */
}
int close(int h)
{
/*  Close file referenced by the file handle <h>.  Return 0 for
	success, or a negative error code.
 */
}
int dup(int handle)
{
/*  Return a second file handle which refers to the same file as
	the given <handle>. (cf: dup2)
 */
}
int dup2(int handle1, int handle2)
{
/*  Force <handle2> to refer to the same file as <handle1>.  Return
	0 for success, or a negative error code.  Both dup() and dup2()
	are direct calls to Fdup() and Fforce() GEMDOS calls.  Refer to
	your GEMDOS documentation for further information.
 */
}
int remove(char *filename)
{
/*  Delete <filename>, if it exists.  Return 0 for success, or a
	negative error code.
 */
}
int rename(char *oldname, *newname)
{
/*  Change the name of file <oldname> to <newname>.  You may use this
	function to move files from one directory (pathname) to another,
	but not from one drive to another.  Return 0 for success, or a
	negative error code.
 */
}
long lseek(int h, long offset, int origin)
{
/*  Move file pointer for file <h> to specified location.  <origin>
	specifies the starting point for the <offset> distance.  Valid
	<origin> values are:
		SEEK_SET	from beginning of file	(0)
		SEEK_CUR	from current location	(1)
		SEEK_END	from end of file	(2)
	The <offset> value is the distance in bytes from the origin.
	The final file position, or a negative error code, is returned.
 */
}
long tell(int h)
{
/*  Return the current file position for the file <h>.
 */
}
FILE *fopen(char *filename, char *mode)
{
/*  Open <filename> as a stream file.  This is the normal open way
	to open a file.  The <mode> is a string specifying the mode(s)
	that are relevent to the file open.  Valid <mode> characters are:
		r		read mode
		w		write mode
		a		append mode
		b		binary mode
		t		text (translated) mode
	At least one of "r", "w" or "a" must be specified.  "t" is assumed
	and indicates that <nl> is translated to <cr><lf> on output and
	vica-versa on input.  If the stream is a character device, the
	translation is slightly different.  The output translation is the
	same, but on input <cr> and <lf> both become <nl> in all cases.
	The "b", for binary mode, overides "t" and indicated that characters
	are not translated during i/o operations.  "a" represents append
	mode and means that the file pointer will initially be placed at
	the end of the file.  "w" mode will create a file if it doesn't
	exists, or zero an existing file.  If "r" is the only mode specified,
	the file must already exist.  A (FILE *) is returned if the open
	succeeds, or NULL if it fails.
 */
}
FILE *freopen(char *filename, char *mode, FILE *fp)
{
/*  Closes the file associated with <fp> and opens the new file as with
	fopen(), except that a new FILE structure is not created.  The
	existing FILE structure pointed to by <fp> is re-initialized with
	the new file information.  This is typically used to redirect i/o
	to standard streams stdin, stdout, stderr, stdprn, stdaux.  <fp>
	is returned for success, or NULL for failure.
 */
}
FILE *fdopen(int h, char *mode)
{
/*  Associates a stream with the already open file <h>.  The <mode>
	values are the same as for fopen(), but MUST be compatible with
	the mode in which <h> was open()ed.  This functions allows a file
	opened with the low level open()/creat() calls to be used as a
	buffered/translated stream.  A pointer to a FILE struct is returned,
	or NULL for errors.
 */
}
FILE *fopenp(char *filename, char *mode)
{
/*  Find <filename> somewhere on the PATH and open it with <mode>.
	Refer to the fopen() function for valid <mode> values.  If you
	want to use a search path other than the PATH environment
	variable, use the pfindfile() function to locate the file, and
	pass that filename to fopen().  (cf: pfindfile, fopen)
 */
}
int fclose(FILE *fp)
{
/*  Close the stream <fp>, flushing the buffer.  Returns 0 on success.
 */
}
void setbuf(FILE *fp, char *buf)
{
/*  If <buf> is NULL, make <fp> unbuffered; else <buf> points to a buffer
	of BUFSIZ characters to be used as the stream buffer for <fp>.
 */
}
void setvbuf(FILE *fp, char *buf, int bmode, int size)
{
/*  If <buf> is NULL or <bmode> is _IONBF, make <fp> unbuffered;
	otherwise <buf> points to a buffer of <size> characters to be
	used as the stream buffer for <fp>.  The <bmode> variable
	indicates the type of buffering desired, as follows:
		_IONBF		No buffering
		_IOFBF		Full buffering (normal)
		_IOLBF		Line buffering (not supported, same as _IOFBF)
 */
}
int fseek(FILE *fp, long offset, int origin)
{
/*  Operates like lseek(), except it works on streams.  Note that
	stream file positions may be misleading due to translation of
	<nl> characters during i/o.  ftell() may be used reliably with
	fseek() to reposition a file to a prior location.  WARNING:
	fseek() returns 0 for success, non-zero for failure, according
	to the ANSI standard.  Some implementations use 0 for failure.
	This function is maintained for compatibility with old programs.
	fsetpos() should be used in new code.  (cf: fsetpos)
 */
}
void rewind(FILE *fp)
{
/*  Operates like fseek(fp, 0L, SEEK_SET), except it also clears the
	end-of-file and error flags for <fp>.  There is no return value.
 */
}
long ftell(FILE *fp)
{
/*  Operates like tell(), except it works on streams.  Note that
	stream file positions may be misleading due to translation of
	<nl> characters during i/o.  This function is maintained for
	compatibility with old programs.  fsetpos() should be used in
	new code.  (cf: fsetpos)
 */
}
int fgetpos(FILE *fp, fpos_t *pos)
{
/*  Get the position of the stream <fp> and store it at the location
	pointed to be <pos>.  This is the new X3J11 function to replace
	ftell().  Returns 0 for success and ERROR for failure.
 */
}
int fsetpos(FILE *fp, fpos_t *pos)
{
/*  Set the position of the stream <fp> to the valued stored at the
	location pointed to be <pos>.  Note that this function is only
	required to work properly for a <pos> value which was previously
	obtained by fgetpos() on the s!me stream.  This is the new X3J11
	function to replace fseek().  Returns 0 for success and ERROR for
	failure.
 */
}
int fileno(FILE *fp)
{
/*  Return the file handle associated with the stream <fp>.
 */
}
int feof(FILE *fp)
{
/*  Return non-zero if <fp>	is at end of file.
 */
}
int ferror(FILE *fp)
{
/*  Return non-zero if and error has occurred on <fp>.
 */
}
void clearerr(FILE *fp)
{
/*  Clear the error flag on <fp>.
 */
}
sync()
{
/*  Provided for compatibility.  #define'ed as a comment.
 */
}

 
