PD HELP FILE FOR CBREEZE                               XBIOS
based on A Hitchhiker's Guide to the BIOS 

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only

XBIOS
Initmous,  Physbase,  Logbase,   Getrez,    Setscreen,  Setpallete,
Setcolor,  Floprd,    Flopwr,    Flopfmt,   Midiws,     Mfpint,
Iorec,     Rsconf,    Keytbl,    Random,    Protobt,    Flopver,
Scrdmp,    Cursconf,  Settime,   Gettime,   Bioskeys,   Ikbdws,
Jdisint,   Jenabint,  Giaccess,  Offgibit,  Ongibit,    Xbtimer,
Dosound,   Setprt,    Kbdvbase,  Kbrate,    Prtblk,     Vsync,
Supexec,

/* the following dlibs call is undocumented and not described */

Steprate(drive,rate)		xbios(41,drive,rate)


/*  Extended BIOS Functions  */


(0) initmous 
VOID Initmous(type, param, vec) 
WORD type;
LONG param, vec;
{
/*    Initialize mouse packet handler.  'type'  is  one of:
 type   Action 
  0     disable mouse 
  1     enable mouse, in relative mode 
  2     enable mouse, in absolute mode 
  3     (unused) 
  4     enable mouse, in keycode mode 

'param' points to a parameter block that should look like:
 struct param   
  BYTE topmode;
  BYTE buttons;
  BYTE xparam;
  BYTE yparam;
  ;

'topmode' should be:
  0     Y_position == 0 at bottom 
  1     Y_position == 0 at top 

'buttons'  is a parameter for the keyboard's "set mouse  buttons" command.

'xparam' and 'yparam' are the X and Y  threshold,  scale or delta  factors,
depending on the mode the mouse is being placed in.

For mouse absolute mode,  some  extra  parameters immediately follow
the parameter block:
 struct extra   
  WORD xmax;
  WORD ymax;
  WORD xinitial;
  WORD yinitial;
  ;

'xmax' and 'ymax' specify the maximum X and Y mouse positions.

'xinitial' and 'yinitial' specify the initial X and Y mouse position.

'vec' points to a mouse interrupt handler;
see extended function number  34,  'kbdvbase', for further information 
about ikbd subsystem handlers.
 */
}

(1) ssbrk 
LONG Ssbrk(amount) 
WORD amount;
{
/*    Reserve 'amount' bytes from the top of memory.
Returns a long pointing to the base of the allocated  memory.
This function  MUST  be  called before the OS is initialized.

'ssbrk'  is actually pretty useless.   It  DOES NOT  work  
after GEMDOS has been brought up,  since the TPA has already 
been set up.
 */
}

(2) _physBase 
LONG Physbase()
{
/*    Get the screen's physical base  address  (at  the  beginning 
of the next vblank).
 */
}

(3) _logBase 
LONG Logbase() 
{
/*    Get  the screen's logical base,  right away.    This is  the 
location that GSX uses when drawing to the screen.
 */
}

(4) _getRez 
WORD Getrez() 
{
/*    Get the screen's current resolution (returning 0, 1 or 2).
 */
}

(5) _setScreen 
VOID Setscreen(logLoc, physLoc, rez) 
LONG logLoc, physLoc;
WORD rez;
{
/*    Set the logical screen location (logLoc),  the  physical screen
location  (physLoc),   and the physical screen resolution.
Negative parameters are ignored ( making it possible,  for instance,
to set screen resolution without changing anything else).

The logical screen location changes immediately.  The physical screen
location hardware register is changed immediately, but the new screen
location will take effect after the next vertical retrace.

When resolution is changed,   the  screen is cleared, the cursor is homed,
and the VT52 terminal emulator state is reset.
 */
}

(6) _setPallete 
VOID Setpallete(palettePtr) 
LONG palettePtr;
{
/*    Set the contents of the hardware palette register (all   16 
color entries) from the 16 words pointed to by 'Paletteptr'.  
'paletteptr' MUST  be  on  a word  boundary.    The  palette  
assignment takes place at the beginning of the next vertical
blank interrupt.
 */
}

(7) _setColor 
WORD Setcolor(colorNum, color) 
WORD colorNum, color;
{
/*    Set the palette number 'Colornum' in the hardware palette 
table to the given color.   Return the old color in D0.W.   
If 'color' is negative, the hardware register is not changed.
 */
}

(8) _floprd 
WORD Floprd(buf,  filler,  devno,  sectno, trackno, sideno, count)
LONG buf, filler;
WORD devno, sectno, trackno, sideno, count;
{
/*    Read one or more  sectors  from  a  floppy   disk.

'filler'  is an unused longword.
'buf'     must point to a word-aligned buffer large enough to
contain the number ofsectors requested.
'devno'   is the floppy number (0 or 1).
'sectno'  is the sector number to start reading from
( usually  1 through 9).
'trackno' is the track number to seek to.
'sideno'  is the side number to select.
'count'   is the number of sectors to read (which must be less than or 
equal to the number of sectors per track).

On return,  D0 contains a status code.  If  D0  is zero, the 
operation succeeded.  If D0 is nonzero, the operation failed 
(and D0  contains  an  error  number).
 */
}

(9) _flopwr 
WORD Flopwr(buf,  filler,  devno,  sectno, trackno, sideno, count)
LONG buf, filler;
WORD devno, sectno, trackno, sideno, count;
{
/*    Write one or more sectors to a floppy disk.

'buf'     must point to a word-aligned buffer.
'filler'  is an unused longword.
'devno'   is the floppy number  (0 or 1).  
'sectno'  is the sector number to start writing to (usually 1 
through 9).
'trackno' is the track number to seek to.
'sideno'  is the side number to select.
'count'   is the number of sectors to write (which must be less than
or equal to the number of sectors pertrack).

On return,  D0 contains a status code.  If  D0  is zero, the 
operation succeeded.  If D0 is nonzero, the operation failed 
(and D0  contains  an  error number).

Writing to the boot sector  (sector  1,   side  0,  track 0) 
will  cause  the  media to enter the  "might  have  changed" 
state.   This  will  be  reflected  on the next  rwabs()  or 
mediach() BIOS call.
 */
}

(10) _flopfmt 
WORD Flopfmt(buf,filler,devno,spt,trackno,sideno,interlv,magic,virgin)
LONG buf, filler;
WORD devno, spt, trackno, sideno, interlv, virgin;
LONG magic;
{
/*    Format a track on a floppy disk.
'buf'     must point to a word-aligned buffer large enough to hold
an entire track image ( 8K   for   9  sectors- per-track ).
'filler'  is an unused longword.
'devno'   is the floppy drive number  (0  or  1).
'spt'     is the number of sectors-per-track to format ( usually 9 ).
'trackno' is the track number to  format ( usually  0  to 79 ).
'sideno'  is the side number to format ( 0 or 1 ).
'interlv' is the sector-interleave factor ( usually 1 ).
'magic'   is a magic number that MUST be the value  $87654321.
'virgin'  is a word fill value for new sectors.

On return,  D0  contains a status code.  If  D0  is zero, the 
operation succeeded.   If D0 is nonzero, the operation failed
( and D0 contains an error number ).  The format function can
softfail when it finds bad sectors during the verify pass.
The caller  has the choice of attempting to reformat the  media, 
or recording the bad sectors so they will not be included in
the file system.

A null-terminated  (0.W)  list of bad sector numbers  is returned
in the buffer.  They are not necessarily in numerical order. ( if
there were no bad sectors, the first word in the buffer will be zero. )
A good value for 'virgin' is $E5E5.  The high nibble of each byte in
the 'virgin' parameter must not be equal to $F.   Resist the temptation
to format a disk with sectors initialized to zero.

Formatting a track will cause the  media to enter the "definitely changed"
state.    This will be reflected on the next rwabs() or mediach()
BIOS call.
 */
}

(11) used-by-BIOS 
VOID used-by-BIOS() 
{
/*    ( Obsolete function ] 
 */
}

(12) midiws 
VOID Midiws(cnt, ptr) 
WORD cnt;
LONG ptr;
{
/*    Writes a string to the MIDI port.
'cnt'    is the number of characters to write, minus one.
'ptr'    points to a vector of characters to write.
 */
}

(13) _mfpint 
VOID Mfpint(interno, vector) 
WORD interno;
LONG vector;
{
/*    Set the MFP interrupt number 'interno' ( 0 to 15 ) to 'vector'.
The old vector is written over ( and thus unrecoverable ).
 */
}

(14) iorec 
LONG Iorec(devno) 
WORD devno;
{
/*    Returns a pointer to a serial device's input buffer record.
'devno' is one of:

 devno   Device 
 -----   -------- 
   0     RS232 
   1     Keyboard 
   2     MIDI 

The structure of the record is:
struct iorec 

  LONG ibuf;          /* pointer to buffer */ 
  WORD ibufsiz;       /* size of buffer */ 
  WORD ibufhd;        /* head index */ 
  WORD ibuftl;        /* tail index */ 
  WORD ibuflow;       /* low-water mark */ 
WORD ibufhi;        /* high-water mark */ 
  ;


For RS-232, an output-buffer record immediately follows the
input-buffer record.  The format of the output-buffer record is identical.

'ibuf'  points to the device's buffer.
'ibufsiz' is the buffer's size.
'ibufhi'  is the buffer's high-water mark.  
'ibuflow' is the buffer's low- water mark.

If flow control is enabled and the number of characters in the
buffer reaches the high-water  mark,  the ST requests ( according
to the flow- control protocol )  the sender to stop sending characters.
When the number of characters in the buffer drops below the low-water
mark,  the ST tells the sender to resume transmission.

The flow-control operation is similar for the RS-232  output record.
 */
}

(15) rsconf 
VOID Rsconf(speed, flowctl, ucr, rsr, tsr, scr) 
WORD speed, flowctl, ucr, rsr, tsr, scr;
{
/*    Configure RS-232 port.
If any parameter is -1 ( $FFFF ), the corresponding hardware register
is not set.
'speed'    sets the port's baud rate,  as per:

 speed         Rate (bps) 
 -----         ---------- 
   0             19,200 
   1             9600 
   2             4800 
   3             3600 
   4             2400 
   5             2000 
   6             1800 
   7             1200 
   8             600 
   9             300 
   10            200 
   11            150 
   12            134 
   13            110 
   14            75 
   15            50 

'flow' s ets the flow control, as per:

 flow    Flavor 
 -----   --------- 
  0     No flow control [powerup default] 
  1     XON/XOFF (^S/^Q) 
  2     RTS/CTS 
  3     XON/XOFF and RTS/CTS [ is this useful? ] 

'ucr', 'rsr', 'tsr', and 'scr' set the appropriate 68901 registers.
 */
}

(16) keytbl 
LONG Keytbl(unshift, shift, capslock) 
LONG unshift, shift, capslock;
{
/*    Sets pointers to the keyboard translation tables for unshifted  keys,
shifted  keys, and keys in caps-lock mode.  
Returns a pointer to the  beginning of a structure:

 struct keytab   
  LONG unshift;       /* -> unshift table */ 
  LONG shift;         /* -> shift table */ 
  LONG capslock;      /* -> capslock table */ 
  ;

Each pointer in the structure should point to a table 128 bytes in length.
A scancode is converted to Ascii by indexing into the table and
taking the byte there.
 */
}

(17) _random 
LONG Random() 
{
/*    Returns a 24-bit psuedo-random number in D0.L.
Bits 24..31 will be zero.   The sequence /should/ be different each
time the system is turned on.

The algorithm is from vol. 2 of Knuth:

         S = [S * C] + K 

where K = 1,  C = 3141592621,  and S is  the  seed. S  >>  8  
is  returned.   The  initial value of S is  taken  from  the 
frame-counter '_frclock'.

The function's behavior is surprisingly good, except that bit 0
has an /exact/ distribution of 50%.  Therefore it is  probably
not a good idea to test individual bits and expect them to be well behaved.
 */
}

(18) _protobt 
VOID Protobt(buf, serialno, disktype, execflag) 
LONG buf, serialno;
WORD disktype, execflag;
{
/*    Prototype an image of a boot sector.
Once the boot sector image has been constructed with this function,
write it to the volume's boot sector.

'buf'  points to a 512-byte buffer ( which  may  contain  garbage,
or already contain a boot sector image).
'serialno'  is a serial number to stamp into the boot sector.
If 'serialno'  is -1, the boot sector's serial number is not changed.
If 'serialno'  is greater than or equal to $01000000,  a random serial
number is generated and placed in the boot sector.

'disktype'  is either -1 ( to leave the disk type information alone )
or one of the following:

  0: 40 tracks, single sided (180K) 
  1: 40 tracks, double sided (360K) 
  2: 80 tracks, single sided (360K) 
  3: 80 tracks, double sided (720K) 

If 'execflag' is  1,  the boot sector is made executable.   
If 'execflag' is  0,  the boot sector is made non-executable.  
If 'execflag' is -1,  the boot sector remains executable
or non-executable depending on the way it was originally.
 */
}

(19) _flopver 
WORD Flopver(buf,   filler,  devno,  sectno,  trackno, sideno, count)
LONG buf, filler;
WORD devno, sectno, trackno, sideno, count;
{
/*    Verify ( by simply reading ) one or more sectors from a floppy disk.
'buf'     must point to a word- aligned 1024-byte buffer.
'filler'  is an  unused longword.
'devno'   is the floppy number ( 0 or 1 ).
'sectno'  is the sector number to start reading from
( usually  1  through  9 ).
'trackno' is the track number to seek to.
'sideno'  is the side number to select.   
'count'   is the number of sectors to verify
( which must be less than or equal to the number of sectors per track ).

On return,  D0 contains a status code.  If  D0  is zero, the 
operation succeeded.  If D0 is nonzero, the operation failed 
( and D0  contains  an  error number ).

A null-terminated ( 0.W ) list of bad sector numbers is  returned
in the buffer.   They are not necessarily in numerical order.
( If there were no bad sectors, the first word in the buffer will be zero.)
 */
}

(20) scrdmp
VOID Scrdmp() 
{
/*    Dump   screen  to  printer.
[ Currently this is the monochrome-only version from CES.
Will be fixed soon. ]  
 */
}

(21)  cursconf
WORD Cursconf(function,  operand)
WORD  function, operand;
{
/*    Configure the "glass terminal" cursor.
The 'function' code is one of the following:

  0     Hide cursor 
  1     Show cursor 
  2     Cursor set to blink 
  3     Cursor set not to blink 
  4     Set cursor blink timer to 'operand' 
  5     Return cursor blink timer value 

The  cursor  blink  rate is based on the  video   scan  rate  
( 60hz  for color,  70hz for monochrome,  50hz for PAL).  The 
'rate' parameter is equal to  one half the cycle time.
 */
}

(22) settime 
VOID Settime(datetime) 
LONG datetime;
{
/*    Sets the intelligent keyboard's idea of the time and date.  
'datetime' is a 32-bit DOS-format date and time ( time in the 
low word, date in the  high word ).
 */
}

(23) gettime 
LONG Gettime()
{
/*    Interrogates the intelligent keyboard's idea of the time and date,
and returns that value (in DOS format) as a 32-bit word.
( Time  in  the low word,  date in  the  high  word ).  
 */
}

(24) bioskeys 
VOID Bioskeys()
{
/*    Restores the powerup settings of the keyboard translation tables.
 */
}

(25) ikbdws 
VOID Ikbdws(cnt, ptr) 
WORD cnt;
LONG ptr;
{
/*    Writes a string to the intelligent keyboard.
'cnt'  is the number of characters to write,  minus one.
'ptr'  points to a vector of characters to write.
 */
}

(26) jdisint 
VOID Jdisint(intno) 
WORD intno;
{
/*    Disable interrupt number 'intno' on the 68901.
 */
}

(27) jenabint 
VOID Jenabint(intno) 
WORD intno;
{
/*    Enable interrupt number 'intno' on the 68901.
 */
}

(28) giaccess 
BYTE Giaccess(data, regno) 
BYTE data;
WORD regno;
{
/*    Read or write a register on the sound chip.
'data'   is a byte to write to the register.
'regno'  is the register number, logically ORed with:

  $00 to read [well, ok, you don't 
      /really/ OR with this...] 
  $80 to write 

Sound chip registers are not shadowed.  Procedures  that  change
register values by reading a register,  modifying a local  copy
of  it,  and writing the result back to the register,  should be
critical sections.   In particular, the BIOS ( frequently ) updates
the PORT A register, and any code that read-modify-writes  PORT A
must  be atomic.
 */
}

(29) offgibit 
VOID Offgibit(bitno) 
WORD bitno;
{
/*    Atomically set a bit in the PORT A register to zero.
 */
}

(30) ongibit 
VOID Ongibit(bitno) 
WORD bitno;
{
/*    Atomically set a bit in the PORT A register to one.
 */
}

(31) xbtimer 
VOID Xbtimer(timer, control, data, vec) 
WORD timer, control, data;
LONG vec;
{
/*    'timer'   is the timer number  ( 0,1,2,3 corresponding to 68901
timers  A, B, C and D ).
'control' is the timer's control-register  setting.
'data'    is a  byte shoved into the timer's data register.
'vec'     is a  pointer to an interrupt handler.

Timers are allocated:

  Timer    Usage
   A     Reserved for  end-users and applications 
   B     Reserved for graphics (hblank  sync,   etc.)
   C     System  timer (200hz) 
   D     RS-232 baud-rate control (this timer's interrupt 
         vector is available to anyone).
 */
}

(32) dosound 
VOID Dosound(ptr) 
LONG ptr;
{
/*    Set sound daemon's "program counter" to 'ptr'.
'ptr'  points to a set of commands organized as bytes.
Command  numbers $00 through $0F  take a  one  byte  argument 
to be shoved into a sound chip register. ( Command $00 shoves 
the  byte  into  register  0,  command  1   shoves  the  byte 
into register 1, and you get the idea...)   Command $80 takes 
a one byte argument which is shoved into a temporary register.

Command  $81  takes three one-byte  arguments.     The  first  
argument   is  a  register  number to load,   using the  temp 
register.   The second argument  is a  2's  complement  value 
to be added to the temp register.   The third argument is the  
termination value. The instruction is executed ( once on each
update ) until the temp register equals the termination value.

Commands  $82 through $FF take a one-byte argument.    If the
argument is zero,  the sound is terminated.     Otherwise the
argument reflects the number of system-timer ticks ( at 50hz )
until the next update.
 */
}

(33) setprt 
WORD Setprt(config) 
WORD config;
{
/*    Set/get  printer configuration byte.
If 'config' is -1  ($FFFF)  return the current printer configuration
byte.  Otherwise set the byte and return it's old value.

Bits currently defined are:

  Bit#   When 0          When 1 
  ----   -------------   --------------- 
    0     Dot matrix      Daisy wheel 
    1     Color device    Monochrome device 
    2     Atari printer   "Epson" printer 
    3     Draft mode      Final mode 
    4     Parallel port   RS232 port 
    5     Form-feed       Single sheet 
    6             reserved 
    7             reserved 
    8             reserved 
    9             reserved 
    10            reserved 
    11            reserved 
    12            reserved 
    13            reserved 
    14            reserved 
    15    Must be zero 
 */
}

(34) kbdvbase 
LONG Kbdvbase() 
{
/*    Returns a pointer to the base of a structure:

struct kbdvecs   
  LONG midivec;       /* MIDI-input */ 
  LONG vkbderr;       /* keyboard error */ 
  LONG vmiderr;       /* MIDI error */ 
  LONG statvec;       /* ikbd status packet */ 
  LONG mousevec;      /* mouse packet */ 
  LONG clockvec;      /* clock packet */ 
  LONG joyvec;        /* joystick packet */ 
  LONG midisys;       /* system MIDI vector */ 
  LONG ikbdsys;       /* system IKBD vector */ 
  ;

'midivec' is initialized to point to a  buffering routine in  the 
BIOS.  D0.B will contain a charac- ter read from the MIDI port.
'vkbderr' and 
'vmiderr' are  called  whenever  an overrun  condition is detected
on the keyboard or MIDI 6850s.  [Probably not  a  useful   vector
to grab.]
'statvec'
'mousevec'
'clockvec' and
'joyvec' point to ikbd status,  mouse,  real-time clock, and 
joystick packet handlers.    The  packet  handlers are  passed  a  
pointer to the packet received in A0, and on the stack as a LONG.  
GEM / GSX uses the mouse  vector.    Handlers  should  return  with 
an  RTS,  and  should  not  spend more  than  1ms   handling  the 
interrupt.

The  'midisys'  and  'ikbdsys'  vectors   are   called  when  
characters are available on the appropriate 6850.  Initially they 
point  to   default   routines  ( the   MIDI   handler   indirects 
through 'midivec',  and the ikbd handler parses-out ikbd  packets  
and calls the appropriate subsystem vectors ).
 */
}

(35) kbrate 
WORD Kbrate(initial, repeat) 
WORD initial, repeat;
{
/*    Get/set  the keyboard's  repeat  rate.
'initial'  governs  the  initial delay  ( before  key-repeat starts ).
'repeat'   governs  the  rate  at  which key-repeats   are  generated.  
If a parameter is -1 ( $FFFF ) it is not changed.   Times  are  
based  on system ticks ( 50hz ).

Returns  the old key-repeat values,  with 'initial' in   the 
high  byte of the low word and 'repeat' in the low  byte  of 
the low word.
 */
}

(36) _prtblk 
VOID Prtblk()
{
/*    Prtblk() primitive [ see manual pages on PRTBLK ].
 */
}

(37) vsync 
VOID Vsync()
{
/*    Waits until the next vertical-blank interrupt and  returns.    
Useful for synchronizing graphics operations with vblank.
 */
}

(38) supexec 
VOID Supexec(codeptr) 
LONG codeptr;
{
/*    'codeptr' points to a piece of code, ending in an RTS,  that  
is executed in supervisor mode.
The idential code cannot  perform BIOS or GEMDOS  calls.
This function is meant to allow programs to hack hardware and protected 
locations  without  having to  fiddle  with  GEMDOS  get/set 
supervisor mode call.
 */
}

(39) puntaes 
VOID Puntaes() 
{
/*    Throws away the AES, freeing  up  any  memory  it used.
If the  AES  is still resident,  it will be discarded  and  the 
system will reboot.   If the AES is not resident ( if it  was 
discarded earlier ) the function will return.

There is NO way to throw away the AES and  return  --   the  
reboot  MUST be performed.   [ Ok,  ok -- we know this  is  a lose. ]
 */
}
