' WERCS DIALOGUE BOX DEMO
' written in HiSoft Basic
' make sure header & library files are in same directory as program

DEFINT a-z
LIBRARY "GEMAES"

'40k to Leave, variable checks on
REM $OPTION l40,v+

REM $INCLUDE GEMAES.BH
REM $INCLUDE DEMO.BH

CONST type_tree=0,type_object=1,ob_sizeof=24
CONST FMD_START=0, FMD_FINISH=3

'global variables
DIM SHARED 	junk
DIM SHARED	form&,te_ptext&

DEF FNobject&(tree&,object)=tree&+object*ob_sizeof

'the main program starts here

junk=PEEKW(SYSTAB)
IF junk<>2 THEN
	junk=FNform_alert(1,"[3][  This version for|MEDIUM RESOLUTION only][ SORRY! ]")
	SYSTEM
END IF

DIM SHARED box(8000)		'big enough for image buffer

MOUSE 0

' load resource file
	IF FNrsrc_load("DEMO.RSC")=0 THEN
		junk=FNform_alert(1,"[3][Resource file| not found][ Quit ]")
		SYSTEM
	END IF

' display boxes in order from 0 to 4
	FOR j=0 TO 4
		tree_num=j
		ed=2:IF tree_num=3 THEN ed=0	'"2" is current editable string
		
		junk=FNrsrc_gaddr(type_tree,tree_num,form&)	'address of tree
		
' set up editable objects: tree No:3 does not have one
	IF tree_num<>3 THEN
		init_rsc form&,ed
	END IF
	
' if you want choose where to put the box, you must do this:
	POKEW form&+ob_x,j*30:POKEW form&+ob_y,j*20

' subroutine handles dialogue box
	junk=FNhandle_dialog(form&,ed)
	
' print out contents of editable string (address at "te_ptext&")
	WHILE PEEKB(te_ptext&)<>0
		PRINT CHR$(PEEKB(te_ptext&));
		INCR te_ptext&
	WEND:PRINT
NEXT

good_bye
END


'handle dialogue box
DEF FNhandle_dialog(VAL dial&,edit%)
STATIC x,y,w,h,btn
SHARED j

' drop following line, if you want to use your own coordinates
	'form_center dial&,x,y,w,h

'allocate memory space
	form_dial FMD_START,0,0,0,0,x,y,w,h

' if you want to save the screen under the box,
' you must do something like this:
	x=PEEKW(dial&+ob_x):y=PEEKW(dial&+ob_y):w=PEEKW(dial&+ob_width):h=PEEKW(dial&+ob_height)
	PRINT "Box No:";j+1;x;y;w;h			'just to show
	GET (x,y)-(x+w,y+h),box

' draw the box (level 10 is overkill)
' x.y.w,h is clipping rectangle: try setting your own
	junk=FNobjc_draw(dial&,0,10,x,y,w,h)

' "edit%" is the number of the first editable object in the tree
' you must make "edit%"=0, if there is no editable string
' or the phantom cursor strikes!
	btn=FNform_do(dial&,edit%)

' finished with dialogue
	form_dial FMD_FINISH,0,0,0,0,x,y,w,h

' restore the original screen, if you have saved it
	PUT (x,y),box,PSET
	
	FNhandle_dialog=btn		'returns the numbr of exit object
END DEF

SUB init_RSC(form&,edit_num)
SHARED	j
STATIC	t&,ted&,te_ptmplt&,n
' zero the editable string
	t&=FNobject&(form&,edit_num)				'address of BOXTEXT
	ted&=PEEKL(t&+ob_spec)				'address of TEDINFO structure
	te_ptext&=PEEKL(ted&)				'address of editable string
	te_ptmplt&=PEEKL(ted&+4)			'address of template
	n=0:WHILE (te_ptext&+n)<te_ptmplt&	
		POKEB te_ptext&+n,0		'zero to set cursor at start of string
		INCR n					'good idea to clear whole text string
	WEND
END SUB

'free resources &c & quit
SUB good_bye
junk=FNrsrc_free
END
END SUB
