' DEMO DIALOGUE BOX, USING "WERCS" & HISOFT BASIC
' the UP & DOWN arrows are only flagged TOUCHEXIT
' *NOT* SELECTABLE, so they aren't highlighted
' The text template is "p" which formats a filename
' in Caps with a skip on entering "."
 
defint a-z
library "gemaes"

' Include WERCS header file with the names & values of objects
REM $INCLUDE TEST.BH
' now set up the global constants for the program
CONST	ob_flags=8,ob_state=10,ob_spec=12
CONST	ob_x=16,ob_y=18,ob_width=20,ob_height=22
CONST	mask_selected=1,mask_touchexit=&h40
CONST	FMD_START=0,FMD_FINISH=3
' HiSoft Basic likes you to declare global variables
DIM SHARED	junk,j,magic_num

' First load the resource file
IF FNrsrc_load("TEST.RSC")=0 THEN PRINT "WHERE'S THE RESOURCE FILE?":END
' and find the address of the tree
junk=FNrsrc_gaddr(0,demo_box,dial&)

' set up the start values in the box:

' make one of the radio buttons active
' Bit No.0 in "OB_STATE" controls "selected"
t&=dial&+24*r1+ob_state
POKEW t&,1 

' set the cursor to the start of the editable text
' "OB_SPEC" holds the address of the "ted_info" table 
t&=dial&+24*f_name+ob_spec
' so a PEEK here will get the address of the table
t&=PEEKL(t&)
' the first item in the table is the address of the actual text
t&=PEEKL(t&)
' now put a zero at the start of the text position
' & the cursor will settle there 
POKEB t&,0

' find the size of the object holding the number
' that's all we want to redraw after the 1st time round
		t&=dial&+24*numbers
		x1=x+PEEKW(t&+ob_x)+4:y1=y+PEEKW(t&+ob_y)+4
		w1=PEEKW(t&+ob_width)-4:h1=PEEKW(t&+ob_height)-2
' the PEEKed numbers need a bit of tuning to get inside the border

' the next call actually does the dialogue box
junk=FNhandle_dlog(dial&,f_name)
END						'program finished

'*** SUB PROGRAMS ***
' routine to produce dialogue box and handle interaction
' including re-setting the number box
' result is the exit object number
DEF FNhandle_dlog(d&,editnum)
SHARED	x1,y1,w1,h1
STATIC	x,y,w,h,but,t&
	
	form_center d&,x,y,w,h
' find the size of the object holding the number
' that's all we want to redraw on the second time round
		t&=d&+24*numbers
		x1=x+PEEKW(t&+ob_x)+4:y1=y+PEEKW(t&+ob_y)+4:w1=PEEKW(t&+ob_width)-4:h1=PEEKW(t&+ob_height)-2

	form_dial FMD_START,0,0,0,0,x,y,w,h

draw_dial:
' put the number into its little box
	CALL set_magic_num(d&)
	
	junk=FNobjc_draw(d&,0,10,x,y,w,h)
	but=FNform_do(d&,editnum)		'call the dialogue box routine
' now we can de-select the object which caused the exit
	t&=d&+24*but
	POKEW t&+ob_state,PEEKW(t&+ob_state) AND (NOT mask_selected)
	
' if it's "touch exit", it must be an arrow
	IF PEEKW(t&+ob_flags) AND mask_touchexit THEN fix_number

' else clear up & finish
	form_dial FMD_FINISH,0,0,0,0,x,y,w,h
FNhandle_dlog=but
EXIT DEF

fix_number:
' add or subtract 5 from the number, as appropriate
	IF but=up THEN magic_num=magic_num+5 ELSE magic_num=magic_num-5
' you can easily make it cycle:
	IF magic_num<0 THEN magic_num=95
	IF magic_num>95 THEN magic_num=0
	x=x1:y=y1:w=w1:h=h1		'change the clipping rectangle
	GOTO draw_dial			'& back to the drawing board...

END DEF

' sub program to install a number in the BOXTEXT
SUB set_magic_num(d&)
STATIC t&,y$
' find the sddress of the "OB-SPEC" field
	t&=PEEKL(d&+24*numbers+ob_spec)
' "OB-SPEC" holds the address of the text to be inserted
	t&=PEEKL(t&)
' calculate & install the numbers
	y$=STR$(magic_num)
		FOR j=2 TO LEN(y$)	'skip the space at start of STR$
			POKEB t&,ASC(MID$(y$,j,1))
			INCR t&
		NEXT
	POKEB t&,0			'end in null
END SUB

 