' DEMO DIALOGUE BOX WITH SLIDE
' to compile with HiSoft Basic + WERCS resource file

defint a-z
library "gemdos","gemaes","gemvdi"

' 40k to Leave, variable checks on
rem $option l40,v+

REM $INCLUDE GEMAES.BH
REM $INCLUDE HARMONY.BH

' additional constants
CONST type_tree=0,ob_sizeof=24
CONST FMD_START=0, FMD_FINISH=3

' global variables
DIM SHARED 	junk,volume&,harm_num,csr_posn,mx,my

DEF FNobject&(tree&,object)=tree&+object*ob_sizeof

' load resource file
IF FNrsrc_load("HARMONY.RSC")=0 THEN
	junk=FNform_alert(1,"[3][Resource file| not found][ Quit ]")
	SYSTEM
END IF

harm_num=3					'choose initial harmony value
csr_posn=harm_num*30		'set cursor position for slide-box
	
' get edit box address
	junk=FNrsrc_gaddr(type_tree,loudness%,volume&)

top:
	set_harmony							'work the dialogue box
	CLS
	LOCATE 10,20:PRINT"""RETURN"" to quit: any other key to go on"
	BEEP
	IF FNpause THEN top	
' loop unless "RETURN" keyed in FNpause,
' in which case...

	SOUND 1,0:SOUND 2,0:SOUND 3,0	'turn off sound
	junk=FNrsrc_free				'scrap resources
	SYSTEM							'back to desktop
 
'*** THE SUB-PROGRAMS & FUNCTIONS
'handle dialogue box
SUB set_harmony
SHARED	boxx,boxy,boxw,boxh
STATIC t&

form_center volume&,boxx,boxy,boxw,boxh
form_dial FMD_START,0,0,0,0,boxx,boxy,boxw,boxh
	t&=FNobject&(volume&,cursor%)
	POKEW t&+ob_x,csr_posn		'initial position of slider
' draw the whole of the dialogue box
	junk=FNobjc_draw(volume&,0,10,boxx,boxy,boxw,boxh)	

DO
' set the volume of channels 2 & 3 according to "harm_num"
	WAVE 7:SOUND 1,15,1,4,0:SOUND 2,10+harm_num,5,4,0:SOUND 3,10+harm_num,8,4,0
	
	junk=FNform_do(volume&,0)
' check if exit object was cursor: exit if not
' (note top bit of exit object may be set if "TOUCHEXIT"
' so AND it out)
	IF junk<>cursor% AND &H7FFF THEN EXIT LOOP
' if not exit then go to drag-box routine & loop back
	harm_num=FNdrag
LOOP

' exit from the SUB-program
' tell AES finished
form_dial FMD_FINISH,0,0,0,0,boxx,boxy,boxw,boxh
' deselect the EXIT button
t&=FNobject&(volume&,xit)
POKEW t&+ob_state,PEEKW(t&+ob_state) AND(NOT mask_selected)
' turn off sound
SOUND 1,0:SOUND 2,0:SOUND 3,0
END SUB

' the drag-box routine to reposition cursor
DEF FNdrag
SHARED	csr_posn,boxx,boxy,boxw,boxh
STATIC	t&,outx,outy,cx,cy,slx,sly

' get the initial positions of the cursor
' & slide box
junk=FNobjc_offset(volume&,cursor,cx,cy)
junk=FNobjc_offset(volume&,slide_box,slx,sly)
' now drag the cursor within the slide box
' (the cursor is 31X22 & the box 182X22 pixels)
graf_dragbox 31,22,cx,cy,slx,sly,182,22,outx,outy
csr_posn=outx-slx
t&=FN object&(volume&,cursor%)
POKEW t&+ob_x,csr_posn
' re-draw the slide box & cursor,
' using the original clipping area
junk=FNobjc_draw(volume&,slide_box,1,boxx,boxy,boxw,boxh)
FNdrag=csr_posn\30
END DEF

DEF FNpause
STATIC y$,k
DO
	y$=INKEY$
	IF y$<>"" THEN
		IF ASC(y$)=13 THEN
			FNpause=0:EXIT LOOP
		ELSE
			FNpause=1:EXIT LOOP
		END IF
	END IF
LOOP
END DEF	