;-------------------------------------------------------------------------------
; Title:       Cookie Reader
;-------------------------------------------------------------------------------
; Description: This program reads the cookie jar and saves the contents to disk
;              to a file called "COOKIE.TXT" in the current folder.
;-------------------------------------------------------------------------------
; Author:      Cyclone / X-Troll
; Mail:        cxt(at)atari.org
; Web:         http://www.edv-rudolf.de/xtroll/
;-------------------------------------------------------------------------------
                RSRESET
os_entry:       RS.W 1
os_version:     RS.W 1
os_start:       RS.L 1
os_base:        RS.L 1
os_membot:      RS.L 1
os_shell:       RS.L 1
os_magic:       RS.L 1
os_gendat:      RS.L 1
os_palmode:     RS.W 1
os_gendatg:     RS.W 1
os_mifl_root:   RS.L 1                  ; these exist from TOS 1.02 upwards
os_kbshift:     RS.L 1
os_act_PD:      RS.L 1
;-------------------------------------------------------------------------------
Reset_SSP       EQU 0
Reset_PC        EQU 4
_sysbase        EQU $04F2
_p_cookies      EQU $05A0

                TEXT

                linea   #0 [ Init ]
                linea   #10 [ Hidem ]

                pea     cookieview(PC)
                move.w  #$26,-(SP)
                trap    #14
                addq.w  #6,SP

wait_key:
                move.w  #2,-(SP)           ; check for pressed key
                move.w  #1,-(SP)
                trap    #13
                addq.w  #4,SP
                tst.w   D0
                beq.s   wait_key

                move.w  #2,-(SP)
                move.w  #2,-(SP)
                trap    #13
                addq.w  #4,SP

                linea   #9 [ Showm ]

                move.l  cookie_ptr(PC),D0  ; are there any cookies to save?
                cmp.l   #cookie_file,D0
                beq.s   error

                move.w  #0,-(SP)           ; Fcreate
                pea     fname(PC)
                move.w  #$3C,-(SP)
                trap    #1
                addq.w  #8,SP

                tst.w   D0
                bmi.s   error

                move.w  D0,fhandle

                pea     cookie_file(PC)    ; FWrite
                move.l  cookie_ptr(PC),D1
                sub.l   #cookie_file,D1
                move.l  D1,-(SP)
                move.w  D0,-(SP)
                move.w  #$40,-(SP)
                trap    #1
                lea     $0C(SP),SP

                tst.w   D0
                bmi.s   error

                move.w  fhandle(PC),-(SP)
                move.w  #$3E,-(SP)
                trap    #1
                addq.w  #4,SP
error:
                clr.w   -(SP)
                trap    #1

tos_ver:
                movea.l _sysbase.w,A3
                move.l  #"TOS ",D0
                moveq   #0,D1
                move.w  os_version(A3),D1  ; Mirrored TOS Version
                bsr.s   print
                move.l  #"Base",D0
                move.l  os_base(A3),D1     ; TOS Base Address
                bsr.s   print
                move.l  #"Date",D0
                move.l  os_gendat(A3),D1   ; TOS Base Address
                bsr.s   print
                move.l  #"Sync",D0
                moveq   #0,D1
                move.w  os_palmode(A3),D1
                bra.s   print
cookieview:
                move.l  #cookie_file,cookie_ptr
                bsr.s   cls

                bsr.s   tos_ver            ; get TOS Info

                move.l  _p_cookies.w,D0    ; fetch pointer to cookie jar
                beq.s   no_cookies
                movea.l D0,A0
loop:
                move.l  (A0)+,D0           ; get cookie
                beq.s   end_of_jar
                move.l  (A0)+,D1
                bsr.s   print
                bra.s   loop
end_of_jar:
                bra.s   exit
no_cookies:
                pea     no_cookies_str(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
exit:
                rts

cls:
                pea     cls_str(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
                rts

print:
                lea     cookie_str(PC),A1
                move.l  D0,(A1)+
                move.w  #" $",(A1)+
                lea     cipher_tab(PC),A2
                moveq   #7,D2
print1:
                rol.l   #4,D1
                move.w  D1,D0
                and.w   #$0F,D0
                move.b  0(A2,D0.w),(A1)+
                dbra    D2,print1

                move.b  #13,(A1)+
                move.b  #10,(A1)+
                clr.b   (A1)+

                move.l  A0,-(SP)
                pea     cookie_str(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
                movea.l (SP)+,A0

                lea     cookie_str(PC),A1
                movea.l cookie_ptr(PC),A2
copy_loop:
                move.b  (A1)+,(A2)+
                bne.s   copy_loop
                subq.w  #1,A2
                move.l  A2,cookie_ptr

                rts

                DATA

cipher_tab:     DC.B "0123456789abcdef"
                EVEN

cls_str:        DC.B 27,"E",0
no_cookies_str: DC.B "No cookies found!",0
fname:          DC.B "COOKIES.TXT",0
                EVEN

                BSS
fhandle:        DS.W 1
cookie_ptr:     DS.L 1
cookie_file:    DS.B 32000

cookie_str:     DS.B 4+1+9+2+1
                EVEN
                END
