bootsector      EQU 1
tv              EQU 0
;-------------------------------------------------------------------------------
; Title:       Boot Information Reader
;-------------------------------------------------------------------------------
; Description: This program reads available system information from the boot-
;              sector and writes it to a file called "B" on floppy A:
;-------------------------------------------------------------------------------
; Author:      Cyclone / X-Troll
; Mail:        cxt(at)atari.org
; Web:         http://www.edv-rudolf.de/xtroll/
;-------------------------------------------------------------------------------
                RSRESET
os_entry:       RS.W 1
os_version:     RS.W 1
os_start:       RS.L 1
os_base:        RS.L 1
os_membot:      RS.L 1
os_shell:       RS.L 1
os_magic:       RS.L 1
os_gendat:      RS.L 1
os_palmode:     RS.W 1
os_gendatg:     RS.W 1
os_mifl_root:   RS.L 1                  ; these exist from TOS 1.02 upwards
os_kbshift:     RS.L 1
os_act_PD:      RS.L 1
;-------------------------------------------------------------------------------
                RSRESET
cookie_ptr:     RS.L 1
cookie_str:     RS.B 20
cookie_file:    RS.B 512
;-------------------------------------------------------------------------------
Reset_SSP       EQU 0
Reset_PC        EQU 4
_membot         EQU $0432               ; start of free GEMdos memory
_memtop         EQU $0436               ; end of free GEMdos memory
_v_bas_ad       EQU $044E               ; start of screen memory
_sysbase        EQU $04F2               ; start of OS vars
_p_cookies      EQU $05A0               ; start of cookie-jar
;-------------------------------------------------------------------------------
org:
                IFNE tv
                OPT D+,P+
                DEFAULT 1
                illegal
                ELSE
                OPT D-,P+
                DEFAULT 2
                ENDC

                lea     baseptr(PC),A0
                move.l  _membot.w,(A0)

                IFNE bootsector
                DEFAULT 5

                bsr     cookieview

                ELSE

                linea   #0 [ Init ]
                linea   #10 [ Hidem ]

                pea     cookieview(PC)
                move.w  #$26,-(SP)
                trap    #14
                addq.w  #6,SP
wait_key:
                move.w  #2,-(SP)           ; check for pressed key
                move.w  #1,-(SP)
                trap    #13
                addq.w  #4,SP
                tst.w   D0
                beq.s   wait_key

                move.w  #2,-(SP)
                move.w  #2,-(SP)
                trap    #13
                addq.w  #4,SP

                linea   #9 [ Showm ]

                ENDC

                clr.w   -(SP)              ; Fcreate
                pea     fname(PC)
                move.w  #$3C,-(SP)
                trap    #1
                addq.l  #8,SP

                tst.w   D0
                bmi.s   error

                movea.l _membot.w,A0       ; patch for steem, it kills baseptr
                lea     cookie_file(A0),A1
                movea.l cookie_ptr(A0),A0
                suba.l  A1,A0

                pea     (A1)               ; start
                pea     (A0)               ; length
                move.w  D0,-(SP)           ; handle
                move.w  #$40,-(SP)         ; FWrite
                trap    #1
                addq.l  #2,SP              ; handle is on stack

                move.w  #$3E,-(SP)         ; Fclose
                trap    #1
                lea     $0C(SP),SP
out:
error:
                IFEQ bootsector
                clr.w   -(SP)
                trap    #1
                ELSE
                rts
                ENDC

tos_ver:
                movea.l _sysbase.w,A3
                move.l  #"tver",D0
                moveq   #0,D1
                move.w  os_version(A3),D1  ; Mirrored TOS Version
                bsr     print
                move.l  #"tbas",D0
                move.l  os_base(A3),D1     ; TOS Base Address
                move.l  D1,-(SP)
                bsr     print
                move.l  #"tdat",D0
                move.l  os_gendat(A3),D1   ; TOS Base Address
                bsr     print
                movea.l (SP)+,A3           ; not initialized during boot
                move.l  #"tsyn",D0         ; get from rom tos instead
                moveq   #0,D1
                move.w  os_palmode(A3),D1  ; lsb set = PAL else NTSC
                and.w   #1,D1

                bra     print

boot_nfo:       lea     org-30(PC),A0
                move.l  #"org ",D0
                move.l  A0,D1
                bsr     print
                move.l  #"sp  ",D0
                move.l  SP,D1
                bsr     print
                move.l  #"vbas",D0
                move.l  _v_bas_ad.w,D1
                bsr     print
                move.l  #"mbot",D0
                move.l  _membot.w,D1
                bsr     print
                move.l  #"mtop",D0
                move.l  _memtop.w,D1
                bsr.s   print
                pea     -1
                move.w  #$48,-(SP)         ; GEMDOS malloc
                trap    #1
                addq.l  #6,SP
                move.l  D0,D1
                move.l  #"mfre",D0
                bsr.s   print
                pea     $0400
                move.w  #$48,-(SP)
                trap    #1
                addq.l  #6,SP
                move.l  D0,D1
                move.l  #"malc",D0
                bra.s   print
cookieview:
                movea.l baseptr(PC),A0
                pea     cookie_file(A0)
                lea     cookie_ptr(A0),A0
                move.l  (SP)+,(A0)
                bsr.s   cls

                bsr     boot_nfo
                bsr     tos_ver            ; get TOS Info

                move.l  _p_cookies.w,D0    ; fetch pointer to cookie jar
                beq.s   no_cookies
                movea.l D0,A0
loop:
                move.l  (A0)+,D0           ; get cookie
                beq.s   end_of_jar
                move.l  (A0)+,D1
                bsr.s   print
                bra.s   loop
end_of_jar:
                bra.s   exit
no_cookies:
                pea     no_cookies_str(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
exit:
                rts

cls:
                pea     cls_str(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
                rts

print:
                movea.l baseptr(PC),A1
                lea     cookie_str(A1),A1
                move.l  D0,(A1)+
                move.w  #" $",(A1)+
                lea     cipher_tab(PC),A2
                moveq   #7,D2
print1:
                rol.l   #4,D1
                move.w  D1,D0
                and.w   #$0F,D0
                move.b  0(A2,D0.w),(A1)+
                dbra    D2,print1

                move.b  #13,(A1)+
                move.b  #10,(A1)+
                clr.b   (A1)+

                move.l  A0,-(SP)
                movea.l baseptr(PC),A0
                pea     cookie_str(A0)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP

                movea.l baseptr(PC),A0
                lea     cookie_str(A0),A1
                lea     cookie_ptr(A0),A0
                movea.l (A0),A2
copy_loop:
                move.b  (A1)+,(A2)+
                bne.s   copy_loop
                subq.w  #1,A2
                move.l  A2,(A0)
                movea.l (SP)+,A0

                rts
;-------------------------------------------
cipher_tab:     DC.B "0123456789abcdef"
cls_str:        DC.B 27,"E",0
no_cookies_str: DC.B "?",0
fname:          DC.B "A:\B",0
                EVEN
baseptr:
;-------------------------------------------
                END
