;                  _____________     __________________________
;                 _\____  ;\    |____\   ;|    \   ;|______  ;/\
;=============== |    ,    |    \   ;|____|    |    |    /____| \ ==============
;                |_________|_________|____|_________/_________|\|
;                \         \         \    \         \         \ |
;                 \_al!ve___\_________\____\_________\_____ltk_\|
;
;================= [m]   [a]   [g]   [a]   [z]   [i]   [n]   [e] ===============

; Circle Fade Bootsector by GGN

debug           EQU 1                   ;0=bootsector, 1=test

                IFNE debug
                clr.w   -(SP)
                move.l  #-1,-(SP)
                move.l  (SP),-(SP)
                move.w  #5,-(SP)
                trap    #14                ;set lo rez
                lea     12(SP),SP

                pea     start(PC)
                move.w  #$26,-(SP)
                trap    #14                ;superexec

	    stop    #$2300
                clr.b   $ffff820a.w	       ;low rez
                ENDC

;The whole idea for the effect is to print whatever text we want to print (or any
;graphics etc. for that matter) using color  1  (which fills all 4 bitplanes) and
;setting all palette colors to white except for  the one that has only the last 3
;planes set. Then, by clearing  the  first  bitplane  with  a  circle that has
;an increasing radius, we make the text appear.

start:          moveq   #$FF,D1            ;white
                moveq   #7,D2
                lea     $FFFF8240.w,A1     ;color registers
whitepal:       move.l  D1,(A1)+           ;make 'em white
                dbra    D2,whitepal
                clr.w   $FFFF8240+28.w

                move.w  #1000/(endmsg-msg-3)-1-1,D7 ;no. of times to print msg
                pea     msg(PC)
                move.w  #9,-(SP)
print:          trap    #1
                dbra    D7,print           ;keep printing till the end of screen
                lea     msg+1(PC),A0       ;make 'v'->'w' - discard word wrap
                addq.b  #1,(A0)
                trap    #1                 ;print message for the last time
                addq.l  #6,SP

                move.w  #2,-(SP)
                trap    #14                ;get screen address
                addq.l  #2,SP
                movea.l D0,A0              ;save address

                move.w  #0,D7              ;d7=radius
                lea     100*160+80(A0),A2  ;(160,100)

                IFNE debug
                clr.w   $FFFF8240.w
                ENDC

circle:         movem.l D0-D2/A0-A2,-(SP)
                move.w  #37,-(SP)
                trap    #14                ;vsync
                addq.l  #2,SP
                movem.l (SP)+,D0-D2/A0-A2

                IFNE debug
                move.w  #$0400,$FFFF8240.w
                ENDC

                move.w  D7,D1              ;y=r
                moveq   #0,D0              ;x=0
                move.w  D7,D2              ;d2=e=3-2*r
                add.w   D2,D2
                neg.w   D2
                addq.w  #3,D2

*****************************************************************
;
; Plot routine with 8-way symmetry and clipping
; This means that, given a (x,y) pair of coordinates,
; we will draw the following pairs:
; (x,y), (-x,y), (x,-y), (-x,y), (y,x), (-y,x), (y,-x), (-y,-x)
; The clipping is done as following:
; - If (x,y) is off bounds, then so do (-x,y), (x,-y) and (-x,-y)
; The same is applied for the rest 4 pairs
;
; Note! (x,y) is top-left corner relative! We must convert
; to (160,100) relative after clipping!
;
; a0 has the screen address
; d0 has the x, while d0 has y
; It would be adviseable not to destroy these ;)
;

plot:
                movea.w D7,A6              ;save d7

xyplot:         cmp.w   #160,D0            ;x>159?
                bge     yxplot             ;if yes, then we are out of bounds
                cmp.w   #100,D1            ;y>99?
                bge     yxplot             ;ditto

                move.w  D0,D3              ;d3=x
                lsr.w   #1,D3
                and.w   #~%111,D3          ;d3=(x/16)*8
                move.w  D1,D4              ;d4=y
                mulu    #160,D4            ;d4=y*160
                move.w  D0,D5              ;d5=x
                andi.w  #15,D5             ;d5=x mod 16
                add.w   D5,D5
                move.w  plottable(PC,D5.w),D7 ;get pixel
                move.w  plottable2(PC,D5.w),D5 ;get inverted pixel

                move.w  D4,D6              ;y offset...
                add.w   D3,D6              ;+x offset
                and.w   D7,0(A2,D6.w)      ;plot (x,y)
                move.w  D3,D6              ;x offset...
                sub.w   D4,D6              ;-y offset
                sub.w   #160,D6
                and.w   D7,0(A2,D6.w)      ;plot (x,-y)
                move.w  D4,D6              ;y offset...
                sub.w   D3,D6              ;-x offset
                subq.w  #8,D6
                and.w   D5,0(A2,D6.w)      ;plot (-x,y)
                move.w  D4,D6              ;y offset...
                add.w   D3,D6              ;+x offset...
                add.w   #168,D6
                neg.w   D6                 ;-(y+x offset)
                and.w   D5,0(A2,D6.w)      ;plot (-x,-y)
                bra.s   yxplot

;
; A couple of notes here on the plot tables:
; Initially it was going to be a neat plot routine with a standard
; plot table (a walking 1 from bits 15 to 0). But then I found out
; that the Bresenham circle algorithm wasn't what I expected, so
; instead of a filled circle all I got was a Moire pattern!
; First thought was to kill the Moire by filling all bits. For this
; I had to create a 'left' and 'right' plot table (see how they are
; constructed below). Alas, that didn't cure the problem 100%, as
; some pixels are still not drawn (the planar system is to blame).
; So, instead of scrapping the idea I sacrifice some of the algorithm's
; accuracy by plotting one extra pixel on the right of the 'right'
; table, and on the left of the 'left' buffer. That's why we have
; $c000 instead of $8000 as an initial value on the 'left' table
; and $0003 instead of $0001 on the 'right' table. Hope I won't burn
; in hell for this (also hope most people won't notice due to the
; 50/60 fps the routines' running at!)
; Final note: commented values of 'i'  should be used when we
; want to DRAW a circle (all ANDs should be replaced with ORs in the
; rest of the plot routine, too). Values of i not commented are
; used when we want to ERASE a circle (and such is our case)
;
plottable:
;i               SET $C000
i               SET $3FFF
                REPT 16
                DC.W i
;i               SET i>>1+$8000
i               SET i>>1
                ENDR

plottable2:
;i               SET 3
i               SET $FFFC
                REPT 16
                DC.W i
;i               SET i<<1+1
i               SET i<<1
                ENDR

yxplot:         cmp.w   #160,D1            ;y>159?
                bge.s   noyxplot           ;out of bounds
                cmp.w   #100,D0            ;x>100?
                bge.s   noyxplot           ;out of bounds

                move.w  D1,D3              ;d3=x
                lsr.w   #1,D3
                and.w   #~%111,D3          ;d3=(x/16)*8
                move.w  D0,D4              ;d4=y
                mulu    #160,D4            ;d4=y*160
                move.w  D1,D5              ;d5=x
                andi.w  #15,D5             ;d5=x mod 16
                add.w   D5,D5
                move.w  plottable(PC,D5.w),D7 ;get pixel
                move.w  plottable2(PC,D5.w),D5 ;get inverted pixel

                move.w  D4,D6              ;y offset...
                add.w   D3,D6              ;+x offset
                and.w   D7,0(A2,D6.w)      ;plot (x,y)
                move.w  D3,D6              ;x offset...
                sub.w   D4,D6              ;-y offset
                sub.w   #160,D6
                and.w   D7,0(A2,D6.w)      ;plot (x,-y)
                move.w  D4,D6              ;y offset...
                sub.w   D3,D6              ;-x offset
                subq.w  #8,D6
                and.w   D5,0(A2,D6.w)      ;plot (-x,y)
                move.w  D4,D6              ;y offset...
                add.w   D3,D6              ;+x offset...
                add.w   #168,D6
                neg.w   D6                 ;-(y+x offset)
                and.w   D5,0(A2,D6.w)      ;plot (-x,-y)

                move.w  A6,D7              ;restore d7
noyxplot:
;                rts

*****************************************************************


                addq.w  #1,D0              ;x=x+1
                tst.w   D2                 ;e>=0?
                blt.s   circle3            ;nope

                subq.w  #1,D1              ;y=y-1
                move.w  D1,D3              ;d3=y
                lsl.w   #2,D3              ;d3=4*y
                sub.w   D3,D2              ;d2=e-4*y

circle3:        move.w  D0,D3              ;d3=x
                lsl.w   #2,D3              ;d3=4*x
                addq.w  #2,D3              ;d3=4*x+2
                add.w   D3,D2              ;d2=e+4*x+2

                cmp.w   D0,D1              ;x<=y?
                bge     plot               ;no ,loop

                addq.w  #1,D7              ;r=r+1
                cmp.w   #188,D7            ;had enough?
                bne     circle             ;not yet, punish me more, please :)

                IFEQ debug
                rts                        ;return to OS
                ELSE
wkey:           cmpi.b  #$39,$FFFFFC02.w
                bne.s   wkey
                illegal
                ENDC

;
; Word wrapping in VT52 mode lifted from
; "The hitchhiker's guide to the BIOS"
; (after so many years, at last I found out how
; to turn word wrapping on/off :)
;
msg:            DC.B 27,'vAlive #11 ',0
endmsg:
                END
