#define __BIGENDIAN__	/* Compile this for a decent machine */

typedef unsigned char u8;
typedef unsigned short int  u16;
typedef unsigned long int u32;

typedef signed char s8;
typedef signed short int  s16;
typedef signed long int s32;

typedef float f32;

/* 24bpp truecolor pixel */
typedef struct {
	u8 b,g,r;
} pel;


/* Targa file header */
typedef struct {
	u8 identsize;		/* Size of ID field that follows 18 byte header (0 usually) */
	u8 colourmaptype;	/* Type of colour map 0=none, 0x01=has palette */
	u8 imagetype;		/* Type of image 0=none,0x01=indexed,0x02=rgb,3=grey,+0x08=rle packed */
	u8 dummy;

	u16 colourmapstart;	/* First entry in CLUT */
	u16 colourmaplength;	/* CLUT entries */

	u16 xstart;		/* X Origin */
	u16 ystart;		/* Y Origin */
	u16 width;		/* Width in pixels */
	u16 height;		/* Height in pixels */
	u8 bits;		/* Nits per pel 0x08,0x10,24,0x20 */
	u8 descriptor;		/* Descriptor bits (vh flip bits) */
	pel * pixels;
} targa;


/* CLUT for choosing a color's C-R parts */
unsigned char cry[3*256] = {
0,0,255,0,17,255,0,34,255,0,51,255,0,68,255,0,85,255,0,102,255,0,119,255,
0,136,255,0,153,255,0,170,255,0,187,255,0,204,255,0,221,255,0,238,255,0,255,255,
34,0,255,34,19,255,34,38,255,34,57,255,34,77,255,34,96,255,34,115,255,34,134,255,
34,154,255,34,173,255,34,192,255,34,211,255,34,231,255,34,250,255,19,255,240,0,255,221,
68,0,255,68,21,255,68,43,255,68,64,255,68,86,255,68,107,255,68,129,255,68,150,255,
68,172,255,68,193,255,68,215,255,68,236,255,64,255,252,43,255,230,21,255,208,0,255,187,
102,0,255,102,23,255,102,47,255,102,71,255,102,95,255,102,119,255,102,142,255,102,166,255,
102,190,255,102,214,255,102,238,255,95,255,248,71,255,224,47,255,200,23,255,177,0,255,153,
135,0,255,135,26,255,135,52,255,135,78,255,135,104,255,135,130,255,135,156,255,135,182,255,
135,208,255,135,234,255,130,255,249,104,255,223,78,255,197,52,255,171,26,255,145,0,255,119,
169,0,255,169,28,255,169,56,255,169,85,255,169,113,255,169,141,255,169,170,255,169,198,255,
169,226,255,170,255,255,141,255,227,113,255,198,85,255,170,56,255,141,28,255,113,0,255,85,
203,0,255,203,30,255,203,61,255,203,91,255,203,122,255,203,153,255,203,183,255,203,214,255,
203,244,255,183,255,235,153,255,204,122,255,173,91,255,143,61,255,112,30,255,81,0,255,51,
237,0,255,237,32,255,237,65,255,237,98,255,237,131,255,237,164,255,237,197,255,237,230,255,
230,255,247,197,255,214,164,255,181,131,255,148,98,255,115,65,255,82,32,255,49,0,255,17,
255,0,237,255,32,237,255,65,237,255,98,237,255,131,237,255,164,237,255,197,237,255,230,237,
247,255,230,214,255,197,181,255,164,148,255,131,115,255,98,82,255,65,49,255,32,17,255,0,
255,0,203,255,30,203,255,61,203,255,91,203,255,122,203,255,153,203,255,183,203,255,214,203,
255,244,203,235,255,183,204,255,153,173,255,122,143,255,91,112,255,61,81,255,30,51,255,0,
255,0,169,255,28,169,255,56,169,255,85,169,255,113,169,255,141,169,255,170,169,255,198,169,
255,226,169,255,255,170,227,255,141,198,255,113,170,255,85,141,255,56,113,255,28,85,255,0,
255,0,135,255,26,135,255,52,135,255,78,135,255,104,135,255,130,135,255,156,135,255,182,135,
255,208,135,255,234,135,249,255,130,223,255,104,197,255,78,171,255,52,145,255,26,119,255,0,
255,0,102,255,23,102,255,47,102,255,71,102,255,95,102,255,119,102,255,142,102,255,166,102,
255,190,102,255,214,102,255,238,102,248,255,95,224,255,71,200,255,47,177,255,23,153,255,0,
255,0,68,255,21,68,255,43,68,255,64,68,255,86,68,255,107,68,255,129,68,255,150,68,
255,172,68,255,193,68,255,215,68,255,236,68,252,255,64,230,255,43,208,255,21,187,255,0,
255,0,34,255,19,34,255,38,34,255,57,34,255,77,34,255,96,34,255,115,34,255,134,34,
255,154,34,255,173,34,255,192,34,255,211,34,255,231,34,255,250,34,240,255,19,221,255,0,
255,0,0,255,17,0,255,34,0,255,51,0,255,68,0,255,85,0,255,102,0,255,119,0,
255,136,0,255,153,0,255,170,0,255,187,0,255,204,0,255,221,0,255,238,0,255,255,0
};
