/*
 * <sys/scsi_io.h> - Steve Woodford, August 1993
 *
 * Device independent Scsi IO interface.
 */

#ifndef __sys_scsi_io_h
#define __sys_scsi_io_h

#define SCSI_TAPE_ID        64      /* Magic number: == system's tapedrive */


/*
 * Pass a pointer to a structure of this type to the scsi_ioctl(fd, SCIO_GET)
 * function to get useful information about the associated SCSI device.
 */
typedef struct {
    u_char      sc_id;              /* Scsi ID of Device */
    u_char      sc_lun;             /* Logical Unit number of device */
    u_short     sc_type;            /* Type of Scsi Device */
#define SCT_FIXED_DISK      0
#define SCT_TAPE_DRIVE      1
#define SCT_FLOPPY          2
#define SCT_CD_ROM          3
    u_char      sc_flags;           /* Flags providing mode info */
#define SCF_IS_REMOVABLE    0x01
#define SCF_IS_WRITABLE     0x02
    u_char      sc_sense_key;       /* Contains Sense code after error */
    u_long      sc_sense_blk;       /* Block # of error (if applicable) */
    u_long      sc_blocks;          /* Number of blocks on device */
    u_short     sc_block_sz;        /* Size, in bytes of a block */
    char        sc_vendor[8];       /* Vendor ID */
    char        sc_product[16];     /* Product ID */
    char        sc_revision[4];     /* Revision level */
} Sc_Desc;

/*
 * Operations possible using 'scsi_ioctl()'
 */
#define SCIO_REZERO     0           /* Rezero unit                      */
#define SCIO_REWIND     0           /* Rewind (Same as Rezero)          */
#define SCIO_OFFLIN     1           /* Rewind and take Offline          */
#define SCIO_WEOF       2           /* Write a filemark                 */
#define SCIO_RETEN      3           /* Retension tape                   */
#define SCIO_ERASE      4           /* Erase tape                       */
#define SCIO_EOD        5           /* Space to end of recorded data    */
#define SCIO_FSF        6           /* Forward-skip filemark            */
#define SCIO_BSF        7           /* Backward-skip filemark           */
#define SCIO_FSR        8           /* Forward-skip record (block)      */
#define SCIO_BSR        9           /* Backward-skip record (block)     */
#define SCIO_GET        10          /* Get sense data & other info.     */

#ifndef SK_NO_SENSE
/*
 * Scsi Sense key values returned in scsi_stat structure
 */
#define SK_NO_SENSE             0x00
#define SK_RECOVERABLE_ERROR    0x01    /* Recoverable error occurred */
#define SK_NOT_READY            0x02    /* Drive Not Ready error */
#define SK_MEDIA_ERROR          0x03    /* Medium Error */
#define SK_HARDWARE_ERROR       0x04    /* Hardware error */
#define SK_ILLEGAL_REQUEST      0x05    /* Illegal Request error */
#define SK_UNIT_ATTENTION       0x06    /* Unit Attention Error */
#define SK_DATA_PROTECTED       0x07    /* Usually Write Protect error */
#define SK_BLANK_CHECK          0x08    /* Blank check error */
#define SK_VENDOR_UNIQUE        0x09    /* Vendor Unique error */
#define SK_COPY_ABORTED         0x0a    /* Copy aborted error */
#define SK_ABORTED_COMMAND      0x0b    /* Aborted Command error */
#define SK_EQUAL                0x0c    /* Equal error */
#define SK_VOLUME_OVERFLOW      0x0d    /* Volume Overflow error */
#define SK_MISCOMPARE           0x0e    /* Miscompare error */
#define SK_RESERVED             0x0f
/* The following sense keys are generated by the Scsi_Io drivers */
#define SK_TIMEOUT              0x10    /* Scsi Bus Timeout */
#define SK_EOF                  0x11    /* Filemark */
#define SK_EOT                  0x12    /* End of tape */
#define SK_BOT                  0x13    /* Beginning of tape */
#define SK_MEDIA                0x14    /* Wrong media */
#define SK_BUSY                 0x15    /* Device busy */

/*
 * Text representing the major 'sense key' errors
 */
#define SENSE_KEY_INFO  {                               \
    "No Sense Available",           /* 0x00 */          \
    "Soft Error",                   /* 0x01 */          \
    "Unit Not Ready",               /* 0x02 */          \
    "Media Error",                  /* 0x03 */          \
    "Hardware Error",               /* 0x04 */          \
    "Illegal Request",              /* 0x05 */          \
    "Unit Attention",               /* 0x06 */          \
    "Write Protected",              /* 0x07 */          \
    "Blank Check",                  /* 0x08 */          \
    "Vendor Unique",                /* 0x09 */          \
    "Copy Aborted",                 /* 0x0a */          \
    "Aborted Command",              /* 0x0b */          \
    "Equal Error",                  /* 0x0c */          \
    "Volume Overflow",              /* 0x0d */          \
    "Miscompare Error",             /* 0x0e */          \
    0,                              /* 0x0f */          \
    "Scsi Bus Timeout",             /* 0x10 */          \
    "File Mark",                    /* 0x11 */          \
    "End of Tape",                  /* 0x12 */          \
    "Length Error",                 /* 0x13 */          \
    "Wrong Media Type",             /* 0x14 */          \
    "Device Busy"}                  /* 0x15 */
#endif  /* SK_NO_SENSE */

extern int  scsi_open(u_short, u_short, char *);
extern long scsi_read(int, void *, long);
extern long scsi_write(int, void *, long);
extern long scsi_lseek(int, long, u_short);
extern int  scsi_ioctl(int, u_short, long);
extern int  scsi_close(int);

#endif  /* __sys_scsi_io_h */
