This archive contains an Atari ST/TT implementation of a Fortran-to-C 
compiler, developed by AT&T Bell Laboratories and Bellcore (read the file 
NOTICE for legal information). After unpacking, you should have the 
following files:

- notice        information about copyright, warranty etc.
- f2c.ttp       the compiler itself
- f2c.1         man page
- f2c.1t        man page for nroff/troff
- f2c.ps        Technical report about f2c
- f2c.h         include file
- f2c.olb       library for 68020/30 machines with 68881 (i.e. Atari TT)
- f2cslow.olb   library for any Atari ST/TT (68000, no FPU)

The last three files depend on the C compiler being used to compile the 
C programs produced by f2c. The versions included can be used with 
GNU-C 1.40 and probably also later releases. In the following it is 
assumed that you have a working installation of GNU-C on your system.

The combination of f2c and GNU-C can be used as a Fortran compiler that 
compares favourably with commercial compilers, the main disadvantage being 
that source-level debugging is not possible. Even those who regularly use 
another Fortran compiler might be interested in using f2c as a syntax 
checker, since it is very fast and produces better diagnostic output than 
any ST Fortran compiler I know of.
Another obvious application is the conversion of Fortran libraries to C to 
free future programmers from the burdens of Fortran (now you know my 
opinion about Fortran).


Installation:
-------------

- Copy f2c.ttp wherever you keep your executable programs.
- Copy f2c.h wherever GNU-C looks for include files (i.e. the path 
  specified by the environment variable GNUINC).
- Copy f2c.olb and/or f2cslow.olb wherever you keep the GNU-C 
  libraries (i.e. the path specified by the environment variable 
  GNULIB).


Using f2c:
----------

See f2c.1 and/or f2c.1t for details. f2c.ttp itself does not need any 
other file to operate, the include file and the libraries are needed 
only for subsequent compilation. Please note that f2c options are case 
sensitive; you must run it from a shell that does not convert commandline 
parameters to upper case like the GEM Desktop does. There are three 
differences between the Atari ST implementation and the original Unix 
version described in the documentation:

- The Atari ST implementation can only translate one file at a time.
- There is an additional option
        -l logfile
  which causes f2c to write all error messages to the file 'logfile' in 
  addition to showing them on the screen.
- The Fortran programs may have the extensions .f or .for or their 
  upper-case equivalents.


Translating the generated C programs:
-------------------------------------

The programs generated by f2c automatically #include the file f2c.h, which 
contains some compiler-specific definitions. For I/O and some mathematical 
functions, they contain calls to library functions that are contained in 
f2c.olb/f2cslow.olb.
To compile a program foo.c for a machine having a 68020/30 and 68881, use
   gcc -o foo.tos -m68020 -m68881 -D_M68881 foo.c -lf2c 
To compile for a generic ST/TT, i.e. using only 68000 opcodes and software 
floating point routines, use
   gcc -o foo.tos foo.c -lf2c -lpml


Obtaining the source code:
--------------------------

The source code for f2c and the libraries is available from an automatic 
file server at AT&T. For more information, send a message containing the 
single line
   send index
to "netlib@research.att.com".
The library source code is necessary to use f2c with C compilers other 
than GNU-C. Be warned however: porting the libraries to less 
Unix-compatible programming environments will not be easy. If anyone 
manages to implement a support library for Turbo-C/Pure-C, please let me 
know (I gave up after two days; after all, I have other things to do).


Bugs:
-----

I have been using f2c.ttp and f2c.olb for a month now without encountering 
any problems. Since I use a TT, I did only some quick checks on 
f2cslow.olb, but I don't expect any problems, since f2cslow.olb differs 
from f2c.olb only in the compiler options used.
Of course I cannot guarantee anything about this ST/TT implementation; 
nevertheless I would be interested in bug reports, because I have come to 
rely on f2c a lot for my Fortran programming. Bugs not specific to the 
ST/TT implementation should also be reported to the original authors; 
obtain the source code for more information.


Konrad Hinsen
Institut fuer Theoretische Physik A
RWTH Aachen
Templergraben 55
D-W-5100 Aachen
Germany


E-Mail addresses:

  konrad@thphys.physik.rwth-aachen.de
  cd010hi.dacth11.bitnet
  konrad_hinsen@ac2.maus.de
