;   ************************************
;   *                                  *
;   *   FAST VARIABLE TEXT OUTPUT      *
;   *                                  *
;   *              BY                  *
;   *                                  *
;   *    M.MALICH         E.GRAH       *
;   *                                  *
;   ************************************


INIT_LINE_A   = $A000
LINE_A        = $A003
X1            = 38
PLANES        = 24
LSTLIN        = 32
;***********************************
     JMP       INIT_POINTER
     JMP       SET_PARAMETER
     JMP       SET_COLOR
     MOVE.L    4(SP),A1          ; TEXT_ADDRESS
     MOVEM     8(SP),D0/D1       ; (X,Y)-CO-ORD
     LEA       ITALIC,A3
     MOVE.L    18(A3),A0         ; LINE_A0 BLOCK
     MOVEQ     #0,D2
     MOVEQ     #0,D3
     MOVEQ     #0,D4
     MOVEQ     #0,D5
PLOT_CHAR:
     LEA       POINTER,A2
     MOVEQ     #0,D6
     MOVE.B    (A1)+,D6          ; NEW CHARACTER
     BEQ       READY
     CMP.B     #32,D6            ; BLANK ??
     BEQ       CHARACTER_READY
     ADD       D6,D6             ; * 4
     ADD       D6,D6
     ADD.L     D6,A2             ; POINTER BERECHNEN
     TST.L     (A2)              ; CHARACTER AVAILABLE ??
     BEQ       PLOT_CHAR
     MOVE.L    (A2),A2
     ADDQ.L    #1,A2
NEW_POLYGON: 
     MOVE.B    (A2)+,D2          ; POLYGON START
     BMI       CHARACTER_READY
     MOVE.B    (A2)+,D3
POLYGON:
     MOVE.B    (A2)+,D4          ; DRAW TO (D4,D5)
     MOVE.B    (A2)+,D5
     BNE       NEXT
     TST.B     D4                ; POLYGON END ??
     BEQ       NEW_POLYGON
NEXT:
     ADD.B     D2,D4
     ADD.B     D3,D5

     MOVEM.L   D0-D2/D4-D5/A0-A2,-(SP)
     MOVE      D3,D6             ; FROM_Y
     MULS      (A3),D6           ; * ITALIC
     ASR       #8,D6
     ADD       D6,D2             ; + FROM_X = FROM_X
     MOVE      D5,D6             ; TO_Y
     MULS      (A3),D6           ; * ITALIC
     ASR       #8,D6
     ADD       D6,D4             ; + TO_X = TO_X

     MOVE      D2,D6             ; FROM_X
     MULS      16(A3),D6         ; * Y_COS
     MOVE      D3,D7             ; FROM_Y
     MULS      14(A3),D7         ; * Y_SIN
     SUB       D7,D6             ; -
     ASR       #8,D6
     MOVE      D6,A6             ; = NEW FROM_X

     MOVE      D2,D6             ; FROM_X
     MULS      10(A3),D6         ; * X_SIN
     MOVE      D3,D7             ; FROM_Y
     MULS      12(A3),D7         ; * X_COS
     ADD       D7,D6             ; +
     ASR       #8,D6
     MOVE      D6,A5             ; = NEW FROM_Y

     MOVE      D4,D6             ; TO_X
     MULS      16(A3),D6         ; * Y_COS
     MOVE      D5,D7             ; TO_Y
     MULS      14(A3),D7         ; * Y_SIN
     SUB       D7,D6             ; -
     ASR       #8,D6
     MOVE      D6,A4             ; = NEW TO_X

     MULS      10(A3),D4         ; TO_X * X_SIN
     MULS      12(A3),D5         ; TO_Y * X_COS
     ADD       D4,D5             ; +
     ASR       #8,D5             ; = NEW TO_Y

     MOVE      D1,D6
     ADD       D0,A6             ; + X
     ADD       D0,A4
     SUB       A5,D6             ; Y -
     SUB       D5,D1
     EXG       D1,A6
     MOVEM     D1/D6/A4/A6,X1(A0)
     DC.W      LINE_A
     MOVEM.L   (SP)+,D0-D2/D4-D5/A0-A2

     MOVE.B    D4,D2
     MOVE.B    D5,D3
     BRA       POLYGON
CHARACTER_READY:
     ADD       6(A3),D0          ; + OFFSET_X
     SUB       8(A3),D1          ; + OFFSET_Y
     BRA       PLOT_CHAR
READY:
     RTS
;***********************************
INIT_POINTER:   
     LEA       POINTER,A0
     LEA       CHARACTER,A1
     CLR.L     (A0)+
     MOVEQ     #0,D0
LOOP:
     MOVEQ     #0,D1
     MOVE.B    (A1),D1
     MOVE      D1,D2
     SUB       D0,D2
     SUBQ      #2,D2
     BMI       GONE
LOOP_2:
     CLR.L     (A0)+
     DBRA      D2,LOOP_2
GONE:
     MOVE      D1,D0
     MOVE.L    A1,(A0)+
SEEK_CHAR:
     MOVE.B    (A1)+,D1
     CMP.B     #$FF,D1
     BNE       SEEK_CHAR
     TST.B     -2(A1)
     BNE       SEEK_CHAR
     TST.B     -3(A1)
     BNE       SEEK_CHAR
     CMP.B     #$FF,(A1)
     BNE       LOOP
     MOVEQ     #1,D5             ; COLOR
     MOVEQ     #-1,D6            ; MASK
     MOVEQ     #0,D7             ; GRAPHMODE
     BRA       INIT_COLOR
;***********************************
SET_COLOR:
     MOVEM     4(SP),D5-D7       ; COLOR/MASK/MODE
INIT_COLOR:
     DC.W      INIT_LINE_A
     LEA       LINE_A0,A1
     MOVE.L    A0,(A1)
     MOVEQ     #-1,D0
     MOVEM     D0/D6/D7,LSTLIN(A0)
     MOVEQ     #0,D0
     MOVEQ     #0,D1
     MOVEQ     #0,D2
     MOVEQ     #0,D3
     BTST      #0,D5
     BEQ       PLANE_1
     MOVEQ     #1,D0
PLANE_1:    
     BTST      #1,D5
     BEQ       PLANE_2
     MOVEQ     #1,D1
PLANE_2:
     BTST      #2,D5
     BEQ       PLANE_3
     MOVEQ     #1,D2
PLANE_3:  
     BTST      #3,D5
     BEQ       PLANE_4
     MOVEQ     #1,D3
PLANE_4:
     MOVEM     D0-D3,PLANES(A0)
     RTS
;***********************************
SET_PARAMETER:
     LEA       ITALIC,A0
     MOVEM     4(SP),D0-D4       ; PARAMETER_BLOCK
     MOVEM     D2-D4,(A0)
     MOVE      D0,D5             ; SIN
     MULS      D3,D5             ; * SIZE_X
     ASR.L     #8,D5
     MOVE      D1,D6             ; COS
     MULS      D3,D6             ; * SIZE_X
     ASR.L     #8,D6
     MOVE      D1,D7             ; COS
     MULS      D4,D7             ; * SIZE_Y
     ASR.L     #8,D7
     MOVE      D7,A1
     MOVE      D0,D7             ; SIN
     MULS      D4,D7             ; * SIZE_Y
     ASR.L     #8,D7

     MOVEQ     #25,D2
     EXG       D3,D4
     MULU      D2,D3
     MULS      D1,D3             ; * COS
     SWAP      D3                ; /256/256
     MULU      D2,D4
     MULS      D0,D4             ; * SIN
     SWAP      D4                ; /256/256
     MOVEM     D3-D7/A1,6(A0)
     RTS
;***********************************

CHARACTER:
     DC.B $21,$08,$0B,$00,$04,$04,$00,$00,$FC,$FC,$00,$00
     DC.B $00,$0A,$14,$FB,$14,$0B,$00,$FA,$EC,$00,$00,$FF
     DC.B $22,$03,$28,$05,$00,$00,$F6,$FB,$0A,$00,$00,$0D
     DC.B $28,$05,$00,$00,$F6,$FB,$0A,$00,$00,$FF,$24,$03
     DC.B $0F,$04,$FC,$07,$00,$04,$04,$00,$07,$FC,$04,$F9
     DC.B $00,$FC,$04,$00,$06,$04,$04,$07,$00,$04,$FC,$00
     DC.B $00,$0B,$28,$00,$E3,$00,$00,$FF,$25,$03,$0B,$0F
     DC.B $1D,$00,$00,$03,$28,$07,$00,$00,$F9,$F9,$00,$00
     DC.B $07,$00,$00,$0B,$12,$07,$00,$00,$F9,$F9,$00,$00
     DC.B $07,$00,$00,$FF,$26,$12,$16,$FC,$00,$00,$F9,$FC
     DC.B $FC,$FD,$00,$FC,$04,$00,$07,$0B,$08,$00,$06,$FC
     DC.B $04,$FB,$FC,$00,$FA,$0D,$ED,$00,$00,$FF,$27,$08
     DC.B $28,$05,$00,$00,$F6,$FB,$0A,$00,$00,$FF,$28,$06
     DC.B $0B,$FD,$09,$00,$0B,$03,$09,$00,$00,$FF,$29,$0F
     DC.B $0B,$03,$09,$00,$0B,$FD,$09,$00,$00,$FF,$2A,$03
     DC.B $1A,$10,$00,$00,$00,$0B,$12,$00,$10,$00,$00,$03
     DC.B $12,$10,$10,$00,$00,$03,$22,$10,$F0,$00,$00,$FF
     DC.B $2B,$03,$1A,$10,$00,$00,$00,$0B,$12,$00,$10,$00
     DC.B $00,$FF,$2C,$08,$0F,$00,$05,$04,$00,$00,$FB,$FD
     DC.B $FC,$01,$04,$FE,$00,$00,$00,$FF,$2D,$03,$1A,$0F
     DC.B $00,$00,$00,$FF,$2E,$08,$0B,$00,$04,$04,$00,$00
     DC.B $FC,$FC,$00,$00,$00,$FF,$2F,$03,$0B,$0F,$1D,$00
     DC.B $00,$FF,$30,$03,$0F,$00,$15,$04,$04,$07,$00,$04
     DC.B $FC,$00,$EB,$FC,$FC,$F9,$00,$FC,$04,$0F,$15,$00
     DC.B $00,$FF,$31,$03,$1A,$08,$0E,$00,$E3,$00,$00,$FF
     DC.B $32,$03,$1E,$00,$06,$04,$04,$07,$00,$04,$FC,$00
     DC.B $FA,$F1,$ED,$0F,$00,$00,$00,$FF,$33,$03,$28,$0F
     DC.B $00,$F9,$F2,$03,$00,$04,$FC,$00,$F9,$FC,$FC,$F9
     DC.B $00,$FC,$04,$00,$00,$FF,$34,$03,$0F,$0B,$19,$00
     DC.B $00,$0E,$14,$00,$F7,$00,$00,$03,$0F,$0F,$00,$00
     DC.B $00,$FF,$35,$03,$0F,$04,$FC,$07,$00,$04,$04,$00
     DC.B $07,$FC,$04,$F5,$00,$00,$0E,$0F,$00,$00,$00,$FF
     DC.B $36,$03,$16,$04,$04,$07,$00,$04,$FC,$00,$F9,$FC
     DC.B $FC,$F9,$00,$FC,$04,$00,$15,$04,$04,$07,$00,$04
     DC.B $FC,$00,$00,$FF,$37,$03,$28,$0F,$00,$F5,$E3,$00
     DC.B $00,$FF,$38,$03,$0F,$00,$07,$04,$04,$07,$00,$04
     DC.B $04,$00,$06,$FC,$04,$F9,$00,$FC,$FC,$00,$FA,$04
     DC.B $FC,$00,$00,$0E,$1A,$04,$FC,$00,$F9,$FC,$FC,$F9
     DC.B $00,$FC,$04,$00,$00,$FF,$39,$03,$0F,$04,$FC,$07
     DC.B $00,$04,$04,$00,$15,$FC,$04,$F9,$00,$FC,$FC,$00
     DC.B $FA,$04,$FC,$0B,$00,$00,$00,$FF,$3A,$08,$19,$00
     DC.B $05,$04,$00,$00,$FB,$FC,$00,$00,$00,$08,$0F,$00
     DC.B $05,$04,$00,$00,$FB,$FC,$00,$00,$00,$FF,$3B,$08
     DC.B $19,$00,$05,$04,$00,$00,$FB,$FC,$00,$00,$00,$08
     DC.B $0F,$00,$05,$04,$00,$00,$FB,$FD,$FC,$01,$04,$FE
     DC.B $00,$00,$00,$FF,$3C,$0A,$10,$F9,$07,$07,$07,$00
     DC.B $00,$FF,$3D,$03,$1D,$0F,$00,$00,$00,$12,$17,$F1
     DC.B $00,$00,$00,$FF,$3E,$0B,$1E,$07,$F9,$F9,$F9,$00
     DC.B $00,$FF,$3F,$08,$0B,$00,$04,$04,$00,$00,$FC,$FC
     DC.B $00,$00,$00,$08,$14,$0A,$0A,$00,$06,$FC,$04,$F9
     DC.B $00,$FC,$FC,$07,$00,$03,$FD,$FB,$F3,$00,$00,$FF
     DC.B $41,$03,$0B,$00,$19,$04,$04,$07,$00,$04,$FC,$00
     DC.B $E7,$00,$00,$12,$1A,$F1,$00,$00,$00,$FF,$42,$03
     DC.B $0B,$00,$1D,$0B,$00,$04,$FC,$00,$FA,$FC,$FC,$F5
     DC.B $00,$00,$00,$0E,$1A,$04,$FC,$00,$F9,$FC,$FC,$F5
     DC.B $00,$00,$00,$FF,$43,$12,$0F,$FC,$FC,$F9,$00,$FC
     DC.B $04,$00,$15,$04,$04,$07,$00,$04,$FC,$00,$00,$FF
     DC.B $44,$03,$0B,$00,$1D,$0B,$00,$04,$FC,$00,$EB,$FC
     DC.B $FC,$F5,$00,$00,$00,$FF,$45,$03,$0B,$00,$1D,$0F
     DC.B $00,$00,$00,$0E,$1A,$F5,$00,$00,$00,$03,$0B,$0F
     DC.B $00,$00,$00,$FF,$46,$03,$0B,$00,$1D,$0F,$00,$00
     DC.B $00,$0E,$1A,$F5,$00,$00,$00,$FF,$47,$0B,$1A,$07
     DC.B $00,$00,$F5,$FC,$FC,$F9,$00,$FC,$04,$00,$15,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$FF,$48,$03,$0B,$00
     DC.B $1D,$00,$00,$12,$28,$00,$E3,$00,$00,$12,$1A,$F1
     DC.B $00,$00,$00,$FF,$49,$07,$0B,$07,$00,$00,$00,$0B
     DC.B $0B,$00,$1D,$00,$00,$07,$28,$07,$00,$00,$00,$FF
     DC.B $4A,$03,$0F,$04,$FC,$07,$00,$04,$04,$00,$19,$00
     DC.B $00,$FF,$4B,$03,$0B,$00,$1D,$00,$00,$12,$28,$F9
     DC.B $F2,$F8,$00,$00,$00,$0B,$1A,$07,$F1,$00,$00,$FF
     DC.B $4C,$03,$28,$00,$E3,$0F,$00,$00,$00,$FF,$4D,$03
     DC.B $0B,$00,$1D,$08,$F2,$07,$0E,$00,$E3,$00,$00,$FF
     DC.B $4E,$03,$0B,$00,$1D,$0F,$E3,$00,$1D,$00,$00,$FF
     DC.B $4F,$03,$0F,$00,$15,$04,$04,$07,$00,$04,$FC,$00
     DC.B $EB,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$FF,$50,$03
     DC.B $0B,$00,$1D,$0B,$00,$04,$FC,$00,$FA,$FC,$FC,$F5
     DC.B $00,$00,$00,$FF,$51,$03,$0F,$00,$15,$04,$04,$07
     DC.B $00,$04,$FC,$00,$EB,$FC,$FC,$F9,$00,$FC,$04,$00
     DC.B $00,$0E,$0F,$04,$FC,$00,$00,$FF,$52,$03,$0B,$00
     DC.B $1D,$0B,$00,$04,$FC,$00,$FA,$FC,$FC,$F5,$00,$00
     DC.B $00,$0E,$1A,$04,$F1,$00,$00,$FF,$53,$03,$0F,$04
     DC.B $FC,$07,$00,$04,$04,$00,$07,$FC,$04,$F9,$00,$FC
     DC.B $04,$00,$06,$04,$04,$07,$00,$04,$FC,$00,$00,$FF
     DC.B $54,$0B,$0B,$00,$1D,$00,$00,$03,$28,$0F,$00,$00
     DC.B $00,$FF,$55,$03,$28,$00,$E7,$04,$FC,$07,$00,$04
     DC.B $04,$00,$19,$00,$00,$FF,$56,$03,$28,$08,$E3,$07
     DC.B $1D,$00,$00,$FF,$57,$03,$28,$00,$E7,$04,$FC,$04
     DC.B $04,$03,$FC,$04,$04,$00,$19,$00,$00,$FF,$58,$03
     DC.B $28,$0F,$E3,$00,$00,$03,$0B,$0F,$1D,$00,$00,$FF
     DC.B $59,$03,$28,$08,$F2,$07,$0E,$00,$00,$0B,$1A,$00
     DC.B $F1,$00,$00,$FF,$5A,$03,$28,$0F,$00,$F1,$E3,$0F
     DC.B $00,$00,$00,$FF,$61,$03,$0F,$00,$07,$04,$04,$07
     DC.B $00,$04,$FC,$00,$00,$12,$1A,$00,$F1,$00,$00,$12
     DC.B $0F,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$FF,$62,$03
     DC.B $0B,$00,$1D,$00,$00,$03,$16,$04,$04,$07,$00,$04
     DC.B $FC,$00,$F9,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$FF
     DC.B $63,$12,$0F,$FC,$FC,$F9,$00,$FC,$04,$00,$07,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$FF,$64,$12,$0F,$FC
     DC.B $FC,$F9,$00,$FC,$04,$00,$07,$04,$04,$07,$00,$04
     DC.B $FC,$00,$00,$12,$28,$00,$E3,$00,$00,$FF,$65,$12
     DC.B $0F,$FC,$FC,$F9,$00,$FC,$04,$00,$07,$04,$04,$07
     DC.B $00,$04,$FC,$00,$FC,$F1,$00,$00,$00,$FF,$66,$07
     DC.B $0B,$00,$19,$04,$04,$03,$00,$04,$FC,$00,$00,$0B
     DC.B $1A,$F8,$00,$00,$00,$FF,$67,$03,$05,$04,$FC,$07
     DC.B $00,$04,$04,$00,$15,$00,$00,$12,$16,$FC,$04,$F9
     DC.B $00,$FC,$FC,$00,$F9,$04,$FC,$07,$00,$04,$04,$00
     DC.B $00,$FF,$68,$03,$0B,$00,$1D,$00,$00,$03,$16,$04
     DC.B $04,$07,$00,$04,$FC,$00,$F5,$00,$00,$FF,$69,$07
     DC.B $0B,$07,$00,$00,$00,$0B,$0B,$00,$0F,$FC,$00,$00
     DC.B $00,$0B,$1F,$00,$03,$00,$00,$FF,$6A,$05,$05,$04
     DC.B $FC,$03,$00,$04,$04,$00,$15,$00,$00,$10,$1F,$00
     DC.B $03,$00,$00,$FF,$6B,$03,$0B,$00,$1D,$00,$00,$12
     DC.B $1B,$F1,$F8,$0F,$F8,$00,$00,$FF,$6C,$07,$0B,$07
     DC.B $00,$00,$00,$0B,$0B,$00,$1D,$FC,$00,$00,$00,$FF
     DC.B $6D,$03,$0B,$00,$0F,$00,$00,$03,$16,$04,$04,$04
     DC.B $FC,$00,$F5,$00,$00,$0B,$16,$04,$04,$04,$FC,$00
     DC.B $F5,$00,$00,$FF,$6E,$03,$0B,$00,$0F,$00,$00,$03
     DC.B $16,$04,$04,$07,$00,$04,$FC,$00,$F5,$00,$00,$FF
     DC.B $6F,$03,$0F,$00,$07,$04,$04,$07,$00,$04,$FC,$00
     DC.B $F9,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$FF,$70,$03
     DC.B $01,$00,$19,$00,$00,$03,$16,$04,$04,$07,$00,$04
     DC.B $FC,$00,$F9,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$FF
     DC.B $71,$12,$0F,$FC,$FC,$F9,$00,$FC,$04,$00,$07,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$12,$1A,$00,$E7,$00
     DC.B $00,$FF,$72,$03,$0B,$00,$0F,$00,$00,$03,$16,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$FF,$73,$03,$0F,$04
     DC.B $FC,$07,$00,$04,$04,$FC,$04,$F8,$00,$FD,$03,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$FF,$74,$12,$0F,$FC
     DC.B $FC,$FC,$00,$FC,$04,$00,$19,$00,$00,$03,$1A,$06
     DC.B $00,$00,$00,$FF,$75,$03,$1A,$00,$F5,$04,$FC,$07
     DC.B $00,$04,$04,$00,$00,$12,$0B,$00,$0F,$00,$00,$FF
     DC.B $76,$03,$1A,$07,$F1,$01,$00,$07,$0F,$00,$00,$FF
     DC.B $77,$03,$1A,$00,$F5,$04,$FC,$04,$04,$04,$FC,$04
     DC.B $04,$00,$0B,$00,$00,$FF,$78,$03,$1A,$0F,$F1,$00
     DC.B $00,$03,$0B,$0F,$0F,$00,$00,$FF,$79,$03,$05,$04
     DC.B $FC,$07,$00,$04,$04,$00,$15,$00,$00,$03,$1A,$00
     DC.B $F5,$04,$FC,$07,$00,$04,$04,$00,$00,$FF,$7A,$03
     DC.B $1A,$0F,$00,$F1,$F1,$0F,$00,$00,$00,$FF,$81,$03
     DC.B $1A,$00,$F5,$04,$FC,$07,$00,$04,$04,$00,$00,$12
     DC.B $0B,$00,$0F,$00,$00,$07,$1C,$00,$03,$00,$00,$0E
     DC.B $1C,$00,$03,$00,$00,$FF,$84,$03,$0F,$00,$07,$04
     DC.B $04,$07,$00,$04,$FC,$00,$00,$12,$1A,$00,$F1,$00
     DC.B $00,$12,$0F,$FC,$FC,$F9,$00,$FC,$04,$00,$00,$07
     DC.B $1C,$00,$03,$00,$00,$0E,$1C,$00,$03,$00,$00,$FF
     DC.B $8E,$03,$0B,$00,$19,$04,$04,$07,$00,$04,$FC,$00
     DC.B $E7,$00,$00,$12,$1A,$F1,$00,$00,$00,$07,$2B,$00
     DC.B $03,$00,$00,$0E,$2B,$00,$03,$00,$00,$FF,$94,$03
     DC.B $0F,$00,$07,$04,$04,$07,$00,$04,$FC,$00,$F9,$FC
     DC.B $FC,$F9,$00,$FC,$04,$00,$00,$07,$1C,$00,$03,$00
     DC.B $00,$0E,$1C,$00,$03,$00,$00,$FF,$99,$03,$0F,$00
     DC.B $15,$04,$04,$07,$00,$04,$FC,$00,$EB,$FC,$FC,$F9
     DC.B $00,$FC,$04,$00,$00,$07,$2B,$00,$03,$00,$00,$0E
     DC.B $2B,$00,$03,$00,$00,$FF,$9A,$03,$28,$00,$E7,$04
     DC.B $FC,$07,$00,$04,$04,$00,$19,$00,$00,$07,$2B,$00
     DC.B $03,$00,$00,$0E,$2B,$00,$03,$00,$00,$FF,$9E,$03
     DC.B $01,$00,$23,$04,$04,$07,$00,$04,$FC,$00,$FA,$FC
     DC.B $FC,$FD,$00,$00,$00,$0E,$1A,$04,$FC,$00,$F9,$FC
     DC.B $FC,$F9,$00,$00,$00,$FF,$FF

ITALIC:        DC.W         0
SIZE_X:        DC.W         0
SIZE_Y:        DC.W         0
OFFSET_X:      DC.W         0
OFFSET_Y:      DC.W         0
X_SIN:         DC.W         0
X_COS:         DC.W         0
Y_SIN:         DC.W         0
Y_COS:         DC.W         0
LINE_A0:       DC.L         0
POINTER:       DS.L         256,0

 END
