// OBJECT BENDER: WILTING FLOWER ANIMATION
// ***************************************
// This animation illustrates how the bend_start and bend_finish
// options can be used to only bend part of an object.

// CAMERA AND LIGHTS
   camera {location <2, 5, -10> look_at <2, -2, 0> angle 40}
   light_source {<5, 30, -20> rgb 1.25}
   light_source {<-5, -10, -20> rgb .5}

// CREATE FLOWER
   #declare Petal = cylinder {<1, 0, -1>, <1, 0, 1>, 1
      clipped_by {sphere {<0, 1, 0>, 1 scale <2, 1, 1>}}
      pigment {onion
         color_map {[0 rgb <1, 1, .3>] [.5 rgb 1]}
         scale 3}
      normal {wrinkles .2 scale <.5, 1, .2>}
      finish {phong .1 phong_size 1}
      scale <1, .6, .4>}

   #declare Flower = union {
      #declare PetalRot = 0 #while (PetalRot < 360)
         object {Petal rotate y * PetalRot}
      #declare PetalRot = PetalRot + (360 / 5) #end
      sphere {y, 1 scale <.3, .2, .3>
         pigment {rgb <.9, .8, .4>}
         normal {bumps 1 scale .02}}
      sphere {y, 1 scale <.35, .35, .35> translate y * -.3}
      cylinder {y * -10, 0, .07}
      pigment {rgb <.3, .5, .2>}
      finish {phong .1 phong_size 2}}

// BEND OPTIONS
   #declare bend_object = Flower
   #declare object_axis1 = y * -10
   #declare object_axis2 = 0
   #declare bend_smoothness = 40
   #declare bend_direction = <1, 0, -1>
   #declare MClock = pow(sin(clock * pi / 2), .5)
   #declare bend_angle = MClock * 110

// ONLY BEND MIDDLE SECTION OF STEM
   #declare bend_start = .9 - MClock * .4
   #declare bend_finish = 1

// CREATE BENT OBJECT
   #include "Bend.inc"
