// OBJECT BENDER: WALKING PENCIL ANIMATION
// ***************************************
// This animation illustrates various feature of the Object
// Bender include file.

// CAMERA AND LIGHTS
   camera {location <9, 5, -7> look_at <3, 0, 1> angle 25}
   light_source {<5, 15, -5> rgb .8}
   light_source {<5, 5, -15> rgb .8 shadowless}

// GROUND PLANE
   disc {<0, 0, 0>, y, 10
      pigment {checker rgb .5, rgb .7}
      normal {quilted .3 control0 0 control1 0}
      finish {reflection .4}
      rotate y * 30 translate x * 3}

// CREATE PENCIL
   #declare Pencil = union {
      cone {0, 0, y * .4, .15
         pigment {gradient y pigment_map {
            [.1 rgb 0]
            [.15 wood color_map {[0 rgb <.7, .5, .3>] [1 rgb <.8, .6, .4>]}
               scale .02 rotate <80, 30, 0>]}}}
      cylinder {y * .4, y * 1.75, .15
         pigment {rgb <1, 0, 0>}
         normal {radial -.2 scallop_wave frequency 6}
         finish {phong .3}}
      cylinder {y * 1.75, y * 1.8, .16
         pigment {rgb <.8, .8, .4>}
         finish {phong .6}}
      cylinder {y * 1.8, y * 1.9, .15
         pigment {rgb <.9, .4, .5>}}
      sphere {y * 1.9, .1
         pigment {rgb <.9, .4, .5>}
         scale <1.5, 1, 1.5>}
   }

// BEND OPTIONS
   #declare MClock = .5 + clock * 5
   #declare object_axis1 = 0
   #declare object_axis2 = y * 2
   #declare bend_angle = -180 + (mod(MClock, 1) * 360)
   #declare bend_smoothness = 50
   #declare stride_length = 2 * vlength(object_axis2 - object_axis1) / pi

// CREATE BENT OBJECT
   object {

// USE UPSIDE-DOWN PENCIL FOR EVERY SECOND STEP
   #if (mod(int(MClock), 2) = 0) #declare bend_object = Pencil
      #else #declare bend_object = object {Pencil scale <1, -1, 1> translate y * 2} #end

   #include "bend.inc"

// TRANSLATE FOR EACH STEP
   translate x * int(MClock) * stride_length}
