//
// 5 x 7 LED font for POVRay 3.0
// version 1.1
// 
// Written by Michael D Johnson
// Donated to public domain
// 
// You can reach me at
//   mdjohnson@voyager.net
//   http://quark.vpplus.com/~redbeard
//
// Newest version of this file can be found at
//   http://quark.vpplus.com/~redbeard/raytrace/POVRay-Utils.html
// 
// Usage:
//   This file will build objects consisting of a string converted to
//   a 5 x 7 LED readout type font.  The result is a single object which
//   you can use like:
//     #declare Message =
//     object
//     {
//          // Set variables
//          #include "5x7led.inc"
//     }
// 
// Variables:
//  Message	none	String to convert
//  Spacing	[1/5]	This is the amount of space (in fraction of character
// 			width) to leave between each character.
//  Color	[spcl]	This is the color of an ON LED.  An off color is a
// 			dimmed version.  This only needs to be set if you
// 			choose not to use TextureOn and TextureOff.  Defaults
// 			to a greenish color.
// TextureOn	none	Texture of an on LED
// TextureOff	none	Texture of an off LED
// LEDType	[0]	0 = round, 1 = square.  Uses 0 for Mode = 0
// UseLights	[0]	0 = no light sources.  1 = Each on LED has a
//			light_source.  I do not recommend
// 			using this.  I have not even bothered trying to do
// 			a complete trace (takes WAY too long)
// Mode		[1]	Object type.  0 = blob, 1 = union, 2 = merge.  If
// 			Mode = 0, LEDType is set to 0.
// LEDSize	[0.8]	Relative size of an LED.  1 makes the each LED fill
// 			its cell.
// 
//   The entire printable 7-bit ASCII character set has been implemented.
// 
// To run the demo, change the line #declare _5x7led_inc_ = 0 to = 1
// 
// History
// -------
// 12/10/96	Added LED sizing, blob support, fixed addresses, and
// 		reformatted comments
//  6/08/96	Initial release
// 


#include "colors.inc"

#ifndef (_5x7led_inc_)
  #declare _5x7led_inc_ = 0
#end

#if (_5x7led_inc_)
  #declare _5x7led_inc_ = 0
  #declare Color = rgb <0.1, 0.7, 0.5>
  #declare TextureOn =
  texture
  {
      pigment { Color }
      finish { diffuse 0.3 ambient 0.8 }
  }
  #declare TextureOff =
  texture
  {
      pigment { Color * 0.5 }
      finish { diffuse 0.3 ambient 0.2 }
  }
  #declare I = 0
  #while (I < 4)
    #switch (I)
      #case (0) #declare Message = "   Hello, Folks!   " #break
      #case (1) #declare Message = " This is a test of " #break
      #case (2) #declare Message = "5x7led.inc Strings." #break
      #case (3) #declare Message = "Thanks a whole lot." #break
    #end
    object
    {
	#include "5x7led.inc"
	translate (8 / 5 * 2 - I * 8 / 5) * y
    }
    #declare I = I + 1
  #end
  light_source { <100, 100, -100> White }
  camera
  {
      location <(_CPos + 1) / 2, -3, -_CPos * 0.8 >
      look_at <(_CPos + 1) / 2, 0.7, 0>
  }

#else

  #ifndef (Spacing)   #declare Spacing = 1/5 #end
  #ifndef (UseLights) #declare UseLights = 0 #end
  #ifndef (LEDType)   #declare LEDType = 0 #end
  #ifndef (Mode)      #declare Mode = 1 #end
  #ifndef (LEDSize)   #declare LEDSize = 0.8 #end
  
  #if (Mode = 0) #declare LEDType = 0 #end

  #ifndef (TextureOn)
    #ifndef (Color)
      #declare Color = rgbf <0.1, 0.7, 0.5, UseLights * 0.9>
    #end
    #declare _5x7led_TOn =
    texture
    {
	pigment { Color }
	finish { diffuse 0.3 ambient 0.8 }
    }
    #declare _5x7led_TOff =
    texture
    {
	pigment { Color * 0.3 }
	finish { diffuse 0.3 ambient 0.2 }
    }
  #else
    #declare _5x7led_TOn  = texture { TextureOn  }
    #declare _5x7led_TOff = texture { TextureOff }
  #end
  
  #declare _5x7led_FontListNum =
  concat("4AHHHA4", "464444E", "EH8421V", "EHGCGHE", "8CAV888", "V11FGGF",
	 "C21FHHE", "VG88444", "EHHEHHE", "EHHUG86")
  #declare _5x7led_FontListSym1 =
  concat("0000000", "4444404", "AA00000", "0AVAVA0", "4U5EKF4", "JJ842PP",
	 "6912L9M", "4200000", "8422248", "2488842", "4LE4EL4", "044V440",
	 "0000042", "000V000", "0000004", "GG84211")
  #declare _5x7led_FontListSym2 =
  concat("0040004", "0040042", "0842480", "00V0V00", "0248420", "EHG8404", 
	 "EHHTLP2")
  #declare _5x7led_FontListSym3 =
  concat("E22222E", "11248GG", "E88888E", "4AH0000", "000000V", "4800000")
  #declare _5x7led_FontListSym4 =
  concat("8442448", "4444444", "2448442", "00GE100")
  #declare _5x7led_FontListUpper =
  concat("4AHVHHH", "FHHFHHF", "U11111U", "FHHHHHF", "V11711V", "V117111", 
	 "U11THHE", "HHHVHHH", "V44444V", "GGGGGHE", "H95359H", "111111V",
	 "HRLHHHH", "HJLPHHH", "EHHHHHE", "FHHF111", "EHHHL9M", "FHHF59H", 
	 "U11EGGF", "V444444", "HHHHHHE", "HHHHAA4", "HHHHLRH", "HHA4AHH",
	 "HHA4444", "VG8421V")
  #declare _5x7led_FontListLower =
  concat("00EHHPM", "11FHHHF", "00E111E", "GGUHHHU", "00EHV1E", "CI27222", 
	 "00UHUGE", "111FHHH", "4044444", "8088886", "1195359", "4444444", 
	 "00BLLLL", "00DJHHH", "00EHHHE", "00FHF11", "00E9E8G", "00DJ111", 
	 "00U1EGF", "02F222C", "00HHHPM", "00HHAA4", "00HHLLA", "00HA4AH", 
	 "00HHUGE", "00V842V")
  
  
  #switch (Mode)
    #case (1) union #break
    #case (0) blob #break
    #case (2) merge #break
  #else #error "Illegal value for Mode"
  #end
  {
      #if (Mode = 0) threshold 0.5 #end
      #declare _C = 1
      #while (_C <= strlen(Message))
	#declare _CPos = (_C - 1) * (1 + Spacing)
	#declare _Char = substr(Message, _C, 1)
	#declare _CharI = asc(_Char)
	#switch(_CharI)
	  #range (32, 47)
	    #declare _CharI = _CharI - 32
	    #declare _CharS = _5x7led_FontListSym1
	  #break
	  #range (48, 57) 
	    #declare _CharI = _CharI - 48
	    #declare _CharS = _5x7led_FontListNum
	  #break
	  #range (58, 64)
	    #declare _CharI = _CharI - 58
	    #declare _CharS = _5x7led_FontListSym2
	  #break
	  #range (65, 90)
	    #declare _CharI = _CharI - 65
	    #declare _CharS = _5x7led_FontListUpper
	  #break
	  #range (91, 96)
	    #declare _CharI = _CharI - 91
	    #declare _CharS = _5x7led_FontListSym3
	  #break
	  #range (97, 122)
	    #declare _CharI = _CharI - 97
	    #declare _CharS = _5x7led_FontListLower
	  #break
	  #range (123, 126)
	    #declare _CharI = _CharI - 123
	    #declare _CharS = _5x7led_FontListSym4
	  #break
	#else
	  #error concat("5x7led.inc: Unsupported character '", _Char, "'\n")
	#end
	#declare _CharS = substr(_CharS, _CharI * 7 + 1, 7)
	#declare _I = 0
	#while (_I < 7)
	  #declare _RVal = asc(substr(_CharS, _I + 1, 1)) - 48
	  #declare _RVal = ((_RVal > 9) ? _RVal - 7 : _RVal)
	  #declare _J = 0
	  #while (_J < 5)
	    #declare _Trans = <_J * 1/5 + 1/10 + _CPos,
	    (6 - _I) * 1/5 + 1/10, 0>
	    #if (LEDType = 0)
	      sphere
	    #else
	      box
	    #end
	    {
		#if (LEDType = 0)
		  _Trans, 1/5 * LEDSize / 2
		  #if (Mode = 0), 1 #end
		#else
		  -1, 1 scale 1/5 * LEDSize / 2 translate _Trans
		#end
		texture
		{
		    #if (mod(_RVal, 2))
		      _5x7led_TOn
		    #else
		      _5x7led_TOff
		    #end
		}
	    }
	    #if ((UseLights != 0) & (mod(_RVal, 2)))
	      light_source { _Trans White }
	    #end
	    #declare _RVal = int(_RVal / 2)
	    #declare _J = _J + 1
	  #end
	  #declare _I = _I + 1
	#end
	#declare _C = _C + 1
      #end
      #if (Mode = 0) texture { _5x7led_TOff } #end
  }
  
#end
