/*=-=
=-= It is intended that all files include this header.
=-=*/

/*
Detial_level settings:
0 = no knobs or rounded corners
1 = knobs but no rounded corners
2 = knobs and rounded corners, studs have the logo on them
*/

#include "colors.inc"
#include "ll_sizes.inc"
#include "ll_color.inc"

#declare logo =
union
 {
  sphere {<0.11 , 0, -.12>, 0.01 }
  sphere {<-.06 , 0, -.16>, 0.01 }
  sphere {<-.06 , 0, -.11>, 0.01 }
  cylinder { <0.11, 0, -.12>,  <-.06, 0, -.16>,  0.01 open }
  cylinder { <-.06, 0, -.16>,  <-.06, 0, -.11>,  0.01 open }
  sphere {<0.11, 0, 0>, 0.01 }
  sphere {<0.11, 0, -0.06>, 0.01 }
  sphere {<0.04, 0, -.07 >, 0.01 }
  sphere {<0.04, 0, -.04 >, 0.01 }
  sphere {<-.06, 0, -.09 >, 0.01 }
  sphere {<-.06, 0, -.02 >, 0.01 }
  cylinder {<0.11, 0,    0>,  <0.11, 0, -0.06>,  0.01 open }
  cylinder {<0.11, 0,    0>,  <0.04, 0,  -.04>,  0.01 open }
  cylinder {<0.04, 0, -.04>,  <-.06, 0,  -.02>,  0.01 open }
  cylinder {<0.04, 0, -.07>,  <0.04, 0,  -.04>,  0.01 open }
  cylinder {<-.06, 0, -.09>,  <-.06, 0,  -.02>,  0.01 open }

  sphere {  < 0.11, 0, .07>, 0.01 }
  sphere {  < 0.11, 0, .03>, 0.01 }
  sphere {  <-0.06, 0,   0>, 0.01 }
  sphere {  <-0.06, 0, .05>, 0.01 }
  sphere {  < 0.02, 0, .06>, 0.01 }
  sphere {  < 0.02, 0, .03>, 0.01 }
  sphere {  < 0.04, 0,   0>, 0.01 }
  cylinder {< 0.11, 0, .07>,  < 0.11, 0, .03>,  0.01 open }
  cylinder {< 0.11, 0, .03>,  < 0.04, 0,   0>,  0.01 open }
  cylinder {< 0.04, 0,   0>,  <-0.06, 0,   0>,  0.01 open }
  cylinder {<-0.06, 0,   0>,  <-0.06, 0, .05>,  0.01 open }
  cylinder {<-0.06, 0, .05>,  < 0.02, 0, .06>,  0.01 open }
  cylinder {< 0.02, 0, .06>,  < 0.02, 0, .03>,  0.01 open }
  sphere {  < 0.11, 0, .11>, 0.01 }
  sphere {  < 0.11, 0, .15>, 0.01 }
  sphere {  < 0.03, 0, .09>, 0.01 }
  sphere {  < 0.03, 0, .15>, 0.01 }
  sphere {  <-0.06, 0, .09>, 0.01 }
  sphere {  <-0.06, 0, .13>, 0.01 }
  cylinder {< 0.11, 0, .11>,  < 0.11, 0, .15>,  0.01 open }
  cylinder {< 0.11, 0, .15>,  < 0.03, 0, .15>,  0.01 open }
  cylinder {< 0.03, 0, .15>,  <-0.06, 0, .13>,  0.01 open }
  cylinder {<-0.06, 0, .13>,  <-0.06, 0, .09>,  0.01 open }
  cylinder {<-0.06, 0, .09>,  < 0.03, 0, .09>,  0.01 open }
  cylinder {< 0.03, 0, .09>,  < 0.11, 0, .11>,  0.01 open }
  cylinder {<-0.06, 0, .09>,  < 0.11, 0, .15>,  0.01 open }
 }

#declare simple_stud = cylinder {  <0, stud_height,0>,  <0, 0, 0>,  stud_radius }


#declare stud =
merge
 {
  object {  simple_stud }
#if (Detail_level = 2)
  object {  logo  translate <0, stud_height, 0> }
#else
#end
 }


#declare tech_stud =
difference
 {
  cylinder {<0, stud_height, 0>,   <0, 0, 0>,   stud_radius  }
  cylinder {<0, stud_height+1,0>,   <0, 0, 0>,  flat/2 }
 }


#declare studx2 =
union
 {
  object { stud translate < wide*0.5, 0 , 0 >}
  object { stud translate < wide*1.5, 0 , 0 > }
 }

#declare studx3 =
union
 {
  object { studx2 }
  object { stud translate < wide*2.5, 0, 0> }
 }

#declare studx4 =
union
 {
  object { studx3 }
  object { stud translate < wide*3.5,  0, 0> }
 }

#declare studx6 =
union
 {
  object { studx4 }
  object { stud translate < wide*4.5, 0 , 0 > }
  object { stud translate < wide*5.5, 0 , 0 > }
 }

#declare tech_studx2 =
union
 {
  object { tech_stud translate < wide*0.5, 0 , 0 >}
  object { tech_stud translate < wide*1.5, 0 , 0 > }
 }

#declare tech_studx3 =
union
 {
  object { tech_studx2 }
  object { tech_stud translate < wide*2.5, 0, 0> }
 }

#declare tech_studx4 =
union
 {
  object { tech_studx3 }
  object { tech_stud translate < wide*3.5,  0, 0> }
 }

#declare tech_studx6 =
union
 {
  object { tech_studx4 }
  object { tech_stud translate < wide*4.5, 0 , 0 > }
  object { tech_stud translate < wide*5.5, 0 , 0 > }
 }

#declare flat_column =
merge {
 difference
  {
   cylinder { <0, flat-wall,0>,          <0, ((flat-stud_radius)/2), 0>, flat }
   cylinder { <0, (flat-wall)+edge,0>,<0, (((flat-stud_radius)/2)- edge),0>, stud_radius }
  }
 #if(Detail_level=2)
 torus { ((flat+stud_radius)/2), ((flat-stud_radius)/2) rotate <0, 90, 0> translate <0, ((flat-stud_radius)/2), 0> }
 #else
 #end
}

#declare thin_flat_column =
 cylinder { <0, (flat-wall),0>, <0, 0, 0>, stud_height }

#declare column =
merge {
 difference
  {
   cylinder { <0, tall-wall,0>,       <0, ((flat-stud_radius)/2), 0>, flat }
   cylinder { <0, (tall-wall)+edge,0>,<0, (((flat-stud_radius)/2)- edge),0>, stud_radius }
  }
 #if(Detail_level=2)
 torus { ((flat+stud_radius)/2), ((flat-stud_radius)/2) rotate <0, 90, 0> translate <0, ((flat-stud_radius)/2), 0> }
 #else
 #end
}

#declare thin_column = cylinder { <0, (tall-wall),0>, <0, 0, 0>, stud_height }