#declare l3g0_c1x1 =
union
 {
  #if (Detail_level > 0)
  object {tech_stud translate <0, tall, 0>}
  #end

  difference
   {
    merge
     {
      cylinder {<0, tall, 0>, <0, cyl_base_height, 0>, wide*0.5 }
      cylinder {<0, (tall-0.01), 0>, <0, 0, 0>, cyl_base_rad }
     }
    merge
     {
      cylinder {<0, (tall-wall), 0>, <0, -0.1, 0>, stud_radius }
      cylinder {<0, (tall+wall), 0>, <0, -0.1, 0>,   (flat/2)  }
     }
   }
  translate <wide*0.5, 0, wide*0.5>
 }



#declare dot_core =
merge
 {
  #if (Detail_level > 0)
  object {tech_stud translate <0, flat, 0> }
  #end
  difference
   {
    cylinder {<0, (flat-0.01), 0>, <0, 0, 0>, cyl_base_rad}
    cylinder {<0, (tall-wall), 0>, <0, -0.1, 0>,stud_radius }
   }
  translate <wide*0.5, 0, wide*0.5>
 }

#declare l3g0_d1x1 =
union
 {
  #if (Detail_level > 0)
  object {tech_stud translate <0, flat, 0> }
  object {stud translate <0, flat, 0>}
  #end
  difference
   {
    merge
     {
      cylinder {<0, flat, 0>, <0, cyl_base_height, 0>, wide*0.5 }
      cylinder {<0, (flat-0.01), 0>, <0, 0, 0>, cyl_base_rad }
     }
    cylinder {<0, (tall-wall), 0>, <0, -0.1, 0>,stud_radius }
   }
  translate <wide*0.5, 0, wide*0.5>
 }

#declare l3g0_n1x1 =
union
 {
  #if (Detail_level > 0)
  object {tech_stud translate <0, tall, 0> }
  #end
  difference
   {
    merge
     {
      cone {<0, tall, 0>, stud_radius <0, cyl_base_height, 0>, wide*0.5 }
      cylinder {<0, (cyl_base_height+0.01), 0>, <0, 0, 0>, cyl_base_rad}
     }
    merge
     {
      cylinder {<0, (cyl_base_height+0.01), 0>, <0, -0.1, 0>, stud_radius}
      cylinder {<0, (tall+wall), 0>, <0, -0.1, 0>,(flat/2) }
     }
   }
  translate <wide*0.5, 0, wide*0.5>
 }

#declare l3g0_d2x2 =
union
 {
  difference
   {
    difference
     {
      cylinder {<wide, 0, wide>, <wide, flat, wide>, wide}
      object {l3g0_tech_axle_4 rotate <-90, 0, 0> translate <wide, (-1*wide), wide> }
     }
    box {<wall, -0.1, wall>, <((2*wide)-wall), (flat-wall), ((2*wide)-wall)>  }
   }

  #if (Detail_level > 0)
  object {flat_column translate <wide, 0, wide>}
  object { studx2 translate <0, flat, wide*0.5>}
  object { studx2 translate <0, flat, wide*1.5>}
  #end
 }

#declare l3g0_c2x2 =
union
 {
  difference
   {
    difference
     {
      cylinder {<wide, 0, wide>, <wide, tall, wide>, wide}
      cylinder {<wide, 0, wide>, <wide, tall, wide>, wide-wall}
      object {l3g0_tech_axle_4 rotate <-90, 0, 0> translate <wide, (-1*wide), wide>}
     }
    box {<wall, -0.1, wall>, <((2*wide)-wall), (flat-wall), ((2*wide)-wall)>  }
   }
  #if (Detail_level > 0)
  object {column translate <wide, 0, wide> }
  object {  stud  translate <wide*0.5, tall, wide*0.5> }
  object {  stud  translate <wide*0.5, tall, (wide+wide*0.5)> }
  object {  stud  translate <(wide+wide*0.5), tall, wide*0.5> }
  object {  stud  translate <(wide+wide*0.5), tall, (wide+wide*0.5)> }
  #end
 }

#declare l3g0_cone_2x2x2 =
union
 {
  difference
   {
    cone {<wide, wall*2, wide>, wide <wide, (2*tall), wide>, wide*0.5}
    cone {<wide, 0, wide>, wide, <wide, (2*tall)-wall,wide> wide*0.5}
   }
  difference
   {
    cylinder { <wide,0,wide> <wide,wall*2,wide>, wide}
    cylinder { <wide,0,wide> <wide,wall*2,wide>, wide-wall}
    box { <wall,-wall,wall> <wide*2-wall,flat,wide*2-wall>}
   }
  #if (Detail_level > 0)

  object {stud translate <wide, (2*tall), wide>}
  object {column scale <1,2,1> translate <wide,0,wide>}
  #end
 }



#declare l3g0_cone_4x4x2 =
union
 {
  difference
   {
    cone {<(2*wide), wall*2, (2*wide)>, (2*wide) <(2*wide), (2*tall), (2*wide)>, wide}
    cone {<(2*wide), 0, (2*wide)>, (2*wide) <(2*wide), 2*tall-wall, (2*wide)>, wide}
   }
  difference
   {
    cylinder {<wide*2,0,wide*2>,<wide*2,wall*2,wide*2>, wide*2}
    cylinder {<wide*2,-wall,wide*2>,<wide*2,flat*2,wide*2>, wide*2-wall}
    union
     {
      box { <-wide*3,-wall,-stud_radius> <wide*3,flat, stud_radius>}
      box { <-stud_radius,-wall,-wide*3> <stud_radius, flat, wide*3>}
      rotate <0,45,0>
      translate <wide*2,0,wide*2>
     }
   }
  #if (Detail_level > 0)
  object { studx2 translate <wide, (2*tall), wide*1.5>}
  object { studx2 translate <wide, (2*tall), wide*2.5>}
  object { column translate <wide,  0,wide*2>}
  object { column translate <wide*2,0,wide*2>}
  object { column translate <wide*3,0,wide*2>}
  object { column translate <wide*2,0,wide>}
  object { column translate <wide*2,0,wide*3>}
  #end
}


#declare R = wide*5.5
#declare E1 = wall/2
#declare l3g0_4x4_radar_dish = // 4x4 radar dish piece -4x4x (2/3)
union
  {
   difference
     {
      cylinder {<wide*2,  0,wide*2> <wide*2,flat,wide*2>,wide*2}
      cylinder {<wide*2,-flat,wide*2> <wide*2,flat*2,wide*2>,wide*2-E1}
     }
   intersection
     {
      difference
        {
         sphere {<wide*2,(flat*2)-R,wide*2> R}
         sphere {<wide*2,(flat*2)-R,wide*2> R-E1}
        }
      cylinder{<wide*2,0,wide*2>,<wide*2,tall*2,wide*2>,wide*2}
     }
  #if (Detail_level > 0)
   object {flat_column translate <wide*2,flat*0.9,wide*2>}
   object { stud translate <wide*2,flat*2,wide*2>}
   #end
  }

#declare R = wide*9
#declare E1 = wall/2
#declare l3g0_6x6_radar_dish = // 6x6 radar dish piece -4x4x1
union
  {
   difference
     {
      cylinder {<wide*3,  0.2,wide*3> <wide*3,0.2+flat,wide*3>,wide*3}
      cylinder {<wide*3,-flat,wide*3> <wide*3,flat*3,wide*3>,wide*3-E1}
     }
   intersection
     {
      difference
        {
         sphere {<wide*3,tall-R,wide*3> R}
         sphere {<wide*3,tall-R,wide*3> R-E1}
        }
      cylinder{<wide*3,0,wide*3>,<wide*3,tall*3,wide*3>,wide*3}
     }
  #if (Detail_level > 0)
   object {flat_column translate <wide*3,flat,wide*3>}
   object {stud translate <wide*3,tall,wide*3>}
   #end
   translate <wide/2,0,wide/2>
  }

#declare l3g0_2x2_radar_dish =
merge
 {
  difference
   {
    intersection
     {
      cylinder {<wide, 0, wide>, <wide, (flat), wide>, wide}
      sphere {<wide, ((flat)-1.3), wide>, 1.325 }
     }
    sphere {<wide, ((flat/2)-1.6), wide>, 1.6 }
   }
  object {dot_core translate <(wide*0.5), 0, (wide*0.5)>}
}