#include "ll_axle.inc"

#declare l3g0_jet_thruster =
union
 {
  difference
   {
    union
     {
      #declare XW=2 #declare YW=flat*2 #declare ZW = 1 #include "BrickBox.inc"
      #if (Detail_level > 0)
      object { studx2 translate <0,flat*2,wide*0.5>}
      object { studx2 rotate <90,0,0> translate <0,flat,-stud_height>}
      object { studx2 rotate <90,0,0> translate <0,flat,wide>}
      object { stud rotate <0,0,90> translate <0,flat,wide*0.5>}
      #end

      cylinder { <wide*2,flat,wide*0.5>, <wide*2+flat,flat,wide*0.5>, stud_radius}
     }
    cylinder { <wide*0.5,flat,-wide>, <wide*0.5,flat,wide*2>, rod}
    cylinder { <wide*1.5,flat,-wide>, <wide*1.5,flat,wide*2>, rod}

    cylinder { <wide*0.5,-tall,wide*0.5>, <wide*0.5,tall,wide*0.5>, rod}
    cylinder { <wide*1.5,-tall,wide*0.5>, <wide*1.5,tall,wide*0.5>, rod}
    cylinder { <-wide,flat,wide*0.5>, <wide*3,flat,wide*0.5>, rod}
   }
  cylinder { <0, ((flat*2)-wall),0>, <0, 0, 0>, stud_height translate <wide,0,wide*0.5>}
  difference
   {
    cylinder { <wide*2+flat,flat,wide*0.5>, <wide*2+flat*2,flat,wide*0.5>, flat}
    cylinder { <0,flat,wide*0.5>, <wide*3,flat,wide*0.5>, stud_radius}
   }
 }

#declare l3g0_laser_prongs =
union
 {
  union
   {
    #declare WX=2 #declare WZ=1 #include "MakeFlat.inc"
    rotate <0, -90, 0>
    translate <wide, 0, 0>
   }
  object {thin_flat_column translate <wide*0.5,0,wide>}
  cylinder {<0, 0, 0>, <(2*wide), 0, 0>, rod translate <0, 0, (-1*(flat/2))>}
  cylinder {<0, 0, 0>, <(2*wide), 0, 0>, rod translate <0, 0, ((2*wide)+(flat/2))>}
 }

#declare l3g0_grill1x2 =
union
 {
  difference
   {
    #declare WX=2 #declare WY=flat #declare WZ=1 #include "BrickBox.inc"
    union
     {
      box { <-wall,flat+wall, wall>      <wide*2+wall,flat-wall*1.1,wide*0.5-wall*0.5>}
      box { <-wall,flat+wall, wide-wall> <wide*2+wall,flat-wall*1.1,wide*0.5+wall*0.5>}
     }
   }
  object { thin_flat_column translate <wide,0,wide*0.5>}
 }

#declare arm_core =
union
 {
  cylinder {<0, 0, 0>, <(1.2*wide), 0, 0>, wide*0.5}
  sphere {<0, 0, 0>, wide*0.5}
  sphere {<(1.2*wide), 0, 0>, wide*0.5}
}

#declare l3g0_arm =
difference
 {
  object {arm_core}
  union
   {
    box {<0.7, stud_radius, -0.5>, <1.7, 0.5, 0.5>}
    box {<0.7, -0.08, -0.5>, <1.7, 0.08, 0.5>}
    box {<0.7, -0.5, -0.5>, <1.7, -stud_radius, 0.5>}
    box {<-0.5, 0.08, -0.5>, <0.5, stud_radius, 0.5>}
    box {<-0.5, -0.08, -0.5>, <0.5, -stud_radius, 0.5>}
    sphere {<(1.2*wide), -stud_radius, 0>, 0.1}
    sphere {<(1.2*wide), stud_radius, 0>, 0.1}
   }
  rotate <90, 0, 0>
 }

#declare l3g0_arm_joint =
difference
 {
  object {arm_core}
  union
   {
    box {<0.7, stud_radius, -0.5>, <1.7, 0.5, 0.5>}
    box {<0.7, -0.08, -0.5>, <1.7, 0.08, 0.5>}
    box {<0.7, -0.5, -0.5>, <1.7, -stud_radius, 0.5>}
    box {<-0.5, -0.5, 0.08>, <0.5, 0.5, stud_radius>}
    box {<-0.5, -0.5, -0.08>, <0.5, 0.5, -stud_radius>}
    sphere {<(1.2*wide), -stud_radius, 0>, 0.1}
    sphere {<(1.2*wide), stud_radius, 0>, 0.1}
   }
 }

#declare l3g0_arm_brick =
union
 {
  difference
   {
    union
     {
      cylinder {<0, 0, 0>, <(1.2*wide), 0, 0>, wide*0.5}
      sphere {<(1.2*wide), 0, 0>, wide*0.5}
     }
    union
     {
      box {<0.7, stud_radius, -0.5>, <1.7, 0.5, 0.5>}
      box {<0.7, -0.08, -0.5>, <1.7, 0.08, 0.5> }
      box {<0.7, -0.5, -0.5>, <1.7, -stud_radius, 0.5>}
      sphere {<(1.2*wide), -stud_radius, 0>, 0.1}
      sphere {<(1.2*wide), stud_radius, 0>, 0.1}
     }
   }
  union
   {
    #declare WX=1 #declare WZ=2 #include "MakeTall.inc"
    rotate <0, -90, 0>  translate <wide*0.5, (-1*((3*flat)-wide*0.5)), (-1*wide)>
   }
 }

#declare l3g0_control_socket =
difference
 {
  union
   {
    cylinder {<0, flat, 0>, <0, 0, 0>,(flat)}
    sphere {<0, flat, 0>, (flat)}
   }
  union
   {
    cylinder {<0, axle_radius, 0>, <0, -axle_radius, 0>, stud_radius}
    box {<-10, flat, ((axle_radius/2))>, <10, (3*flat), (-1*(axle_radius/2))>}
   }
  translate <wide*0.5, 0, wide*0.5>
 }

#declare l3g0_retro_rocket = //3-nozzle thruster
union
 {
  difference
   {
    box { <0,0,0> <wide,tall,wide>}
    box { <wall,-wall,wall> <wide-wall,tall-wall,wide-wall>}
   }

  difference
    {
     box{ <0,0,0>, <wide,flat,wide> }
     box{<wall,-wall,wall> <wide-wall,flat-wall,wide-wall> }
     translate <wide,flat*2,0>
    }

  object {studx2 translate <0,tall,wide*0.5>}
  // the nozzle
  difference
   {
    cone { <wide/2,flat*2,0>,   stud_radius,         <wide/2,flat*2,-wide>,    wide/2}
    cone { <wide/2,flat*2,0.01>,stud_radius-wall,<wide/2,flat*2,-wide*1.1>,(wide/2)-wall}
   }

  difference
   {
    cone { <wide/2,flat*2,wide>,   stud_radius,         <wide/2,flat*2,wide*2>,   wide/2}
    cone { <wide/2,flat*2,wide*.9>,stud_radius-wall,<wide/2,flat*2,wide*2.1>,(wide/2)-wall}
   }

  difference
   {
    cone { <0,flat*2,wide/2>,   stud_radius,      <-wide,flat*2,wide/2>,   wide/2}
    cone { <0.1,flat*2,wide/2>,stud_radius-wall,<-wide*1.1,flat*2,wide/2>,(wide/2)-wall}
   }
 }

#declare l3g0_medium_antenna =
merge
 {
  difference
   {
    cylinder {<0,0,0> <0,flat,0>, flat}
    cylinder {<0,-wall,0> <0,flat-wall,0>, flat-(wall/2)}
   }
  cylinder { <0,flat,0> <0,flat*1.5,0>, flat*0.75 }

  cylinder { <0,flat,0> <0,(tall*4)-rod,0>, rod}
  sphere { <0,(tall*4)-rod,0> rod}
  translate <wide/2,0,wide/2>
 }

#declare l3g0_1x1x8_antenna =
merge
 {
  cylinder {<0, (3*flat), 0>, <0, 0, 0>, (flat/2)translate <0, flat, 0>}
  difference
   {
    cylinder {<0, (flat), 0>, <0, 0, 0>, 0.3256 }
    cylinder {<0, axle_radius, 0>, <0, -wall, 0>, stud_radius}
   }
  cylinder {<0, flat, 0>, <0, (8*(3*flat)-(flat/2)), 0>, (flat/3)}
  sphere {<0, (8*(3*flat)-(flat/2)), 0>, (flat/2)}
  translate <wide*0.5, 0, wide*0.5>
 }

#declare l3g0_top_clip =
merge {
 union {
  merge {
   merge {
    merge {
     merge {
      merge {
       merge {
        merge {
         merge {
          merge {
           merge {
            merge {
             merge {
              merge {
               merge {
                merge {
                 merge {
                  merge {
                   merge {
                    merge {
                     sphere {<wall, wall, wall>, wall}
                      cylinder {<wall, wall, wall>, <(wide-wall), wall, wall>, wall}
                    }
                    sphere {<(wide-wall), wall, wall>, wall}
                   }
                    cylinder {<(wide-wall), wall, wall>,<(wide-wall), (flat-wall), wall>,wall}
                  }
                  sphere {<(wide-wall), (flat-wall), wall>, wall}
                 }
                  cylinder {<(wide-wall), (flat-wall), wall>,<wall, (flat-wall), wall>,wall}
                }
                sphere {<wall, (flat-wall), wall>, wall}
               }
                cylinder {<wall, wall, wall>,<wall, (flat-wall), wall>,wall}

              }
               cylinder {<wall, wall, wall>,<wall, wall, (wide-wall)>,wall}
             }
             sphere {<wall, wall, (wide-wall)>, wall}
            }
             cylinder {<wall, wall, (wide-wall)>, <wall, (flat-wall), (wide-wall)>,wall }
           }
           sphere {<wall, (flat-wall), (wide-wall)>, wall}
          }
           cylinder {<wall, (flat-wall), wall>, <wall, (flat-wall), (wide-wall)>,wall}
         }
          cylinder {<(wide-wall), wall, wall>,<(wide-wall), wall, (wide-wall)>,wall}
        }
        sphere {<(wide-wall), wall, (wide-wall)>, wall}
       }
        cylinder {<(wide-wall), wall, (wide-wall)>,<wall, wall, (wide-wall)>,wall}
      }
       cylinder {<(wide-wall), wall, (wide-wall)>,<(wide-wall), (flat-wall), (wide-wall)>,wall}
     }
     sphere {<(wide-wall), (flat-wall), (wide-wall)>, wall}
    }
     cylinder {<(wide-wall), (flat-wall), (wide-wall)>,<wall, (flat-wall), (wide-wall)>,wall}
   }
    cylinder {<(wide-wall), (flat-wall), wall>,<(wide-wall), (flat-wall), (wide-wall)>,wall}
  }
  union {
   polygon {5, <wall, wall, 0>,  <wall, (flat-wall), 0>,  <(wide-wall), (flat-wall), 0>,  <(wide-wall), wall, 0>,   <wall, wall, 0>  }
   polygon {5, <wide, wall, wall>,  <wide, (flat-wall), wall>,  <wide, (flat-wall), (wide-wall)>,  <wide, wall, (wide-wall)>,   <wide, wall, wall>  }
   polygon {5, <wall, wall, wide>,  <(wide-wall), wall, wide>,  <(wide-wall), (flat-wall), wide>,  <wall, (flat-wall), wide>,   <wall, wall, wide>  }
   polygon {5, <0, wall, wall>,  <0, wall, (wide-wall)>,  <0, (flat-wall), (wide-wall)>,  <0, (flat-wall), wall>,   <0, wall, wall>  }
   polygon {5, <wall, flat, wall>,  <wall, flat, (wide-wall)>,  <(wide-wall), flat, (wide-wall)>,  <(wide-wall), flat, wall>,   <wall, flat, wall>  }
   polygon {5, <wall, 0, wall>,  <(wide-wall), 0, wall>,  <(wide-wall), (flat-wall), wall>,  <wall, (flat-wall), wall>,   <wall, 0, wall>  }
   polygon {5, <(wide-wall), 0, wall>,  <(wide-wall), 0, (wide-wall)>,  <(wide-wall), (flat-wall), (wide-wall)>,  <(wide-wall), (flat-wall), wall>,   <(wide-wall), 0, wall>  }
   polygon {5, <wall, 0, (wide-wall)>,  <wall, (flat-wall), (wide-wall)>,  <(wide-wall), (flat-wall), (wide-wall)>,  <(wide-wall), 0, (wide-wall)>,   <wall, 0, (wide-wall)>  }
   polygon {5, <wall, 0, wall>,  <wall, (flat-wall), wall>,  <wall, (flat-wall), (wide-wall)>,  <wall, 0, (wide-wall)>,   <wall, 0, wall>  }
   polygon {5, <wall, (flat-wall), wall>,  <(wide-wall), (flat-wall), wall>,  <(wide-wall), (flat-wall), (wide-wall)>,  <wall, (flat-wall), (wide-wall)>,   <wall, (flat-wall), wall>  }
   polygon {5, <wall, 0, wall>,  <(wide-wall), 0, wall>,  <(wide-wall), 0, wall>,  <wall, 0, wall>,   <wall, 0, wall>  }
   polygon {5, <(wide-wall), 0, wall>,  <(wide-wall), 0, (wide-wall)>,  <(wide-wall), 0, (wide-wall)>,  <(wide-wall), 0, wall>,   <(wide-wall), 0, wall>  }
   polygon {5, <(wide-wall), 0, (wide-wall)>,  <wall, 0, (wide-wall)>,  <wall, 0, (wide-wall)>,  <(wide-wall), 0, (wide-wall)>,   <(wide-wall), 0, (wide-wall)>  }
   polygon {5, <wall, 0, (wide-wall)>,  <wall, 0, wall>,  <wall, 0, wall>,  <wall, 0, (wide-wall)>,   <wall, 0, (wide-wall)>  }
  }
 }
 difference {
  difference {
   union {
    polygon {5, <(flat/2), (flat-wall), wall>,  <(flat/2), (flat-wall), (wide-wall)>,  <(flat/2), (wide-(wall/2)), (wide-(flat/2))>,  <(flat/2), (wide-(wall/2)), (flat/2)>,   <(flat/2), (flat-wall), wall>  }
    polygon {5, <(wide-(flat/2)), (wide-(wall/2)), (flat/2)>,  <(wide-(flat/2)), (wide-(wall/2)), (wide-(flat/2))>,  <(wide-(flat/2)), (flat-wall), (wide-wall)>,  <(wide-(flat/2)), (flat-wall), wall>,   <(wide-(flat/2)), (wide-(wall/2)), (flat/2)>  }
    polygon {5, <(flat/2), (flat-wall), wall>,  <(wide-(flat/2)), (flat-wall), wall>,  <(wide-(flat/2)), (flat-wall), (wide-wall)>,  <(flat/2), (flat-wall), (wide-wall)>,   <(flat/2), (flat-wall), wall>  }
    polygon {5, <(flat/2), (wide-(wall/2)), (flat/2)>,  <(flat/2), (wide-(wall/2)), (wide-(flat/2))>,  <(wide-(flat/2)), (wide-(wall/2)), (wide-(flat/2))>,  <(wide-(flat/2)), (wide-(wall/2)), (flat/2)>,   <(flat/2), (wide-(wall/2)), (flat/2)>  }
    polygon {5, <(flat/2), (wide-(wall/2)), (flat/2)>,  <(wide-(flat/2)), (wide-(wall/2)), (flat/2)>,  <(wide-(flat/2)), (flat-wall), wall>,  <(flat/2), (flat-wall), wall>,   <(flat/2), (wide-(wall/2)), (flat/2)>  }
    polygon {5, <(flat/2), (flat-wall), (wide-wall)>,  <(wide-(flat/2)), (flat-wall), (wide-wall)>,  <(wide-(flat/2)), (wide-(wall/2)), (wide-(flat/2))>,  <(flat/2), (wide-(wall/2)), (wide-(flat/2))>,   <(flat/2), (flat-wall), (wide-wall)>  }
   }
   box {<0, ((wide-(wall/2))-(flat/2)), ((wide-(wide*flat))/2)>, <wide, (2*(3*flat)), (wide-((wide-(wide*flat))/2))>}
  }
   cylinder {<0, ((wide-(wall/2))-(flat/2)), wide*0.5>, <wide, ((wide-(wall/2))-(flat/2)), wide*0.5>, (flat/2) }
 }
}

#declare socket_tube =
merge
 {
  difference
   {
    cylinder {<0, ((2*wide)-((flat-stud_radius)/2)), 0>, <0, ((flat-stud_radius)/2), 0>, flat}
    cylinder {<0, (2*wide), 0>, <0, 0, 0>, stud_radius}
   }
  #if (Detail_level=2)
  torus {((flat+stud_radius)/2), ((flat-stud_radius)/2) translate <0, ((flat-stud_radius)/2), 0>}
  torus {((flat+stud_radius)/2), ((flat-stud_radius)/2) translate <0, ((2*wide)-((flat-stud_radius)/2)), 0>}
  #else
  #end
 rotate <90, 0, 0>
}

#declare l3g0_socket_brick_2x4x2 =
union
 {
  difference
   {
    union
     {
      difference
       {
        box {<0, 0, 0>, <(4*wide), (2*(3*flat)), (2*wide)>}
        box {<(wide*0.5-stud_radius), (((2*(3*flat))-(2*wide))+(wide*0.5-stud_radius)), -1>, <((4*wide)-(wide*0.5-stud_radius)), ((2*(3*flat))-(wide*0.5-stud_radius)), (wide-wall)>}
        box {<(wide*0.5-stud_radius), (((2*(3*flat))-(2*wide))+(wide*0.5-stud_radius)), ((2*wide)-(wide-wall))>, <((4*wide)-(wide*0.5-stud_radius)), ((2*(3*flat))-(wide*0.5-stud_radius)), 2>}
        box {<wall,-wall,wall> <wide*4-wall,flat-wall,wide*2-wall>}
       }
      object {socket_tube translate <wide, ((2*(3*flat))-wide), 0> }
      object {socket_tube translate <(2*wide), ((2*(3*flat))-wide), 0>}
      object {socket_tube translate <(3*wide), ((2*(3*flat))-wide), 0>}
     }
    object {l3g0_tech_axle_4   translate <wide, ((2*(3*flat))-wide), 0>  }
    object {l3g0_tech_axle_4   translate <(2*wide), ((2*(3*flat))-wide), 0>  }
    object {l3g0_tech_axle_4   translate <(3*wide), ((2*(3*flat))-wide), 0>  }
   }
  #if (Detail_level > 0)
  object { tech_studx4 translate <0,flat*3*2,wide*0.5>}
  object { tech_studx4 translate <0,flat*3*2,wide*1.5>}
  object { flat_column translate <wide,0,wide>}
  object { flat_column translate <wide*2,0,wide>}
  object { flat_column translate <wide*3,0,wide>}
  #end

 }


#declare l3g0_jet_engine =
union
 {
  union
   {
    #declare WX=2 #declare WZ=1 #include "MakeFlat.inc"
    object { thin_flat_column translate <wide,0,wide*0.5>}
    translate <0,0,-wide>
   }
  prism
   {
  linear_spline

    wall/2, flat-(wall/2)
    5,
    <0,-wide>,
    <wide*2,-wide>,
    <wide*2 - wall, -(wide+flat)>,
    <wall,-(wide+flat)>
    <0,-wide>
   }

  cylinder { <wall, flat/2, -(wide+flat+ (tall/2))>
             <wide*2-wall, flat/2, -(wide+flat+(tall/2))>, tall/2}

  difference
   {
    cone {<wall, flat/2, -(wide+flat+ (tall/2))> tall/2 <-wide,flat/2, -(wide+flat+ (tall/2))>, flat}
    cylinder {<wall, flat/2, -(wide+flat+ (tall/2))> <-wide*2, flat/2, -(wide+flat+ (tall/2))>, stud_radius}
   }
  difference
   {
    cone {<wide*2-wall, flat/2, -(wide+flat+(tall/2))> tall/2, <wide*3, flat/2, -(wide+flat+(tall/2))> flat}
    cylinder {<wide*2-wall, flat/2, -(wide+flat+(tall/2))> <wide*4, flat/2, -(wide+flat+(tall/2))> stud_radius}
   }
  translate <0,0,wide>
 }


#declare l3g0_2x2_brace =
union
 {
  difference
   {
    union
     {
      difference
       {
        box {<0, 0, 0>, <wide*2+flat, flat, wide*2>}
        box {<wall,-wall,wall> <wide*2-wall, flat-wall, wide*2-wall>}
        box {<wide*2,-wall,wall> <wide*3, flat-wall, wide-wall>}
        box {<wide*2,-wall,wide+wall> <wide*3, flat-wall,wide*2-wall>}
       }
      cylinder { <wide, 0,wide>, <wide,flat-wall, wide>, flat}
     }
    cylinder { <wide,-flat,wide>, <wide,flat*2,wide>, stud_radius}
   }
  difference
   {
    union
     {
      difference
       {
        box { <wide*2,flat, 0> <wide*2+flat, flat+wide*2,wide*2>}
        box { <wide,flat, wall> <(wide*2+flat)-wall, (flat+wide*2)-wall,wide*2-wall>}
       }
      cylinder { <wide*2,flat+wide,wide>, <wide*2+flat-wall,flat+wide,wide>, flat}
     }
    cylinder { <0,flat+wide,wide>, <wide*3,flat+wide,wide>, stud_radius}
   }
  #if (Detail_level > 0)
  object { studx2 rotate <0,0,-90> translate <wide*2+flat,wide*2+flat,wide*0.5>}
  object { studx2 rotate <0,0,-90> translate <wide*2+flat,wide*2+flat,wide*1.5>}
  #end

 }

#declare l3g0_2x2_landing_strut =
union
 {
  difference
   {
    difference
     {
      cylinder { <wide,0,wide>, <wide, flat,wide>, wide}
      cylinder { <wide,-tall,wide> <wide, flat-wall, wide>, wide-wall}
     }
    box { <wall,-wall,wall> <wide*2-wall,flat-wall,wide*2-wall> }
    translate <-wide,0,-wide>
   }
  cylinder { <0,flat,0>, <0,tall,0>, tall/2}
  cylinder { <0,flat,0>, <0,tall*2,0>, stud_radius }
  cylinder { <0,tall*2,0>, <0,tall*2-wall,0>, wide}
  #if (Detail_level > 0)
  object { tech_studx2 translate <-wide,tall*2,-wide*0.5>}
  object { tech_studx2 translate <-wide,tall*2,wide*0.5>}
  object { flat_column }
  #end

  translate <wide,0,wide>
 }

#declare Ring =
difference
 {
  cylinder { <0,0,0> <0.05,0,0>, flat*1.1}
  cylinder { <-0.1,0,0> <0.2 ,0,0>,flat}
 }

#declare l3g0_ray_gun =
union
 {
  difference
   {
    cylinder { <0,0,0> <flat*2,0,0>, flat}
    cylinder { <-0.1,0,0> <flat*2,0,0>, stud_radius}
   }
  cylinder { <flat*2-0.035,0,0> <flat*2,0,0>,wide/2}
  cylinder { <flat*2,0,0> <flat*2+wide*2-wall,0,0>, rod}

  cylinder { <tall,0,0> <tall,-flat*2,0>, rod} //handle

  //4 rings around the muzzle
  #if (Detail_level = 2)
  #declare Offset= ((flat*2)-(flat*0.5))/4
  object {Ring translate <Offset,0,0>}
  object {Ring translate <Offset*2,0,0>}
  object {Ring translate <Offset*3,0,0>}
  object {Ring translate <Offset*4,0,0>}
  #end

  translate <tall,0,0>
 }


#declare l3g0_stabilizer =
union
 {
  #if (Detail_level = 0)
  box {<wide*0.5, 0, 0>, <(3*wide*0.5), (flat/2), (3*wide)> }
  #else
  #declare diff = (wide*0.5)-stud_radius
  prism
   {
    linear_spline
    0, flat/2,
    //27,
    27,
    <wide-(wall/2),0>,
    <wide-diff, diff+wall>,
    <wide-diff, wide-(diff+wall)>,
    <wide*0.5,  wide-diff>,
    <wide*0.5,  wide+diff>,
    <wide-diff, wide+diff+wall>,
    <wide-diff, wide*2-(diff+wall)>,
    <wide*0.5,  wide*2-diff>,
    <wide*0.5,  wide*2+diff>,
    <wide-diff, wide*2+diff+wall>,
    <wide-diff, wide*3-(diff+wall)>,
    <wide*0.5,  wide*3-diff>,
    <wide*0.5,  wide*3>,

    <wide*1.5,  wide*3>,
    <wide*1.5,  wide*3-diff>,
    <wide+diff, wide*3-(diff+wall)>,
    <wide+diff, wide*2+diff+wall>,
    <wide*1.5,  wide*2+diff>,
    <wide*1.5,  wide*2-diff>,
    <wide+diff, wide*2-(diff+wall)>,
    <wide+diff, wide+diff+wall>,
    <wide*1.5,  wide+diff>,
    <wide*1.5,  wide-diff>,
    <wide+diff, wide-(diff+wall)>,
    <wide+diff, diff+wall>,
    <wide+(wall/2),0>,

    <wide-(wall/2),0>

   }
  #end

  box {<0, 0, 0>, <(2*wide), (flat/2), (2*wide)> translate <0, (2*(3*flat)-(flat/2)), (2*wide)> }

  polygon { 5,<(wide-(flat/2)/2), (flat/2), 0>,  <(wide-(flat/2)/2), (flat/2), (3*wide)>,  <(wide-(flat/2)/2), (2*(3*flat)-(flat/2)), (4*wide)>,  <(wide-(flat/2)/2), (2*(3*flat)-(flat/2)), (2*wide)>,   <(wide-(flat/2)/2), (flat/2), 0>  }
  polygon { 5,<(wide+(flat/2)/2), (flat/2), 0>,  <(wide+(flat/2)/2), (flat/2), (3*wide)>,  <(wide+(flat/2)/2), (2*(3*flat)-(flat/2)), (4*wide)>,  <(wide+(flat/2)/2), (2*(3*flat)-(flat/2)), (2*wide)>,   <(wide+(flat/2)/2), (flat/2), 0>  }
  polygon { 5,<(wide+(flat/2)/2), (flat/2), 0>,  <(wide-(flat/2)/2), (flat/2), 0>,  <(wide-(flat/2)/2), (2*(3*flat)-(flat/2)), (2*wide)>,  <(wide+(flat/2)/2), (2*(3*flat)-(flat/2)), (2*wide)>,   <(wide+(flat/2)/2), (flat/2), 0>  }
  polygon { 5,<(wide-(flat/2)/2), (flat/2), (3*wide)>,  <(wide+(flat/2)/2), (flat/2), (3*wide)>,  <(wide+(flat/2)/2), (2*(3*flat)-(flat/2)), (4*wide)>,  <(wide-(flat/2)/2), (2*(3*flat)-(flat/2)), (4*wide)>,   <(wide-(flat/2)/2), (flat/2), (3*wide)>  }

  #if (Detail_level > 0)
  object { tech_studx2 translate <0,tall*2,wide*2.5>}
  object { tech_studx2 translate <0,tall*2,wide*3.5>}
  #end
 }

#declare box1x1 =
  difference
  {
   #if(Detail_level=1)
    superellipsoid
     {
      <.07, .07>
      scale <wide*0.5, flat*0.5,wide*0.5>
      translate <wide*0.5,flat*0.5 ,wide*0.5>
     }
   #else
    box { <0,0,0> <wide,flat,wide>}
   #end
    box { <wall,-wall,wall> <wide-wall,flat-wall,wide-wall>}
   }


#declare l3g0_vertical_side_clip =
union
 {
  #if (Detail_level > 0)
  object {stud translate <wide*0.5, flat, wide*0.5>}
  #end

  object { box1x1}
  difference
   {
    union
     {
      cylinder {<0, 0, ((wide-flat)/2)>,<0, 0, (flat+((wide-flat)/2))>, 0.3256 translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0> }
      box {<wide-wall, 0, ((wide-flat)/2)>, <(wide+wide*0.5), flat, (((wide-flat)/2)+flat)>}
      }
    union
     {
      cylinder {<0, 0, 0>, <0, 0, wide>, (flat/2) translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
      box {<0, (-1*(flat/2)), 0>, <wide, (flat/2), wide> translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
      box { <0, -1, 0>, <1, 1, 1> translate <(wide+wide*0.5+(flat/2)), 0, 0>}
     }
   }
 }

#declare l3g0_vertical_stud_clip =
union
 {
  object { box1x1}
  #if (Detail_level > 0)
  object {stud translate <wide*0.5, flat, wide*0.5>}
  #end
  difference
   {
    union
     {
      cylinder {<0, 0, ((wide-flat)/2)>,<0, 0, (flat+((wide-flat)/2))>,0.3256 translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
      box {<wide-wall, 0, ((wide-flat)/2)>, <(wide+wide*0.5), flat, (((wide-flat)/2)+flat)>}
      cylinder {<0, 0, (((wide-flat)/2)-axle_radius)>,<0, 0, (flat+((wide-flat)/2)+axle_radius)>,stud_radius translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
     }
    cylinder {<0, 0, 0>, <0, 0, wide>, (flat/2) translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
   }
 }

#declare l3g0_satellite_panel =
union
 {
  #declare XW=3 #declare YW=flat #declare ZW=1 #include "Brickbox.inc"
  #if (Detail_level > 0)
  object { thin_flat_column translate <wide,0,wide*0.5>}
  object { thin_flat_column translate <wide*2,0,wide*0.5>}
  #end

  difference
   {
    union
     {
      cylinder {<0, 0, ((wide-flat)/2)>,<0, 0, (flat+((wide-flat)/2))>, 0.3256 translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0> }
      box {<wide-wall, 0, ((wide-flat)/2)>, <(wide+wide*0.5), flat, (((wide-flat)/2)+flat)>}
      }
    union
     {
      cylinder {<0, 0, 0>, <0, 0, wide>, (flat/2) translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
      box {<0, (-1*(flat/2)), 0>, <wide, (flat/2), wide> translate <(wide+wide*0.5), ((2*flat)-wide*0.5), 0>}
      box { <0, -1, 0>, <1, 1, 1> translate <(wide+wide*0.5+(flat/2)), 0, 0>}
     }
    translate <wide*2,0,0>
   }
  prism
   {
    linear_spline
    flat-wall, flat,
    5,
    <wide*3,0>,
    <wide*3,wide>,
    <0,wide*2>,
    <0,-wide>,
    <wide*3,0>
   }

  prism
   {
    linear_spline
    0,wall
    5,
    <0,0>
    <wide*0.75,-wide*1.75>
    <wide*3,-wide>
    <wide*3.25,0>
    <0,0>
    rotate <30,0,0>
    rotate <0,-degrees(atan2(1/3,1)),0>
    translate <0,flat-wall,-wide>
   }

  prism
   {
    linear_spline
    0,wall
    5,
    <0,0>
    <wide*0.75,-wide*1.75>
    <wide*3,-wide>
    <wide*3.25,0>
    <0,0>
    scale <1,1,-1>
    rotate <-30,0,0>
    rotate <0,degrees(atan2(1/3,1)),0>
    translate <0,flat-wall,wide*2>
   }
 }

#declare l3g0_f1x2_with_side_bar =
union
 {
  #declare XW=2 #declare ZW=1 #include "MakeFlat.inc"
  object { thin_flat_column translate <wide,0,wide*0.5>}
  cylinder {<0, stud_radius, (wide+wide*0.5)>, <(2*wide), stud_radius, (wide+wide*0.5)>,(flat/2)}
  union
   {
    cylinder {<0, stud_radius, (wide+wide*0.5)>,<(2*(axle_radius/2)), stud_radius, (wide+wide*0.5)>,stud_radius}
    box {<0, 0, wide>, <(2*(axle_radius/2)), flat, (wide+wide*0.5)>}
    translate <flat, 0, 0>
   }
  union
   {
    cylinder {<0, stud_radius, (wide+wide*0.5)>,<(2*(axle_radius/2)), stud_radius, (wide+wide*0.5)>,stud_radius}
    box {<0, 0, wide>, <(2*(axle_radius/2)), flat, (wide+wide*0.5)>}
    translate <((2*wide)-(flat+(2*(axle_radius/2)))), 0, 0>
   }
 }

#declare l3g0_handlebars =
union
 {
  difference
   {
    box {<0, 0, 0>, <wide, flat, wide>}
    box {<(wide*0.5/2), -1, (wide*0.5/2)>, <(3*wide*0.5/2), 1, (3*wide*0.5/2)>}
   }
  sphere {<(-1*wide), 0, (-1*(flat/2))>, (flat/2)}
  cylinder {<(-1*wide), 0, (-1*(flat/2))>,<(flat/2), (flat/2), (flat/2)>,(flat/2) open}
  sphere {<(2*wide), 0, (-1*(flat/2))>, (flat/2)}
  cylinder {<(2*wide), 0, (-1*(flat/2))>, <(wide-(flat/2)), (flat/2), (flat/2)>,(flat/2) open}
  translate <0, (-1*flat/2), (-1*wide)>
  rotate <30, 0, 0>
  translate <0, (3*flat/2), wide*0.5>
 }

#declare hinge_tooth =
merge
 {
  box {<0, 0, 0>, <wide*0.5, flat, axle_radius>}
  cylinder {<wide*0.5, (flat/2), 0>, <wide*0.5, (flat/2), axle_radius>,(flat/2)}
 }

#declare l3g0_1x2_two_tooth_hinge =
merge
 {
  #declare XW=2 #declare ZW=1 #include "BrickBox.inc"
  #if (Detail_level > 0)
  object {thin_flat_column translate <wide, 0, wide*0.5>}
  object {tech_studx2 translate <0, flat, wide*0.5>}
  #end

  object {hinge_tooth translate <(2*wide), 0, axle_radius>}
  object {hinge_tooth translate <(2*wide), 0, (3*axle_radius)>}
 }

#declare l3g0_1x2_three_tooth_hinge =
merge
 {
  #declare XW=2 #declare ZW=1 #include "BrickBox.inc"
  #if (Detail_level > 0)
  object {thin_flat_column translate <wide, 0, wide*0.5>}
  object {tech_studx2 translate <0, flat, wide*0.5>}
  #end
  union
   {
    object {hinge_tooth}
    object {hinge_tooth translate <0, 0, (2*axle_radius)>}
    object {hinge_tooth translate <0, 0, (4*axle_radius)>}
    translate <(2*wide), 0, 0>
   }
 }

#declare l3g0_2x1_three_tooth_hinge =
merge
 {
  #declare XW=1 #declare ZW=2 #include "BrickBox.inc"
  #if (Detail_level > 0)
  object {thin_flat_column translate <wide*0.5, 0, wide>}
  object {stud translate <wide*0.5, flat, wide*0.5>}
  object {stud translate <wide*0.5, flat, (3*wide*0.5)>}
  #end
  union
   {
    object {hinge_tooth}
    object {hinge_tooth translate <0, 0, (2*axle_radius)> }
    object {hinge_tooth translate <0, 0, (4*axle_radius)> }
    translate <wide, 0, wide*0.5>
   }
}

#declare l3g0_goblet =
merge
 {
  difference
   {
    merge
     {
      cylinder {<0, 0, 0>, <0, (0.6*flat), 0>, wide*0.5}
      torus {(wide*0.5-(wide*0.5*flat)), (wide*0.5*flat) translate <0, (0.6*flat), 0>}
      cylinder {<0, 0.1, 0>, <0, flat, 0>, (wide*0.5-(wide*0.5*flat))}
      cylinder {<0, 0.1, 0>, <0, (flat+0.05), 0>, ((flat/2)+0.05)}
     }
    cylinder {<0, -0.1, 0>, <0, stud_height, 0>,stud_radius }
   }
  cylinder {<0, (flat-0.001), 0>, <0, (2.7*flat), 0>, (flat/2)}
  difference
   {
    cone {<0, (2.66*flat), 0>, stud_radius <0, (5*flat), 0>, wide*0.5}
    cylinder {<0, (4.5*flat), 0>, <0, (5.1*flat), 0>, flat open}
   }
}

#declare b1x1_sidestud = cylinder {<0, 0, (wide-1.01*wall)>, <0, 0, (wide)>, stud_radius translate <(wide*0.5), ((3*flat)-wall-stud_radius), 0>}
#declare b1x1_sidestud_cutout = cylinder {<0, 0, -1>, <0, 0, ((2*wide))>,(stud_radius-(1/2*wall)) translate <(wide*0.5), ((3*flat)-wall-stud_radius), 0>}
#declare l3g0_b1x1_side_stud =
difference
 {
  union
   {
    box {<0,wall,0> <wide,tall,wide-wall>}

  #if (Detail_level > 0)
    object {stud translate <wide*0.5, (3*flat), wide*0.5>}
    #end
    box {<0, 0, 0>, <wide, wall, wide> }
    box {<0, 0, wall>, <wide, ((3*flat)-(2*wall)), (1.5*wall)>}
    object {b1x1_sidestud}
   }
  union
   {
    object {b1x1_sidestud_cutout}
    box {<(wall), -1, (1.5*wall)>, <(wide-wall), ((3*flat)-wall-wall), (wide-(1.5*wall))>}
    box {<(wall), ((3*flat)-wall-wall-(2*stud_radius)), (-1)>, <(wide-wall), ((3*flat)-wall-wall), (wide-(1.5*wall))>}
    box {<(wall), 0, (wall)>, <(wide-wall), (.9*wall), (wide-wall)>}
   }
 }

#declare l3g0_control_lever =
merge
 {
  cylinder {<0, 0, 0>, <0, ((2*wide)-(1.5*(axle_radius/2))), 0>,(axle_radius/2)}
  sphere {<0, ((2*wide)-(1.5*(axle_radius/2))), 0>, (1.5*(axle_radius/2))}
  cylinder {<0, 0, (-1*(axle_radius/2))>, <0, 0, ((axle_radius/2))>,(0.9*flat)}

  rotate <0, 0, -45>
  translate <wide*0.5, flat, wide*0.5>
 }