#if (Detail_level=2)
#declare tech_gear_tooth =
intersection
 {
  box {<-0.075, 0, (-0.25*wide)>, <0.075, (wide-(2*tech_hole_outer_rad)), (0.25*wide)> }
  sphere {  <0, 0, 0>, 1 scale <0.075, ((wide-(2*tech_hole_outer_rad))), 1000> }
 }

#declare tech_gear_8_tooth =
object {tech_gear_tooth translate <0, (tech_hole_outer_rad), 0> }

#declare tech_gear_8_teeth =
union
 {
  #declare number=8
  #declare current=0
  #while (current < 360)
   object { tech_gear_8_tooth rotate <0,0,current> }
   #declare current = current + (360/number)
  #end
 }

#declare tech_gear_24_tooth =
object {tech_gear_tooth translate <0, (tech_hole_outer_rad+wide), 0> }

#declare tech_gear_24_teeth =
union
 {
  #declare number=24
  #declare current=0
  #while (current < 360)
   object { tech_gear_24_tooth rotate <0,0,current> }
   #declare current = current + (360/number)
  #end
}

#declare tech_gear_40_tooth =
 object {tech_gear_tooth translate <0, (tech_hole_outer_rad+(2*wide)), 0> }

#declare tech_gear_40_teeth =
union
 {
  #declare number=40
  #declare current=0
  #while (current < 360)
   object { tech_gear_40_tooth rotate <0,0,current> }
   #declare current = current + (360/number)
  #end
}

#end

#declare l3g0_tech_gear_8 =
difference
 {
  union
   {
    cylinder {<0, 0, 0>, <0, 0, wide>, tech_hole_outer_rad}
    #if (Detail_level = 2)
    object {tech_gear_8_teeth translate <0, 0, wide/2>   }
    #end
   }
 object {l3g0_tech_axle_4 translate <0, 0, (-1*wide)> }
}

#declare geartube =
    difference
     {
      cylinder {<0, 0, 0>, <0, 0, wide>, (tech_hole_outer_rad+0.05)}
      cylinder {<0, 0, -0.1>, <0, 0, (wide+0.1)>, stud_radius}
     }

#declare l3g0_tech_gear_24 =
difference
 {
  union
   {
    difference
     {
      union
       {
        cylinder {<0, 0, 0>,<0, 0, wide>,tech_hole_outer_rad}
        cylinder {<0, 0, (0.35*wide)>, <0, 0, (0.65*wide)>, (tech_hole_outer_rad+wide) }
        #if (Detail_level = 2)
        object {tech_gear_24_teeth translate <0, 0, 0.4>}
        #end
       }
      object {l3g0_tech_axle_4 translate <0, 0, (-1*wide)>}
     }
    difference
     {
      cylinder {<0, 0, (0.25*wide)>, <0, 0, (0.75*wide)>,(tech_hole_outer_rad+wide)}
      cylinder {<0, 0, 0>, <0, 0, wide>, ((tech_hole_outer_rad+wide)-0.05) }
     }
    object { geartube translate <0.4, 0.4, 0>}
    object { geartube translate <(-1.0*0.4), 0.4, 0> }
    object { geartube translate <0.4, (-1.0*0.4), 0>}
    object { geartube translate <(-1.0*0.4), (-1.0*0.4), 0> }
  }
 union
  {
   object {l3g0_tech_axle_4 rotate <0, 0, 45> translate <(-0.75*wide), 0, (-1*wide)>}
   object {l3g0_tech_axle_4 rotate <0, 0, 45> translate <(0.75*wide), 0, (-1*wide)> }
  }
}

#declare tech_gear_tube =  cylinder {<0, 0, 0.1>, <0, 0, 0.7>, 0.32 }
#declare tech_gear_hole =  cylinder {<0, 0, (-0.01)>, <0, 0, (wide+0.01)>,stud_radius }


#declare l3g0_tech_gear_40 =
difference
 {
  union
   {
    difference
     {
      cylinder {<0, 0, (0.25*wide)>,<0, 0, (0.75*wide)>,(tech_hole_outer_rad+(2*wide))}
      cylinder {<0, 0, 0>, <0, 0, (0.35*wide)>, ((tech_hole_outer_rad+(2*wide))-0.05) }
      cylinder {<0, 0, (0.65*wide)>, <0, 0, (wide)>, ((tech_hole_outer_rad+(2*wide))-0.05)}
     }
    #if (Detail_level = 2)
    object {tech_gear_40_teeth translate <0, 0, 0.4>}
    #end
    intersection
     {
      box {<-1.12, -1.12, 0.1>, <1.12, 1.12, 0.7> }
      box {<-1.12, -1.12, 0.0>, <1.12, 1.12, 0.8> rotate <0, 0, 45>}
     }

    box {<-0.06, (-1*(tech_hole_outer_rad+(2*wide))), 0.22>, <0.06, (tech_hole_outer_rad+(2*wide)), 0.58>   rotate <0, 0, 45>  }
    box {<-0.06, (-1*(tech_hole_outer_rad+(2*wide))), 0.22>, <0.06, (tech_hole_outer_rad+(2*wide)), 0.58>   rotate <0, 0, -45>  }

    object {tech_gear_tube translate <(3*0.4), (0.4), 0> }
    object {tech_gear_tube   translate <(3*0.4), (-1*0.4), 0>  }
    object {tech_gear_tube   translate <(-3*0.4), (0.4), 0>  }
    object {tech_gear_tube   translate <(-3*0.4), (-1*0.4), 0>  }
    object {tech_gear_tube   translate <(0.4), (3*0.4), 0>  }
    object {tech_gear_tube   translate <(0.4), (-3*0.4), 0>  }
    object {tech_gear_tube   translate <(-1*0.4), (3*0.4), 0>  }
    object {tech_gear_tube   translate <(-1*0.4), (-3*0.4), 0>  }

    box {   <(-1*0.4), (-1*0.4), 0>, <0.4, 0.4, wide>  }

   }

  object {tech_gear_hole  translate <(-1*0.4), (-3*0.4), 0> }
  object {tech_gear_hole  translate <(1*0.4), (-3*0.4), 0> }
  object {tech_gear_hole  translate <(-3*0.4), (-1*0.4), 0> }
  object {tech_gear_hole  translate <(-1*0.4), (-1*0.4), 0> }
  object {tech_gear_hole  translate <(1*0.4), (-1*0.4), 0> }
  object {tech_gear_hole  translate <(3*0.4), (-1*0.4), 0> }
  object {tech_gear_hole  translate <(-3*0.4), (1*0.4), 0> }
  object {tech_gear_hole  translate <(-1*0.4), (1*0.4), 0> }
  object {tech_gear_hole  translate <(1*0.4), (1*0.4), 0> }
  object {tech_gear_hole  translate <(3*0.4), (1*0.4), 0> }
  object {tech_gear_hole  translate <(-1*0.4), (3*0.4), 0> }
  object {tech_gear_hole  translate <(1*0.4), (3*0.4), 0> }

  object {l3g0_tech_axle_2  translate <0, 0, (-1*0.4)> }
  box {<-0.04, -0.4, 0>, <0.04, 0.4, 1> }
  object {l3g0_tech_axle_2  translate <wide, 0, (-1*0.4)> }
  box {<-0.04, -0.6, 0>, <0.04, 0.6, 1>  translate <(1*wide), 0, 0> }
  object {l3g0_tech_axle_2  translate <(-1*wide), 0, (-1*0.4)> }
  box {<-0.04, -0.6, 0>, <0.04, 0.6, 1>  translate <(-1*wide), 0, 0> }
  object {l3g0_tech_axle_2  translate <0, (wide), (-1*0.4)> }
  box {<-0.6, -0.04, 0>, <0.6, 0.04, 1>  translate <0, (1*wide), 0> }
  object {l3g0_tech_axle_2  translate <0, (-1*wide), (-1*0.4)> }
  box {<-0.6, -0.04, 0>, <0.6, 0.04, 1>  translate <0, (-1*wide), 0> }

 }

#declare tech_medium_pulley_hole = cylinder {<0, 0, 0>, <0, 0, 0.4>,stud_radius  translate <0, wide, 0> }

#declare l3g0_tech_medium_pulley =
difference
 {
  merge
   {
    difference
     {
      cylinder {<0, 0, 0>, <0, 0, 0.4>, (3*wide)/2}
      union
       {
        cone {<0, 0, -0.1>, ((3*wide)/2)-.15 <0, 0, 0.1>, ((3*wide)/2) - 0.25}
        cone {<0, 0, (0.4+0.001)>, (3*wide)/2-.15 <0, 0, (0.4-.1)>, (3*wide/2)-.25 pigment { color Blue}}
       }
     }
    cylinder {<0, 0, 0>, <0, 0, 0.4>, .35}
   }
  union
   {
    object {l3g0_tech_axle_3 translate <0,0,-wide>}
    box {<(-1*.96/2), -.045, -wide>, <(.96/2), .045, wide>}
    object {tech_medium_pulley_hole}
    object {tech_medium_pulley_hole rotate <0, 0, 60> }
    object {tech_medium_pulley_hole rotate <0, 0, 120>}
    object {tech_medium_pulley_hole rotate <0, 0, 180>}
    object {tech_medium_pulley_hole rotate <0, 0, 240>}
    object {tech_medium_pulley_hole rotate <0, 0, 300>}
    torus { (3*wide/2-.02), .12 rotate <90,0,0> translate <0, 0, (0.4/2)> }
   }
}

#declare pulley_rim_disc = cylinder {<0, 0, (-1*stud_radius)>, <0, 0, (stud_radius)>, (2.4*wide) }
#declare pulley_hole = cylinder {<0, 0, (-1*wide)>, <0, 0, wide>, (0.3256-.05) }

#declare pulley_rim =
union
 {
  intersection
   {
    object {pulley_rim_disc }
    torus {(2.2*wide-.01), (stud_radius+0.0125) rotate <90,0,0> translate <0, 0, 0>}
   }
  intersection
   {
    object {pulley_rim_disc}
    torus {(2.2*wide), (stud_radius+.01125) rotate <90,0,0> translate <0, 0, 0>}
   }
 }

#declare l3g0_tech_large_pulley =
union
 {
  difference
   {
    union
     {
      object {pulley_rim}
      cylinder {<(-2*wide+.4*wide), 0, 0>, <(2*wide-.4*wide), 0, 0>, (stud_radius+.01)}
      cylinder {<0, 0, (-1*wide/2)>, <0, 0, (wide/2)>, (wide/2) }
      cylinder {<(1.5*wide), 0, (-1*wide/2+.05)>, <(1.5*wide), 0, (wide/2-.05)>, (0.3256)}
      cylinder {<(-1.5*wide), 0, (-1*wide/2+.05)>, <(-1.5*wide), 0, (wide/2-.05)>, (0.3256)}
     }
    torus {(2.4*wide-.07), (.1) rotate <90,0,0> translate <0, 0, 0>}
    object {l3g0_tech_axle_2 translate <0, 0, -.5> }
    box {<(-1*wide+.10), -.04, -1>, <(wide-.10), .04, 1> }
    object {pulley_hole translate <(1.5*wide), 0, 0>}
    object {pulley_hole translate <(-1.5*wide), 0, 0> }
   }
 }



#declare tech_hole_cylinder = cylinder {<0, 0, 0>, <0, (2*.96), 0>, (0.32/2)}
#declare tech_cylinder_box =  box {<(2*wide), (-.16), (-3*wide)>, <(5*wide), 0, (3*wide)> }

#declare l3g0_tech_motor_45v =
difference
 {
  union
   {
    difference
     {
      intersection
       {
        cylinder {<0, (4*.32), 0>, <(6*wide), (4*.32), 0>, (2*wide-.15) }
        box {<(wide), (.67*.32), (-2*wide)>, <(5*wide), (2*.96+.32), (2*wide)>}
       }
      union
       {
        object {tech_cylinder_box translate <0, .32, 0>}
        object {tech_cylinder_box translate <0, (2*.32), 0>}
        object {tech_cylinder_box translate <0, (3*.32), 0>}
        object {tech_cylinder_box translate <0, (4*.32), 0>}
        object {tech_cylinder_box translate <0, (5*.32), 0>}
        object {tech_cylinder_box translate <0, (6*.32), 0>}
        object {tech_cylinder_box translate <0, (7*.32), 0>}
        object {tech_cylinder_box translate <0, (8*.32), 0>}
       }
     }
    intersection
     {
      cylinder {<0, (4*.32), 0>, <(6*wide), (4*.32), 0>, (2*wide-.3)}
      box {<wide, (.16), (-2*wide)>, <(5*wide), (2*.96+.32), (2*wide)>}
     }
    #if (Detail_level > 0)
    object {tech_stud translate <(1.5*wide), (2*.96+.32), (-.5*wide)>}
    object {tech_stud translate <(1.5*wide), (2*.96+.32), (.5*wide)>}
    object {tech_stud translate <(2.5*wide), (2*.96+.32), (-.5*wide)>}
    object {tech_stud translate <(2.5*wide), (2*.96+.32), (.5*wide)>}
    object {tech_stud translate <(3.5*wide), (2*.96+.32), (-.5*wide)>}
    object {tech_stud translate <(3.5*wide), (2*.96+.32), (.5*wide)>}
    object {tech_stud translate <(4.5*wide), (2*.96+.32), (-.5*wide)>}
    object {tech_stud translate <(4.5*wide), (2*.96+.32), (.5*wide)>}
    box {<0, (2*.32), (-1*wide)>, <(wide), (2*.32+.96), (1*wide)>}
    object {tech_stud translate <(.5*wide), (2*.32+.96), (-.5*wide)>}
    object {tech_stud translate <(.5*wide), (2*.32+.96), (.5*wide)>}
    #end

    object {l3g0_tech_axle_2 texture { l3g0_black } rotate <0, 90, 0> translate <(4*wide), (4*.32), 0>}
    object {flat2x4 translate <wide, 0, (-1*wide)>}
   }
  object {tech_hole_cylinder translate <(.5*wide), 0, (-.5*wide)>}
  object {tech_hole_cylinder translate <(.5*wide), 0, (.5*wide)>}
  object {tech_hole_cylinder rotate <0, 0, -90> translate <-1, (4*.32), (-.5*wide)>}
  object {tech_hole_cylinder rotate <0, 0, -90> translate <-1, (4*.32), (.5*wide)>}
  torus { ((0.32/2)), (.04) rotate <90,0,0> translate <(5*wide+.3), (4*.32), 0>}
 }

#declare l3g0_tech_spacer =
difference
 {
  union
   {
    cylinder {<0, 0, 0>, <wide, 0, 0>, .3}
    cylinder {<0, 0, 0>, <.1, 0, 0>, .4}
    cylinder {<.7, 0, 0>, <wide, 0, 0>,.4 }
   }
  union
   {
    object {l3g0_tech_axle_2 rotate <0, 90, 0> translate <-0.1,0,0>}
    object {flat2x2 rotate <0, 0, -90> translate <-.96, wide, -wide>}
    box {<.1, -.4, -.05>, <.7, .4, .05>}
   }
 }

#declare tech_pulley_box = box {<-.04, 0, .09>, <.04, (.6*wide), -.5>}

#declare l3g0_tech_small_pulley =
difference
 {
  cylinder {<0, 0, 0>, <0, 0, (.5*wide)>, (.5*wide) }
  object {l3g0_tech_axle_2 }
  torus {(.5*wide), .08 rotate <90,0,0> translate <0, 0, (.5*wide-.2)>}

  #declare number=16
  #declare current=0
  #while (current < 360)
   object { tech_pulley_box rotate <0, 0, current>}
   #declare current = current + (360/number)
  #end
  cylinder {<0, 0, -.1>, <0, 0, .09>, (stud_radius)}
 }

#if (Detail_level =2)
#declare tech_rackgear_tooth =
intersection
 {
  box {<-.075, 0, (-.5*wide)>, <.075, (wide-(2*tech_hole_outer_rad)), (.5*wide)>}
  sphere {<0, 0, 0>, 1 scale <.075, ((wide-(2*tech_hole_outer_rad))), 1000>}
 }



#declare tech_worm_tooth =
intersection
 {
  box {<-.085, 0, (-.15*wide)>, <.085, (wide-(2*tech_hole_outer_rad)), (.15*wide)>}
  sphere {<0, 0, 0>, 1 scale <.085, ((wide-(2*tech_hole_outer_rad))), 1000>}
 }

#declare tech_gear_16_tooth = object {tech_gear_tooth translate <0, (tech_hole_outer_rad+0.4), 0>}

#declare tech_gear_16_teeth =
union
 {
  #declare number=16
  #declare current=0
  #while (current < 360)
   object { tech_gear_16_tooth rotate <0, 0, current>}
   #declare current = current + (360/number)
  #end
 }
#end

#declare tech_gear_16_cylinder = cylinder {<0, 0, (0.4-.25*wide)>, <0, 0, (0.4+.25*wide)>,stud_radius}
#declare tech_gear_16_hole = cylinder {<0, 0, -1>, <0, 0, (wide)>,(0.32/2)}
#declare tech_gear_16_cylinder_transla = object {tech_gear_16_cylinder translate <0, (.5*wide), 0>}
#declare tech_gear_16_cutout = object {tech_gear_16_hole translate <0, (.5*wide), 0>}


#declare tech_box_cutout =
merge
 {
  box {<-.08, (-.6*wide), -1>, <.08, (.6*wide), 1>}
  box {<(-.6*wide), -.08, -1>, <(.6*wide), .08, 1>}
 }

#declare l3g0_tech_gear_16 =
difference
 {
  union
   {
    difference
     {
      union
       {
        #if (Detail_level = 2)
        object {tech_gear_16_teeth translate <0, 0, 0.4>}
        #end
        cylinder {<0, 0, (0.4-.25*wide)>, <0, 0, (0.4+.25*wide)>, (tech_hole_outer_rad+0.4)}
       }
      union
       {
        cylinder {<0, 0, (0.4-.3*wide)>, <0, 0, (0.4-.1)>, ((tech_hole_outer_rad+0.4)-.1)}
        cylinder {<0, 0, (0.4+.1)>, <0, 0, (0.4+1)>, ((tech_hole_outer_rad+0.4)-.1) }
       }
     }
    object {tech_gear_16_cylinder_transla}
    object {tech_gear_16_cylinder_transla rotate <0, 0, 90>}
    object {tech_gear_16_cylinder_transla rotate <0, 0, 180>}
    object {tech_gear_16_cylinder_transla rotate <0, 0, 270>}
    box {<(-.5*wide+.06), (-.5*wide+.06), 0>, <(.5*wide-.06), (.5*wide-.06), (wide)> rotate <0, 0, 45>}
   }
  union
   {
    object {tech_gear_16_cutout}
    object {tech_gear_16_cutout rotate <0, 0, 90>}
    object {tech_gear_16_cutout rotate <0, 0, 180>}
    object {tech_gear_16_cutout rotate <0, 0, 270>}
    object {tech_box_cutout}
   }
 }

#if (Detail_level = 2)
#declare tech_worm_tooth_2 = object {tech_worm_tooth}

#declare tech_worm_teeth_section =
union
 {
  #declare number=16
  #declare start=0.02
  #declare current=0
  #while (current < 360)
   object { tech_worm_tooth_2 rotate <0, 0, current> translate <start,0,0>}
   #declare current = current + (360/number)
   #declare start= start + 0.02
  #end

 }


#declare tech_worm_teeth =
union
 {
  object {tech_worm_teeth_section translate <-.32, 0, 0>}
  object {tech_worm_teeth_section }
  object {tech_worm_teeth_section translate <.32, 0, 0>}
  object {tech_worm_teeth_section translate <.64, 0, 0> }
  object {tech_worm_teeth_section translate <.96, 0, 0> }
  object {tech_worm_teeth_section translate <1.28, 0, 0> }
  object {tech_worm_teeth_section translate <1.6, 0, 0> }
 }
#end


#declare l3g0_tech_gear_worm =
difference
 {
  union
   {
    intersection
     {
      box {<0, -1, -1>, <1.6, 1, 1> }
      #if (Detail_level = 2)
      object {tech_worm_teeth }
      #else
      cylinder {<0,0,0>,<1.6,0,0>, flat/2}
      #end
     }
    cylinder {<0, 0, 0>, <1.6, 0, 0>,flat/2}
   }
  object {l3g0_tech_axle_4 rotate <0, 90, 0> translate <-.8, 0, 0>}
 }

#if (Detail_level = 2)
#declare tech_rack_teeth =
union
 {
  object {tech_rackgear_tooth translate <(.5*(4*wide/10)), 0, 0>}
  object {tech_rackgear_tooth translate <(1.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(2.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(3.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(4.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(5.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(6.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(7.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(8.5*(4*wide/10)), 0, 0> }
  object {tech_rackgear_tooth  translate <(9.5*(4*wide/10)), 0, 0> }
 }
#end

#declare l3g0_tech_gear_rack =
union
 {
  #declare XW=4 #declare YW=flat #declare ZW=1 #include "BrickBox.inc"
  #if (Detail_level = 2)
  object {tech_rack_teeth translate <0, .32, (.5*wide)>}
  #end
  #if (Detail_level > 1)
  object { thin_flat_column translate <wide,0,wide*0.5> }
  object { thin_flat_column translate <wide*2,0,wide*0.5> }
  object { thin_flat_column translate <wide*3,0,wide*0.5> }
  #end
 }

#if (Detail_level = 2)
#declare tech_crown_tooth_bottom =
intersection
 {
  object {tech_gear_tooth translate <0, (tech_hole_outer_rad+wide), 0> }
  torus {((tech_hole_outer_rad+wide)-.05), (wide-(2*tech_hole_outer_rad)) rotate <90,0,0> translate <0, 0, (.3*wide)>}
 }


#declare tech_crown_cone =
union
 {
  cylinder {<0, 0, 0>, <0, 0, .05>,.07}
  cone {<0, 0, .05>, .07 <0, 0, .15>, .025 }
  sphere {<0, 0, .15>, .025}
 }

#declare tech_crown_tooth =
merge
 {
  object {tech_crown_tooth_bottom }
  object {tech_crown_cone translate <0, ((tech_hole_outer_rad+wide)+(wide-(2*tech_hole_outer_rad))-.125), (.46*0.4)>}
 }

#declare tech_crown_teeth =
union
 {
  #declare number=24
  #declare current=0
  #while (current < 360)
   object { tech_crown_tooth rotate <0, 0, current> }
   #declare current = current + (360/number)
  #end
 }
#end

#declare tech_gear_crown_shell =
difference
 {
  union
   {
    difference
     {
      union
       {
        #if (Detail_level = 2)
        object { tech_crown_teeth }
        #end
        cylinder {<0, 0, -.05>, <0, 0, (.48*0.4)>, (tech_hole_outer_rad+wide)}
       }
      cylinder {<0, 0, -.5>, <0, 0, .5>, (.8*wide)}
     }
    torus { ((tech_hole_outer_rad+wide)-.15), .1 rotate <90,0,0> translate <0, 0, .01>}
    box {<-.25, (-1*((tech_hole_outer_rad+wide)-.2)), -.05>, <.25, ((tech_hole_outer_rad+wide)-.2), (.48*0.4)>}
    cone {<0, 0, -.05>, (wide/2) <0, 0, -.09>, (wide/2-.05) }
    cylinder {<0, 0, -.05>, <0, 0, .66>, (wide/2) open}
    cone {<0, 0, .66>, (wide/2) <0, 0, .71>, (wide/2-.05)}
   }
  object {l3g0_tech_axle_3 translate <0, 0, (-1*wide)> }
  box {<-.045, (-1*(.8*wide-.1)), -1>, <.045, (.8*wide-.1), 1>}
 }

#declare l3g0_tech_gear_crown = object {tech_gear_crown_shell translate <0, 0, .09>}