    processor 6502
    include vcs.h
    include sleep.h
    include macro.h
    include build/font.asm
    include plaque.asm
    include plasmabar.asm
    include timeline.asm
    include gradients.asm

    ;Checks whether * and {1} reside on the same page
    MAC CHECK_ALIGN
    IF >{1} - >*
        ;I can't figure out how to print the actual label, so have DASM fail here and print it
        ECHO {1} not aligned
        ERR
    ENDIF
    ENDM

VBLNK   equ 48
LINES   equ 228
OVERSCN equ 36
TEMPO   equ 48
MAKE4K  equ 0               ;non-zero -> build 4k instead of 16k, because my Harmony cart is broken

    ;RAM
    SEG.U VARS
    org $80

frame   ds  1
    ;song player vars
vol1    ds  1
vol2    ds  1
beat    ds  1
tempoCount  ds  1           ;bit 7 (sign) = whether it's the first frame in the beat
measure ds  1
    ;timeline stuff
pattern ds  1
row     ds  1
rowbeat ds  1

VARSTART    equ *

TEMPSZ  equ 6
temp    equ $100-TEMPSZ     ;overlay temp variables with stack
rowptr  equ temp

    echo "RAM:", (temp - *)d, "bytes for kernels"
    org VARSTART

plaquechars ds  1           ;number of lines
burnlines   ds  1
textptr     ds  2
charptr     ds  96          ;4 lines * 12 chars * 2 byte/char

    echo "RAM:", (temp - *)d, "bytes left"
    org VARSTART

gradbary    ds  1
gradbarv    ds  1

    echo "RAM:", (temp - *)d, "bytes left"

    ;ROM
    SEG CODE
    org $1000
    rorg $1000

    FONT

bitMaskArray
    byte #%10000000
    byte #%01000000
    byte #%00100000
    byte #%00010000
    byte #%00001000
    byte #%00000100
    byte #%00000010
    byte #%00000001

Burn
    sta WSYNC
    dex
    bne Burn
    rts

    include build/sintab.asm
    include utils.asm
    PLAQUE_LOGIC
    PLAQUE_KERNEL
    PLASMA_BAR_KERNEL
    include song.asm
    TIMELINE
    GRADIENTS_KERNEL
    TEXT_DATA

Black
    ;ldx #LINES+1
    ;jsr Burn
    ;brk

Start
    cld
    ldx #0
    txa
ClearStack
    dex
    pha
    bne ClearStack

MainLoop
    lda #(OVERSCN-2)*19/16
    sta TIM64T
    lda #2
    sta VBLANK

    lda #0
    sta PF0
    inc frame

    ;came here from a BRK (SP known) or from Start (SP unknown)
    ldx #$FF
    txs

    ;play song by falling into songPlayer
    include songplay.h
    ;we fall back out of the player here

WaitForOverscanEnd
    sta WSYNC
    lda INTIM
    bpl WaitForOverscanEnd

    ;VERTICAL_SYNC
    lda #%1110         ; each '1' bits generate a VSYNC ON line (bits 1..3)
VSLP1
    sta WSYNC           ; 1st '0' bit resets Vsync, 2nd '0' bit exit loop
    sta VSYNC
    lsr
    bne VSLP1           ; branch until VYSNC has been reset

    lda #(VBLNK-2)*19/16-1
    sta TIM64T

    jsr LoadRowPtr1
    jsr LogicStub
    jsr LoadRowPtr

    lda Kernels+1,X
    pha
    lda Kernels,X
    pha

WaitForVblankEnd
    lda INTIM
    bpl WaitForVblankEnd

    lda #0
    sta WSYNC
    sta HMOVE
    sta VBLANK

    rts             ;call kernel, BRK to MainLoop

    ;like LoadRowPtr, but advances one row if needed
LoadRowPtr1
    ;new beat?
    lda tempoCount
    bpl LoadRowPtr

    inc rowbeat
    jsr LoadRowPtr

    iny
    lda (rowptr),Y
    cmp rowbeat
    bne LoadRowPtrRts   ;rowbeat != table value? we're done

    ;next row
    dey
    sty rowbeat

    lda row
    clc
    adc #ROWLEN
    sta row

    jsr LoadRowPtr

    lda (rowptr),Y
    bpl LoadRowPtrRts   ;not at end of pattern yet

    ;next pattern
    sty row
    inc pattern
    inc pattern

    ;load current rowptr
LoadRowPtr
    ldx pattern
    lda row
    clc
    adc Timeline+1,X
    sta rowptr
    lda Timeline,X
    bmi Repeat
    adc #0
    sta rowptr+1
LoadRowPtrRts
    ldy #0
    lax (rowptr),Y
    rts
Repeat
    lda #REPEAT
    sta pattern
    bne LoadRowPtr

LogicStub
    lda Logics+1,X
    pha
    lda Logics,X
    pha
    rts

    align 48
    incbin face.bin ;by visy

    echo "ROM:",($1FF6-*)d,"bytes left"

    org $1FF6
    rorg $1FF6
    word $FFFF,$FFFF    ;hotspots
Delay14
    nop
Delay12
    rts
    .word Start
    .word MainLoop
