    processor 6502
    include vcs.h
    include macro.h
    include build/audioquant.asm

;FPS = 50 or 60
;PAL = 0 or 1
#if FPS==50         ;PAL
VBLNK   equ 48
LINES   equ 228
OVERSCN equ 36
#else               ;NTSC
VBLNK   equ 40
LINES   equ 192
OVERSCN equ 30
#endif

VBLNK64 equ VBLNK*19/16-1   ;value to set TIM64 to for VBLNK
OVERS64 equ OVERSCN*19/16   ;ditto for overscan
LPF     equ 1               ;low-pass filter output?
BEAT    equ 155             ;the length of a beat in bytes

JMPBank equ $1FEE

    ;18 byte bootstrap macro
    ;Includes JMPBank routine and JMP to Start in Bank 7
    MAC END_SEGMENT
.BANK   SET {1}
    echo "Bank",.BANK,":", (JMPBank - *), "free"

    org JMPBank + (.BANK * 4096)
    rorg JMPBank
;Jump to fnptr in bank X
;Example usage:
;   SET_POINTER fnptr Address
;   ldx #Bank
;   jmp JMPBank
;
    ;$1FEE-$1FF3
    nop $1FF4,X     ;3 B
    jmp (fnptr)     ;3 B
    ;$1FF4-$1FFB
    .byte 0,0,0,0
    .byte 0,0,0,$4C ;JMP Start (reading the instruction jumps to bank 7, where Start's address is)
    ;$1FFC-1FFF
    .word $1FFB
    .word $1FFB
    ;Bank .BANK+1
    org $1000 + ((.BANK + 1) * 4096)
    rorg $1000
    ENDM

    MAC PLAYER
.SAMPLEDATA SET {1}
.SAMPLEEND  SET {2}
.NEXTSTART  SET {3}
.NEXTBANK   SET {4}
    echo "Sample data in bank:",.SAMPLEEND-.SAMPLEDATA
    lda #<(.SAMPLEDATA-1)
    sta pcmptr
    lda #>(.SAMPLEDATA-1)
    sta pcmptr+1

    ldx #7
.PlayLoop
    inx
    cpx #8
    bne .PlayLoop_Continue

    dec beatcnt
    lda beatcnt
    bne .BeatCntOK
    inc beatdiv
    lda #BEAT
    sta beatcnt
.BeatCntOK
    lda beatdiv
    lsr
    asr #%11110
    tay
    lda .Pal,Y
    sta bk
    ora #$0E
    sta COLUPF

    lda pcmptr+1
    cmp #>(.SAMPLEEND-1)
    bcc .PlayLoop_PtrOK
    lda pcmptr
    cmp #<(.SAMPLEEND-1)
    bcc .PlayLoop_PtrOK

    IF .NEXTSTART > 0
        ;goto next bank
        lda #<.NEXTSTART
        sta fnptr
        lda #>.NEXTSTART
        sta fnptr+1
        ldx #.NEXTBANK
        jmp JMPBank
    ELSE
        ;go black and JAM
        lda #0
        sta COLUBK
        sta COLUPF
        sta COLUP0
        sta COLUP1
        .byte $02
    ENDIF

.PlayLoop_PtrOK
    inc pcmptr
    bne .PlayLoop_Load
    inc pcmptr+1

.PlayLoop_Load
    ldy #0
    lda (pcmptr),Y
    sta bits
    ldx #0

.PlayLoop_Continue
    lsr bits
    lda last
    rol
    tay
    lda ADPCMTable0,Y
    sta last
    ldy #4
.DoWSync
    lda last

    IF LPF
        adc lpf
        lsr
        sta lpf
    ENDIF

    lsr

    sta WSYNC

    sta AUDV0       ;5-bit PCM
    adc #0
    sta AUDV1
    ora bk
    sta COLUBK

    eor bk
    asr #%11111100
    adc #8
    ora bk
    sta COLUP1

    eor bk
    lsr
    adc #8
    ora bk
    sta COLUP0

    dey
    bne .DoWSync
    jmp .PlayLoop
.Pal
    .byte $00
    .byte $20
    .byte $00
    .byte $40
    .byte $00
    .byte $60
    .byte $00
    .byte $80
    .byte $00
    .byte $30
    .byte $00
    .byte $50
    .byte $00
    .byte $70
    .byte $00
    .byte $90
    ENDM

    ;RAM
    SEG.U VARS
    org $80

last    ds  1
pcmptr  ds  2
bits    ds  1
fnptr   ds  2
#if LPF
lpf     ds  1
#endif
bk      ds  1
beatcnt ds  1
beatdiv ds  1
temp    ds  1
frame   ds  1
screen  ds  1
linea   ds  1   ;start
lineb   ds  1   ;end
padtop  ds  1
padbot  ds  1

    echo "RAM:", ($100 - *), "bytes left"

    ;ROM
    SEG CODE

    ;Bank 0
    org $1000
    rorg $1000

    TABLE1
    SAMPLES1
Bank0Start
    PLAYER SampleData1, SampleEnd1, Bank1Start, 1

    END_SEGMENT 0

    TABLE2
    SAMPLES2
Bank1Start
    PLAYER SampleData2, SampleEnd2, Bank2Start, 2

    END_SEGMENT 1

    TABLE3
    SAMPLES3
Bank2Start
    PLAYER SampleData3, SampleEnd3, Bank3Start, 3

    END_SEGMENT 2

    TABLE4
    SAMPLES4
Bank3Start
    PLAYER SampleData4, SampleEnd4, Bank4Start, 4

    END_SEGMENT 3

    TABLE5
    SAMPLES5
Bank4Start
    PLAYER SampleData5, SampleEnd5, Bank5Start, 5

    END_SEGMENT 4

    TABLE6
    SAMPLES6
Bank5Start
    PLAYER SampleData6, SampleEnd6, Bank6Start, 6

    END_SEGMENT 5

    TABLE7
    SAMPLES7
Bank6Start
    PLAYER SampleData7, SampleEnd7, 0, 0

    END_SEGMENT 6

    include build/bmp.asm

    TABLE0
    SAMPLES0

    include utils.asm

    org $8700
    rorg $1700
    COL0
    COL1
    org $8800
    rorg $1800
    COL2
    COL3
    org $8900
    rorg $1900
    COL4
    COL5
    org $8A00
    rorg $1A00
    COL6
    COL7
    org $8B00
    rorg $1B00
    COL8
    COL9
    org $8C00
    rorg $1C00
    COL10
    COL11

Lines
    .byte HEIGHT-1-0
    .byte HEIGHT-1-13
    .byte HEIGHT-1-23
    .byte HEIGHT-1-43
    .byte HEIGHT-1-51
    .byte HEIGHT-1-79
    .byte HEIGHT-1-99

Start
    CLEAN_START

    ;initial black to let the display stabilize
    lda #128
    sta frame
    lda #$FF
    sta screen

    ;comfort noise
    lda #2
    sta AUDC0
    lda #%11010
    sta AUDF0

MainLoop
    VERTICAL_SYNC
    lda #VBLNK64
    sta TIM64T

    inc frame
    inc frame
    bne FrameOK

    inc screen
    lda screen
    cmp #6
    bcc FrameOK
    jmp StartDecoder

FrameOK
    ldx screen
    lda Lines,X
    sta linea
    lda Lines+1,X
    sta lineb
    lda #LINES/2-1
    clc
    adc lineb
    sec
    sbc linea
    lsr
    sta padtop
    adc #0
    sta padbot

    lda #$06
    sta NUSIZ0
    sta NUSIZ1

    lda frame
    lsr
    lsr
    cmp #16
    bcc ColuPxOK
    cmp #48
    bcc ColuPxWhite
    eor #63
    .byte $0C
ColuPxWhite
    lda #$0E
ColuPxOK
    sta COLUP0
    sta COLUP1
    lsr
    lsr
    adc #4
    sta AUDV0
    lda #$00
    sta COLUBK
    lda #1
    sta VDELP0
    sta VDELP1
    lda #0
    sta COLUPF

XPOS equ 37
    lda #XPOS
    ldx #0
    jsr PositionObject
    lda #XPOS+16
    ldx #1
    jsr PositionObject
    sta WSYNC
    sta HMOVE

WaitForVblankEnd
    lda INTIM
    bmi WaitForVblankEnd_Overflow
    bne WaitForVblankEnd
WaitForVblankEnd_Overflow
    lda #0
    sta VBLANK
    ;NOTE: Don't set COLUBK before VBLANK has been turned off (above)
    ;      Otherwise you get ugly colors for the first few lines

    sta WSYNC
    sta WSYNC

    lda screen
    cmp #$FF
    bne ProceedNormally ;delicious hacks
    ldx #LINES/2-1
    jmp PadBot

ProceedNormally

    ldx padtop
PadTop
    sta WSYNC
    sta WSYNC
    dex
    bne PadTop

    ldx linea
Kernel
    lda #$80
    sta HMP0
    sta HMP1
    ;cy 66

    sta WSYNC
    sta HMOVE           ;right 8 pixels

    dec temp
    dec temp

    lda Col1,X
    sta GRP0
    lda Col3,X
    sta GRP1
    lda Col5,X
    sta GRP0
    lda Col7,X
    sta GRP1
    lda Col9,X
    sta GRP0
    lda Col11,X
    sta GRP1
    sta GRP0

    dec temp
    dec temp

    sta HMCLR   ;I found a video that explains how this works:
    sta HMOVE   ;http://www.youtube.com/watch?v=9wT_OTml5vE

    dec temp
    dec temp

    lda Col0,X
    sta GRP0
    lda Col2,X
    sta GRP1
    lda Col4,X
    sta GRP0
    lda Col6,X
    sta GRP1
    lda Col8,X
    sta GRP0
    lda Col10,X
    sta GRP1
    sta GRP0

    dex
    cpx lineb
    bne Kernel

    ldx padbot
PadBot
    sta WSYNC
    lda #0
    sta GRP0
    sta GRP1
    sta GRP0
    sta WSYNC
    dex
    bne PadBot

    lda #OVERS64
    sta TIM64T
    lda #2
    sta VBLANK
WaitForOverscanEnd
    lda INTIM
    bmi WaitForOverscanEnd_Overflow
    bne WaitForOverscanEnd
WaitForOverscanEnd_Overflow
    jmp MainLoop

StartDecoder
    lda #0
    sta AUDC0
    sta VBLANK

    lda #$FF
    sta PF0
    lda #1
    sta CTRLPF

    lda #20             ;P0
    ldx #0
    jsr PositionObject    
    lda #25             ;M1
    ldx #3
    jsr PositionObject
    lda #136             ;P1
    ldx #1
    jsr PositionObject    
    lda #145             ;M0
    ldx #2
    jsr PositionObject

    lda #%11110000
    sta GRP0
    lda #%00001111
    sta GRP1
    sta GRP0            ;VDELPx..
    lda #2
    sta ENAM0
    sta ENAM1
    lda #$20
    sta NUSIZ0
    sta NUSIZ1

    sta WSYNC
    sta HMOVE

    lda #90
    sta beatcnt
    lda #15
    sta last

    ldx #5
DelayOuter
    lda #255
    sta T1024T
Delay
    lda INTIM
    bne Delay
    dex
    bne DelayOuter

    PLAYER SampleData0, SampleEnd0, Bank0Start, 0

    echo "Bank",7,":", (JMPBank - *), "free"

    org JMPBank + $7000
    rorg JMPBank
;JMPBank
;Jump to fnptr in bank X
    ;$1FEE-$1FF3
    nop $1FF4,X     ;3 B
    jmp (fnptr)     ;3 B
    ;$1FF4-$1FFB
    .byte 0,0,0,0
    .byte 0,0,0,0
    ;$1FFC-1FFF
    .word Start
    .word Start
