;Old code. Beware of dragons.

    MAC PIXBUF_VARS
    ;Stuff for the playfield pixel buffer
SCREENH equ 24

    ;The following vars set the position and height of the buffer.
    ;The kernel needs to burn LINES - pixbufy - (pixbufh-1)*(pixbufk+1)
    ;lines after drawing the buffer.
pixbufy ds  1           ;vertical position of screen
pixbufh ds  1           ;height of pixel buffer + 1, destroyed by the kernel
pixbufk ds  1           ;kernel height - 1, may be modified - see pixbufl
pixbufl ds  1           ;fine kernel height adjustment
                        ;on the pixbufl:th line, pixbufk++
                        ;destroyed by the kernel
pixbufb ds  1           ;post-burn

pixbuf  ds  4*SCREENH   ;playfield data

    ;FIXME: We might want to more the scroller vars somewhere else
scrlptr ds  2           ;pointer to current character in string
charptr ds  2           ;pointer to current character's data
curkern ds  1           ;kerning left to do
curcol  ds  1           ;columns left to shift out
    ENDM

    MAC PIXBUF_LOGIC
PixBufLogic
PIXBUFH	equ	50
	lda #PIXBUFH
	lsr
	lsr
	lsr
	lsr
	sta pixbufk
	lda #PIXBUFH
	lsr
	sta pixbufy
	lda #LINES/2
	sec
	sbc pixbufy
	sta pixbufy
	lda #17
	sta pixbufh
	
	lda #PIXBUFH
	and #$0F
	sta temp
	lda #17
	sec
	sbc temp
	sta pixbufl

	lda #LINES - 16
	sec
	sbc #PIXBUFH
	sbc pixbufy
	sta pixbufb

	;TODO: fix up pixbufy and pixbufh such that we can fiddle with
	;      both and pixbufk without risking drawing too many lines

	;mirror playfield
	lda #1
	sta CTRLPF

	rts
    ENDM

    MAC PIXBUF_KERNEL
PixBufKernel
    ;light green on dark green
    lda #$34
    sta COLUBK
    lda #$3E
    sta COLUPF

	;this is needed to make X zero when we add 4 to it later
	ldx #252

	;burn lines to shift pixels down
	ldy pixbufy
	beq PixBufKernel_PreBurn_NextRow

PixBufKernel_PreBurn
	sta WSYNC
	dey
	bne PixBufKernel_PreBurn
	jmp PixBufKernel_PreBurn_NextRow

PixBufKernel_Loop
	sta WSYNC

	;Note: we have lots of time to do fun stuff like change COLUPF here

	lda pixbuf,X
	sta PF1
	lda pixbuf+1,X
	sta PF2
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	lda temp
	lda pixbuf+2,X
	sta PF2
	lda pixbuf+3,X
	sta PF1

	dey
	bne PixBufKernel_Loop

PixBufKernel_PreBurn_NextRow
	txa
	clc
	adc #4
	tax

	ldy pixbuf,X

	sta WSYNC

	dec pixbufh
	beq PixBufKernel_PostBurn

	dec pixbufl
	beq PixBufKernel_IncKernelSize

	nop
	nop
	nop
	lda temp

PixBufKernel_Continue
	sty PF1
	lda pixbuf+1,X
	sta PF2

	lda pixbuf+3,X
	sta.w PF1
	lda pixbuf+2,X
	sta PF2

	ldy pixbufk
	beq PixBufKernel_PreBurn_NextRow
	jmp PixBufKernel_Loop

PixBufKernel_IncKernelSize
	inc pixbufk
	jmp PixBufKernel_Continue

PixBufKernel_PostBurn
	lda #0
	sta PF1
	sta PF2
	ldx pixbufb
	beq PixBufKernel_Return

PixBufKernel_PostBurn_Loop
	sta WSYNC
	dex
	bne PixBufKernel_PostBurn_Loop

PixBufKernel_Return
	jmp DoneKernel
    ENDM

    MAC PIXBUF_LOGIC2
	;Shifts the pixel buffer one pixel (bit) to the left
	;X = number of lines to shift * 4
	;    in other words, pointer to the left line to shift
PixBufShiftLeft_Dex
	dex
	dex
	dex
	dex

PixBufShiftLeft
	lsr pixbuf-1,X
	rol pixbuf-2,X
	ror pixbuf-3,X
	rol pixbuf-4,X
	cpx #4
	bne PixBufShiftLeft_Dex

	rts

#if 0
Bitmask
	byte %00000001
	byte %00000010
	byte %00000100
	byte %00001000
	byte %00010000
	byte %00100000
	byte %01000000
	byte %10000000

BitmaskInv
	byte %11111110
	byte %11111101
	byte %11111011
	byte %11110111
	byte %11101111
	byte %11011111
	byte %10111111
	byte %01111111

	;Shifts column A up one bit
	;X = line to start shifting from * 4
PixBufShiftColumnUp
	;calculate byte index and bit offset in said byte
	;the following also accounts for odd bytes being displayed reflected

	;first augment X with the byte offset
	sta temp
	lsr
	lsr
	lsr
	sta temp+1
	txa
	clc
	adc temp+1
	tax

	;figure out the bit offset and put it in Y
	lda temp
	and #7
	sta temp
	tay

	lda temp+1
	and #1
	bne PixBufShiftColumnUp_Odd
	lda #7
	sec
	sbc temp
	tay

PixBufShiftColumnUp_Odd
	lda pixbuf,X
	and Bitmask,Y
	sta temp+1
	lda pixbuf,X
	and BitmaskInv,Y
	sta pixbuf,X

PixBufShiftColumnUp_Loop
	lda temp+1
	sta temp
	lda pixbuf,X
	and Bitmask,Y
	sta temp+1
	lda pixbuf,X
	and BitmaskInv,Y
	ora temp
	sta pixbuf,X
	dex
	dex
	dex
	dex
	cpx #0
	bpl PixBufShiftColumnUp_Loop

	rts

PixBufClear
	ldx #4*SCREENH
	lda #0
PixBufClear_Loop
	sta pixbuf+1,X
	dex
	bne PixBufClear_Loop
	rts
#endif
    ENDM
