;see http://pouet.net/groups.php?which=11387 for future prods
    processor 6502
    include vcs.h
    include macro.h

;FPS = 50 or 60
;PAL = 0 or 1
#if FPS==50         ;PAL
VBLNK   equ 48
LINES   equ 228
OVERSCN equ 36
TEMPO   equ 195*8/33             ;fine tempo adjustment
#else               ;NTSC
VBLNK   equ 40
LINES   equ 192
OVERSCN equ 30
TEMPO   equ 162*8/33             ;fine tempo adjustment
#endif

VBLNK64 equ VBLNK*19/16-1   ;value to set TIM64 to for VBLNK
OVERS64 equ OVERSCN*19/16   ;ditto for overscan
SONGDBG equ 0

    ;RAM
    SEG.U VARS
    org $80

frame   ds  1
temp    ds  5
kernelptr   equ temp    ;yep, reusing temp. this will get overwritten
                        ;by both logics and kernels, but that's OK

    ;song player vars
temp16L equ temp + 1
temp16H equ temp + 2
#if SONGDBG
note1   ds  1
note2   ds  1
sound1  ds  1
sound2  ds  1
#endif
vol1    ds  1
vol2    ds  1
beat    ds  1
tempoCount  ds  1           ;bit 7 (sign) = whether it's the first frame in the beat
measure ds  1
atten   ds  1               ;attenuation counter for fadeout

SCENERAM    equ *

    echo "Overhead:", (* - $80), "bytes"

    ;plasma vaars
xpos        ds  2
ypos        ds  2

ytabofs     ds  1
lastsample  ds  1
lastcarry   ds  1
ytab        ds  LINES/4

NHORISZCLR  equ 10   ;number of horizontal color
ramkernel   ds  KERNELSIZE
    echo "Plasma:", ($100 - *), "bytes left"

    org SCENERAM
line            ds  1
palofs          ds  1
ramkernelbar    ds  $50     ;plenty of space
rampalette      ds  16
    echo "Rasterbars:", ($100 - *), "bytes left"

    org SCENERAM
DRAWLINES   equ 8
pointers    ds  12
curline     ds  1
firstline   ds  1
lastline    ds  1           ;last line + 1
ledclr      ds  1
onlastline  ds  1
flash       ds  1
col0        ds  DRAWLINES
col1        ds  DRAWLINES
col2        ds  DRAWLINES
col3        ds  DRAWLINES
col4        ds  DRAWLINES
col5        ds  DRAWLINES
    echo "Screen:", ($100 - *), "bytes left"

    org SCENERAM
angle       ds  1
xstart      ds  1
rotoline    ds  1
pf0next     ds  1   ;4 bits
pf1next     ds  1   ;8 bits
pf2next     ds  1   ;8 bits
grp0next    ds  1   ;8 bits
x0          ds  1
y0          ds  1
x           ds  1
dx          ds  1
dy          ds  1
dx0         ds  1
dy0         ds  1
    echo "Roto28:", ($100 - *), "bytes left"

    org SCENERAM
NXS     equ 50

xminl   ds  1
xmin    ds  1
xminr   ds  1
xmax    ds  1
xmaxl   ds  1
xmaxr   ds  1

xs      ds  NXS
lastx   ds  1
pfs     ds  6
cline   ds  1
hmmnext ds  1
hmpnext ds  1
    echo "Curtains:", ($100 - *), "bytes left"

    ;ROM
    SEG CODE
    org $1000

    include build/sintab.asm

    include build/text.asm
    FONT                        ;must be aligned
    include utils.asm
    include plasma.asm
    include roto28.asm
    TEXT
    include screen.asm

Music
    include song.asm
    include songplay.h
    echo "Music:",*-Music

    .byte 0             ;for ScreenLogic
Measures
    .byte INTROTEXT
    .byte ROTOZOOMSTART
ROTOZOOMPART    equ *-Measures
    .byte HISTORYSTART
    .byte RASTERBARSTART
    .byte PLASMATEXT
    .byte PLASMASTART
    .byte BEAUTY
    .byte PLASMAV2
    .byte MIDDLETEXT
    .byte CURTAINSSTART
    .byte OPTIONAL
    .byte CURTAINCONTINUE
    .byte PALETTE
    .byte ENDTEXTSTART
    .byte ENDFLASH
    .byte EXIT
    .byte EXIT+1
    .byte EXIT+2
    .byte EXIT+3
    .byte EXIT+4
    .byte EXIT+5
    .byte EXIT+6
    .byte EXIT+7
    .byte EXIT+8

    .byte 255

Logics
    .word IntroLogic        ;dummy since it only flashes
    .word IntroLogic

    .word Roto28Logic

    .word HistoryLogic

    .word RasterbarLogic
    .word PlasmaTextLogic
    .word PlasmaLogic
    .word BeautyLogic
    .word PlasmaLogic
    .word MiddleTextLogic
    .word CurtainsLogic
    .word OptionalLogic
    .word CurtainsLogic
    .word PaletteLogic
    .word EndtextLogic
    .word IntroLogic        ;dummy since it only flashes

    .word PlasmaLogic
    .word Roto28Logic
    .word RasterbarLogic
    .word CurtainsLogic
    .word PlasmaLogic
    .word Roto28Logic
    .word RasterbarLogic
    .word CurtainsLogic

Kernels
    .word ScreenKernelWhiteFlash
    .word ScreenKernel
    .word Roto28Kernel

    .word ScreenKernel

    .word RasterbarKernel
    .word ScreenKernel
    .word PlasmaKernel
    .word ScreenKernel
    .word PlasmaKernel

    .word ScreenKernel
    .word CurtainsKernel
    .word ScreenKernel
    .word CurtainsKernel
    .word ScreenKernelFlash
    .word ScreenKernel
    .word ScreenKernelWhiteFlash

    .word PlasmaKernel
    .word Roto28Kernel
    .word RasterbarKernel
    .word CurtainsKernel
    .word PlasmaKernel
    .word Roto28Kernel
    .word RasterbarKernel
    .word CurtainsKernel

    ;returns index to Logics/Kernels
FindMeasure
    ;HACKHACK: fade out in rotozoomer because it's easy to fade the background and stuff
    lda atten
    beq NotFadingOut
    ldx #ROTOZOOMPART*2
    rts
NotFadingOut
    lda measure
    ldx #0
FindMeasureLoop
    cmp Measures,X
    bcc FoundMeasure
    inx
    bne FindMeasureLoop
FoundMeasure
    txa
    tay     ;useful for ScreenLogic
    asl
    tax
    rts

Start
    CLEAN_START

MainLoop
KernelRet
    lda #0
    sta COLUBK

    lda #OVERS64
    sta TIM64T
    lda #2
    sta VBLANK

    lda atten
    cmp #9
    bcc NotFadedOut
    lda #0
    sta AUDV0
    sta AUDV1
    .byte $02       ;JAM
NotFadedOut

    inc frame

    ;play song
    jmp songPlayer
SongPlayerRet

WaitForOverscanEnd
    lda INTIM
    bmi WaitForOverscanEnd_Overflow
    bne WaitForOverscanEnd
WaitForOverscanEnd_Overflow

    VERTICAL_SYNC
    lda #VBLNK64
    sta TIM64T

    jsr FindMeasure
    lda Logics,X
    sta kernelptr
    lda Logics+1,X
    sta kernelptr+1
    jmp (kernelptr)
LogicRet
    ;BRK got us here - reset SP
    ldx #$FF
    txs

    jsr FindMeasure
    lda Kernels,X
    sta kernelptr
    lda Kernels+1,X
    sta kernelptr+1

WaitForVblankEnd
    lda INTIM
    bmi WaitForVblankEnd_Overflow
    bne WaitForVblankEnd
WaitForVblankEnd_Overflow
    lda #0
    sta VBLANK

    jmp (kernelptr)

    include rasterbars.asm
    include curtains.asm
    include palette.asm

    echo "ROM:", ($1FFC - *), "bytes left"

    org $1FFC
    .word Start
    .word LogicRet
