;;
;;	 |                                        |   
;;	 __|  __| _` | __ \   __| __ `__ \   _` | __| 
;;	 |   |   (   | |   |\__ \ |   |   | (   | |   
;;	\__|_|  \__,_|_|  _|____/_|  _|  _|\__,_|\__| 
;;
;; An attempt at glitch art and sound with an Atari VCS
;;
;; Written by:
;;     TSCHAK
;;	
;; Build this with DASM, -f3 option.
;;

	processor 6502
	include "vcs.h"

	SEG CODE
	ORG $F000

	;; Equates
	
CLK	EQU	$80   		; Used as simple clock with intim.
SEED	EQU	$83

	;; Clear all memory
	
Init	SEI
	CLD
	LDA #$00
	LDX #$FF
	TXS
Clr	STA #$00,X
	DEX
	BNE Clr

	;; Let's pollinate RAM a bit with some randomness.
	
	LDA INPT0		; Grab a seed from RIOT
	STA SEED
	LDY #$84
DoRnd	LDA SEED
	BEQ doEor
	CLC
	ASL
	BEQ noEor 		; skip EOR if > $80
	BCC noEor
doEor	EOR #$1d
	ADC #$01		; Prevent zeroes.
noEor	STA SEED
	STA $00,Y
	INY
	BNE DoRnd
	
	LDX #$84
	
Reset	LDA #$40
	STA T1024T
Top	LDA CLK+0
	ORA CLK+1
	AND #$1F		; Keep within TIA regs
	TAY
	LDA CLK+0
	ORA CLK+1
	STA $02,Y		; on top of the video TIA regs
	AND $0F
	STA $00,Y
	EOR INTIM
	AND #$0F		; keep sort of within sound regs
	TAY
	LDA CLK+1
	EOR CLK+0
	STA $14,Y		; on top of the sound regs
	
ChkTim	LDA INTIM
	BNE Top
	INC CLK+0
	BNE TimDon
	INC CLK+1
	BNE TimDon
	INC CLK+2
TimDon	STA VSYNC
	INX
	BVC Reset
	
	ORG $FFFC
	.word Init
	.word Init
