#include <ext.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mm2_sndh.h>

#define CONV "MM2_SNDH"

/* functions used for adding data to the SNDH header - we need these as we dont want to stop at 0x00s */
void append_char(char * lpInput, char cAppend, int * intLength);
void append_str(char * lpInput, char * strAppend, int * intLength);
void print_str(char * lpInput, int *intLength);

int main(int argc, char * argv[])
{
	char strInput[50];				/* string for user input */
	char strDestFile[12];			/* string holding destination file name */
	char *strExtension;				/* pointer to file extension */

	char lpHeader[256-OFFSET2D];	/* SNDH header, with self-imposed limit */
	char *lpInputData;				/* Pointer to input data */
	char *lpReplayRout;				/* Pointer to replay routine */

	char cDigiSynth;				/* digi/synth module flag */

	int iHeader_Length = 0;			/* counts length of SNDH header */
	int iRoutOffset1;				/* replay routine offset 1 */
	int iRoutOffset2;				/* replay routine offset 2 */

	long lCount;					/* general counter */
	long lFileSize;					/* size of input file */
	long lRoutSize;					/* size of replay routine */

	FILE * lpFile;					/* general pointer to file */


	/* -- nice title, 40 chars wide for low-res viewing */
	puts("****************************************");
	puts("*   MusicMon2 to SNDH Converter v1.0   *");
	puts("*             by gwEm 2004             *");
	puts("****************************************");
	putch('\n');


	/* -- User error ;-> */
	if ((argc > 2) || (argc < 2))
	{
		puts( "syntax : MM2_SNDH <mm2_module>\n" );
		puts("Press any key to exit");
		getch();
		return(EXIT_FAILURE);
	}


	/* -- Open input file */
	lpFile = fopen( argv[1], "rb" );
	if( !lpFile )
	{
		printf( "ERROR : File not found \"%s\"\n", argv[1] );
		puts("Press any key to exit");
		getch();
		return(EXIT_FAILURE);
	}

	fseek( lpFile, 0, SEEK_END );
	lFileSize = ftell( lpFile );
	fclose( lpFile );

	lpInputData = malloc( lFileSize );
	if( !lpInputData )
	{
		printf( "ERROR : Malloc failed\n");
		puts("Press any key to exit");
		getch();
		return(EXIT_FAILURE);
	}

	lpFile = fopen( argv[1], "rb" );
	fread( lpInputData, lFileSize, 1, lpFile );
	fclose( lpFile );
	printf("input : %s ", argv[1]);


	/* -- Test if synth or digi module */
	if	(  (lpInputData[lFileSize-4] == 0xFFFF) 
		&& (lpInputData[lFileSize-3] == 0xFFFF) 
		&& (lpInputData[lFileSize-2] == 0xFFFF) 
		&& (lpInputData[lFileSize-1] == 0xFFFF) ) cDigiSynth = 's';
	else cDigiSynth = 'd';

	if(cDigiSynth == 'd') 
	{
		puts("\(detected digi\)");
		lpReplayRout = DigiRout;
		iRoutOffset1 = OFFSET1D;
		iRoutOffset2 = OFFSET2D;
		lRoutSize    = DIGISIZE;
	}
	else
	{
		puts("\(detected synth\)");
		lpReplayRout = SynthRout;
		iRoutOffset1 = OFFSET1S;
		iRoutOffset2 = OFFSET2S;
		lRoutSize    = SYNTHSIZE;
	}


	/* -- Work out what destination file name should be*/
	strcpy(strDestFile, argv[1]);
	strExtension = strchr(strDestFile,'.');
	if (strExtension) strcpy(strExtension, ".snd");	/* if file extension replace it */
	else strcat(strDestFile, ".snd");				/* otherwise add an extension */


	/* -- Open destination file */
	lpFile = fopen( strDestFile, "wb" );
	if( !lpFile )
	{
		printf( "ERROR : Couldn't create \"%s\"\n", strDestFile );
		puts("Press any key to exit");
		getch();
		free(lpInputData);
		return(EXIT_FAILURE);
	}
	printf("output : %s\n", strDestFile);


	/* -- form start of header - fill routine pointers with 0x00 for now */
	for (lCount = 0 ; lCount < 3 ; lCount ++)
	{
		append_char(lpHeader, '\x60', &iHeader_Length);
		append_char(lpHeader, '\x00', &iHeader_Length);
		append_char(lpHeader, '\x00', &iHeader_Length);
		append_char(lpHeader, '\x00', &iHeader_Length);
	}
	append_str(lpHeader, "SNDH", &iHeader_Length);


	/* -- Fill rest of header */
	/* composer */
	printf("\ncomposer : ");
	gets(strInput);
	append_str(lpHeader, "COMM", &iHeader_Length);
	append_str(lpHeader, strInput, &iHeader_Length);
	append_char(lpHeader, '\x00', &iHeader_Length);

	/* track title */
	printf("title : ");
	gets(strInput);
	append_str(lpHeader, "TITL", &iHeader_Length);
	append_str(lpHeader, strInput, &iHeader_Length);
	append_char(lpHeader, '\x00', &iHeader_Length);

	/* ripper credits */
	printf("ripper : ");
	gets(strInput);
	append_str(lpHeader, "RIPP", &iHeader_Length);
	append_str(lpHeader, strInput, &iHeader_Length);
	append_char(lpHeader, '\x00', &iHeader_Length);

	/* add conversion credits to this software ;-> */
	append_str(lpHeader, "CONV", &iHeader_Length);
	append_str(lpHeader, CONV, &iHeader_Length);
	append_char(lpHeader, '\x00', &iHeader_Length);

	/* make header an even length or it all fucks up ;-> */
	if ((iHeader_Length) % 2)
	{
		append_char(lpHeader, '\x00', &iHeader_Length);
	}

	/* add number of tracks and interrupt infos */
	append_str(lpHeader, "##01TC200", &iHeader_Length);
	append_char(lpHeader, '\x00', &iHeader_Length);

	/* adjust address of replay rout starting points */
	/* only LSB adjusted - ok as we limit header size to 256 max */
	lpHeader[3] = iHeader_Length - 2;
	lpHeader[7] = iHeader_Length - 2 + iRoutOffset1;
	lpHeader[11]= iHeader_Length - 2 + iRoutOffset2;

	/* -- Write SNDH file */
	printf("\nwriting SNDH file... ");
	
	/* header */
	for(lCount=0 ; lCount < iHeader_Length ; lCount++)
	{
		fputc (lpHeader[lCount], lpFile);
	}

	/* replay rout */
	fwrite (lpReplayRout, 1, lRoutSize, lpFile);
	fwrite (lpInputData, 1, lFileSize, lpFile);

	/* footer */
	for(lCount=0 ; lCount < 4 ; lCount++)
	{
		fputc ('\x00', lpFile);
	}


	/* -- Wrap things up */
	fclose(lpFile);
	free(lpInputData);
	puts("Finished!");
	puts("\nDon't forget - ICE the SNDH if you want.");
	puts("Press any key to exit");
	getch();
	return(EXIT_SUCCESS);
}


void append_char(char * lpInput, char cAppend, int * intLength)
{
	lpInput[*intLength] = cAppend;
	*intLength += 1;

	/* print_str (lpInput, intLength); */
}


void append_str(char * lpInput, char * strAppend, int * intLength)
{
	long lCount = 0;

	while(strAppend[lCount])
	{
		lpInput[*intLength] = strAppend[lCount];
		lCount++;
		*intLength += 1;
	}

	/* print_str (lpInput, intLength); */
}


void print_str(char * lpInput, int *intLength)
{
	long lCount = 0;

	for (lCount=0 ; lCount<*intLength ; lCount++)
	{
		putch(lpInput[lCount]);
	}
	putch('\n');
	putch('\r');
}