/*      512-color demo driver      */
/*          by Tom Hudson          */
/* Copyright 1985 ANALOG Computing */
/*      For low-rez use only!      */

#include "portab.h"

extern go();
extern stop();
extern int ctable[512];

int contrl[12],intin[128],ptsin[128],
    intout[128],ptsout[128];

int handle,chstat;

main()
{

int i,j,dum,l_intin[11],l_out[57],
    r,g,b,rx,gx,bx,cx,x,y,wchar,
    gr_1,gr_2,gr_3,gr_4,l_ptsin[20],
    oldpal[16],box[4],rgb[3],
    mousex,mousey;

long regval;

char lastr = -1,lastg = -1,lastb = -1;

static int cofset[8] =
{
2,3,6,4,7,5,8,9
};

static char redval[2] = {0,0};
static char grnval[2] = {0,0};
static char bluval[2] = {0,0};

/* Start the program! */

appl_init();

handle=graf_handle(&gr_1,&gr_2,&gr_3,&gr_4);

/* open workstation */

l_intin[0] = 1;
for (i = 1; i < 10; i++)
  l_intin[i] = 1;
l_intin[10] = 2;
v_opnvwk(l_intin, &handle, l_out);
v_hide_c(handle);
v_clrwk(handle);

/* Save system color palette */

for (i=0; i<16; i++)
 oldpal[i] = setcolor(i,-1);

/* Initialize 512-color table */

cx=0;
for(rx=0; rx<8; rx++)
 {
 for(gx=0; gx<8; gx++)
  {
  for(bx=0; bx<8; bx++,cx++)
   {
   regval=0x0000f888 + (rx * 256) + (gx * 16) + bx;
   ctable[cx]=regval & 0xffff;
   }
  }
 }

/* Draw 512 boxes for colors */

vsf_interior(handle,1);
for(x=0,cx=0; x<319; x=x+40,cx++)
 {
 vsf_color(handle,cofset[cx]);
 for(y=1; y<192; y=y+3)
  {
  box[0]=x;
  box[1]=y;
  box[2]=x+38;
  box[3]=y+1;
  v_bar(handle,box);
  }
 }

/* Set other fixed colors */

rgb[0]=1000; rgb[1]=1000; rgb[2]=1000;
vs_color(handle,1,rgb);
rgb[0]=1000; rgb[1]=0; rgb[2]=0;
vs_color(handle,11,rgb);
rgb[0]=0; rgb[1]=1000; rgb[2]=0;
vs_color(handle,14,rgb);
rgb[0]=0; rgb[1]=0; rgb[2]=1000;
vs_color(handle,12,rgb);

/* Print title message */

vst_color(handle,10);
v_gtext(handle,40,199,"ATARI 520ST COLOR PALETTE");
graf_mouse(0,&dum);
v_show_c(handle,0);

/* Start VBLANK & HBLANK code */

go();

/* Main program loop */

wchar=0;
while(wchar != 32)
 {
 chstat=bconstat(2);
 if(chstat != 0)
  wchar=bconin(2);

/* Get mouse X and Y locations */

 vq_mouse(handle,&dum,&mousex,&mousey);

/* Convert to R, G & B values */

 if(mousey < 192)
  {
  redval[0]=mousey / 24 + 48;
  grnval[0]=((mousey/3) & 0x0007) + 48;
  bluval[0]=mousex / 40 + 48;
  if((lastr != redval[0]) || (lastg != grnval[0]) || (lastb != bluval[0]))
   {
   v_hide_c(handle);
   vst_color(handle,11);
   v_gtext(handle,256,199,redval);
   vst_color(handle,14);
   v_gtext(handle,264,199,grnval);
   vst_color(handle,12);
   v_gtext(handle,272,199,bluval);
   v_show_c(handle,0);
   lastr=redval[0];
   lastg=grnval[0];
   lastb=bluval[0];
   }
  }
 }

/* Stop VBLANK & HBLANK */

stop();

/* Restore original color palette */

setpallete(oldpal);

/* Close the workstation. */

v_clsvwk(handle);
 
appl_exit();
_exit(0);

}

/* That's all, folks! */
