/*  Fractal Mandelbrot set generator  */
/*           by Tom Hudson            */
/*  Copyright 1985 ANALOG Computing   */

#include "portab.h"

extern double sqrt();
extern long bconin();
extern long physbase();
extern long f_create();
extern long f_open();
extern long f_close();
extern long f_write();

int contrl[12],intin[128],ptsin[128],
    intout[128],ptsout[128],handle,
    whand,chstat,wchar,alldone,pcolor,
    asca,oldpal[16],plot[2];

int lowhead = 0;

/* Define fractal map colors */

int palette[16] =
{
0x0707,0x0507,0x0307,0x0007,
0x0037,0x0057,0x0075,0x0072,
0x0070,0x0370,0x0570,0x0770,
0x0750,0x0730,0x0700,0x0000
};

static int cofset[16] =
{
0,2,3,6,4,7,5,8,9,10,11,14,12,15,13,1
};

double sqin,sqout;

long fhand,lchar,s1phys;

char decimal[20];

/* Main processing routine */

main()
{
float getflt();

int i,l_intin[11],l_out[57],
    gr_1,gr_2,gr_3,gr_4,l_ptsin[20],
    count,climit,xp,yp,cdivfac;

float x,y,xs,xe,xstep,ys,ye,ystep,at,bt,az,bz,
      ac,bc,size,tsiz,rrange,irange;

/* Start the program! */

appl_init();

handle=graf_handle(&gr_1,&gr_2,&gr_3,&gr_4);

/* open workstation */

for (i = 0; i < 10; i++)
  l_intin[i] = 1;
l_intin[10] = 2;
v_opnvwk(l_intin, &handle, l_out);
v_hide_c(handle);
for (i=0; i<16; i++)
 oldpal[i] = setcolor(i,-1);
s1phys=physbase();
vsm_type(handle,1);

/* main program loop */

alldone=0;
while(alldone == 0)
 {
 v_clrwk(handle);
 setpallete(oldpal);

/* Input map parameters */

 crlf();
 prompt("Real number center");
 xs=getflt();
 prompt("Real number range");
 rrange=getflt();
 xs=xs-rrange/2;
 xe=xs+rrange;
 xstep=(xe-xs)/319;
 crlf();
 prompt("Imaginary number center");
 ys=getflt();
 prompt("Autoscale Imaginary axis (Y/N)?");
 asca=yesno();
 if(asca == 0)
  {
  prompt("Imaginary number range");
  irange=getflt();
  ys=ys-irange/2;
  ye=ys+irange;
  }
 else
  {
  ys=ys-(rrange*.77)/2;
  ye=ys+rrange*.77;
  }
 ystep=(ye-ys)/199;
 crlf();
 prompt("Iteration limit");
 climit=getflt();
 cdivfac=climit/16;

 v_clrwk(handle);
 setpallete(palette);

/* Process the pixel map! */

 xp=0;
 for(x=xs; xp<320; x=x+xstep,xp++)
  {
  yp=199;
  for(y=ys; yp > -1; y=y+ystep,yp--)
   {
   az=0; bz=0; ac=x; bc=y;
   count=0; size=0;
   while((count < climit) && (size < 2))
    {
    at=az*az-bz*bz; bt=az*bz*2; az=at+ac; bz=bt+bc;
    tsiz=az*az+bz*bz;
    sqin=tsiz;
    sqout=sqrt(sqin);
    size=sqout;
    count++;
    }
   pcolor=count/cdivfac;
   if(pcolor > 15)
    pcolor=15;
   vsm_color(handle,cofset[pcolor]);
   plot[0]=xp; plot[1]=yp; v_pmarker(handle,1,plot);
   chstat=bconstat(2);
   if(chstat != 0)
    {
    xp = 320; yp = -1;
    }
   }
  }

/* Map done, wait for key */

 chstat=0;
 while(chstat == 0)
  chstat=bconstat(2);
 lchar = bconin(2);
 wchar = lchar & 0x00FF;

/* Check for RETURN */

 if(wchar == 0x000d)
  {
  alldone=1;
  }
 else

/* Check for function key F1 */

 if(lchar == 0x003b0000)
  {
  fhand=f_create(&"fractal.pi1",0);
  if (fhand >= 0)
   {
   whand=fhand;

/* Write resolution flag (1 word) */

   f_write(whand,2L,&lowhead);

/* Write color palette (16 words) */

   f_write(whand,32L,&palette);

/* Write picture data (32000 bytes) */

   f_write(whand,32000L,s1phys);
   f_close(whand);
   alldone=1;
   }
  }
 }

/* Close the workstation. */

v_clsvwk(handle);
setpallete(oldpal);
 
appl_exit();
_exit(0);

}

/* Print string w/ CR & LF */

print(string)
char *string;
{
c_conws(string);
crlf();
}

/* Print string (no CR/LF) */

prompt(string)
char *string;
{
c_conws(string);
}

/* Output CR/LF to screen */

crlf()
{
c_conout(13);
c_conout(10);
}

/* Accept Y/N response */

yesno()
{
int exit,yorn;

exit = -1;
while (exit < 0)
 {
 yorn = bconin(2);
 if ((yorn == 0x004e) || (yorn == 0x006e))
  {
  print("No");
  exit = 0;
  }
 else
 if ((yorn == 0x0059) || (yorn == 0x0079))
  {
  print("Yes");
  exit=1;
  }
 }
return(exit);
}

/* Accept floating-point number */

float getflt()
{
int i,getfx,inct,negct,decct,decfnd;
float work,mfac,innum;
static int fltwk[20];

c_conout('?');
negct=0;
decct=0;
inct=0;
getfx=0;
while(getfx == 0)
 {
 chstat=0;
 while(chstat == 0)
  chstat=bconstat(2);
 lchar = bconin(2);
 wchar = lchar & 0x00FF;
 if((wchar == 0x0008) && (inct > 0))
  {
  c_conout(8);
  c_conout(32);
  c_conout(8);
  inct--;
  if(fltwk[inct] == 98)
   {
   decct=0;
   }
  else
  if(fltwk[inct] == 99)
   {
   negct=0;
   }
  }
 else
 if(wchar == 0x000d)
  {
  if((inct-decct-negct) > 0)
   {
   crlf();
   fltwk[inct] = -1;
   getfx=1;
   }
  }
 if(inct < 19)
  {
  if((wchar > 0x002f) && (wchar < 0x003a))
   {
   fltwk[inct]=wchar-48;
   inct++;
   c_conout(wchar);
   }
  else
  if((wchar == 0x002d) && (negct == 0) && (inct == 0))
   {
   negct++;
   fltwk[inct]=99;
   inct++;
   c_conout(wchar);
   }
  else
  if((wchar == 0x002e) && (decct == 0))
   {
   decct++;
   fltwk[inct]=98;
   inct++;
   c_conout(wchar);
   }
  }
 }
decfnd=0;
innum=0;
mfac = 10;
for(i=0; i<inct; i++)
 {
 if(fltwk[i] == 98)
  {
  decfnd = 1;
  }
 else
 if(fltwk[i] < 10)
  {
  if(decfnd == 0)
   {
   innum=innum*10;
   innum=innum+fltwk[i];
   }
  else
   {
   work=fltwk[i];
   work=work/mfac;
   innum=innum+work;
   mfac=mfac * 10;
   }
  }
 }
if(negct == 1)
 innum = -innum;
return(innum);
}
