; STOS patcher (yeah, right ;) by GGN/KA software productions
; Written in Turbo Assembler & Bugaboo (the only sensible choice!)
; 31/8/04 10:00 (approx)   Started
;         14:30 (approx)   continued
;         15:46            seems to be working
; 02/9/04 13:30            v2 started
;         15:25            working

;
; Init stuff - needed for ptermres
; Lifted from Evil/DHS's demo engine, as I'm too lazy to figure out by
; myself (init stuff always bores me to death :)
;

                OPT X+

start:          movea.l 4(SP),A5        ;address to basepage
                move.l  $0C(A5),D0      ;length of text segment
                add.l   $14(A5),D0      ;length of data segment
                add.l   $1C(A5),D0      ;length of bss segment
                add.l   #$0100,D0       ;length of basepage
                move.l  D0,start        ;store lng(newbies,don't look at this ;)
                move.l  A5,D1           ;address to basepage
                add.l   D0,D1           ;end of program

                move.l  D0,-(SP)        ;mshrink()
                move.l  A5,-(SP)        ;
                clr.w   -(SP)           ;
                move.w  #$4A,-(SP)      ;
                trap    #1              ;
                lea     12(SP),SP       ;

                pea     msgstart(PC)    ;print our crappy startup msg
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

                pea     getosversion(PC) ;use superexec, because I'm
                move.w  #$26,-(SP)      ;bored switching supervisor on/off
                trap    #14
                addq.l  #6,SP

;
; Search to see if user's TOS is supported
;

                move.w  tosvers(PC),D0
                lea     vectors(PC),A0
                moveq   #(vectorsend-vectors)/30-1,D1 ;no of TOSes supported
search:         cmp.w   (A0),D0         ;found?
                beq.s   found
                lea     30(A0),A0       ;next vector
                dbra    D1,search

                pea     msgnotfound(PC) ;warn the user that we didn't find
                move.w  #9,-(SP)        ;his/hers TOS
                trap    #1
                move.w  #1,-(SP)
                trap    #1
                addq.l  #8,SP

                clr.w   -(SP)
                trap    #1              ;bye!

found:          move.l  A0,patch        ;store address
                addq.l  #2,patch

                pea     initvect(PC)    ;redirect trap 14
                move.w  #$26,-(SP)
                trap    #14
                addq.l  #6,SP

                pea     msginstalled(PC) ;inform that we're installed
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

                move.w  #0,-(SP)        ;Terminate and stay resident
                move.l  start(PC),-(SP) ;How many bytes resident
                move.w  #$31,-(SP)
                trap    #1

;
; Our trap #14 handler
;

trap14:         movem.l D0-A6,start     ;save registers in unused area
                movea.l SP,A1
                movea.l 2(SP),A0        ;PC before the trap was called
                addq.l  #6,A1
                move.w  (SP),D0
                btst    #$0D,D0         ;supervisor or user mode???
                bne.s   cont
                move    USP,A1
cont:           cmpi.w  #3,(A1)         ;XBIOS(3) called?
                bne.s   jump            ;No, continue trap call


search2:        cmpi.w  #$41FA,34(A0)   ;1st place to check
                bne.s   search21        ;(later versions of STOS)
                cmpi.b  #$72,44(A0)     ;2nd check (just to be sure)
                bne.s   search21
                lea     42(A0),A0       ;ok, we're sure! Point to offset
                adda.w  (A0),A0         ;a0 has the vector table now
                bra.s   search2found    ;go patch

search21:       cmpi.w  #$41FA,24(A0)   ;2nd string
                bne.s   jump            ;(older versions of STOS)
                cmpi.w  #$3039,28(A0)   ;2nd check
                bne.s   jump
                move.l  tosstart(PC),30(A0) ;slap on the start of our TOS
                lea     26(A0),A0       ;point to offset
                adda.w  (A0),A0         ;a0 has the vector table

search2found:   move.w  tosvers(PC),(A0)+ ;put our TOS version
                movea.l patch(PC),A1    ;time to apply the vectors
                moveq   #6,D1
dopatch:        move.l  (A1)+,(A0)+     ;patch!
                dbra    D1,dopatch
;continue with trap

jump:           movem.l start(PC),D0-A6
jmptrap:        jmp     'GGN!'



;
; Get TOS version
;

getosversion:   movea.l $04F2.w,A0      ;not the most elegant solution to
                move.w  2(A0),tosvers   ;get tos version, but it'll have to do
                addq.l  #2,tosstart
                move.l  A0,tosstart
                rts

;
; Redirect trap #14
;

initvect:       move.l  $B8.w,jmptrap+2 ;save old trap #14 vector
                move.l  #trap14,$B8.w   ;install our own vector
                rts

tosstart:       DS.L 1
patch:          DS.L 1
tosvers:        DS.W 1
                EVEN
;                     1234567890123456789012345678901234567890
msgstart:       DC.B 'EGGN''s STOS fixer v2',13,10
                DC.B '-_--_--_--_--',13,10,0
msgnotfound:    DC.B 13,10,'Your TOS version was not found among',13,10
                DC.B 'the versions supported by this program!',13,10
                DC.B 'TSR *not* installed!',13,10
                DC.B 'press any key to exit...',13,10,0
msginstalled:   DC.B 13,10,'TSR installed!',0
                EVEN

;
; This list was lifted from the game H.E.R.O., typed by hand.
; Therefore it might contain errors and might not be complete.
; You have been warned!
; UPDATE: Took a look at STOS 2.06 source code and corrected
; some values :)
;

vectors:        DC.W $0100      ;TOS 1.00
                DC.L $26E0,$0E09,$0DB0,$2686,$2748,$0DDC,$0E44 ;vectors
                DC.W $0101
                DC.L $26E0,$0E09,$0DB0,$2686,$2748,$0DDC,$0E44
                DC.W $0102
                DC.L $2740,$0E4F,$0C76,$26E6,$27A8,$0E22,$0E8A
                DC.W $0104
                DC.L $2882,$0E6B,$0C92,$2828,$28EA,$0E3E,$0EA6
                DC.W $0106
                DC.L $28C2,$0EAB,$0CD2,$2868,$292A,$0E7E,$0EE6
                DC.W $0162
                DC.L $28C2,$0EAB,$0CD2,$2868,$292A,$0E7E,$0EE6
                DC.W $0205
                DC.L $2476,$0EAB,$0CCE,$241C,$24DE,$0E7E,$0EE6
                DC.W $0206
                DC.L $26AA,$10B7,$0ED8,$2650,$2712,$1088,$10F2
                DC.W $0306
                DC.L $37C0,$10A7,$0ECA,$3766,$3828,$107A,$10E2
                DC.W $0401
                DC.L $3C2C,$1175,$0F96,$3BD2,$3C94,$1146,$11BC
                DC.W $0402
                DC.L $3C2C,$1175,$0F96,$3BD2,$3C94,$1146,$11BC
                DC.W $0404
                DC.L $3C2C,$1175,$0F96,$3BD2,$3C94,$1146,$11BC
                DC.W $0492
                DC.L $40E0,$1175,$0F96,$4086,$4148,$1146,$11BC
vectorsend:

                END
