	;
	; example source on howto use a a precalculated fade from assembler
	; 
	; this example program is very simple and uses TOS calls
	; only

	; run in ST-LOW
	
	Section text

		
fade:
	
	pea fades			; the first all black palette
	move.w #6,-(sp)
	trap #14			; Setpalette()
	addq.l #6,sp

	move.w #3,-(sp)
	trap #14			; Logbase()
	addq.l #2,sp
	move.l d0,a1			; screen begin

	lea picture+34,a0		; picture data

	move.l #7999,d0			; copy 8000 longs
showpic: 
	move.l (a0)+,(a1)+
	dbra d0,showpic
	
	; now we have the pic onscreen
	; fade it in
	
	move.w #15,d7			; loop 16 times
	lea fades,a6			; begin of palettes in a6 (a0 is overwritten by TOS)

fadeloop:
	; wait for VBL
	bsr vsync
	bsr vsync

	pea (a6)			; set current palette
	move.w #6,-(sp)
	trap #14			; Setpalette()
	addq.l #6,sp
	
	lea 32(a6),a6			; next palette	
	dbra d7,fadeloop		; ...and loop
	
	; wait for 100 VBLS (roughly 2 secs)
	move.w #99,d4			; xbios vsync() overwrites d0!
waitloop:
	bsr vsync		
	dbra d4,waitloop
	
	; and exit...
	clr.w -(sp)			; Pterm0()
	trap #1
		
	
	; wait for VBL
vsync:
	move.w #37,-(sp)		; Vsync()
	trap #14
	addq.l #2,sp
	rts
	
	Section Data
	
picture:
	incbin "example.pi1"		; the picture
	even
	
fades:	incbin "example.bin"		; the fade data (16 palettes a 32 bytes)
	even
	
	end
