	*** SUPERVISOR MODE AND INIT ***
	
	move.w	#0,-(sp)		supervisor mode
	move.w	#$20,-(sp)		gemdos $20			
	trap	#1			call dos				
	lea	4(sp),sp		correct stack				
	move.l	d0,old_usp		save old usp
	
	moveq	#0,d0			clear registers
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
	
	*** MONO DETECT ***
	
	cmp.b	#2,$44c			check if mono
	bne	picture			if no then branch
	
	*** PRINT ERRORMESSAGE AND WAIT FOR KEY ***
	
	move.l	#message,-(sp)		print errormessage
	move.w	#9,-(sp)		gemdos 9
	trap	#1			call dos				
	lea	6(sp),sp		correct stack
key	cmp.b	#$39,$fffffc02.w	check if space is space pressed
	bne	key			if not then loop
	jmp	exit			exit

	
	*** DISPLAY PICTURE ***
	
picture	dc.w	$a00a			hide mouse

	move.w	$44c,old_res		save old resolution
	
	move.w	#0,-(sp)		0=low 1=medium 2=high
	move.l	#-1,-(sp)		physbase
	move.l	#-1,-(sp)		logbase
	move.w	#5,-(sp)		xbios 5
	trap	#14		        call dos
	add.l	#12,sp			correct stack
	
	move.w	#2,-(sp)		get screen address
	trap	#14			call dos
	addq.l	#2,sp			correct stack
	move.l	d0,screen		save screenpointer
	
	lea	$ff8240,a0		a0=system palette
	lea	old_pall,a1		a1=old_pall
	movem.l (a0)+,d0-d3/a2-a5 	copying to the registers
	movem.l d0-d3/a2-a5,(a1) 	copying to old_pall
				
	lea	pic+2,a0		a0=picture+2 bytes
	lea	$ff8240,a1		a1=huh?
	movem.l	(a0)+,d0-d7		copying new palette
	movem.l	d0-d7,(a1)	        copying to system palette

	lea 	pic+34,a0		a0=pic+34 bytes
	move.l	screen,a1		a1=screen
	move.w	#160,d0			set d0=160 (bytes/row)
	muls	#200,d0		 	mutiplicate with 200 (rowas)
	divs	#4,d0			divide with 4
	subq.l	#1,d0			subtract d0 with 1

loop	move.l	(a0)+,(a1)+		copy from pic to screen
	dbra	d0,loop			sub d0 with 1 and branch
	jmp 	main(pc)	        if d0 is bigger than 0
	
	*** SCROLLTEXT ROUTINE ***

scrollbig
	move.l	#false,d4		
	move.l	#24,d3
scrollall
	move.l	d4,a0		
	move.l	d4,a1
	add.l	#160,d4		
	addq.l	#1,a1
	REPT	19
	move.b	(a1),(a0)		
	addq.l	#8,a0
	move.b	(a0),(a1)
	addq.l	#8,a1
	ENDR
	move.b	(a1),(a0)
	addq.l	#8,a0
	move.b	(a0),(a1)
	move.b	#0,(a1)		
	dbf	d3,scrollall	
	rts			
	
plotbig
	cmp.b	#$00,flagbig
	beq	nytt_tecken
	moveq.l	#0,d1
klar	move.b	bigcount,d1
	lsl.b	#2,d1		
	move.l	#fontadd,a0
	add.l	d1,a0
	move.l	(a0),a1		
	bsr	plotout
	cmp.b	#4,bigcount
	bne	nofinich
	sf	flagbig
nofinich
	add.b	#1,bigcount
	rts

nytt_tecken
	move.l	#0,d0
	move.l	#0,d1
	move.l	#0,d2
	move.l	mesvarbig,a0		the position in the text
	move.b	(a0),d0			d0=character
	cmp.b	#$ff,d0
	bne	notend
	move.l	#text,mesvarbig
	bra.s	nytt_tecken
notend	move.b	d0,d1
	add.l	#1,mesvarbig		next character, plis
	cmp.b	#8,d0		
	bhi	plus
	beq	plus
	bra.s	notplus
plus	add.l	#4000,d2
	sub.b	#8,d1
notplus
	cmp.b	#16,d0		
	bhi	plus1
	beq	plus1
	bra.s	notplus1
plus1	add.l	#4000,d2
	sub.b	#8,d1
notplus1
	cmp.b	#24,d0		
	bhi	plus2
	beq	plus2
	bra.s	notplus2
plus2	add.l	#4000,d2
	sub.b	#8,d1	
notplus2
	cmp.b	#32,d0		
	bhi	plus3
	beq	plus3
	bra.s	notplus3
plus3	add.l	#4000,d2
	sub.b	#8,d1
notplus3
	cmp.b	#40,d0		
	bhi	plus4
	beq	plus4
	bra.s	notplus4
plus4	add.l	#4000,d2
	sub.b	#8,d1
notplus4
	cmp.b	#48,d0		
	bhi	plus5
	beq	plus5
	bra.s	notplus5
plus5	add.l	#4000,d2
	sub.b	#8,d1
notplus5
	cmp.b	#56,d0		
	bhi	plus6
	beq	plus6
	bra.s	notplus6
plus6	add.l	#4000,d2
	sub.b	#8,d1
notplus6
	add.l	#font+34,d2		the address to the font
	btst	#0,d1
	bne	ojamt
	mulu	#20,d1			hur langt in pa font rad
	add.l	d1,d2			adress till font
	move.l	#fontadd,a0
	move.l	d2,(a0)+
	add.l	#1,d2
	move.l	d2,(a0)+
	add.l	#7,d2
	move.l	d2,(a0)+
	add.l	#1,d2
	move.l	d2,(a0)+
	add.l	#7,d2
	move.l	d2,(a0)+
	st	flagbig
	sf	bigcount
	bra	klar
ojamt
	mulu	#20,d1			hur langt in pa font rad
	add.l	d1,d2			address till font
	move.l	#fontadd,a0
	sub.l	#3,d2
	move.l	d2,(a0)+
	add.l	#7,d2
	move.l	d2,(a0)+
	add.l	#1,d2
	move.l	d2,(a0)+
	add.l	#7,d2
	move.l	d2,(a0)+
	add.l	#1,d2
	move.l	d2,(a0)+
	st	flagbig
	sf	bigcount
	bra	klar

plotout
	move.l	#false,a0
	add.l	#153,a0
	move.b	(a1),(a0)
	move.b	160(a1),160(a0)
	move.b	320(a1),320(a0)
	move.b	480(a1),480(a0)
	move.b	640(a1),640(a0)
	move.b	800(a1),800(a0)
	move.b	960(a1),960(a0)
	move.b	1120(a1),1120(a0)
	move.b	1280(a1),1280(a0)
	move.b	1440(a1),1440(a0)
	move.b	1600(a1),1600(a0)
	move.b	1760(a1),1760(a0)
	move.b	1920(a1),1920(a0)
	move.b	2080(a1),2080(a0)
	move.b	2240(a1),2240(a0)
	move.b	2400(a1),2400(a0)
	move.b	2560(a1),2560(a0)
	move.b	2720(a1),2720(a0)
	move.b	2880(a1),2880(a0)
	move.b	3040(a1),3040(a0)
	move.b	3200(a1),3200(a0)
	move.b	3360(a1),3360(a0)
	move.b	3520(a1),3520(a0)
	move.b	3680(a1),3680(a0)
	move.b	3840(a1),3840(a0)
	rts

scroll				
	lea	false,a1
	move.l	screen,a0
	add.l	wherescroll,a0
	move.l	#24,d3
.copy
	move.w	0(a1),0(a0)
	move.w	8(a1),8(a0)
	move.w	16(a1),16(a0)
	move.w	24(a1),24(a0)
	move.w	32(a1),32(a0)
	move.w	40(a1),40(a0)
	move.w	48(a1),48(a0)
	move.w	56(a1),56(a0)
	move.w	64(a1),64(a0)
	move.w	72(a1),72(a0)
	move.w	80(a1),80(a0)
	move.w	88(a1),88(a0)
	move.w	96(a1),96(a0)
	move.w	104(a1),104(a0)
	move.w	112(a1),112(a0)
	move.w	120(a1),120(a0)
	move.w	128(a1),128(a0)
	move.w	136(a1),136(a0)
	move.w	144(a1),144(a0)
	move.w	152(a1),152(a0)
	add.l	#160,a0
	add.l	#160,a1
	dbf	d3,.copy		
	rts
	
	*** REPLAY INTERRUPTS ***

save_ints:				*save interrupts
	move.b	$fffffa07.w,mfpa07
	move.b	$fffffa09.w,mfpa09
	move.b	$fffffa13.w,mfpa13
	move.b	$fffffa15.w,mfpa15
	move.b	$fffffa19.w,mfpa19
	move.b	$fffffa1f.w,mfpa1f
	move.l	$134.w,old134
	move.l	$70.w,oldvbl
	rts
init_ints:				*init. interrupts
	clr.b	$fffffa09.w
	clr.b	$fffffa15.w
	move.w	module+$90,d0
	lea	mfp_freqs(pc),a0
	move.b	(a0,d0.w),$fffffa1f.w
	move.b	#2,$fffffa19.w
	move.b	#32,$fffffa07.w
	move.b	#32,$fffffa13.w
	bclr	#3,$fffffa17.w
	move.l	#replay_rot+$88ca,$134.w
	move.l	#vbi,$70.w
	rts
mfp_freqs:				*10 and 8.3 khz
	dc.b	24
	dc.b	29
ret_ints:				*restore interrupts
	move.b	mfpa07,$fffffa07.w
	move.b	mfpa09,$fffffa09.w
	move.b	mfpa13,$fffffa13.w
	move.b	mfpa15,$fffffa15.w
	move.b	mfpa19,$fffffa19.w
	move.b	mfpa1f,$fffffa1f.w
	move.l	old134,$134.w
	move.l	oldvbl,$70.w
	rts	
mfpa07:	dc.b	0			*the vars for saving interrupts
mfpa09:	dc.b	0
mfpa13:	dc.b	0
mfpa15:	dc.b	0
mfpa19:	dc.b	0
mfpa1f:	dc.b	0
old134:	dc.l	0
oldvbl:	dc.l	0

init_ste:
	move.w	#0,$ffff8900.w		*init. STE
	lea	setsam_dat(pc),a0
	move.w	#3,d0
mwwrite:
	move.w	#$7ff,$ffff8924.w
mwwrite2:
	cmp.w	#$07ff,$ffff8924.w
	bne.s	mwwrite2
	move.w	(a0)+,$ffff8922.w
	dbra	d0,mwwrite

	move.l	#$486,temp			
	move.b	temp+1(pc),$ffff8903.w
	move.b	temp+2(pc),$ffff8905.w
	move.b	temp+3(pc),$ffff8907.w

	move.l	#$488,temp
	move.b	temp+1(pc),$ffff890f.w
	move.b	temp+2(pc),$ffff8911.w
	move.b	temp+3(pc),$ffff8913.w

	move.w	#%0000000000000001,$ffff8920.w
	move.w	#3,$ffff8900.w
	rts

	*** THE MAIN PROGRAM ***
	
	* you can use all registers here
		
main	jsr	init_ste(pc)		init. ste
	lea	module,a0		a0=module start
	jsr	replay_rot+$20(pc)	init. replay routine

	* don't use a2-a6/d6-d7 from here

	jsr	save_ints(pc)		save interrupts
	jsr	init_ints(pc)		init. interrupts
	clr.w	wfnc
	
	move.l	#text,mesvarbig

demo_loop:
	cmp.w	#1,wfnc			wait for video
	bne.s	demo_loop
	clr.w	wfnc

	jsr	scrollbig(pc)
	jsr	plotbig(pc)
	jsr	scroll(pc) 

	cmp.w	#1,updown
	beq	up
	sub.l	#160,wherescroll
	cmp.l	#24480,wherescroll
	bne	down
	move.w	#1,updown
	bra	down
up:
	add.l	#160,wherescroll
	cmp.l	#28160,wherescroll
	bne	down
	move.w	#0,updown
down:
	cmp.b	#185,$fffffc02.w	space
	bne.s	demo_loop		yes/no
	jsr	ret_ints(pc)

	*** TERMINATE PROGRAM ***

end:
	lea	old_pall,a0		a0=old_pall
	lea	$ff8240,a1		a1=system palette
	movem.l	(a0)+,d0-d7		copying...
	movem.l	d0-d7,(a1)		copying...
	
	move.w	old_res,-(sp)		restore old resolution
	move.l	#-1,-(sp)		physbase
	move.l	#-1,-(sp)		logbase
	move.w	#5,-(sp)		setscreen
	trap	#14			call dos
	add.l	#12,sp			correct stack

exit	dc.w    $a009			show mouse
	move.l	old_usp,-(sp)		user mode
	move.w	#$20,-(sp)		gemdos $39
	trap	#1			call dos
	addq.l	#6,sp			correct stack
	clr.w	(sp)			exit
	trap	#1			call dos
vbi:
	movem.l	d0-d5/a0-a1,-(sp)	save regs.
	jsr	replay_rot+$24		jump to music rout
	move.w	#1,wfnc			set the wait flag
	movem.l	(sp)+,d0-d5/a0-a1	pop regs.
	rte
wfnc:
	dc.w	0
screen:					
	ds.l	1			
old_usp:				
	ds.l	1			
old_res:				
	ds.w	1			
old_pall:				
	 ds.w	16			
wherescroll:
	dc.l	24800
updown:
	dc.w	1
mesvarbig:
 	ds.l	1
fontadd:
	ds.l	5
flagbig:
	ds.b	1
bigcount:
	ds.b	1
false:
	ds.b	4000
temp:
	dc.l	0
setsam_dat:
	dc.w	%0000000011010100  	mastervol
	dc.w	%0000010010000110  	treble
	dc.w	%0000010001000110  	bass
	dc.w	%0000000000000001  	mixer
replay_rot:
	incbin	trackere.rot
	even
module:						
	incbin 	yazzir.mod
	even
pic:					
	incbin	picture.pi1
	even
font:
	incbin	font.pi1
text:
	include	message.txt
	dc.b	255
	even
message:
	dc.b	"I need a colour monitor!",0
