/* Parse a music file into a score. . . .(part of mbox)
 * John Palevich 8-22-83
 */

#include <a:stdio.h>

#define AV_NU	0
#define AV_GO	1
#define AV_PP	2
#define AV_TR	3
#define AV_VO	4
#define AV_DI	5
#define AV_CO	6

static char    *score;
static int     build_p;

#define PHRASE_N 10
#define VOICE_N 4
#define T_MAX 5000
char *phrases[PHRASE_N], *voices[VOICE_N], *misc, *eob;

char t[T_MAX];
int  ttp, tp[VOICE_N];

char xpitch[7] = {
		 0,	 /* C3 */
		 2,	 /* D3 */
		 4,	 /* E3 */
		 5,	 /* F3 */
		 7,	 /* G3 */
		 9,	 /* A3 */
		 11};	 /* B3 */

int	xaccidental[4] = {0, 1, -1, 0};

char	xduration[12] = {
		2, 3,	 /* thirtysecond */
		4, 6,	 /* sixteenth	 */
		8, 12,	 /* eighth	 */
		16, 24,  /* quarter	 */
		32, 48,  /* half	 */
		64, 96}; /* whole	 */

/* parse a music file into a score */
parse(m, len, s, testing)
	char *m, *s;
	int len, testing;
{
	int i, n_p, n_v, v;
	if(testing){
		printf("Parsing music file.\n");
	}

	/* find the phrase and voice and miscellaneous records */
	for(i = 0; i < PHRASE_N; i += 1)phrases[i] = 0;
	for(i = 0; i < VOICE_N; i += 1)voices[i] = 0;

	i = 0;		/* Point to start of file */
	while(i < len){
		if(m[i] == 255){
			if(testing)printf("End at %d\n", i);
			eob = m + i;
			break;
		}
		else if(m[i] != 170){
			printf("Bad end-of-file %d\n", m[i]);
			return -1;
		}
		v = m[i + 1] / 2;

		if(v <= 9){
			if(testing)printf("Phrase %d\n", v);
			i += 2;
			phrases[v] = m + i;
			while(m[i] != 255){
				if(i < len)i += 2;
				else {
					printf("No end of record\n");
					return -1;
				}
			}
			i += 1;
		}
		else if(v <= 13){
			v -= 10;
			if(testing)printf("Arrange Voice %d\n", v);
			i += 2;
			voices[v] = m + i;

			while(m[i] != 255){
				if(i < len)i += 2;
				else {
					printf("No end to Arrange record\n");
					return -1;
				}
			}
			i += 1;
		}
		else if(v == 64){
			if(testing)printf("Miscellaneous Information Record\n");
			i += 2;
			misc = m + i;

			if(i + 5 <= len && m[i + 5] != 255)i += 5;
				else {
					printf(
					 "Misc. record has wrong length.\n");
					return -1;
				}
		}
		else {
			printf("Wierd record: %d.\n", v + v);
			return -1;
		}
	} /* end while */

	len = eob - m;

	/* Report on file format */

	if(testing){
		printf("Misc record: %d\n", misc - m);

		for(i = 0; i < VOICE_N; i += 1){
			if(voices[i] == 0)printf("voice %d undefined\n",i);
			else printf("voice %d: %d\n", i, voices[i] - m);
		}

		for(i = 0; i < PHRASE_N; i += 1){
			if(phrases[i] == 0)printf("phrase %d undefined\n", i);
			else printf("phrase %d: %d\n", i,
				phrases[i] - m);
		}
		fflush(stdout);
		printf("Type SPACE BAR to see raw bytes, anything else to skip\n");
		if(getch() == ' '){
			printf("Type any key to stop this\n");
			for (i = 0; i < len; i += 1)
			{
				if (kbhit() != 0)
				{
					getch();
					break;
				}
				if( i % 10 == 0)printf("[%4d - %4d] ",i, i+9);
				printf("%4d", m[i]);
				if (i % 10 == 9)putchar('\n');
			}
			putchar('\n');
			fflush(stdout);
		}
	}
	/* Now use voice tables to build score */

	score = s;
	return build(testing);
}

/*
 * Build the event table.  The trick is to build note tables for each
 * voice, then shuffle the individual notes into the event table.
 */

build(testing)
	int testing;
{
	int i, j, k, ph;
	long int top; /* time of piece, in 72.8ths of a second */

	char *vp, vline;	/* the voice we're playing */
	int voice_p[VOICE_N],	/* pointer into voice table */
	    pp, phrase_p[VOICE_N],  /* which phrase this voice is playing */
	    ip, iph_p[VOICE_N],     /* how far into the phrase are we? */
	    delay[VOICE_N],	/* delay before next action on a voice */
	    count_p[VOICE_N],	/* counter for AV_CO command */
	    tbp[VOICE_N],	/* beginning of each voices temporary notes */
	    tep[VOICE_N],	/* end of ... */
	    sp[VOICE_N],	/* shuffle-the-data pointer */
	    vt[VOICE_N],	/* voice time-of-next-event */
	    ve[VOICE_N];	/* voice next event */

	tbp[0] = ttp = 0;

	for(i = 0; i < VOICE_N; i += 1)
	{	/* don't change indent level */
	vp = voices[i];
	vline = 1;

	/* now interpret this voice */

	if (testing)
		printf("     Parsing voice %d\n", i);

	while(1)
	{
		if (testing)
			printf("[%2d] ", vline);
		j = (vline - 1) << 1;
		vline += 1;	/* Post-increment count */
		if (vp[j] == 255)
		{
			if(testing)printf("End of Voice\n");
			break;	  /* end of this music piece */
		}
		switch (vp[j])
		{
		case AV_NU:
			if(testing)printf("Null\n");
			break;
		case AV_GO:
			vline = vp[j + 1];
			if(testing)printf("Go to %d\n", vline);
			break;
		case AV_PP:
			ph = vp[j + 1];
			if(testing)printf("Play phrase %d\n", ph);
			vphrase(testing, ph);
			break;
		case AV_TR:
			if(testing)printf("Transpose piece %d\n", vp[j + 1]);
			break;
		case AV_VO:
			if(testing)printf("Volume %d\n", vp[j + 1]);
			break;
		case AV_DI:
			if(testing)printf("Display voice %d\n", vp[j + 1]);
			break;
		case AV_CO:
			if(testing)printf("Count %d\n", vp[j + 1]);
			break;
		default:
			printf("Error: wierd command byte: %d\n", vp[j]);
			break;
		}

	}	/* elihw */

	tep[i] = ttp - 1;
	if(i < 3)tbp[i + 1] = ttp;

	}	/* don't change indent level */

	if(testing){
		for (i = 0; i < VOICE_N; i += 1)
			printf("Voice [%d] %4d bytes\n", i, tep[i] - tbp[i]);
	}

	/* shuffle the individual voices together */

	b_start();

	top = 0;	/* time == zero */

	for (i = 0; i < 4; i += 1)
	{
		sp[i] = tbp[i];  /* shuffle pointer to start of this buffer */
		vt[i] = top;	  /* voice times to zero */
		ve[i] = 0;	/* next event is a new depression */
	}

	while(1)
	{
		j = 30000; k = -1;
		for (i = 0; i < VOICE_N; i += 1)	/* find next event */
			if ((sp[i] < tep[i]) && (j > vt[i] - top))
			{
				j = vt[i] - top;
				k = i;
			}
		if (k == -1) break; /* end of shuffleing */

		if (j > 0)b_wait(j);
		top += j;

		switch (ve[k])
		{
		default:
		case 0: /* time to attack a key */
			i = t[ sp[k] ];
			if (i !=  128) /* not a rest */
				b_attack(i);
			ve[k] = 1;	/* make an appointment to release key */
			i = t[ sp[k] + 1];
			vt[k] += (i & 127) - ( (i & 128) ? 0 : 1);
			break;

		case 1: /* time to release a key */
			i = t[ sp[k] ];
			if( i != 128) /* not a rest */
				b_release(t[ sp[k] ]);
			ve[k] = 0;     /* make an appointment to attack the next key */
			i = t[ sp[k] + 1];
			vt[k] += (i & 128) ? 0 : 1;	/* badip */
			sp[k] += 2;
			break;
		}

	}
	b_end();
	return 0;
}

/*
 * parse a phrase
 */

vphrase(testing, p)
	int testing, p;
{
	int i, j, k;
	char *v;

	if (testing)
		printf("vphrase(%d):\n", p);

	v = phrases[p];

	if (v == 0)
	{
		if (testing) printf(". . . which is undefined.\n" );
		return;
	}
	/*
	 * Here we convert from the ATARI Music Composer Phrase Record
	 *  format to an internal format.  At this point we just drop
	 *  measure signatures.
	 */
	while (*v != 255)	/* end of measure */
	{
		if (*v < 87)	/* a note */
		{
			i = v[0];
			j = i >> 2;
			if (i == 85)	/* a rest */
			{
				t[ttp] = 128;
			}
			else
			{
				t[ttp] = 12 * (j / 7)
					+ xpitch[j % 7]
					+ xaccidental[i & 3]
					- 12;	/* C3, not C4 */
			}
			i = v[1];
			t[ttp + 1] = (i & 128)	/* tie bit */
				| xduration[(i & 127) - 1];
			ttp += 2;
			if (ttp >= T_MAX)
			{
				printf("Too many notes...\n");
				return;
			}
		}
		else if (*v != 127)	/* measure bar */
		{
			if(testing)printf("Junk Byte: %d\n", *v);
		}
		v += 2;
	}
	if (testing)
		printf("%d notes in phrase %d.\n", v - phrases[p], p);
}

/* start the score table */

b_start()
{
	score[build_p=0]=0;
}

/* wait for a time */

b_wait(i)
char	i;
{
	score[build_p]=i;
}

/* attack a note */

b_attack(i)
char	i;
{
	score [build_p + 1] = i & 0x7f ; /* bit seven == 0 for an attack */
	build_p += 2;
	score[build_p]=0;
}

/* release a note */

b_release(i)
char	i;
{
	score [build_p + 1] = i | 0x80; /* bit seven == 1 for a release */
	build_p += 2;
	score[build_p]=0;
}

/* end the piece */

b_end()
{
	score[build_p]=score[build_p+1]=255;
}

