/*
 * play.h --  Makes the ibm-pc simulate a Chroma keyboard.
 * Jack Palevich 7-22-83
 */

#define DATAPORT	0x3bc
#define ACKPORT 	0x3bd
#define IRQPORT 	0x3be
#define ACKMASK 	0x40
#define IRQMASK 	0x01

mu_init()
{
	outp(IRQPORT,0);
}

/* send_byte(b) -- sends a byte to the 8051 that controls Amy.
 * timeout and return a negative number if no reply.
 *  0 == no error
 *  1 == ACKBAR was low and never became high
 *  2 == IRQBAR was never answered
 */

send_byte(b)
char b;
{
	int timeout;
	for(timeout = 0; timeout < 5000; ++timeout)
		if(inp(ACKPORT) & ACKMASK)break;

	if(timeout == 5000)return(-1);	/* timeout */

	outp(DATAPORT,b);
	outp(IRQPORT,IRQMASK);

	for(timeout = 0; timeout < 5000; ++timeout)
		if((inp(ACKPORT) & ACKMASK) == 0)break;

	outp(IRQPORT,0);	/* withdrawl request */

	if(timeout == 5000)return(-2);	  /* time out. */
	else return(0);
}

/* depress_key(keycode, velocity, pressure)
 *   keycode  = key code (-64 to 63)
 *   velocity = velocity (  0 to 31)
 *   pressure = pressure (  0 to 63)
 */

depress_key(keycode, velocity, pressure)

	int keycode, velocity, pressure;
{
	int result;

	if((result = send_byte(0xd0)) != 0)return(result);
	if((result = send_byte(keycode)) != 0)return(result);
	if((result = send_byte(velocity)) != 0)return(result);
	if((result = send_byte(pressure)) != 0)return(result);

	return(0);
}


/* release_key(keycode, velocity)
 *   keycode  = key code (-64 to 63)
 *   velocity = velocity (  0 to 31)
 */

release_key(keycode, velocity)

	int keycode, velocity;
{
	int result;

	if((result = send_byte(0xd8)) != 0)return(result);
	if((result = send_byte(keycode)) != 0)return(result);
	if((result = send_byte(velocity)) != 0)return(result);

	return(0);
}

/* === end of play.h === */
