/*
 * play test -- play a scale of notes
 *
 * 7-22-83, John Palevich
 */
#include <a:stdio.h>
#include <play.h>
long	clock_t;
#define MAX_SCORE	5000

char	score[MAX_SCORE];
int	build_p;

int	music_p;       /* -1 for not-playing, otherwise points to current score */
char	note,herror;

main(){
	int i;

	mu_init();

	music_p = -1;

	printf("init_clock = %x\n",
			init_clock());

	while(kbhit() == 0){
		printf("\nBuilding tune\n");
		b_start();
		b_wait(20);b_attack(8);b_wait(20);b_release(8);
		b_attack(11);b_wait(20);b_release(11);
		b_wait(20);b_attack(4);b_wait(40);b_release(4);
		b_end();

		printf("Starting tune\n\n");
		herror = 0;
		note = 0;
		music_p = 0;
		while(1){
			i=music_p;
			printf("music_p = %d, note = %d,",i,note);
			printf(" herror = %d\n",herror);
			if(i == -1)break;
		}
	}
	printf("quit_clock = %x\n",quit_clock());

}

b_start()
{
	score[build_p=0]=0;
}

b_wait(i)
char	i;
{
	score[build_p]=i;
}

b_attack(i)
char	i;
{
	score [build_p + 1] = i & 0x7f ; /* bit seven == 0 for an attack */
	build_p += 2;
	score[build_p]=0;
}

b_release(i)
char	i;
{
	score [build_p + 1] = i | 0x80; /* bit seven == 1 for a release */
	build_p += 2;
	score[build_p]=0;
}

b_end()
{
	score[build_p]=score[build_p+1]=255;
}
/* === end of playtest === */

