      name    icode
;
; jcode.asm -- "improved" amy interrupt driver
; -- now has more complicated note data structure
;
	title	72 hz Interrupt Routine for Amy Driving v2.0
	subttl	16 Sept 83 (IBM PC)

dgroup	group	data
data	segment word public 'data'
	assume	ds:dgroup

old_o	dw	?;		old offset  (of interrupt routine)
old_s	dw	?;		old segment

divby4	db	0;	0..3

treg	db	0;	0..tempo

voice	dw	?;voice counter
state	db	4 dup(?)	;state of note-playing fsa -- 0..3

dataport	dw	?;equ	  3bch
ackport 	dw	?;equ	  3bdh
irqport 	dw	?;equ	  3beh

ackmask 	equ	40h
irqmask 	equ	1


nlen	dw	?;	# of bytes to send to 8051. . . .
nbuf	db	10 dup(?);	buffer for note bytes

;dispatch table

state_table   dw      is0, is1, is2, is3

;variables imported/exported from/to the C environment

	extrn	music_p:word,music_s:byte,score:byte,herror:byte, tempo: byte

;end of variables i/e f/t the C environment

data	ends

abs0	segment at 0

	org	08h*4
timer_int label   dword;	   offset here, then a segment

abs0	ends

rom_data segment at 40h

	org	8
printer_base label dword

rom_data ends

pgroup	group	prog
prog	segment byte public 'prog'
	public	init_clo,quit_clo, send_amy
	assume	cs:pgroup, ds:dgroup, ss:dgroup, es: abs0

;send a byte to amy

send_amy  proc near

	push	bp
	mov	bp, sp
	mov	al,[bp+4] ;get arguement
	mov	nlen,1
	mov	nbuf,al
	call	send_bytes
	pop	bp
	ret

send_amy endp

init_clo  proc near

;initialize the clock interrupt to 72hz and our own routine

	cli;interrupts off

	mov	music_s,0ffffh	;don't play music now
	mov	divby4,0	;initialize counter
	mov	treg,1		;initialize tempo register

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,es:timer_int;    save the old interrupt vector
	mov	old_o,ax

	mov	ax,es:timer_int+2
	mov	old_s,ax


	mov	ax,offset tick_clock; set up the new interrupt vector
	mov	es:timer_int,ax

	mov	ax,prog
	mov	es:timer_int+2,ax

;So, let's change the interrupt rate to 72.8hz (which is 4 times the traditional
;18.2hz time of day interrupt)
; By the way, the clock is 1.19318 Mhz
; so 60hz needs 19886.3333 (riiiiiight)

timer	equ	40h;	like code on page A-11

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al

	mov	ax,4000h
	out	timer,al
	mov	al,ah
	out	timer,al

;set up i/o port locations of printer

	assume	es: rom_data

	mov	ax, rom_data
	mov	es, ax
	mov	ax, es:printer_base
	mov	dataport, ax
	inc	ax
	mov	ackport, ax
	inc	ax
	mov	irqport, ax

;zero the state variable

	mov	si, 3
zst:	mov	state[si],0
	dec	si
	jge	zst

	mov	ax, dataport	;return printer base

	pop	es;	restore es, enable interrupts, and return
	sti
	ret

init_clo  endp

	assume	es: abs0
tick_clock proc far

;handle an interrupt

	sti

	push	ds;	set ds to the C data area
	push	si
	push	ax
	mov	ax,data
	mov	ds,ax

;---- Start of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

;interpretation loop

	cmp	music_s,0	;should we be playing?
	je	check
	jmp	iloopx	;nope!

check:	dec	treg		;decrement tempo count
	je	check0
	jmp	iloopx

check0: mov	al, tempo     ;set up loop again
	mov	treg, al

	mov	si,0

checkl: cmp	state[si],3	;dead voice state
	jne	checkx
	inc	si
	cmp	si,3
	jle	checkl

;all dead -- end of music
	mov	music_s,0ffffh
	jmp	iloopx

checkx:

;for each voice: (0..3)

	mov	voice, 0

iloop:	mov	si, voice	;dispatch on state of this voice
	mov	al, state[si]
	mov	ah,0
	cmp	al,3
	jle	iloop1
	mov	al,3	;limit 0..3
iloop1: shl	ax,1
	mov	si,ax
	mov	ax,state_table[si]
	mov	si,voice
	jmp	ax

;state is zero, so attack note and set state to one

is0:	shl	si,1
	mov	ax,music_p[si]	;counter for this voice
	mov	si,ax
	cmp	score[si][1],255   ;end of piece? (if volume == 255)
	jne	i1

;end of piece

	mov	si, voice
	mov	state[si],3	;end of this voice (state 3)
	shl	si,1
	mov	music_p[si],0ffffh
	jmp	iloopq

i1:	cmp	score[si],128	;rest?
	je	i2		;if so, don't attack it.

;attack a note

	mov	ax, 0d0h	;base for a note depression
	add	ax, voice
	mov	nbuf, al

	mov	al,score[si]	;note
	mov	nbuf+1,al

	mov	al, score[si][1]	;volume
	mov	nbuf+2,al

	mov	nbuf+3,0	;preasure

	mov	nlen,4
	call	send_bytes

i2:	mov	si,voice	;state := 1
	mov	state[si],1
	jmp	is1		;and fall thru to state 1

;state is 1 (counting down while playing something)

is1:	shl	si,1
	mov	ax,music_p[si]
	mov	si,ax
	dec	score[si][2]	;decrement count
	jne	iloopq

;we've counted down to zero, so release note and go to state 2

	cmp	score[si],128	;rest?
	je	i3		;if so, don't release it.

;release a note

	mov	ax, 0d8h	;base for a note depression
	add	ax, voice
	mov	nbuf, al

	mov	al,score[si]	;note
	mov	nbuf+1,al

	mov	al, score[si][1]	;volume
	mov	nbuf+2,al

	mov	nlen,3
	call	send_bytes

i3:

	mov	al,score[si][3] ;inter-record gap
	cmp	al,0
	jne	i4	;not a tied note. . . .

;a tied note, so report it as an error (we shouldn't see it here!)
	mov	herror,3
;	mov	si,voice	;bump music pointer
;	shl	si,1
;	add	music_p[si],4
;
;	mov	si,voice
;	jmp	is0		;and handle as if state zero
;

i4:
	mov	si,voice
	mov	state[si],2
	jmp	iloopq

;state 2

is2:	shl	si,1
	mov	ax,music_p[si]
	mov	si,ax
	dec	score[si][3]	;decrement inter-note-gap
	jne	iloopq

;have reached end of inter-note-gap

	mov	si,voice	;back to state 0
	mov	state[si],0

	shl	si,1		;and bump music pointer
	add	music_p[si],4
	jmp	iloopq

;state 3 -- don't do anything

is3:

;loop 'till voice == 4

iloopq: inc	voice
	cmp	voice,4
	jge	iloopx
	jmp	iloop

iloopx:

;and that's the ball game

;---- End of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

	inc	divby4
	cmp	divby4,4
	jne	my_tick

	mov	al,0
	mov	divby4,al

	push	es

	cli
	mov	ax,abs0
	mov	es,ax
	mov	ax,old_o
	mov	es:timer_int,ax
	mov	ax,old_s
	mov	es:timer_int+2,ax
	sti

	int	8;	      do the "real" 18hz interrupt

	cli
	mov	ax,offset tick_clock
	mov	es:timer_int,ax
	mov	ax,prog
	mov	es:timer_int+2,ax
	sti

	pop	es

	jmp	end_tick

my_tick:
	mov	al,20h; 	EOI to 8259 ala A-78
	out	020h,al

end_tick:
	pop	ax;		restore ds and return
	pop	si
	pop	ds
	iret



tick_clock endp

;normalize note by copying bit 6 into bit 7

norm_note	proc	near
	and	al,07fh
	cmp	al,040h
	jl	nnq
	or	al,080h
nnq:	ret
norm_note	endp

; send a string of bytes to AMY via lpt1:
;

send_bytes  proc near
	push	si
	push	dx
	push	bx
	push	ax
	cli
	mov	si,0
	cmp	dataport,0	;check if any printer
	je	saq		;if none, punt

sl:
;wait for ack to be high

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w1:	dec	bx
	jne	w12
	mov	herror,1
	jmp	saq;		timed out

w12:	in	al,dx
	and	al,ackmask
	je	w1

;ack is high
	mov	dx,dataport
	mov	al,nbuf[si];this is the byte to send
	out	dx,al

	mov	al,irqmask
	mov	dx,irqport
	out	dx,al

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w2:	dec	bx
	jne	w21
	mov	al,0;	timed out
	mov	dx,irqport
	out	dx,al
	mov	herror,2
	jmp	saq

w21:	in	al,dx
	and	al,ackmask
	jne	w2

;ack went low
	mov	al,0
	mov	dx,irqport
	out	dx,al

s2:	inc	si
	cmp	si,nlen
	jne	sl

saq:	sti
	pop	ax
	pop	bx
	pop	dx
	pop	si
	ret
send_bytes   endp

quit_clo  proc near

;restore the clock interrupt to 18.2hz and the default routine


	cli;interrupts off

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,old_o;    restore the old interrupt vector
	mov	es:timer_int,ax

	mov	ax,old_s
	mov	es:timer_int+2,ax

	pop	es;	restore es, enable interrupts, and return

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al
	mov	ax,0
	out	timer,al
	mov	al,ah
	out	timer,al

	sti
	mov	ax,old_s
	ret

quit_clo  endp

prog	ends
	end
