
;	chroma interface

	name	chroma

	title	chroma - p/c interface
	subttl	14 feb 84 (ibmpc)


abst	segment at	0h
	org	34h

irq5	dw	?
irq52	dw	?
irq6	dw	?
irq62	dw	?
irq7	dw	?
irq72	dw	?

abst	ends

dmem	segment para	public	'data'

age_table	db	8 dup (?)
pn_table	db	8 dup (?)
pv_table	db	8 dup (?)
pg_table	db	8 dup (?)
tailptr 	dw	?
index		dw	?
first_flag	db	?
psp		dd	?
data_byte	db	?
state		db	?
end_flag	db	?
note		db	?
player		db	?
numvoice	db	?
front		dw	?
back		dw	?

		org	100

inbuff		db	2048 dup (?)

dmem	ends


pic0		equ	20h
pic1		equ	21h
porta		equ	71ch
portb		equ	71dh
portc		equ	71eh
pcmd		equ	71fh
dataport	equ	3bch
statport	equ	3bdh
cntlport	equ	3beh

pgroup	group	cseg

cseg	segment para	public	'code'
	public	chroma
	assume	cs:cseg, ds:dmem, es:abst

chroma	proc	near

start:
	mov	bx, 25
st0:	mov	ax, 50000
st1:	dec	ax
	jnz	st1
st2:	dec	bx
	jnz	st0

	mov	ax, dmem		; set up ds
	mov	ds, ax
	mov	ax, abst		; set up es
	mov	es, ax
	mov	ax, offset cntl_int	; set up interrupt vector
	mov	es:irq5, ax
	mov	ax, cseg
	mov	es:irq5+2, ax

	mov	bx, 0
	mov	tailptr, offset age_table
i1:	mov	age_table[bx], 0ffh
	inc	bx
	cmp	bx, 24
	jne	i1
	mov	bx, 0

i2:	mov	pg_table[bx], 0
	inc	bx
	cmp	bx, 8
	jne	i2

	mov	first_flag, 0
	mov	end_flag, 0
	mov	state, 0
	mov	index, 0

	mov	dl, 'n'
	mov	ah, 2
	int	21h
	mov	dl, '='
	mov	ah, 2
	int	21h
	mov	ah, 1
	int	21h
	sub	al, 30h
	cmp	al, 8
	jle	iok
	mov	al, 8

iok:	mov	numvoice, al
	mov	front, offset inbuff
	mov	back, offset inbuff

	mov	bx, 0
i3:	mov	inbuff[bx], 0ffh
	inc	bx
	cmp	bx, 2048
	jne	i3

	in	al, pic1
	and	al, 0dfh		; unmask 5
	or	al, 1			; mask 0
	out	pic1, al

	mov	dx, pcmd		; set up cntl port
	mov	al, 099h
	out	dx, al
	mov	dx, portb
	mov	al, 0feh		; toggle ack/
	out	dx, al
	in	al, dx
	mov	al, 0ffh
	out	dx, al
	mov	al, 0ffh		; set ack/
	out	dx, al

	mov	dx, cntlport		; set stb/
	mov	al, 0
	out	dx, al
	sti				; enable interrupts

loop:
	mov	al, end_flag
	cmp	al, 0
	je	loop1

	in	al, pic1
	or	al, 20h 		; mask 5
	and	al, 0feh		; unmask 0
	out	pic1, al
	mov	al, end_flag

	jmp	endloop

loop1:	cmp	index, 0		; any dat in buffer?
	je	loop

	cmp	index, 2048
	jne	loop15
	mov	end_flag, 2
	jmp	end_int

loop15: mov	bx, back		; get next data byte
	mov	al, [bx]
	inc	back
	cmp	back, offset inbuff+2048
	jne	loop2
	mov	back, offset inbuff

loop2:	dec	index

	cmp	state, 0		; state 0 ?
	jne	chks1
chkatk: cmp	al, 0d0h		; attack command?
	jne	chkrel
	mov	state, 1
	mov	first_flag, 1
	jmp	end_int
chkrel: cmp	al, 0d8h		; release command?
	jne	chkoth
	mov	state, 4
	jmp	end_int
chkoth: cmp	first_flag, 0
	je	loop
	mov	end_flag, 1		; program exit
	jmp	end_int

chks1:	cmp	state, 1		; state 1?
	jne	chks2
	mov	note, al		; save note value
alloc:	call	find_player		; is note in pn_table?
	cmp	al, 0ffh		; al = p or ff if not in table
	jne	assign
	call	find_avail		; any players available?
	cmp	al, 0ffh		; al = p or ff if none avialable
	jne	assign
	mov	al, age_table		; use oldest player
	call	rem_table		; remove that player fm age_table
assign: mov	player, al		; save assigned player number
	mov	bx, tailptr
	mov	[bx], al		; add player to end of table
	inc	tailptr
	mov	bx, 0
	mov	bl, al			; set up index
	mov	al, note		; retreive note value
	mov	pn_table[bx], al	; save note value
	mov	pg_table[bx], 1 	; set gate
	mov	state, 2
	jmp	end_int

chks2:	cmp	state, 2		; state 2?
	jne	chks3
	mov	bx, 0
	mov	bl, player		; set up index
	mov	pv_table[bx], al	; save velocity value
	mov	state, 3
	jmp	end_int

chks3:	cmp	state, 3		; state 3?
	jne	chks4
	mov	bx,0
	mov	bl, player		; set up index
	mov	al, player		; set up chroma command byte
	add	al, 0d0h
	call	out_byte		; send it to driver
	mov	al, pn_table[bx]	; get note value
	call	out_byte
	mov	ax, 0
	mov	al, pv_table[bx]	; get velocity value
	shl	ax, 1			; x 8
	shl	ax, 1
	cmp	ax, 255
	jle	itsok
	mov	ax, 255
itsok:	call	out_byte
	mov	al, 0			; dummy
	call	out_byte
	mov	state, 0
	jmp	end_int

chks4:	cmp	state, 4		; state 4?
	jne	s6
	call	find_player		; find player associated
	cmp	al, 0ffh		; al = p or ff if not found
	je	s5			; player allready reassigned
	mov	bx, 0
	mov	bl, al
	mov	pg_table[bx], 0 	; clear gate
	call	rem_table		; remove player from age_table
	add	al, 0d8h
	call	out_byte
	mov	al, pn_table[bx]
	call	out_byte
	mov	al, 0
	call	out_byte
s5:	mov	state, 5
	jmp	end_int

s6:	mov	state, 0		; state 5?
end_int:jmp	loop

endloop:ret

chroma	endp


cntl_int    proc    far

	cli
	push	ax
	push	bx
	push	dx
	mov	dx, porta		; get control byte
	in	al, dx

	mov	bx, front
	mov	[bx], al
	inc	front
	cmp	front, offset inbuff+2048
	jne	c1
	mov	front, offset inbuff
c1:	inc	index

	mov	dx, portb
	mov	al, 0feh		; toggle ack/
	out	dx, al
	in	al, dx
	mov	al, 0ffh
	out	dx, al
	mov	al, 20h
	out	pic0, al
	pop	dx
	pop	bx
	pop	ax
	iret

cntl_int    endp

out_byte    proc    near

	cli
	push	ax
	push	cx
	push	dx
	mov	data_byte, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be hi
l1:	dec	cx
	jz	l4		; timed out - bye
	in	al, dx			; chk ack/
	and	al, 40h 		; ack/ = bit 6
	jz	l1			; wait

	mov	dx, dataport		; put byte at output port
	mov	al, data_byte
	out	dx, al

	mov	dx, cntlport		; set stb/ = 0
	mov	al, 1
	out	dx, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be lo
l2:	dec	cx
	jz	l3
	in	al, dx			; chk ack/
	and	al, 40h
	jnz	l2			; wait
	jmp	l5

l3:	mov	end_flag, 4
l5:	mov	dx, cntlport		; set stb/ = 1
	mov	al, 0
	out	dx, al
	jmp	end_byte

l4:	mov	end_flag, 3

end_byte:
	pop	dx
	pop	cx
	pop	ax
	sti
	ret

out_byte    endp

rem_table   proc    near

	push	ax
	push	bx
	mov	bx, offset age_table - 1	; find player #
r1:	inc	bx
	cmp	al, [bx]
	jne	r1

r2:	inc	bx
	cmp	bx, tailptr		; done?
	je	r3
	mov	al, [bx]
	dec	bx
	mov	[bx], al
	inc	bx
	jmp	r2

r3:	dec	tailptr
	pop	bx
	pop	ax
	ret

rem_table   endp

find_player proc    near

	push	bx
	mov	bx, 0

fp1:	cmp	al, pn_table[bx]
	je	fp2
	inc	bx
	cmp	bl, numvoice
	jne	fp1
	mov	bx, 0ffh

fp2:	mov	al, bl
	pop	bx
	ret

find_player endp

find_avail  proc    near

	push	bx
	mov	bx, 0

fa1:	cmp	pg_table[bx], 0
	je	fa2
	inc	bx
	cmp	bl, numvoice
	jne	fa1
	mov	bx, 0ffh

fa2:	mov	al, bl
	pop	bx
	ret

find_avail  endp

cseg	ends
	end
