
;	chroma interface

	name	chroma

	title	chroma - p/c interface
	subttl	2 feb 84 (ibm pc)


abst	segment at	0h
	org	34h

irq5	dw	?
irq52	dw	?

abst	ends

dmem	segment para	public	'data'

age_table	db	8 dup (?)
pn_table	db	8 dup (?)
pv_table	db	8 dup (?)
pg_table	db	8 dup (?)
tailptr 	dw	?
data_byte	db	?
state		db	?
end_flag	db	?
note		db	?
player		db	?

dmem	ends

stack	segment para	stack	'stack'

	db	512 dup (?)

stack	ends


pic0		equ	20h
pic1		equ	21h
porta		equ	71ch
portb		equ	71dh
portc		equ	71eh
pcmd		equ	71fh
dataport	equ	3bch
statport	equ	3bdh
cntlport	equ	3beh

cseg	segment para	public	'code'
	assume	cs:cseg, ds:dmem, ss:stack, es:abst


start:
	cli				; start off clean
	mov	ax, dmem		; set up ds
	mov	ds, ax
	mov	ax, abst		; set up es
	mov	es, ax
	mov	ax, offset cntl_int	; set up interrupt vector
	mov	es:irq5, ax
	mov	ax, cseg
	mov	es:irq5+2, ax

	mov	bx, 0
	mov	tailptr, offset age_table
i1:	mov	age_table[bx], 0ffh
	inc	bx
	cmp	bx, 24
	jne	i1
	mov	bx, 0

i2:	mov	pg_table[bx], 0
	inc	bx
	cmp	bx, 8
	jne	i2

	mov	end_flag, 0
	mov	state, 0

	in	al, pic1		; read imr
	and	al, 0dfh		; clear m5
	out	pic1, al

	mov	dx, pcmd		; set up cntl port
	mov	al, 099h
	out	dx, al
	mov	dx, portb
	mov	al, 0ffh		; set ack/
	out	dx, al

	mov	dx, cntlport		; set stb/
	mov	al, 0
	out	dx, al
	sti				; enable interrupts

loop:
	cmp	end_flag, 1
	jne	loop

loop1:	jmp	loop1


cntl_int:
	push	ax
	push	bx
	push	dx
	mov	dx, porta		; get control data in 'al'
	in	al, dx

	cmp	state, 0		; state 0 ?
	jne	chks1
chkatk: cmp	al, 0d0h		; attack command?
	jne	chkrel
	mov	state, 1
	jmp	end_int
chkrel: cmp	al, 0d8h		; release command?
	jne	chkoth
	mov	state, 4
	jmp	end_int
chkoth: mov	end_flag, 1		; program exit
	jmp	end_int

chks1:	cmp	state, 1		; state 1?
	jne	chks2
	mov	note, al		; save note value
alloc:	call	find_player		; is note in pn_table?
	cmp	al, 0ffh		; al = p or ff if not in table
	jne	assign
	call	find_avail		; any players available?
	cmp	al, 0ffh		; al = p or ff if none avialable
	jne	assign
	mov	al, age_table		; use oldest player
	call	rem_table		; remove that player fm age_table
assign: mov	player, al		; save assigned player number
	mov	bx, tailptr
	mov	[bx], al	 ; add player # to end of table
	inc	tailptr
	mov	bx, 0
	mov	bl, al			; set up index
	mov	al, note		; retreive note value
	mov	pn_table[bx], al	; save note value
	mov	pg_table[bx], 1 	; set gate
	mov	state, 2
	jmp	end_int

chks2:	cmp	state, 2		; state 2?
	jne	chks3
	mov	bx, 0
	mov	bl, player		; set up index
	mov	pv_table[bx], al	; save velocity value
	mov	state, 3
	jmp	end_int

chks3:	cmp	state, 3		; state 3?
	jne	chks4
	mov	bx,0
	mov	bl, player		; set up index
	mov	al, player		; set up chroma command byte
	add	al, 0d0h
	call	out_byte		; send it to driver
	mov	al, pn_table[bx]	; get note value
	call	out_byte
	mov	al, pv_table		; get velocity value
	shl	ax, 1			; x 8
	shl	ax, 1
	shl	ax, 1
	call	out_byte
	mov	al, 0			; dummy
	call	out_byte
	mov	state, 0
	jmp	end_int

chks4:	cmp	state, 4		; state 4?
	jne	s6
	call	find_player		; find player associated
	cmp	al, 0ffh		; al = p or ff if not found
	je	s5			; player allready reassigned
	mov	bx, 0
	mov	bl, al
	mov	pg_table[bx], 0 	; clear gate
	call	rem_table		; remove player from age_table
s5:	mov	state, 5
	jmp	end_int

s6:	mov	state, 0		; state 5?

end_int:
	mov	dx, portb
	mov	al, 0feh		; toggle ack/
	out	dx, al
	mov	al, 0ffh
	out	dx, al
	mov	al, 20h 		; eoi to 8259 ala a-78
	out	pic0, al
	pop	dx
	pop	bx
	pop	ax
	iret




out_byte:
	push	ax
	push	cx
	push	dx
	cli
	mov	data_byte, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be hi
l1:	dec	cx
	jz	end_byte		; timed out - bye
	in	al, dx			; chk ack/
	and	al, 40h 		; ack/ = bit 6
	jz	l1			; wait

	mov	dx, dataport		; put byte at output port
	mov	al, data_byte
	out	dx, al

	mov	dx, cntlport		; set stb/ = 0
	mov	al, 1
	out	dx, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be lo
l2:	dec	cx
	jz	l3
	in	al, dx			; chk ack/
	and	al, 40h
	jz	l2			; wait

l3:	mov	dx, cntlport		; set stb/ = 1
	mov	al, 0
	out	dx, al

end_byte:
	sti
	pop	dx
	pop	cx
	pop	ax
	ret

rem_table:

	push	ax
	push	bx
	mov	bx, offset age_table - 1	; find player #
r1:	inc	bx
	cmp	al, [bx]
	jne	r1

r2:	inc	bx
	cmp	bx, tailptr		; done?
	je	r3
	mov	al, [bx]
	dec	bx
	mov	[bx], al
	inc	bx
	jmp	r2

r3:	dec	tailptr
	pop	bx
	pop	ax
	ret


find_player:

	push	bx
	mov	bx, 0

fp1:	cmp	al, pn_table[bx]
	je	fp2
	inc	bx
	cmp	bx, 8
	jne	fp1
	mov	bx, 0ffh

fp2:	mov	al, bl
	pop	bx
	ret


find_avail:

	push	bx
	mov	bx, 0

fa1:	cmp	pg_table[bx], 0
	je	fa2
	inc	bx
	cmp	bx, 8
	jne	fa1
	mov	bx, 0ffh

fa2:	mov	al, bl
	pop	bx
	ret

cseg	ends
end	start
