
/*-----------------------------------------------------------------------------
 * September 1983, Claudia Rudolph
 * Some of this file was taken from stuff written by Jack Palevich, August 1983.
 *-----------------------------------------------------------------------------
 */

#include <stdio.h>
#include <maestro.h>

char	name_buf[MAXNBUF];	/* Directory of file name buffer.
				 * (Things like *flist and *instname point
				 * to the elements of name_buf.)	     */
char	orch_buf[MAXOBUF];	/* Directory of instruments in orchestra.
				 * *olist points to the elements in orch_buf.*/
int	buf_end = 0;		/* Last character in orch_buf.		     */
char	*olist[MAXENT]; 	/* Array of file names for those instrument
				 * files which compose the orchestra.	     */
int	o_len = 0;		/* Number of instruments in orchestra.
				 * i.e. Length of olist.		     */
int	p_inst[8] = {-1,-1,-1,-1,-1,-1,-1,-1 };
				/* Array of pointers into the orchestra
				 * list to specify which instrument
				 * each of the 8 players is playing.	     */
char	dump = 0;		/* Flag for dump option.		     */

/*-----------------------------------------------------------------------------
 *
 *
 *
 *-----------------------------------------------------------------------------
 */

dirtab(){
	char *flist[MAXENT];	/* flist is an array of pointers into an
				 * array of file names (name_buf).   gfname
				 * will return flist arranged so that the
				 * file names can be accessed alphabetically.*/
	int f_end;		/* Number of instrument tables	on disk.
				 * i.e. Length of flist.		     */
	int inst;		/* Instrument number.			     */
	char *instname; 	/* Points into name_buf; for transfer of a
				 * file name (in name_buf) to an instrument
				 * name (in orch_buf).			     */
	int page = 1;		/* Page of list to be displayed.	     */
	int i,j;
	char c[4];		/* Input				     */

	while((f_end=gfname("????????SND",flist,MAXENT,name_buf,MAXNBUF))==0) {
		CLEAR;
		cursor(20,1);
		printf("\n There are no instrument files in your ");
		printf("default directory.\n");
		printf(" Insert a new disk and type any character ");
		printf("to try again.  (ESC to return.)\n");
		if (getch() == ESC) return;
	}
	putbar(TOP);		/* Clears screen.			     */
	printf("\t\t     Sound Library in Current Directory ");
	putright();
	putbar(MID);
	prntlist(flist, f_end, page);
	putbar(MID);
	printf("  Specify the instrument number ( 1 - %3d)       ",f_end);
	putright();
	printf("  for those instruments which you wish to add    ");
	putright();
	printf("  to your orchestra.     Type ESC when finished. ");
	putright();
	printf("                        (Type '*' to toggle dump option.)");
	putright();
	putbar(BOT);

	i = o_len;
	printf("     Instrument (if none, type ESC): ");
	fflush(stdout);
	SAV_CURS;
	while ((inst = getnum()) != 0-ESC) {  /* Collect list of instruments */
		RTN_CURS;
		if (inst == 0-'*') {          /* dump has been toggled.      */
			if (dump) printf("\n\t\t\t (Dump option on.) ");
			else	printf("\n\t\t\t (Dump option off.)");
		}
		else if (inst > 0 && inst <= f_end) {
			j = search(flist[inst-1],olist,i);
			if (j != -1) printf("      Already in orchestra. ");
			else {
				/* Transfer file name (less '.SND') from
				 * name_buf to orch_buf:		     */
				olist[i++] = &orch_buf[buf_end];
				instname = flist[inst-1];
				while ( *instname != '\0')
					orch_buf[buf_end++] = *instname++;
				orch_buf[buf_end++] = '\0';
				printf("      Okay. Next Instrument.");
			}
		}
		else	printf("      No good. Try again.   ");
		fflush(stdout);
		RTN_CURS;
	}
	if (i != o_len) {

		/* Load new instruments. ( # o_len ... i-1)		     */

		printf("\n\nLoading RAM . . . please wait. . .\n");
		if (orch( &olist[o_len], i - o_len) == ERR) {
			printf("Press any key to go on.\n");
			getch();
		}
		o_len = i;
	}
	return;
}

/*-----------------------------------------------------------------------------
 * players() displays the orchestra.
 * players() then displays the current instrument of all players, and allows for
 * re-assignment of the players' instruments.
 *-----------------------------------------------------------------------------
 */
players()
{
	int page = 1;			/* Page of list to be displayed.     */
	int line,col;			/* Cursor position.		     */
	int player;
	int c,i,j,inst;

      for(;;) {
	putbar(TOP);		/* Clears screen.		      */
	printf("\t\t               Orchestra  ");
	putright();
	putbar(MID);
	if (o_len == 0) {
		printf(" Sorry.  The Orchestra is empty.   ");
		putright();
		printf(" Hence you cannot yet assign the players' instruments. ");
		putright();
		printf(" ");
		putright();
		printf(" Type any key to return.");
		putright();
		putbar(BOT);
		getch();
		return;
	}
	prntlist(olist, o_len, page);
	curs_loc(&line,&col);
      for (;;) {
	cursor(line-1,1);
	putright();
	putbar(MID);
	printf(" Specify player (a-h) to reassign his instrument.       ");
	putright();
	printf(" Type ESC to return.                                    ");
	putright();
	putbar(BOT);
	prntplay(p_inst);
	c = getch();
	if (c == ESC) return;
	else if ((c >= 'a' && c <= 'h') || (c >= 'A' && c <= 'H'))  {
	     if (c >= 'a') player = c - 'a';
	     else	   player = c - 'A';
	     cursor(line-1,1);
	     putright();
	     putbar(MID);
	     printf("  Player %c:   New Instrument ( 1 - %3d): ",
		player+'a', o_len);
	     SAV_CURS;
	     printf("               ");
	     putright();
	     printf("                                                 ");
	     putright();
	     putbar(BOT);
	     RTN_CURS;
	     while ((inst = getnum()) != 0-ESC)
		if (inst == 0-'*') {
			putright();
			if (dump) printf("       (Dump option on.) ");
			else {
				printf("       (Dump option off.)");
				cursor(23,1);
				printf("                                    ");
				printf("                                    ");
			}
			RTN_CURS;
		}
		else if (inst < 1 || inst > o_len) {
			putright();
			printf("        No good. Try again.  ");
			RTN_CURS;
			printf("    ");
			RTN_CURS;
		}
		else {
			p_inst[player] = inst - 1;
			/* search unalphabetized list for inst */
			alocvoic(player,p_inst[player]);
			break;
		}
	}
	else; /* process error on input (or fall through to scroll list?) */
      }
	/* scroll list stuff? */
      }
}

/*-----------------------------------------------------------------------------
 *
 * pre_pro invokes the massage() routine to convert ascii instrument tables
 * the binary form needed by the 8051 driver.
 *
 * The old ascii file (named *.TAB) is replaced by a new binary file
 * (named *.SND).  Some risk is taken in the process, and if the C code
 * below bombs, the *.TAB file may be lost during conversion.
 *
 *-----------------------------------------------------------------------------
 */
pre_pro(){
	char *flist[MAXENT];	/* flist is an array of pointers into an
				 * array of file names (name_buf).   gfname
				 * will return flist arranged so that the
				 * file names can be accessed alphabetically.*/
	int f_end;		/* Number of .TAB files on disk.
				 * i.e. Length of flist.		     */
	char *plist[MAXENT];	/* Array of file names for those files
				 * to be pre-processed. 		     */
	int p_len = 0;		/* Length of plist.			     */
	int inst;		/* Instrument number.			     */
	char *instname; 	/* Points into name_buf; for transfer of a
				 * file name (in name_buf) to an instrument
				 * name (in orch_buf).			     */
	static char ext[] = ".TAB";
	char file[14];		/* Copy of inst name plus .TAB extension.    */
	int page = 1;		/* Page of list to be displayed.	     */
	int i,j,k;
	char c[4];		/* Input				     */

      for (;;) {
	while((f_end=gfname("????????TAB",flist,MAXENT,name_buf,MAXNBUF))==0) {
		CLEAR;
		cursor(20,1);
		printf("\n There are no .TAB files in your ");
		printf("default directory.\n");
		printf(" Insert a new disk and type any character ");
		printf("to try again.  (ESC to return.)\n");
		if (getch() == ESC) return;
	}
	putbar(TOP);		/* Clears screen.			     */
	printf("\t\t   .TAB files available for Pre-processing");
	putright();
	putbar(MID);
	prntlist(flist, f_end, page);
	putbar(MID);
	printf("  Type '0' to pre-process all .TAB files, or");
	putright();
	printf("  Specify a file number ( 1 - %3d)       ",f_end);
	putright();
	printf("  for a single file to pre-process.");
	putright();
	printf("  Type ESC to return. ");
	putright();
	printf("                        (Type '*' to toggle dump option.)");
	putright();
	putbar(BOT);

	SAV_CURS;
	while ((inst = getnum()) == 0-'*') {
		RTN_CURS;
		if (dump) printf("(Dump option on.) \n");
		else	printf("(Dump option off.)\n");
	}
	RTN_CURS;

	if (inst == 0-ESC) return(0);

	printf("\nPlease wait . . . file pre-processing in progress.\n");
	if (inst == 0) {
		for ( i = 0; i <= f_end-1; i++) {
			instname = flist[i];
			for (j=0; (file[j] = instname[j]) != '\0'; j++);
			for (k=0; k < 5; file[j+k] = ext[k++]);
			if (massage(file) == ERR) {
			     printf("ERROR: %s not pre-processed.\n",instname);
			     printf("Press any key to go on.\n");
			     getch();
			}
			else if (dump) {
			     printf("%s has been pre-processed.\n",instname);
			     printf("Press any key to go on.\n");
			     getch();
			}
		}
		return(0);
	}
	else if (inst > 0 && inst <= f_end) {
		instname = flist[inst-1];
		for (j=0; (file[j] = instname[j]) != '\0'; j++);
		for (k=0; k < 5; file[j+k] = ext[k++]);
		if (massage(file) == ERR) {
			printf("ERROR: %s not pre-processed.\n",instname);
			printf("Press any key to go on.\n");
			getch();
		}
		else if (dump) {
			printf("%s has been pre-processed.\n",instname);
			printf("Press any key to go on.\n");
			getch();
		}
	}
      }
}

/*-----------------------------------------------------------------------------
 * prntplay lists the 8 players and their assigned instruments in 2 rows:
 *
 *-----------------------------------------------------------------------------
 */
prntplay(p_inst)
int p_inst[];	/* Array of 8: the instruments of players 1-7.	p_inst is the
		 * index into the orchestra list (olist) for the instrument.
		 * Note: if player n has no instrument, p_inst[n] is -1.     */
{
	extern char *olist[];
	int i, j, inst;

	for (i = 0; i <= 1; i+=1) {
		cursor(20 + i, 1);
		for (j = 0; j <= 6; j+=2) {
			inst = p_inst[i+j];
			if (inst == -1)
				printf("Player %c:           ", i+j+'a');
			else
				printf("Player %c: %-10s", i+j+'a', olist[inst]);
		}
		fflush(stdout);
	}
}

/*-----------------------------------------------------------------------------
 * prntlist prints the elements of a list 'list' of length 'len'.
 * The page-th page of the list is printed.  (A page consists of
 * 'LINES' lines and 'COLUMNS' columns.
 *-----------------------------------------------------------------------------
 */
#define LINES	10
#define COLUMNS 4

prntlist(list,len,page)
char **list;	/* List to be displayed.				     */
int  len;	/* Length of list.					     */
int  page;	/* Page to be displayed.  The list is displayed in pages of
		 * 12 lines and 2 columns; hence 24 entries per page.	     */
{
	int first;	/* first entry to be displayed (starting at 1)	     */
	int last;	/* last  entry to be displayed (starting at epp)     */
	int epp=LINES*COLUMNS;		/* Elements per page.		     */
	int epsc;			/* Elements per shortest col.	     */
	int rem;			/* Number of long columns.	     */
	int item_no;			/* number of item from list.	     */
	int line, col, i;		/* Loop counters.		     */

	first = (page-1) * epp + 1;
	if (len >= first + epp - 1) last = first + epp - 1;
	else last = len;

	epsc = (last - first + 1) / COLUMNS;
	rem = (last - first + 1) % COLUMNS;

	for (line = 0; line < (epsc+(rem>0)); line++) {
		printf(" ");
		for (col = 1; col <= COLUMNS; col++) {
			if (col <= rem) item_no = col - 1;
			else item_no = rem;
			item_no += first + line + ((col - 1) * epsc);
			if (line >= epsc && col > rem)
				printf("                ");
			/* each field is 16 spaces to fill 2 tab areas	  */
			else printf("%3d) %-11s",item_no,list[item_no - 1]);
		}
		putright();
	}
	while (line++ <= LINES) {
		for (col = 1; col <= COLUMNS; col++)
			printf("                ");
		putright();
	}
}

/*-----------------------------------------------------------------------------
 * search returns the number of the element in sarray which matches string,
 * (0 - ary_len-1); -1 if no match is found.
 *-----------------------------------------------------------------------------
 */

search(string,sarray,ary_len)
char string[];
char *sarray[];
int  ary_len;
{
	int i;
	for (i = 0; (i < ary_len) && (strcmp (string,sarray[i])); ++i);
	if (i < ary_len) return(i);	/* Found.	*/
	else return(-1);	       /* Not found.   */
}

/*-----------------------------------------------------------------------------
 * gfname
 *-----------------------------------------------------------------------------
 */

/* get file names (directory) command
 * August 1983, Jack Palevich
 *
 * passed: dspec, buf, maxsng, and maxnbuf
 *	dspec	is the string which specifies the type of file name to be
 *		searched for.  (e.g. if dspec is "?????????xxx", all files
 *		the extention .xxx will be found.)
 *	buf	is an array of pointers into name_buf to provide for
 *		alphabetization of the file names found.
 *	maxsng	is a limit to the size of buf.
 *	maxnbuf is a limit to the size of name_buf.
 *
 * gfname fills name_buf with all occurrances of the the specified file name
 * (dspec) on the current default directory.  (This list is alphabetized
 * through the array of pointers, buf.)
 *
 */

#define SFE 0x11
#define SNE 0x12

char	my_fcb[37],dta[37];	/* (Global)	*/

int gfname(dspec, buf, maxsng, name_buf, maxnbuf)
char  *dspec;
char **buf;		/* buf is an array of pointers to the elements of    */
			/* name_buf.					     */
char *name_buf; 	/* name_buf is an array of file names.		     */
int maxsng, maxnbuf;
{
    int i, j, result;
    /* set up FCB */
    my_fcb [0] = 0;  /* default drive */
    j = 0;	/* pointer to name buffer */
    strcpy(my_fcb + 1, dspec); /* file name */

    bdos(0x1A, dta);	/* Set disk transfer address */

    result = bdos(SFE, my_fcb);
    if(result != 0)return 0;	/* no entries */

    buf[0] = name_buf;
    convert(dta, buf [0]);
    j = strlen(buf[0]) + 1;

    for(i = 1; i < maxsng; i += 1){
	bdos(0x1A, dta);
	result = bdos(SNE, my_fcb);
	if(result != 0)break;
	buf[i] = name_buf + j;
	convert(dta, buf [i]);
	j += strlen(buf[i]) + 1;
	if(j + 13 > maxnbuf)break;
    }
    /* alphabetize the entries. . . . */
    bsort(buf, i);

    return i;
}

convert(fc,b)
char	*fc;	/* fc points into a file control block containing the	*/
char	*b;	/* file name to be read into b[].			*/
{
    int i,j;
    i = 1;
    j = 0;
    while(i < 9){
	if(fc[i]==' ')break;
	b[j]=fc[i];
	j += 1;
	i += 1;
    }
/*  b[j]='.'; j += 1;

    i = 9;
    while(i<12){
	if(fc[i]==' ')break;
	b[j]=fc[i];
	j += 1;
	i += 1;
    }
*/  b[j] = 0;
}

bsort(b, i)
	char **b;
	int i;
{
	int k,j;
	char *t;
	if(i <= 1)return;
	for(k = 0; k < i-1; k += 1)
		for(j = 0; j < i-1; j += 1)
			if( strcmp( b [j], b [j + 1]) > 0){
				t = b[j];
				b[j] = b[j + 1];
				b[j + 1] = t;
			}
 }

cursor(line,col)
int line,col;
{
	printf("%c[%d;%dH",27,line,col);
	fflush(stdout);
}

curs_loc(line,col)
int *line,*col; 	/* These values will be made to reflect the current
			 * cursor line and column position.		     */
{
	int c;

	printf("\033[6n");     /* issue Device Status Report (DSR) command. */
	fflush(stdout);

	*line = *col = 0;
	c = getch();		/* ESC	*/
	c = getch();		/* '['  */
	while ((c = getch()) != ';') *line = *line * 10 + (c - '0');
	while ((c = getch()) != 'R') *col = *col * 10 + (c - '0');
	getch();		/* <CR> */
	return;
}
