	name	icode
;
; icode.asm -- "improved" amy interrupt driver
; -- now has more complicated note data structure
;
	title	72 hz Interrupt Routine for Amy Driving v2.0
	subttl	16 Sept 83 (IBM PC)

dgroup	group	data
data	segment word public 'data'
	assume	ds:dgroup

dataport	dw	?;equ	  3bch
ackport 	dw	?;equ	  3bdh
irqport 	dw	?;equ	  3beh

ackmask 	equ	40h
irqmask 	equ	1

;variables imported/exported from/to the C environment
;	herror = error flag (will be non-zero if any error occurrs)
;	nlen   = number of bytes to send to the 8051
;	nbuf   = buffer for bytes to send

	extrn	herror:byte, nlen:word, nbuf:byte

;end of variables i/e f/t the C environment

data	ends


rom_data segment at 40h

	org	8
printer_base label dword

rom_data ends

pgroup	group	prog
prog	segment byte public 'prog'
	public	initport, send_amy, silence
	assume	cs:pgroup, ds:dgroup, ss:dgroup

silence proc near

	mov	nlen,1
	mov	nbuf,000h	;silence-amy command
	call	send_amy
	ret

silence endp

initport  proc near

;set up i/o port locations of printer

	assume	es: rom_data

	push	es

	mov	ax, rom_data
	mov	es, ax
	mov	ax, es:printer_base
	mov	dataport, ax
	inc	ax
	mov	ackport, ax
	inc	ax
	mov	irqport, ax

	mov	ax, dataport	;return printer base

	pop	es;	restore es, enable interrupts, and return
	ret

initport  endp

; send a string of bytes to AMY via lpt1:
;

send_amy	proc near
	push	si
	push	dx
	push	bx
	push	ax
	cli
	mov	si,0
sl:
;wait for ack to go high

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w1:	dec	bx
	jne	w12
	mov	al,1
	mov	herror,al
	jmp	saq;		timed out

w12:	in	al,dx
	and	al,ackmask
	je	w1

;ack is high
	mov	dx,dataport
	mov	al,nbuf[si];this is the byte to send
	out	dx,al

	mov	al,irqmask
	mov	dx,irqport
	out	dx,al

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w2:	dec	bx
	jne	w21
	mov	al,0;	timed out
	mov	dx,irqport
	out	dx,al
	mov	al,2
	mov	herror,al
	jmp	saq

w21:	in	al,dx
	and	al,ackmask
	jne	w2

;ack went low
	mov	al,0
	mov	dx,irqport
	out	dx,al

s2:	inc	si
	cmp	si,nlen
	jne	sl

saq:	sti
	pop	ax
	pop	bx
	pop	dx
	pop	si
	ret
send_amy	endp


prog	ends
	end
