/* This is the version which worked for the 12K-restricted MAESTRO v.1.3
 * as of 1-27-84.							     */

/******************************************************************************
 * This file defines constants to be used by all of MAESTRO's subroutines.
 *****************************************************************************/

extern char nbuf[];	/* Buffer to contain bytes to send to 8051 driver.   */

extern unsigned NBUFSIZ;/* Size of buffer to send to send_bytes routine.     */

#define MAXTABL   65280 /* End of RAM for instrument tables.		     */
			/* How much ram are we going to have ??????????      */
			/* (1-10-84: reserve the last 256 bytes for AMY.)    */
#define MAXENT 26	/* left over from Jack's constraint of alphabet size */
			/* (no. of possible file names) 		     */
#define MAXNBUF (12288) /* (arbitrary) and mis-used, i think. 1-25-83	     */
#define MAXOBUF (MAXENT * 9)
			/* (arbitrary) no. of possible names in orchestra
			 * times 9 (no. of characters in each name,
			 * including the '\0' character).                    */

#define BEG_ORCH  0x200 /* Starting location of instrument tables in RAM     */
#define BEG_PTR   0x100 /* RAM location of table of pointers (one for each
			 * instrument in the orchestra) to the location
			 * of the corresponding instrument table in RAM      */
			/* This pointer table occurrs after the first
			 * page of RAM which is reserved as scratch space
			 * for the 8051.				    */
#define LRAM  0x16	/* 8051's LRAM command.                             */
#define AVOIC 0x20	/* 8051's command to allocate voice assignments.    */
			/* As of yet, undefined.			    */
#define EOL  (EOF - 1)	/* End of line flag.				    */
#define ERR  -1 	/* Common error value.				    */
#define LSB  0x00FF
#define ESC 27
#define SPACE 32
#define CLEAR	 printf("\033[2J\n")         /* Clear screen.               */
#define SAV_CURS printf("\033[s"); fflush(stdout)  /* Save cursor position. */
#define RTN_CURS printf("\033[u"); fflush(stdout)  /* Return cursor.        */
#define CLEAR	 printf("\033[2J\n\t")             /* Clear screen.         */
#define ERASE	 printf("\033[k"); fflush(stdout)  /* Erase line.           */

/* character codes used to draw a pretty box around the file names */

#define TOPLEFT  201
#define TOPRIGHT 187
#define MIDLEFT  204
#define MIDRIGHT 185
#define BOTLEFT  200
#define BOTRIGHT 188
#define VERTICAL 186
#define HORIZON  205
#define TOP 0
#define MID 1
#define BOT 2
