*************************************************
*						*
*   2600 GAME SYSTEM EQUATES			*
*						*
*************************************************
*
*
*
	.6502
*
*  STELLA (TIA) REGISTER ADDRESSES
*
	.ORG	0
*
*
VSYNC:	.DS.B	1	; BIT	     1	VERTICAL SYNC SET-CLR
VBLANK:	.DS.B	1	; BIT	     1	VERTICAL BLANK SET-CLR
WSYNC:	.DS.B	1	; STROBE	WAIT FOR HORIZ BLANK
RSYNC:	.DS.B	1	; STROBE	RESET HORIZ SYNC COUNTER
NUSIZ0:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 0
NUSIZ1:	.DS.B	1	; BITS   54 210	NUMBER-SIZE PLAYER/MISSILE 1
COLUP0:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 0
COLUP1:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYER 1
COLUPF:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) PLAYFIELD
COLUBK:	.DS.B	1	; BITS 7654321	COLOR(4)-LUM(3) BACKGROUND
CTRLPF:	.DS.B	1	; BITS 7 54 210	PLAYFIELD CONTROL
REFP0:	.DS.B	1	; BIT      3	REFLECT PLAYER 0
REFP1:	.DS.B	1	; BIT      3	REFLECT PLAYER 1
PF0:	.DS.B	1	; BITS 7654	PLAYFIELD REG BYTE 0
PF1:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 1
PF2:	.DS.B	1	; BITS ALL	PLAYFIELD REG BYTE 2
RESP0:	.DS.B	1	; STROBE	RESET PLAYER 0
RESP1:	.DS.B	1	; STROBE	RESET PLAYER 1
RESM0:	.DS.B	1	; STROBE	RESET MISSILE 0
RESM1:	.DS.B	1	; STROBE	RESET MISSILE 1
RESBL:	.DS.B	1	; STROBE	RESET BALL
AUDC0:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 0
AUDC1:	.DS.B	1	; BITS	   3210	AUDIO CONTROL 1
AUDF0:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 0
AUDF1:	.DS.B	1	; BITS	   3210	AUDIO FREQUENCY 1
AUDV0:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 0
AUDV1:	.DS.B	1	; BITS	   3210	AUDIO VOLUME 1
GRP0:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 0
GRP1:	.DS.B	1	; BITS ALL	GRAPHICS FOR PLAYER 1
ENAM0:	.DS.B	1	; BIT	     1	ENABLE MISSILE 0
ENAM1:	.DS.B	1	; BIT	     1	ENABLE MISSILE 1
ENABL:	.DS.B	1	; BIT	     1	ENABLE BALL
HMP0:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 0
HMP1:	.DS.B	1	; BITS 7654	HORIZ MOTION PLAYER 1
HMM0:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 0
HMM1:	.DS.B	1	; BITS 7654	HORIZ MOTION MISSILE 1
HMBL:	.DS.B	1	; BITS 7654	HORIZ MOTION BALL
VDELP0:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 0
VDELP1:	.DS.B	1	; BIT	      0	VERTICAL DELAY PLAYER 1
VDELBL:	.DS.B	1	; BIT	      0	VERTICAL DELAY BALL
RESMP0:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 0
RESMP1:	.DS.B	1	; BIT	     1	RESET MISSILE TO PLAYER 1
HMOVE:	.DS.B	1	; STROBE	ACT ON HORIZ MOTION
HMCLR:	.DS.B	1	; STROBE	CLEAR ALL HM REGISTERS
CXCLR:	.DS.B	1	; STROBE	CLEAR COLLISION LATCHES
	.DS.B	3
*
*  READ ADDRESSES -	BIT 7	BIT 6 (ONLY)
*
CXM0P:	.DS.B	1	;M0.P1	M0.P0
CXM1P:	.DS.B	1	;M1.P0	M1.P1
CXP0FB:	.DS.B	1	;P0.PF	P0.BL
CXP1FB:	.DS.B	1	;P1.PF	P1.BL
CXM0FB:	.DS.B	1	;M0.PF	M0.BL
CXM1FB:	.DS.B	1	;M1.PF	M1.BL
CXBLPF:	.DS.B	1	;BL.PF	NOT USED
CXPPMM:	.DS.B	1	;P0.P1	M0.M1
*
*  PADDLE INPUT PORTS..
*
INPT0:	.DS.B	1
INPT1:	.DS.B	1
INPT2:	.DS.B	1
INPT3:	.DS.B	1
*
*
INPT4:	.DS.B	1	;D7=0 WHEN LEFT JOYSTICK FIREBUTTON PRESSED
INPT5:	.DS.B	1	;D7=0 WHEN RITE JOYSTICK FIREBUTTON PRESSED
*
*	PIA AND TIMER (6532) LOCATIONS
*
	.ORG	$280
*
SWCHA:	.DS.B	1	;P0,P1 JOYSTICKS
*
*	LEFT RITE
*	7654 3210
*	---- ----
*	RLDU RLDU
*
CTLSWA:	.DS.B	1	;SWCHA DATA DIRECTION (0=INPUT)
*
SWCHB:	.DS.B	1	;CONSOLE SWITCHES
*
*	D7-RITE DIFFICULTY
*	D6-LEFT DIFFICULTY
*	D5/D4 NOT USED
*	D3-COLOR - B/W
*	D2-NOT USED
*	D1-GAME SELECT
*	D0-GAME RESET
;
CTLSWB:	.DS.B	1	;SWCHB DATA DIRECTION (0=INPUT)
;
INTIM:	.DS.B	1	;INTERVAL TIMER READ
	.DS.B	15
TIM1T:	.DS.B	1	;SET 1    CLK INTERVAL (838   NSEC/INTERVAL)
TIM8T:	.DS.B	1	;SET 8    CLK INTERVAL (6.7   USEC/INTERVAL)
TIM64T:	.DS.B	1	;SET 64   CLK INTERVAL (53.6  USEC/INTERVAL)
T1024T:	.DS.B	1	;SET 1024 CLK INTERVAL (858.2 USEC/INTERVAL)
