/*  output.c
 *    routines for displaying data
 */


#include <stdio.h>
#include "memtype.h"



char *atari_to_vt(byte b)
{
static char buf[20];
char ch;
	ch = b&0x7f;
	if(ch < 32 || ch > 126)
		ch = '~';
	if(b > 128)
		sprintf(buf, "\033[7m%c\033[0m", ch);
	else
		sprintf(buf, "%c", ch);
	return buf; 
}


void hexascii_dump(byte *buf, int size)
{
int i, n;
	for(i=0; i<size; i++) {
		if(!(i&15))
			printf("%02X: ", i);
		printf("%02X ", buf[i]);
		if((i&15) == 15) {
			printf("   ");
			for(n=-15; n<1; n++)
				printf("%s", atari_to_vt(buf[i+n]));
			printf("\n");
		}
	}
	if(size & 15)
		printf("\n");
}

void dump_data(byte *buf, int size)
{
	hexascii_dump(buf, size);
}


