/*  sio.h
 *    general Atari SIO constants
 */


/* command status: */
#define CSTAT_INVCMD	0x01	/* invalid command frame received */
#define CSTAT_INVDATA	0x02	/* invalid data frame received */
#define CSTAT_BADPUT	0x04	/* put was unsuccessful */
#define CSTAT_WPROT	0x08	/* disk is write-protected */
#define CSTAT_READY	0x10	/* drive is ready */
#define CSTAT_DOUBLE	0x20	/* double density disk in drive? */


/* device codes: */
#define D1	0x31
#define D2	0x32
#define D3	0x33
#define D4	0x34
#define D5	0x35
#define D6	0x36
#define D7	0x37
#define D8	0x38
#define P1	0x40
#define P2	0x4f
#define R1	0x50
#define R2	0x51
#define R3	0x52
#define R4	0x53

/* command codes: */
#define	Read		0x52
#define Write		0x57
#define Status		0x53
#define Put		0x50
#define Format		0x21
#define Download	0x20
#define ReadAdr		0x54
#define ReadSpin	0x51
#define MotorOn		0x55
#define VerifySec	0x56

/* status codes: */
#define Ack		0x41
#define Complete	0x43
#define Error		0x45
#define Nak		0x4e

/* misc */

#define DEFAULT_TIMEOUT	160	/* default timeout in seconds */


static inline byte compute_checksum(byte *data, int len)
{
int sum;
	sum = 0;
	while(len-- > 0)
		sum += *data++;
	while(sum > 0xff)
		sum = (sum&0xff)+(sum>>8);
	return sum;
}

