/*=========================================================================
 *           Envision: Font editor for Atari                              *
 ==========================================================================
 * File: title.c                                                          *
 * Author: Mark Schmelzenbach                                             *
 * Started: 08/04/97                                                      *
 =========================================================================*/
#include <grx20.h>
 
#include "raw.h"
#include "envision.h"

void titlepal()
{
 unsigned char r,g,b;
 int x;

#ifdef __linux__ 
 for(x=0;x<256;x++) {
   r=(tpal[x*3])>>2;
   g=(tpal[x*3+1])>>2;
   b=(tpal[x*3+2])>>2;
   vga_setpalette(x,r,g,b);
 }
#else 
 for(x=0;x<256;x++) { 
   outportb(0x3c8,x);
   r=(tpal[x*3])>>2;
   g=(tpal[x*3+1])>>2;
   b=(tpal[x*3+2])>>2;
   outportb(0x3c9,r);
   outportb(0x3c9,g);
   outportb(0x3c9,b);
 } 
#endif 
}

int unpack()
{
 unsigned char *look;
 int i,x,y,c,t;

 GrClearContext(0); 
 look=titles;
 x=44; y=76; t=0;
 do {
  if (!t) {
    c=*look++;
    i++;
    if (!c) {
      t=*look++;
      i++;
      t--;
    }
  } else t--;
  GrPlot(x,y,c);
  x++;
  if (x==253) { x=44; y++; }
 } while(y<130);   
}

int credits()
{
 GrFilledBox(8,191,319-8,200,1); 
 string(44,126,"Atari Font Editor");
 string(253,126,"v0.5");
 string(28,191,"Programmed by Mark Schmelzenbach");
}

int title()
{
 titlepal();
 unpack();
 credits();
 getch();
}
