
/*
   This software is copyright 1989 by John Dunning.  See the file
   'COPYLEFT.JRD' for the full copyright notice.
*/

/* stuff for symbol table */

#ifndef _TYPES_
#include "types.h"
#endif

struct sym
	{
	struct sym * next;		/* next elt */
	short nbr;			/* for reloc files, sym nbr
					   when linking, module nbr of
					     module that defined it */
	USHORT value;			/* sym's value */
	USHORT flags;			/* sym flags */
	char name[1];			/* name this sym; really longer */
	};

/* sym flags */

#define	DEFINED	1			/* has some value */
#define THIS_SEG 2			/* defined in this seg */
#define GLOBAL	4			/* globally visible */
#define	ABS	8			/* value is absolute */

#ifdef M6502
/* why doesn't this work? */
#else
extern struct sym * find_sym();
extern struct sym * assign_sym();
#endif
