	Page	58,132
	Title	SIO.ASM		SIO Page Access Routines
;******************************************************************************
;
;   Name:	SIO.ASM		SIO Routines
;
;   Group:	SIO
;
;   Revision:	0.00
;
;   Date:
;
;   Author: Michael Munoz
;
;******************************************************************************
;
;  Module Functional Description:
;
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	my_siov

;
;  External Declarations
;
	Extrn	filenum1:Byte
	Extrn	filenum2:Byte
;
;  LOCAL Equates
;

;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include		Atari.inc	; Atari equates
	.286c				; Include 80286 instructions
	Page
;
;	Define SIO code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulate code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing

;
; local memory space
;
fname		EQU	0d080h		; filename memory
mybuf		EQU	0d180h		; temp buffer
sect		DW	0h
	Subttl	my_siov
	Page	+
;******************************************************************************
;
;	my_siov
;
;	Registers on Entry:
;
;		dh   - flags
;
;	Registers on Exit:
;
;		none
;
;******************************************************************************
		Even			; Force procedure to even address
my_siov	Proc	Near			; my siov routine emulates atari code
	mov	di,DSTATS		; assume no error
	mov	Byte Ptr [di],1
	pusha 				; save all registers
	mov     di,DDEVIC		; get device type
	mov	al,[di]			; get device type from data seg.
	cmp	al,031h			; Is the device the disk drive
	je	Disk_Drive_OK		; no, so exit with error timeout
Device_Error:
	mov	di,DSTATS		; save status
	mov	Byte Ptr [di],8ah	; timeout
	jmp	my_siov_done		; exit
Disk_Drive_OK:
	mov	di,DUNIT		; get disk drive number
	mov	al,[di]
	sub	al,2			; see if it is drive 1 or 2
	jg	Device_Error		; error if unit not 1 or 2
	mov	di,DCOMND		; get the command
	mov	al,[di]
	cmp	al,'S'			; is it status
	jne	Not_Status
	call	sio_status		; do status
	jmp	my_siov_done		; then exit
Not_Status:
	cmp	al,'R'			; read a sector?
	jne	Not_Read		;
	call	sio_read		; read a sector
	jmp	my_siov_done		; then exit
Not_Read:
	cmp	al,'W'			; is it a write?
	je	Yes_Write
	cmp	al,'P'			; is it a put?
	je	Yes_Write
	cmp	al,'!'			; is it format?
	jne	my_siov_done		; no, so exit
	call	sio_format		; do a format
	jmp	my_siov_done
Yes_Write:
	call	sio_write		; do a sector write
my_siov_done:
	popa
	mov	di,DSTATS
	mov	al,[di]			; get status value
	mov	cl,al			; also save status in Y
	and	al,80h			; get msb
	and	dh,7fh			; clear msb of flags
	or	dh,al			; set or reset N flag
	retf
my_siov	Endp				; End of the my siov

	Subttl	sio_status
	Page	+
;******************************************************************************
;
;	sio_status
;
;	Registers on Entry:
;
;		dh   - flags
;
;	Registers on Exit:
;
;		none
;
;******************************************************************************
		Even			; Force procedure to even address
sio_status	Proc	Near		; my siov routine emulates atari code
	mov	ah,1			; assume good status
	mov	di,DUNIT		;
	mov	al,[di]			; get drive number
	cmp	al,1			; is it disk 1?
	jne	Status_Disk2		; jmp to disk 2 status
	mov	di,offset filenum1
	jmp	Check_Size
Status_Disk2:
	mov	di,offset filenum2
Check_Size:
	dec	di			; get poitn to string space
	mov	al,cs:[di]		; get filename length
	cmp	al,0
	jne	Status_OK		; jmp if there is a filename
	mov	ah,8ah			; timeout
Status_OK:
	mov     di,DBUFLO
	mov	si,[di]			; get buffer address
	mov	Byte Ptr [si],10h	; status good
Status_Done:
	mov	di,DSTATS		; write status
	mov	Byte Ptr [di],ah
	ret
sio_status	Endp				; End of the my siov

	Subttl	sio_read
	Page	+
;******************************************************************************
;
;	sio_read
;
;	Registers on Entry:
;
;		dh   - flags
;
;	Registers on Exit:
;
;		none
;
;******************************************************************************
		Even			; Force procedure to even address
sio_read	Proc	Near		; sio_read routine replaces atari code
	mov	di,DSTATS
	mov	Byte Ptr [di],1		; assume good status
	; Copy file name to atari unused ram space
	; Assume device #1
	mov	di,DUNIT		; get drive number
	mov	al,[di]
	mov	di,offset fname		; get pointer to dest. string
	mov	si,offset filenum1	; point to filenum1 string
	mov	cl,cs:[si-1]		; get number of bytes to xfer
	cmp	al,1			; is it drive 1?
	je	Read_Filename		; yes, do string copy
	mov	si,offset filenum2	; point to filenum2 string
	mov	cl,cs:[si-1]		; get number of bytes to xfer
Read_Filename:
	cmp	cl,0			; no filename?
	je	Read_Error
Copy_Loop:
	mov	al,cs:[si]		; get one character
	mov	[di],al			; save one character
	inc	si       		; bump pointers
	inc	di
	dec	cl                  	; copy entire string
	jne	Copy_Loop
	mov	Byte Ptr [di],0		; end of string character
	; Open File for reading
	mov	dx,offset fname		; tell dos where the filename is
	mov	al,READ_ONLY		; open for read
	mov	ah,OPEN_FILE		; command to open the file
	int	DOS			; call dos
	jnc	No_Open_Error		; open successful
Read_Error:
	mov	di,DSTATS		; get sio status address
	mov	Byte Ptr [di],8ah	; set timeout error
	jmp	sio_read_done		; exit
No_Open_Error:
	; Next read the sector
	mov	bx,ax			; save the file handle
	; compute the number of bytes to read
	mov	di,DAUX1		; get low sector byte
	mov	al,[di]			; save in al
	inc	di
	mov	ah,[di]			; save high sector byte in ch
	dec	ax
	mov	cx,80h			; 128 bytes / sector
	mul	cx			; ax*cx
	xchg	ax,dx			; put low part in dx
	mov	cx,ax			; put high part in cx
	mov	al,0			; use bgin. of file
	mov	ah,42h			; mov file pointer
	int	DOS			; call dos
	mov	cx,80h			; number of bytes to read
	mov	di,DBUFLO		; get data buffer address lo
	mov	dl,[di]
	inc	di			; get data buffer address hi
	mov	dh,[di]			; save in dx
	mov	ah,READ_FILE		; set up to read 128 bytes
	int	DOS			; call dos
	; the last sector read is the desired sector
	; now close the file
	mov	ah,CLOSE_FILE		; command to close the file
	; bx already holds the file handle
	int	DOS			; call dos
sio_read_done:
	ret
sio_read	Endp				; End of the my siov
	Subttl	sio_write
	Page	+
;******************************************************************************
;
;	sio_write
;
;	Registers on Entry:
;
;		dh   - flags
;
;	Registers on Exit:
;
;		none
;
;******************************************************************************
		Even			; Force procedure to even address
sio_write	Proc	Near		; sio_read routine replaces atari code
	mov	di,DSTATS
	mov	Byte Ptr [di],1		; assume good status
	; Copy file name to atari unused ram space
	; Assume device #1
	mov	si,offset filenum1	; point to filenum1 string
	mov	cl,cs:[si-1]		; get number of bytes to xfer
	mov	di,DUNIT		; get drive number
	mov	al,[di]
	mov	di,offset fname		; get pointer to dest. string
	cmp	al,1			; is it drive 1?
	je	Write_Copy_Loop		; yes, do string copy
	mov	si,offset filenum2	; point to filenum2 string
	mov	cl,cs:[si-1]		; get number of bytes to xfer
Write_Filename:
	cmp	cl,0			; no filename?
	je	Write_Error
Write_Copy_Loop:
	mov	al,cs:[si]		; get one character
	mov	[di],al			; save one character
	inc	si       		; bump pointers
	inc	di
	dec	cl                  	; copy entire string
	jne	Write_Copy_Loop
	mov	Byte Ptr [di],0		; end of string character
	; Open File for reading
	mov	dx,offset fname		; tell dos where the filename is
	mov	al,WRITE_ONLY		; open for write
	mov	ah,OPEN_FILE		; command to open the file
	int	DOS			; call dos
	jnc	No_Open_Error_W		; open successful
Write_Error:
	mov	di,DSTATS		; get sio status address
	mov	Byte Ptr [di],8ah	; set timeout error
	jmp	sio_read_done		; exit
No_Open_Error_W:
	; Next read up to the desired sector
	mov	bx,ax			; save the file handle
	; compute the number of bytes to read
	mov	di,DAUX1		; get low sector byte
	mov	al,[di]			; save in al
	inc	di
	mov	ah,[di]			; save high sector byte in ch
	dec	ax
	mov	cx,80h			; 128 bytes / sector
	mul	cx			; ax*cx
	xchg	ax,dx			; put low part in dx
	mov	cx,ax			; put high part in cx
	mov	al,0			; use bgin. of file
	mov	ah,42h			; mov file pointer
	int	DOS			; call dos
	; the next sector is the sect we want to write
	mov	di,DBUFLO		; get data buffer address lo
	mov	dl,[di]
	inc	di			; get data buffer address hi
	mov	dh,[di]			; save in dx
	mov	ah,WRITE_FILE		; write command
	mov	cx,80h			; write 128 bytes
	; the file handle is still set up in bx
	int	DOS
	; now close the file
	mov	ah,CLOSE_FILE		; command to close the file
	; bx already holds the file handle
	int	DOS			; call dos
sio_write_done:
	ret
sio_write	Endp				; End of the my siov
;***************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;***************************************************************************
	Subttl	sio_format
	Page	+
;******************************************************************************
;
;	sio_format
;
;	Registers on Entry:
;
;		dh   - flags
;
;	Registers on Exit:
;
;		none
;
;******************************************************************************
		Even			; Force procedure to even address
sio_format	Proc	Near		; sio_read routine replaces atari code
	ret
sio_format	endp
Emulate Ends
	End				; End of the SIO module
