/* atari.h
 */


#define VER_MAJOR 0
#define VER_MINOR 02


#define SCWID	384
#define SCHGT	240	/* visible scanlines */
#define NSCAN	262	/* full count of scanlines */
#define NCYCLES 114	/* number of cycles per scanline */
#define NFRAMES	60	/* number of frames per second */
#define CPUHZ	(NSCAN*NCYCLES*NFRAMES)

#define MSEC(n)	((CPUHZ*(n))/1000)	/* convert msec to cycles */


#define SCHED_TIMER0	0
#define SCHED_TIMER1	1
#define SCHED_TIMER3	3
#define SCHED_SEROUT	4
#define SCHED_SERDONE	5
#define SCHED_SERIN	6
#define SCHED_HSYNC	7
#define SCHED_VSYNC	8
#define SCHED_DISK	12
#define SCHED_KB	13	/* timer for key press delays */
#define SCHED_KB2	14	/* timer for console release delays */

typedef struct scanline {
	byte	*pix;
	byte	colpf[5];
	word	color[10];
	byte	colpm[4];
	word	pmcolor[5];
	byte	update;
	byte	dmacycles;
	byte	redraw;
} ScanLine; 

typedef struct pixline {
	byte	*pix;
	word	dlist;		/* address of dlist entry */
	word	adr;		/* address of video data */
	byte	nbytes;		/* number of bytes to read */
	byte	mode;		/* mode of line (0-15) */
	byte	nscan;		/* number of scanlines */
	byte	wid;		/* width (1=narrow,2=normal,3=wide) */
	byte	dli;		/* DLI for this line? (1=True) */
	byte	hscroll;	/* Hscroll enabled? (1=True) */
	byte	vscroll;	/* Vscroll enabled? (1=True) */
	byte	update;		/* needs updating? (0x200 = DL) */
	byte	dmacycles;	/* number of DMA cycles for dlist */
} PixLine;
 
struct atari {
        int     flags;

        byte    *ram;
        int     ramsize;
	byte	*extram;	/* extended RAM */
	int	extramsize;
        byte    *rom;
        byte    *cartA;
        byte    *cartB;
	char	romfile[40];	/* filename for ROM */
	char	cartAfile[40];	/* filename for CartA */
	char	cartBfile[40];	/* filename for CartB */
	byte	systype;
/* GTIA: */
	byte	hposp[4];
	byte	hposm[4];
	byte	sizep[4];
	byte	sizem[4];
	byte	grafp[4];
	byte	grafm;
	byte	colpm[4];
	byte	colpf[5];
	byte	prior;
	byte	gractl;
	byte	console;
	byte	speaker;
	byte	mpf[4];
	byte	ppf[4];
	byte	mpl[4];
	byte	ppl[4];
/* POKEY: */
	byte	irq_enable;
	byte	irq_status;
	byte	sk_status;
	byte	keylast;
	byte	keycode;
	uint	timer[4];
	byte	audf[4];
	byte	audc[4];
	byte	audctl;
	byte	paddle[8];
	byte	strig[4];
	uint 	clock[4];
	uint	clockbase;
	byte	serin;
	byte	serout;
/* PIA: */
	byte	stick[4];
	byte	pactl;
	byte	pbctl;
	byte	porta;
	byte	portb;
/* ANTIC: */
	byte	dmactl;
	byte	dmactl_pfwidth;
	byte	dmactl_missile;
	byte	dmactl_player;
	byte	dmactl_single;
	byte	dmactl_dma;
	byte	hscroll;
	byte	vscroll;
	word	dlist;
	word	chbase;
	word	pmbase;
	word	vadr;
	word	vcount;
	byte	nmi_enable;
	byte	nmi_status;
	byte	penh;
	byte	penv;
	byte	pdata[4];
	byte	mdata[4];
/* graphics output: */
	int	update_mask;
	int	fcount;
	int	scale;
	byte	*screen;
	byte	*pix;
	word	vid_adr;	/* video base address */
	byte	blank[SCWID/2];
	ScanLine scan[NSCAN+15];	/* all scanlines */
	PixLine	pixline[NSCAN+15];	/* all dlist pixlines */
	int	refresh;	/* refresh all */
	word	*wscan;		/* write to scan # */
	byte	pixel[256];
};


/*** Basic system types: ***/
#define SYSTYPE_800	1	/* 400/800 line */
#define SYSTYPE_XL	2	/* 600XL/800XL line (also 65XE) */
#define SYSTYPE_XE	3	/* 130XE */
#define SYSTYPE_XE320	4	/* 130XE with 256K mod */


/*** memory access control flags: ***/
#define MFLAG_BURNROM	0x0001
#define MFLAG_BURNCARTA	0x0002
#define MFLAG_BURNCARTB	0x0004
#define MFLAG_DEBUG	0x8000

/*** Memory types for directing to proper "hardware": ***/
#define	MTYPE_RAM	0
#define MTYPE_GTIA	1
#define MTYPE_POKEY	2
#define MTYPE_PIA	3
#define MTYPE_ROM	4
#define MTYPE_ANTIC	5
#define MTYPE_CARTA	6
#define MTYPE_CARTB	7
#define MTYPE_PBI	9
#define MTYPE_NULL	10


/*** ATARI MEMORY MAP ***/
				/* 0000-7fff RAM */
#define MBASE_CARTB	0x8000	/* 8000-9fff 8K Cartridge B or RAM */
#define MSIZE_CARTB	0x2000	
#define MBASE_CARTA	0xa000	/* a000-bfff 8K Cartridge A or RAM */
#define MSIZE_CARTA	0x2000	
#define MBASE_FPROM	0xc000	/* c000-cfff unused or 4K FP ROMs */
#define MSIZE_FPROM	0x1000
#define MBASE_GTIA	0xd000	/* d000-d0ff Television Interface Adapter */
#define MSIZE_GTIA	 0x100	
				/* d100-d1ff unused */
#define MBASE_POKEY	0xd200	/* d200-d2ff Pot/Keyboard Adapter */
#define MSIZE_POKEY	 0x100	
#define MBASE_PIA	0xd300	/* d300-d3ff Peripheral Interface Adapter */
#define MSIZE_PIA	 0x100
#define MBASE_ANTIC	0xd400	/* d400-d5ff Graphics/Interrupts */
#define MSIZE_ANTIC	 0x200
				/* d600-d7ff unused */
#define MBASE_OSROMB	0xd800	/* d800-ffff O/S ROM A or B */
#define MSIZE_OSROMB	0x2800
#define MBASE_OSROMC	0xc000	/* c000-ffff O/S ROM C */
#define MSIZE_OSROMC	0x4000
#define MBASE_OSROM	0xc000	/* base address for any OS */
#define MSIZE_OSROM	0x4000	/* full size of O/S ROM area */
#define MBASE_OSROM1	0xc000	/* base for first part of OS ROM */
#define MSIZE_OSROM1	0x1000	/* size of first part */
#define MBASE_OSROM2	0xd800	/* base for second part of OS ROM */
#define MSIZE_OSROM2	0x2800	/* size for second part */
#define MBASE_STROM	0x5000	/* base for self-test ROM */
#define MSIZE_STROM	0x0800	/* size of self-test ROM */

#define MBASE_BANK	0x4000	/* base for XE bank-switched region */
#define MSIZE_BANK	0x4000	/* size of XE bank-switched region */

/* GTIA addresses: */
#define MASK_GTIA	0x1f	/* only low 6 bits significant */
#define	W_HPOSP0	0x00	/* 0-3 */
#define R_M0PF		0x00	/* 0-3 */
#define W_HPOSM0	0x04	/* 0-3 */
#define R_P0PF		0x04	/* 0-3 */
#define W_SIZEP0	0x08	/* 0-3 */
#define R_M0PL		0x08	/* 0-3 */
#define W_SIZEM		0x0c
#define R_P0PL		0x0c	/* 0-3 */
#define W_GRAFP0	0x0d	/* 0-3 */
#define R_TRIG0		0x10	/* 0-3 */
#define W_GRAFM		0x11
#define W_COLPM0	0x12	/* 0-3 */
#define R_PAL		0x14
#define W_COLPF0	0x16	/* 0-3 */
#define W_COLBK		0x1a
#define W_PRIOR		0x1b
#define W_VDELAY	0x1c
#define W_GRACTL	0x1d
#define RW_HITCLR	0x1e
#define RW_CONSOL	0x1f

/* POKEY addresses: */
#define MASK_POKEY	0x0f	/* only low 4 bits significant */
#define	W_AUDF0		0x00	/* 0-3 by 2 */
#define W_AUDC0		0x01	/* 0-3 by 2 */
#define R_POT0		0x00	/* 0-7 */
#define W_AUDCTL	0x08
#define R_ALLPOT	0x08
#define W_STIMER	0x09
#define R_KBCODE	0x09
#define W_SKREST	0x0a
#define R_RANDOM	0x0a
#define W_POTGO		0x0b
#define W_SEROUT	0x0d
#define R_SERIN		0x0d
#define W_IRQEN		0x0e
#define R_IRQST		0x0e
#define W_SKCTL		0x0f
#define R_SKSTAT	0x0f

/* PIA addresses: */
#define MASK_PIA	0x03	/* only low 2 bits significant */
#define RW_PORTA	0x00
#define RW_PORTB	0x01
#define RW_PACTL	0x02
#define RW_PBCTL	0x03

/* ANTIC addresses: */
#define MASK_ANTIC	0x0f	/* only low 4 bits significant */
#define W_DMACTL	0x00
#define W_CHACTL	0x01
#define W_DLISTL	0x02
#define W_DLISTH	0x03
#define W_HSCROL	0x04
#define W_VSCROL	0x05
#define W_PMBASE	0x07
#define W_CHBASE	0x09
#define W_WSYNC		0x0a
#define R_VCOUNT	0x0b
#define R_PENH		0x0c
#define R_PENV		0x0d
#define W_NMIEN		0x0e
#define	W_NMIRES	0x0f
#define R_NMIST		0x0f


#define	SET_IRQ(n)	{ sys.irq_status |= (n); \
			  if(sys.irq_status & sys.irq_enable) \
				cpu_irq(); }


GLOBAL	struct atari sys;

int	atari_init(int argc, char **argv);
void 	atari_mem_direct(uint base, uint len, uint type);
void 	atari_extmem_direct(uint base, uint len, uint adr, uint type);
void	atari_run(int cycles);
void	atari_logo(int count);
void	atari_dlist_test(void);
void	atari_video_refresh(void);
void	atari_warmstart(void);
void	atari_coldstart(void);

void	ostrap(word addr);
int	ostrap_init(int argc, char **argv);

void	atari_press_ascii(char key);

int	interface_init(int argc, char **argv);
void	interface_end(void);
void	interface_open(void);
void	interface_close(void);
void	interface_screen_update(void);
void	interface_sound_update(void);
void	interface_click(int n);
void	interface_control_update(void);
void	interface_map_update(uint base, int len, uint adr, int type);
void	interface_map_update(uint base, int len, uint adr, int type);
void	interface_device_cmd(char type, int uint, char *cmd);
void	interface_device_param(char type, int uint, char *cmd, char *param);

int	sio_init(int argc, char **argv);
void	sio_write(byte data);
void	sio_cmd_start(void);
void	sio_cmd_end(void);

