#define GLOBAL
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "memtype.h"
#include "6502.h"
#include "atari.h"
#include "vdisk.h"
#include "ados.h"
#include "mem.h"
#ifdef USE_PSIO
#include "psio.h"
#endif

char errmsg[200];
extern char *interface_name;


int exec_options(int argc, char **argv)
{
char *carta = NULL, *cartb = NULL;
	if((argc = atari_init(argc, argv)) < 0)
		return False;
	if((argc = cpu_init(argc, argv)) < 0)
		return False;
	if((argc = sio_init(argc, argv)) < 0)
		return False;
	if((argc = dos_init(argc, argv)) < 0)
		return False;
	if((argc = vdisk_init(argc, argv)) < 0)
		return False;
#ifdef USE_PSIO
	if((argc = psio_init(argc, argv)) < 0)
		return False;
#endif
	if((argc = interface_init(argc, argv)) < 0)
		return False;
	if((argc = ostrap_init(argc, argv)) < 0)
		return False;
	while(argc--) {
		if(!strcmp(*argv,"-h")) {
			printf("General options:\n");
			printf("\t-h\t\t\tlist options\n");
			printf("\t-a <rom image>\t\tload left cartridge\n");
			printf("\t-b <rom image>\t\tload right cartridge\n");
			return 0;
		} else if(!strcmp(*argv,"-a")) 
			carta = *(++argv);
		else if(!strcmp(*argv,"-b")) 
			cartb = *(++argv);
		else if(**argv != '-')
			carta = *argv;
		else {
			sprintf(errmsg, "invalid option: %s\n", *argv);
			return False;
		}
	}
	if(carta) {
		atari_mem_direct(MBASE_CARTA, MSIZE_CARTA, MTYPE_CARTA);
		sys.flags |= MFLAG_BURNCARTA;
		strncpy(sys.cartAfile, carta, sizeof(sys.cartAfile));
		mem_load(MBASE_CARTA, MSIZE_CARTA, carta);
		sys.flags &= ~MFLAG_BURNCARTA;
	}
	if(cartb) {
		atari_mem_direct(MBASE_CARTB, MSIZE_CARTB, MTYPE_CARTB);
		sys.flags |= MFLAG_BURNCARTB;
		strncpy(sys.cartBfile, cartb, sizeof(sys.cartBfile));
		mem_load(MBASE_CARTB, MSIZE_CARTB, cartb);
		sys.flags &= ~MFLAG_BURNCARTB;
	}
	return True;
}



int main(int argc, char **argv) 
{
	printf(
"ACE: Atari Computer Emulator v%d.%02d, (c) 1993,94 Frank \"Shaggy\" Barrus\n",
		VER_MAJOR, VER_MINOR);
	printf("(pre-release version:  demo purposes only)\n"); 
	printf("%s\n", interface_name);
	argc--; argv++;
	if(!exec_options(argc, argv)) {
		fprintf(stderr, "%s\n", errmsg);
		return 1;
	}
	cpu_monitor();
	interface_end();
	return 0;
}

