/*  memtype.h
 *    Frank Barrus
 */ 

#ifndef True
#define True	1
#endif

#ifndef False
#define False	0
#endif

typedef unsigned char byte;
typedef signed char sbyte;
typedef unsigned short word;
#ifndef UINT
typedef unsigned int uint;
#endif

#define HI(x)			((x)>>8)
#define LO(x)			((x)&0x00ff)
#define WORD(l,h)		((l)|((h)<<8))
#define LONG(b1,b2,b3,b4)	(WORD(b1,b2)|(WORD(b3,b4)<<16))
#define B1(n)			((n)&0x00ff)
#define B2(n)			(((n)>>8)&0x00ff)
#define B3(n)			(((n)>>16)&0x00ff)
#define B4(n)			(((n)>>24)&0x00ff)

#define GETWORD(v)		WORD(v##_lo, v##_hi)
#define GETLONG(v)		LONG(v##_b1, v##_b2, v##_b3, v##_b4)
#define PUTWORD(v,w)		{ v##_lo = LO(w); v##_hi = HI(w); }
#define PUTLONG(v,l)		{ v##_b1 = B1(l); v##_b2 = B2(l); \
				v##_b3 = B3(l); v##_b4 = B4(l); }

#define K	1024
#define	M	(K*K)

#ifndef GLOBAL
#define GLOBAL extern
#else
#define IS_MAIN
#endif

