/* scancode values for Atari keyboard: */

#define Sl	0x00
#define Sj	0x01
#define Ssemi	0x02
#define SF1	0x03
#define SF2	0x04
#define Sk	0x05
#define Splus	0x06
#define Ssplat	0x07
#define So	0x08

#define Sp	0x0a
#define Su	0x0b
#define Sreturn	0x0c
#define Si	0x0d
#define Sminus	0x0e
#define Sequal	0x0f
#define Sv	0x10
#define Shelp	0x11
#define	Sc	0x12
#define SF3	0x13
#define SF4	0x14
#define Sb	0x15
#define Sx	0x16
#define Sz	0x17
#define S4	0x18

#define S3	0x1a
#define S6	0x1b
#define Sescape	0x1c
#define S5	0x1d
#define S2	0x1e
#define S1	0x1f
#define Scomma	0x20
#define Sspace	0x21
#define Speriod	0x22
#define Sn	0x23

#define Sm	0x25
#define Sslash	0x26
#define Satari	0x27
#define Sr	0x28

#define Se	0x2a
#define Sy	0x2b
#define Stab	0x2c
#define St	0x2d
#define Sw	0x2e
#define Sq	0x2f
#define S9	0x30

#define S0	0x32
#define S7	0x33
#define Sback	0x34
#define S8	0x35
#define Sless	0x36
#define Sgtr	0x37
#define Sf	0x38
#define Sh	0x39
#define Sd	0x3a

#define Slower	0x3c
#define Sg	0x3d
#define Ss	0x3e
#define Sa	0x3f

#define Sshift	0x40
#define Sctrl	0x80

#define Sbang	Sshift|S1
#define Sdquote	Sshift|S2
#define Spound	Sshift|S3
#define Sdollar	Sshift|S4
#define Spcent	Sshift|S5
#define Sand	Sshift|S6
#define Squote	Sshift|S7
#define Sat	Sshift|S8
#define Slparen	Sshift|S9
#define Srparen	Sshift|S0
#define Sclear	Sshift|Sless
#define Siline	Sshift|Sgtr		/* insert line */
#define Sdline	Sshift|Sback		/* delete line */
#define Suline	Sshift|Sminus
#define Spipe	Sshift|Sequal
#define Sbslash	Sshift|Splus
#define Scarat	Sshift|Ssplat
#define Slbrack	Sshift|Scomma
#define Srbrack	Sshift|Speriod
#define Squest	Sshift|Sslash
#define Scaps	Sshift|Slower		/* shift lock */
#define Slkctrl	Sctrl|Slower		/* control lock */
#define Stset	Sshift|Stab		/* Tab set */
#define Stclear	Sctrl|Stab		/* Tab clear */
#define Scolon	Sshift|Ssemi
#define Spause	Sctrl|S1		/* Ctrl-1 - scroll pause */
#define Sbuzz	Sctrl|S2		/* Ctrl-2 - buzzer */
#define Seof	Sctrl|S3		/* Ctrl-3 - EOF */
#define Sinsert	Sctrl|Sgtr		/* insert char */
#define Sdelete	Sctrl|Sback		/* delete char */

#define Shome	Sshift|SF1		/* home cursor */
#define Slleft	Sshift|SF2		/* lower-left corner */
#define Ssline	Sshift|SF3		/* start of line */
#define Seline	Sshift|SF4		/* end of line */
#define Senkb	Sctrl|SF1		/* keyboard enble/disable */
#define Sendis	Sctrl|SF2		/* screen display enable/disable */
#define Senclk	Sctrl|SF3		/* click enable/disable */
#define Scset	Sctrl|SF4		/* domestic/international charset */

#define Sup	Sctrl|Sminus		/* cursor up */
#define Sdown	Sctrl|Sequal		/* cursor down */
#define Sleft	Sctrl|Splus		/* cursor left */
#define Sright	Sctrl|Ssplat		/* cursor right */

#define Sc_a	Sctrl|Sa
#define Sc_b	Sctrl|Sb
#define Sc_c	Sctrl|Sc
#define Sc_d	Sctrl|Sd
#define Sc_e	Sctrl|Se
#define Sc_f	Sctrl|Sf
#define Sc_g	Sctrl|Sg
#define Sc_h	Sctrl|Sh
#define Sc_i	Sctrl|Si
#define Sc_j	Sctrl|Sj
#define Sc_k	Sctrl|Sk
#define Sc_l	Sctrl|Sl
#define Sc_m	Sctrl|Sm
#define Sc_n	Sctrl|Sn
#define Sc_o	Sctrl|So
#define Sc_p	Sctrl|Sp
#define Sc_q	Sctrl|Sq
#define Sc_r	Sctrl|Sr
#define Sc_s	Sctrl|Ss
#define Sc_t	Sctrl|St
#define Sc_u	Sctrl|Su
#define Sc_v	Sctrl|Sv
#define Sc_w	Sctrl|Sw
#define Sc_x	Sctrl|Sx
#define Sc_y	Sctrl|Sy
#define Sc_z	Sctrl|Sz
#define Sc_semi	Sctrl|Ssemi
#define Sc_com	Sctrl|Scomma
#define Sc_per	Sctrl|Speriod

#define SA	Sshift|Sa
#define SB	Sshift|Sb
#define SC	Sshift|Sc
#define SD	Sshift|Sd
#define SE	Sshift|Se
#define SF	Sshift|Sf
#define SG	Sshift|Sg
#define SH	Sshift|Sh
#define SI	Sshift|Si
#define SJ	Sshift|Sj
#define SK	Sshift|Sk
#define SL	Sshift|Sl
#define SM	Sshift|Sm
#define SN	Sshift|Sn
#define SO	Sshift|So
#define SP	Sshift|Sp
#define SQ	Sshift|Sq
#define SR	Sshift|Sr
#define SS	Sshift|Ss
#define ST	Sshift|St
#define SU	Sshift|Su
#define SV	Sshift|Sv
#define SW	Sshift|Sw
#define SX	Sshift|Sx
#define SY	Sshift|Sy
#define SZ	Sshift|Sz


