/* sio2pc.h
 *   info for SIO2PC disk image files
 */


#define SIO2PC_MAGIC	0x0296

struct sio2pc_image_hdr {
	byte	code_lo, code_hi;	/* ID code = 0x0296 */
	byte	size_b1, size_b2;	/* low 16-bits of size */
	byte	secsize_lo, secsize_hi;	/* sectors size: 128/256 */
	byte	size_b3, size_b4;	/* high 16-bits of size (paragraphs) */
	byte	resv[6];		/* reserved */
	byte	numerr_hi, numerr_lo;	/* number of sectors with errors */
};

struct errormap {
	byte	sec_lo, sec_hi;		/* sector with error */
	byte	cstat;			/* communication status */
	byte	hstat; 			/* hardware status */
	byte	resv[4];		/* reserved */
};

